/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Factory;

import ru.m210projects.Blood.DB;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Types.BuildVariable;
import ru.m210projects.Build.Types.SECTOR;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.WALL;

public class BloodEngine
extends BuildEngine {
    public BuildVariable<Integer> fastDemo;

    public BloodEngine(BuildGame game) throws Exception {
        super(game, Globals.kFrameTicks);
        UseBloodPal = true;
        if (VERSION.SHAREWARE) {
            this.tilesPath = "shareXXX.art";
        }
        this.fastDemo = new BuildSettings.IntVar(0, "FastDemo");
    }

    @Override
    public void setbrightness(int nGamma, byte[] dapal, GLRenderer.GLInvalidateFlag flags) {
        GLRenderer gl = this.glrender();
        curbrightness = Gameutils.BClipRange(nGamma, 0, Screen.gGammaLevels);
        if ((gl == null || gl.getType().getFrameType() != BuildFrame.FrameType.GL) && curbrightness != 0) {
            int i = 0;
            while (i < dapal.length) {
                this.temppal[i] = Screen.gammaTable[nGamma][dapal[i] & 0xFF];
                ++i;
            }
            this.changepalette(this.temppal);
        } else {
            this.changepalette(dapal);
        }
        if (gl != null) {
            gl.gltexinvalidateall(flags);
        }
        BloodEngine.palfadergb.b = 0;
        BloodEngine.palfadergb.g = 0;
        BloodEngine.palfadergb.r = 0;
        BloodEngine.palfadergb.a = 0;
    }

    @Override
    public int setrendermode(Renderer render) {
        if (this.render != null && this.render != render) {
            com.badlogic.gdx.Screen screen;
            if (render.getType() != Renderer.RenderType.Software && (screen = Main.game.getScreen()) instanceof GameAdapter) {
                Main.gPrecacheScreen.init(true, new Runnable(){

                    @Override
                    public void run() {
                        Main.game.changeScreen(screen);
                        if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                            Main.game.net.ready2send = true;
                        }
                    }
                });
                Main.game.changeScreen(Main.gPrecacheScreen);
            }
            View.PaletteView = 0;
            Screen.scrSetPalette(View.PaletteView);
        }
        return super.setrendermode(render);
    }

    @Override
    public byte[] loadtile(int nTile) {
        if (nTile < 0 || nTile >= MAXTILES) {
            return null;
        }
        if (waloff[nTile] == null) {
            super.loadtile(nTile);
        }
        return waloff[nTile];
    }

    @Override
    public void sampletimer() {
        if (this.timerfreq == 0) {
            return;
        }
        long n = this.getticks() * (long)timerticspersec / (long)this.timerfreq - this.timerlastsample;
        if (n > 0L) {
            totalclock = Main.game.isCurrentScreen(Main.gDemoScreen) && this.fastDemo.get() != 0 ? (totalclock += this.fastDemo.get() * 4) : (int)((long)totalclock + n);
            this.timerlastsample += n;
        }
    }

    @Override
    public byte getclosestcol(byte[] palette, int r, int g, int b) {
        int rgb = r << 12 | g << 6 | b;
        Byte out = this.palcache[rgb & this.palcache.length - 1];
        if (out != null) {
            return out;
        }
        byte col = Screen.scrFindClosestColor(palette, r << 2, g << 2, b << 2);
        this.palcache[rgb & this.palcache.length - 1] = col;
        return col;
    }

    @Override
    public void loadpalette() {
        Screen.curPalette = 0;
        Screen.scrLoadPalette();
        Console.Println("Loading gamma correction table", 0);
        byte[] buf = BuildGdx.cache.getBytes("gamma.dat", 0);
        if (buf == null) {
            Console.Println("Gamma table not found", Console.OSDTEXT_RED);
        }
        Screen.gGammaLevels = buf.length / 256;
        int i = 0;
        while (i < 16) {
            int j = 0;
            while (j < 256) {
                Screen.gammaTable[i][j] = buf[i * 256 + j];
                ++j;
            }
            ++i;
        }
    }

    @Override
    public short setsprite(int spritenum, int newx, int newy, int newz) {
        return DB.setSprite(spritenum, newx, newy, newz);
    }

    @Override
    public void initspritelists() {
        DB.initspritelists();
    }

    @Override
    public short insertsprite(short sectnum, short statnum) {
        return DB.insertsprite(sectnum, statnum);
    }

    @Override
    public short deletesprite(short spritenum) {
        GLRenderer gl = this.glrender();
        if (gl != null) {
            gl.removeSpriteCorr(spritenum);
        }
        DB.deletesprite(spritenum);
        return 0;
    }

    @Override
    public short changespritesect(int spritenum, short newsectnum) {
        return DB.changespritesect((short)spritenum, newsectnum);
    }

    @Override
    public short changespritestat(int spritenum, int newstatnum) {
        return DB.changespritestat((short)spritenum, (short)newstatnum);
    }

    @Override
    public Engine.Point rotatepoint(int xpivot, int ypivot, int x, int y, short daang) {
        this.rotatepoint.set(Pragmas.dmulscaler(x -= xpivot, Trig.Cos(daang), -(y -= ypivot), Trig.Sin(daang), 30) + xpivot, Pragmas.dmulscaler(y, Trig.Cos(daang), x, Trig.Sin(daang), 30) + ypivot, 0);
        return this.rotatepoint;
    }

    @Override
    public int clipmove(int x, int y, int z, short sectnum, long xvect, long yvect, int walldist, int ceildist, int flordist, int cliptype) {
        int templong1;
        int templong2;
        int i;
        Object out;
        short j;
        clipmove_x = x;
        clipmove_y = y;
        clipmove_z = z;
        clipmove_sectnum = sectnum;
        if ((xvect | yvect) == 0L || clipmove_sectnum < 0) {
            return 0;
        }
        int retval = 0;
        long oxvect = xvect;
        long oyvect = yvect;
        int goalx = clipmove_x + (int)(xvect >> 14);
        int goaly = clipmove_y + (int)(yvect >> 14);
        this.clipnum = 0;
        int cx = clipmove_x + goalx >> 1;
        int cy = clipmove_y + goaly >> 1;
        int gx = goalx - clipmove_x;
        int gy = goaly - clipmove_y;
        int rad = this.ksqrt(gx * gx + gy * gy) + 1024 + walldist + 8;
        int xmin = cx - rad;
        int ymin = cy - rad;
        int xmax = cx + rad;
        int ymax = cy + rad;
        int dawalclipmask = cliptype & 0xFFFF;
        int dasprclipmask = cliptype >> 16;
        this.clipsectorlist[0] = clipmove_sectnum;
        short clipsectcnt = 0;
        this.clipsectnum = 1;
        do {
            int bsz;
            int daz2;
            int daz;
            int day;
            int dax;
            int y2;
            int y1;
            int x1;
            int x2;
            short dasect = this.clipsectorlist[clipsectcnt++];
            SECTOR sec = sector[dasect];
            short startwall = sec.wallptr;
            int endwall = startwall + sec.wallnum;
            if (startwall < 0 || endwall < 0) {
                ++clipsectcnt;
                continue;
            }
            j = startwall;
            while (j < endwall) {
                block59: {
                    boolean clipyou;
                    int dy;
                    int dx;
                    WALL wal;
                    block61: {
                        block60: {
                            WALL wal2;
                            wal = wall[j];
                            if (wal == null || wal.point2 < 0 || wal.point2 >= MAXWALLS || (wal2 = wall[wal.point2]) == null || wal.x < xmin && wal2.x < xmin || wal.x > xmax && wal2.x > xmax || wal.y < ymin && wal2.y < ymin || wal.y > ymax && wal2.y > ymax || (dx = (x2 = wal2.x) - (x1 = wal.x)) * (clipmove_y - (y1 = wal.y)) < (clipmove_x - x1) * (dy = (y2 = wal2.y) - y1) || (dax = dx > 0 ? dx * (ymin - y1) : dx * (ymax - y1)) >= (day = dy > 0 ? dy * (xmax - x1) : dy * (xmin - x1))) break block59;
                            clipyou = false;
                            if (wal.nextsector >= 0 && (wal.cstat & dawalclipmask) == 0) break block60;
                            clipyou = true;
                            break block61;
                        }
                        out = this.rintersect(clipmove_x, clipmove_y, 0, gx, gy, 0, x1, y1, x2, y2);
                        if (out == null) {
                            dax = clipmove_x;
                            day = clipmove_y;
                        } else {
                            dax = ((Engine.Point)out).getX();
                            day = ((Engine.Point)out).getY();
                        }
                        daz = this.getflorzofslope(dasect, dax, day);
                        daz2 = this.getflorzofslope(wal.nextsector, dax, day);
                        SECTOR sec2 = sector[wal.nextsector];
                        if (sec2 == null) break block59;
                        if (daz2 < daz - 256 && (sec2.floorstat & 1) == 0 && clipmove_z >= daz2 - (flordist - 1)) {
                            clipyou = true;
                        }
                        if (!clipyou) {
                            daz = this.getceilzofslope(dasect, dax, day);
                            daz2 = this.getceilzofslope(wal.nextsector, dax, day);
                            if (daz2 > daz + 256 && (sec2.ceilingstat & 1) == 0 && clipmove_z <= daz2 + (ceildist - 1)) {
                                clipyou = true;
                            }
                        }
                    }
                    if (clipyou) {
                        bsz = walldist;
                        if (gx < 0) {
                            bsz = -bsz;
                        }
                        this.addclipline(x1 - bsz, y1 - bsz, x1 - bsz, y1 + bsz, j + 32768);
                        this.addclipline(x2 - bsz, y2 - bsz, x2 - bsz, y2 + bsz, j + 32768);
                        bsz = walldist;
                        if (gy < 0) {
                            bsz = -bsz;
                        }
                        this.addclipline(x1 + bsz, y1 - bsz, x1 - bsz, y1 - bsz, j + 32768);
                        this.addclipline(x2 + bsz, y2 - bsz, x2 - bsz, y2 - bsz, j + 32768);
                        dax = walldist;
                        if (dy > 0) {
                            dax = -dax;
                        }
                        day = walldist;
                        if (dx < 0) {
                            day = -day;
                        }
                        this.addclipline(x1 + dax, y1 + day, x2 + dax, y2 + day, j + 32768);
                    } else {
                        i = this.clipsectnum - 1;
                        while (i >= 0) {
                            if (wal.nextsector == this.clipsectorlist[i]) break;
                            --i;
                        }
                        if (i < 0) {
                            short s = this.clipsectnum;
                            this.clipsectnum = (short)(s + 1);
                            this.clipsectorlist[s] = wal.nextsector;
                        }
                    }
                }
                j = (short)(j + 1);
            }
            j = headspritesect[dasect];
            while (j >= 0) {
                SPRITE spr = sprite[j];
                short cstat = spr.cstat;
                if ((cstat & dasprclipmask) != 0) {
                    x1 = spr.x;
                    y1 = spr.y;
                    switch (cstat & 0x30) {
                        case 0: {
                            if (x1 < xmin || x1 > xmax || y1 < ymin || y1 > ymax) break;
                            int k = tilesizy[spr.picnum] * spr.yrepeat << 2;
                            daz = (cstat & 0x80) != 0 ? spr.z + (k >> 1) : spr.z;
                            if ((picanm[spr.picnum] & 0xFF0000) != 0) {
                                daz -= (byte)(picanm[spr.picnum] >> 16 & 0xFF) * spr.yrepeat << 2;
                            }
                            if (clipmove_z >= daz + ceildist || clipmove_z <= daz - k - flordist) break;
                            bsz = (spr.clipdist << 2) + walldist;
                            if (gx < 0) {
                                bsz = -bsz;
                            }
                            this.addclipline(x1 - bsz, y1 - bsz, x1 - bsz, y1 + bsz, j + 49152);
                            bsz = (spr.clipdist << 2) + walldist;
                            if (gy < 0) {
                                bsz = -bsz;
                            }
                            this.addclipline(x1 + bsz, y1 - bsz, x1 - bsz, y1 - bsz, j + 49152);
                            break;
                        }
                        case 16: {
                            int k = tilesizy[spr.picnum] * spr.yrepeat << 2;
                            daz = (cstat & 0x80) != 0 ? spr.z + (k >> 1) : spr.z;
                            if ((picanm[spr.picnum] & 0xFF0000) != 0) {
                                daz -= (byte)(picanm[spr.picnum] >> 16 & 0xFF) * spr.yrepeat << 2;
                            }
                            daz2 = daz - k;
                            if (clipmove_z >= (daz += ceildist) || clipmove_z <= (daz2 -= flordist)) break;
                            short tilenum = spr.picnum;
                            int xoff = (byte)(picanm[tilenum] >> 8 & 0xFF) + spr.xoffset;
                            if ((cstat & 4) > 0) {
                                xoff = -xoff;
                            }
                            k = spr.ang;
                            int l = spr.xrepeat;
                            dax = sintable[k & 0x7FF] * l;
                            day = sintable[k + 1536 & 0x7FF] * l;
                            l = tilesizx[tilenum];
                            k = (l >> 1) + xoff;
                            x2 = (x1 -= Pragmas.mulscale(dax, k, 16)) + Pragmas.mulscale(dax, l, 16);
                            if (this.clipinsideboxline(cx, cy, x1, y1 -= Pragmas.mulscale(day, k, 16), x2, y2 = y1 + Pragmas.mulscale(day, l, 16), rad) == 0) break;
                            dax = Pragmas.mulscale(sintable[spr.ang + 256 + 512 & 0x7FF], walldist, 14);
                            day = Pragmas.mulscale(sintable[spr.ang + 256 & 0x7FF], walldist, 14);
                            if ((x1 - clipmove_x) * (y2 - clipmove_y) >= (x2 - clipmove_x) * (y1 - clipmove_y)) {
                                this.addclipline(x1 + dax, y1 + day, x2 + day, y2 - dax, j + 49152);
                            } else {
                                if ((cstat & 0x40) != 0) break;
                                this.addclipline(x2 - dax, y2 - day, x1 - day, y1 + dax, j + 49152);
                            }
                            if ((x2 - x1) * (clipmove_x - x1) + (y2 - y1) * (clipmove_y - y1) < 0) {
                                this.addclipline(x1 - day, y1 + dax, x1 + dax, y1 + day, j + 49152);
                                break;
                            }
                            if ((x1 - x2) * (clipmove_x - x2) + (y1 - y2) * (clipmove_y - y2) >= 0) break;
                            this.addclipline(x2 + day, y2 - dax, x2 - dax, y2 - day, j + 49152);
                            break;
                        }
                        case 32: {
                            daz = spr.z + ceildist;
                            daz2 = spr.z - flordist;
                            if (clipmove_z >= daz || clipmove_z <= daz2 || (cstat & 0x40) != 0 && clipmove_z > spr.z == ((cstat & 8) == 0)) break;
                            short tilenum = spr.picnum;
                            int xoff = (byte)(picanm[tilenum] >> 8 & 0xFF) + spr.xoffset;
                            int yoff = (byte)(picanm[tilenum] >> 16 & 0xFF) + spr.yoffset;
                            if ((cstat & 4) > 0) {
                                xoff = -xoff;
                            }
                            if ((cstat & 8) > 0) {
                                yoff = -yoff;
                            }
                            int k = spr.ang;
                            short cosang = sintable[k + 512 & 0x7FF];
                            short sinang = sintable[k & 0x7FF];
                            short xspan = tilesizx[tilenum];
                            short xrepeat = spr.xrepeat;
                            short yspan = tilesizy[tilenum];
                            short yrepeat = spr.yrepeat;
                            dax = ((xspan >> 1) + xoff) * xrepeat;
                            day = ((yspan >> 1) + yoff) * yrepeat;
                            this.rxi[0] = x1 + Pragmas.dmulscale(sinang, dax, cosang, day, 16);
                            this.ryi[0] = y1 + Pragmas.dmulscale(sinang, day, -cosang, dax, 16);
                            int l = xspan * xrepeat;
                            this.rxi[1] = this.rxi[0] - Pragmas.mulscale(sinang, l, 16);
                            this.ryi[1] = this.ryi[0] + Pragmas.mulscale(cosang, l, 16);
                            l = yspan * yrepeat;
                            k = -Pragmas.mulscale(cosang, l, 16);
                            this.rxi[2] = this.rxi[1] + k;
                            this.rxi[3] = this.rxi[0] + k;
                            k = -Pragmas.mulscale(sinang, l, 16);
                            this.ryi[2] = this.ryi[1] + k;
                            this.ryi[3] = this.ryi[0] + k;
                            dax = Pragmas.mulscale(sintable[spr.ang - 256 + 512 & 0x7FF], walldist, 14);
                            day = Pragmas.mulscale(sintable[spr.ang - 256 & 0x7FF], walldist, 14);
                            if ((this.rxi[0] - clipmove_x) * (this.ryi[1] - clipmove_y) < (this.rxi[1] - clipmove_x) * (this.ryi[0] - clipmove_y)) {
                                if (this.clipinsideboxline(cx, cy, this.rxi[1], this.ryi[1], this.rxi[0], this.ryi[0], rad) != 0) {
                                    this.addclipline(this.rxi[1] - day, this.ryi[1] + dax, this.rxi[0] + dax, this.ryi[0] + day, j + 49152);
                                }
                            } else if ((this.rxi[2] - clipmove_x) * (this.ryi[3] - clipmove_y) < (this.rxi[3] - clipmove_x) * (this.ryi[2] - clipmove_y) && this.clipinsideboxline(cx, cy, this.rxi[3], this.ryi[3], this.rxi[2], this.ryi[2], rad) != 0) {
                                this.addclipline(this.rxi[3] + day, this.ryi[3] - dax, this.rxi[2] - dax, this.ryi[2] - day, j + 49152);
                            }
                            if ((this.rxi[1] - clipmove_x) * (this.ryi[2] - clipmove_y) < (this.rxi[2] - clipmove_x) * (this.ryi[1] - clipmove_y)) {
                                if (this.clipinsideboxline(cx, cy, this.rxi[2], this.ryi[2], this.rxi[1], this.ryi[1], rad) == 0) break;
                                this.addclipline(this.rxi[2] - dax, this.ryi[2] - day, this.rxi[1] - day, this.ryi[1] + dax, j + 49152);
                                break;
                            }
                            if ((this.rxi[3] - clipmove_x) * (this.ryi[0] - clipmove_y) >= (this.rxi[0] - clipmove_x) * (this.ryi[3] - clipmove_y) || this.clipinsideboxline(cx, cy, this.rxi[0], this.ryi[0], this.rxi[3], this.ryi[3], rad) == 0) break;
                            this.addclipline(this.rxi[0] + dax, this.ryi[0] + day, this.rxi[3] + day, this.ryi[3] - dax, j + 49152);
                        }
                    }
                }
                j = nextspritesect[j];
            }
        } while (clipsectcnt < this.clipsectnum);
        short hitwall = 0;
        int cnt = clipmoveboxtracenum;
        do {
            out = this.raytrace(clipmove_x, clipmove_y, goalx, goaly);
            int intx = ((Engine.Clip)out).getX();
            int inty = ((Engine.Clip)out).getY();
            hitwall = ((Engine.Clip)out).getNum();
            if (hitwall >= 0) {
                int lx = this.clipit[hitwall].x2 - this.clipit[hitwall].x1;
                int ly = this.clipit[hitwall].y2 - this.clipit[hitwall].y1;
                templong2 = lx * lx + ly * ly;
                if (templong2 > 0) {
                    templong1 = (goalx - intx) * lx + (goaly - inty) * ly;
                    i = Pragmas.klabs(templong1) >> 11 < templong2 ? Pragmas.divscale(templong1, templong2, 20) : 0;
                    goalx = Pragmas.mulscale(lx, i, 20) + intx;
                    goaly = Pragmas.mulscale(ly, i, 20) + inty;
                }
                templong1 = Pragmas.dmulscale(lx, oxvect, ly, oyvect, 6);
                i = cnt + 1;
                while (i <= clipmoveboxtracenum) {
                    j = this.hitwalls[i];
                    templong2 = Pragmas.dmulscale(this.clipit[j].x2 - this.clipit[j].x1, oxvect, this.clipit[j].y2 - this.clipit[j].y1, oyvect, 6);
                    if ((templong1 ^ templong2) < 0) {
                        if (!DEMO.IsOriginalDemo()) {
                            clipmove_sectnum = this.updatesector(clipmove_x, clipmove_y, clipmove_sectnum);
                        }
                        return retval;
                    }
                    ++i;
                }
                Engine.Point goal = this.keepaway(goalx, goaly, hitwall);
                goalx = goal.getX();
                goaly = goal.getY();
                xvect = goalx - intx << 14;
                yvect = goaly - inty << 14;
                if (cnt == clipmoveboxtracenum) {
                    retval = this.clipobjectval[hitwall];
                }
                this.hitwalls[cnt] = hitwall;
            }
            clipmove_x = intx;
            clipmove_y = inty;
        } while ((xvect | yvect) != 0L && hitwall >= 0 && --cnt > 0);
        j = 0;
        while (j < this.clipsectnum) {
            if (this.inside(clipmove_x, clipmove_y, this.clipsectorlist[j]) == 1) {
                clipmove_sectnum = this.clipsectorlist[j];
                return retval;
            }
            j = (short)(j + 1);
        }
        clipmove_sectnum = (short)-1;
        templong1 = Integer.MAX_VALUE;
        j = (short)(numsectors - 1);
        while (j >= 0) {
            if (this.inside(clipmove_x, clipmove_y, j) == 1) {
                templong2 = (BloodEngine.sector[j].ceilingstat & 2) != 0 ? this.getceilzofslope(j, clipmove_x, clipmove_y) - clipmove_z : BloodEngine.sector[j].ceilingz - clipmove_z;
                if (templong2 > 0) {
                    if (templong2 < templong1) {
                        clipmove_sectnum = j;
                        templong1 = templong2;
                    }
                } else {
                    templong2 = (BloodEngine.sector[j].floorstat & 2) != 0 ? clipmove_z - this.getflorzofslope(j, clipmove_x, clipmove_y) : clipmove_z - BloodEngine.sector[j].floorz;
                    if (templong2 <= 0) {
                        clipmove_sectnum = j;
                        return retval;
                    }
                    if (templong2 < templong1) {
                        clipmove_sectnum = j;
                        templong1 = templong2;
                    }
                }
            }
            j = (short)(j - 1);
        }
        return retval;
    }
}

