/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import com.badlogic.gdx.utils.ByteArray;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import ru.m210projects.Blood.AI.Ai;
import ru.m210projects.Blood.Actor;
import ru.m210projects.Blood.Config;
import ru.m210projects.Blood.Factory.BloodEngine;
import ru.m210projects.Blood.Factory.BloodFactory;
import ru.m210projects.Blood.Factory.BloodMenuHandler;
import ru.m210projects.Blood.Factory.BloodNetwork;
import ru.m210projects.Blood.Fire;
import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.LEVELS;
import ru.m210projects.Blood.LOADSAVE;
import ru.m210projects.Blood.Menus.BLMenuMultiplayer;
import ru.m210projects.Blood.Menus.MainMenu;
import ru.m210projects.Blood.Menus.MenuCorruptGame;
import ru.m210projects.Blood.Menus.MenuDifficulty;
import ru.m210projects.Blood.Menus.MenuGame;
import ru.m210projects.Blood.Menus.MenuNetwork;
import ru.m210projects.Blood.Menus.MenuNewAddon;
import ru.m210projects.Blood.PLAYER;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Screens.CutsceneScreen;
import ru.m210projects.Blood.Screens.DemoScreen;
import ru.m210projects.Blood.Screens.DisconnectScreen;
import ru.m210projects.Blood.Screens.GameScreen;
import ru.m210projects.Blood.Screens.LoadingScreen;
import ru.m210projects.Blood.Screens.LogoScreen;
import ru.m210projects.Blood.Screens.MenuScreen;
import ru.m210projects.Blood.Screens.NetScreen;
import ru.m210projects.Blood.Screens.PrecacheScreen;
import ru.m210projects.Blood.Screens.StatisticScreen;
import ru.m210projects.Blood.Tile;
import ru.m210projects.Blood.Trig;
import ru.m210projects.Blood.Types.BloodDef;
import ru.m210projects.Blood.Types.BloodIniFile;
import ru.m210projects.Blood.Types.DEMO;
import ru.m210projects.Blood.Types.EpisodeInfo;
import ru.m210projects.Blood.Types.PLOCATION;
import ru.m210projects.Blood.Types.ScreenEffect;
import ru.m210projects.Blood.Types.Seq.SeqHandling;
import ru.m210projects.Blood.VERSION;
import ru.m210projects.Blood.View;
import ru.m210projects.Blood.Weapon;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildMessage;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.FileHandle.UserGroup;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.OnSceenDisplay.OSDCOMMAND;
import ru.m210projects.Build.OnSceenDisplay.OSDCVARFUNC;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Script.Maphack;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Types.SPRITE;

public class Main
extends BuildGame {
    public static final String appdef = "bloodgdx.def";
    public static MenuScreen gMenuScreen;
    public static GameScreen gGameScreen;
    public static DemoScreen gDemoScreen;
    public static LoadingScreen gLoadingScreen;
    public static LogoScreen gLogoScreen;
    public static CutsceneScreen gCutsceneScreen;
    public static NetScreen gNetScreen;
    public static StatisticScreen gStatisticScreen;
    public static DisconnectScreen gDisconnectScreen;
    public static PrecacheScreen gPrecacheScreen;
    public static UserFlag mUserFlag;
    public static Main game;
    public static BloodEngine engine;
    public static Config cfg;
    public BloodMenuHandler menu;
    public BloodNetwork net;
    public Runnable rMenu = new Runnable(){

        @Override
        public void run() {
            Main.this.resetState();
            if (DEMO.demofiles.size() == 0 || Main.cfg.gDemoSeq == 0 || !gDemoScreen.showDemo()) {
                Main.this.changeScreen(gMenuScreen);
            }
        }
    };

    static {
        mUserFlag = UserFlag.None;
    }

    public Main(BuildConfig bcfg, String appname, String sversion, boolean isDemo, boolean isRelease) {
        super(bcfg, appname, sversion, isRelease);
        game = this;
        cfg = (Config)bcfg;
        VERSION.SHAREWARE = isDemo;
    }

    public Main(BuildConfig bcfg, String appname, String sversion, boolean isDemo) {
        this(bcfg, appname, sversion, isDemo, true);
    }

    @Override
    public BuildFactory getFactory() {
        return new BloodFactory(this);
    }

    @Override
    public boolean init() throws Exception {
        FileEntry filgdx;
        this.net = (BloodNetwork)this.pNet;
        Console.Println("Initializing timer");
        engine.inittimer(120);
        this.ConsoleInit();
        Console.Println("Initializing sound system");
        SOUND.sndInit();
        Console.Println("Loading INI file");
        String main = "blood.ini";
        byte[] data = BuildGdx.cache.getBytes(main, 0);
        Globals.MainINI = new BloodIniFile(data, main, BuildGdx.compat.checkFile(main));
        Globals.pGameInfo.copy(Globals.defGameInfo);
        Console.Println("Creating standard color lookups");
        Screen.scrCreateStdColors();
        Tile.tileInit();
        try {
            Globals.fire = new Fire();
        }
        catch (Exception e) {
            e.printStackTrace();
            game.GameMessage(e.getMessage());
            return false;
        }
        Console.Println("Loading cosine table");
        Trig.trigInit();
        Console.Println("Initializing view subsystem");
        View.viewInit();
        DEMO.demoscan();
        this.net.ResetNetwork();
        int i = 0;
        while (i < 8) {
            Globals.gPlayer[i] = new PLAYER();
            PLAYER.gPrevView[i] = new PLOCATION();
            ++i;
        }
        Globals.gMe = Globals.gPlayer[Mmulti.myconnectindex];
        View.gViewIndex = Mmulti.myconnectindex;
        SeqHandling.SeqInit();
        ScreenEffect.FadeInit();
        LEVELS.initEpisodeInfo(Globals.MainINI);
        LEVELS.getEpisodeInfo(LEVELS.gEpisodeInfo, Globals.MainINI);
        this.InitCutscenes();
        Engine.tilesizy[504] = 0;
        Engine.tilesizx[504] = 0;
        Console.Println("Initializing def-scripts...");
        ru.m210projects.Build.Gameutils.loadGdxDef(this.baseDef, appdef, "bloodgdx.dat");
        if (Main.cfg.autoloadFolder) {
            Console.Println("Initializing autoload folder");
            DirectoryEntry autoload = BuildGdx.compat.checkDirectory("autoload");
            if (autoload != null) {
                for (FileEntry file : autoload.getFiles().values()) {
                    Group group;
                    if (file.getExtension().equals("zip")) {
                        group = BuildGdx.cache.add(file.getPath());
                        if (group == null) continue;
                        GroupResource def = group.open(appdef);
                        if (def != null) {
                            byte[] buf = def.getBytes();
                            this.baseDef.loadScript(file.getName(), buf);
                            def.close();
                            continue;
                        }
                        group.setFlags(true, false);
                        try {
                            LEVELS.prepareusergroup(group);
                        }
                        catch (Exception e) {
                            this.GameWarning("Error in \"" + file.getName() + "\" \r\n" + e.getMessage());
                            continue;
                        }
                        LEVELS.InitGroupResources(this.getBaseDef(), group.getList());
                        continue;
                    }
                    if (file.getExtension().equals("rff") || file.getExtension().equals("grp")) {
                        group = BuildGdx.cache.add(file.getPath());
                        if (group == null) continue;
                        group.setFlags(true, false);
                        LEVELS.InitGroupResources(this.getBaseDef(), group.getList());
                        continue;
                    }
                    if (!file.getExtension().equals("def")) continue;
                    this.baseDef.loadScript(file);
                }
            }
        }
        if ((filgdx = BuildGdx.compat.checkFile(appdef)) != null) {
            this.baseDef.loadScript(filgdx);
        }
        this.setDefs(this.baseDef);
        View.viewHandInit();
        Console.Println("Initializing weapon animations");
        Weapon.WeaponInit();
        LOADSAVE.FindSaves();
        this.menu.mMenus[0] = new MainMenu(this);
        this.menu.mMenus[1] = new MenuGame(this);
        this.menu.mMenus[4] = new MenuDifficulty(this);
        this.menu.mMenus[14] = new MenuNewAddon(this);
        this.menu.mMenus[12] = new BLMenuMultiplayer(this);
        this.menu.mMenus[11] = new MenuNetwork(this);
        this.menu.mMenus[17] = new MenuCorruptGame(this);
        gCutsceneScreen = new CutsceneScreen(this);
        gLoadingScreen = new LoadingScreen(this);
        gLogoScreen = new LogoScreen(this, 2.0f);
        gMenuScreen = new MenuScreen(this);
        gGameScreen = new GameScreen(this);
        gDemoScreen = new DemoScreen(this);
        gNetScreen = new NetScreen(this);
        gStatisticScreen = new StatisticScreen(this, 1.0f);
        gDisconnectScreen = new DisconnectScreen(this, 1.0f);
        gPrecacheScreen = new PrecacheScreen(this);
        Runnable nextLogo = new Runnable(){

            @Override
            public void run() {
                if (Main.cfg.showCutscenes && gCutsceneScreen.init("gti.smk", "gti.wav")) {
                    Main.this.changeScreen(gCutsceneScreen.setCallback(Main.this.rMenu));
                } else {
                    Main.this.changeScreen(gLogoScreen.setTile(2052).setCallback(Main.this.rMenu));
                }
            }
        };
        gLogoScreen.setTile(2050).setCallback(nextLogo).setSkipping(this.rMenu);
        gCutsceneScreen.setCallback(nextLogo).setSkipping(this.rMenu).escSkipping(false);
        return true;
    }

    public BloodDef getBaseDef() {
        return (BloodDef)this.baseDef;
    }

    public BloodDef getCurrentDef() {
        return (BloodDef)this.currentDef;
    }

    private void ConsoleInit() {
        Console.Println("Initializing on-screen display system");
        Console.setParameters(0, 0, 0, 12, 2, 12);
        Console.setVersion(String.valueOf(this.appname) + " " + this.sversion, 10, Console.OSDTEXT_GOLD);
        Console.RegisterCvar(new OSDCOMMAND("initgroupfile", "initgroupfile", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("initgroupfile: <path to [zip/grp/rff]>");
                    return;
                }
                if (!Main.this.isCurrentScreen(gMenuScreen)) {
                    Console.Println("initgroupfile: Back to menu at first");
                    return;
                }
                String filename = Console.osd_argv[1];
                FileEntry file = BuildGdx.compat.checkFile(filename);
                if (file != null) {
                    if (file.getExtension().equals("zip") || file.getExtension().equals("grp") || file.getExtension().equals("rff")) {
                        try {
                            Group gr = BuildGdx.cache.add(file.getPath());
                            gr.setFlags(true, false);
                            LEVELS.prepareusergroup(gr);
                            LEVELS.InitGroupResources(Main.this.getCurrentDef(), gr.getList());
                            Screen.scrReset();
                            Console.Println("initgroupfile: " + filename + " successfuly added to game resources");
                        }
                        catch (Exception e) {
                            Console.Println("Error to load " + file.getName(), Console.OSDTEXT_RED);
                        }
                    }
                } else {
                    Console.Println("initgroupfile: File not found");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("changeteam", "changeteam to 0 or 1", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("changeteam: " + Main.this.net.gProfile[Mmulti.myconnectindex].team + " ( 0 - auto, 1 - blue, 2 - red )");
                    return;
                }
                int team = Integer.parseInt(Console.osd_argv[1]);
                if (team >= 0 && team < 3) {
                    if (Main.this.net.gProfile[Mmulti.myconnectindex].team == team) {
                        Console.Println("Already changed");
                        return;
                    }
                    Main.this.net.ChangeTeam(Mmulti.myconnectindex, team);
                    String message = "Your team will change to ";
                    team = team == 0 ? Mmulti.myconnectindex & 1 : --team;
                    switch (team) {
                        case 0: {
                            message = String.valueOf(message) + "blue after respawn";
                            break;
                        }
                        case 1: {
                            message = String.valueOf(message) + "red after respawn";
                        }
                    }
                    Console.Println(message);
                } else {
                    Console.Println("changeteam: out of range");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("noenemies", "show enemies", new OSDCVARFUNC(){

            @Override
            public void execute() {
                block13: {
                    if (Main.this.isCurrentScreen(gDemoScreen) || Globals.pGameInfo.nGameType != 0 || Mmulti.numplayers > 1) {
                        Console.Println("noenemies: Single player only");
                        return;
                    }
                    if (Console.osd_argc != 2) {
                        Console.Println("noenemies: " + Actor.gNoEnemies + " ( 0 - disabled, 1 - ai disable, 2 - enabled )");
                        return;
                    }
                    try {
                        int type = Integer.parseInt(Console.osd_argv[1]);
                        if (type >= 0 && type < 3) {
                            Actor.gNoEnemies = type;
                            switch (type) {
                                case 0: 
                                case 1: {
                                    if (type == 0) {
                                        Console.Println("noenemies disabled");
                                    } else {
                                        Console.Println("noenemies: ai disable");
                                    }
                                    short nSprite = Engine.headspritestat[6];
                                    while (nSprite >= 0) {
                                        if (!DEMO.IsOriginalDemo() && Globals.pGameInfo.nGameType == 0 && Mmulti.numplayers < 2) {
                                            SPRITE pSprite = Engine.sprite[nSprite];
                                            pSprite.cstat = (short)(pSprite.cstat & 0xFFFF7FFF);
                                            pSprite.cstat = (short)(pSprite.cstat | 0x1101);
                                            Ai.aiInit(DEMO.IsOriginalDemo());
                                        }
                                        nSprite = Engine.nextspritestat[nSprite];
                                    }
                                    break block13;
                                }
                                case 2: {
                                    Console.Println("noenemies enabled");
                                }
                            }
                            break block13;
                        }
                        Console.Println("noenemies: out of range");
                    }
                    catch (Exception e) {
                        Console.Println("noenemies: out of range");
                    }
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("playback", "playback \"filename.dem\"", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Globals.pGameInfo.nGameType != 0 || Mmulti.numplayers > 1) {
                    Console.Println("playback: Single player only");
                    return;
                }
                if (Console.osd_argc < 2) {
                    Console.Println("playback \"demoname.dem\" [\"addon.ini\" or \"zipfile.zip:addon.ini\"]");
                    return;
                }
                String name = Console.osd_argv[1];
                if (BuildGdx.cache.contains(name, 0)) {
                    gDemoScreen.showDemo(name, Console.osd_argv[2]);
                } else {
                    Console.Println("\"" + name + "\" " + "not found!");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("quicksave", "quicksave: performs a quick save", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Globals.pGameInfo.nGameType != 0 || Mmulti.numplayers > 1) {
                    Console.Println("quicksave: Single player only");
                    return;
                }
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    LOADSAVE.quicksave();
                } else {
                    Console.Println("quicksave: not in a game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("quickload", "quickload: performs a quick load", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    LOADSAVE.quickload();
                } else {
                    Console.Println("quickload: not in a game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("spawndude", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                block7: {
                    if (Globals.pGameInfo.nGameType != 0 || Mmulti.numplayers > 1) {
                        Console.Println("spawndude: Single player only");
                        return;
                    }
                    if (Console.osd_argc != 2) {
                        Console.Println("spawndude \"enemy type number\"");
                        return;
                    }
                    if (Main.this.isCurrentScreen(gGameScreen)) {
                        try {
                            int type = Integer.parseInt(Console.osd_argv[1]);
                            if (type > 200 && type < 256) {
                                Actor.actSpawnDude(Globals.gMe.pSprite, type, -1);
                                break block7;
                            }
                            Console.Println("spawndude: type out of range");
                        }
                        catch (Exception e) {
                            Console.Println("spawndude: type out of range");
                        }
                    } else {
                        Console.Println("spawndude: not in a game");
                    }
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("showcoords", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                SPRITE spr = Globals.gMe.pSprite;
                Console.Println("Player x: " + spr.x);
                Console.Println("Player y: " + spr.y);
                Console.Println("Player z: " + spr.z);
                Console.Println("Player sect: " + spr.sectnum);
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("maphack_angoff", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("maphack_angoff value");
                    return;
                }
                try {
                    int angoff = Integer.parseInt(Console.osd_argv[1]);
                    int nSprite = Main.this.getSprite();
                    if (nSprite != -1) {
                        Engine.spriteext[nSprite].angoff = (short)angoff;
                        Console.Println("sprite " + nSprite + " angoff " + angoff);
                    }
                }
                catch (Exception e) {
                    Console.Println("type out of range");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("maphack_notmd", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("maphack_notmd value");
                    return;
                }
                try {
                    int value = Integer.parseInt(Console.osd_argv[1]);
                    int nSprite = Main.this.getSprite();
                    if (nSprite != -1) {
                        Engine.spriteext[nSprite].flags = value == 1 ? (short)(Engine.spriteext[nSprite].flags | 1) : (short)(Engine.spriteext[nSprite].flags & 0xFFFFFFFE);
                        Console.Println("sprite " + nSprite + (value == 1 ? " notmd" : " notmd removed"));
                    }
                }
                catch (Exception e) {
                    Console.Println("type out of range");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("maphack_mdposxoff", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("maphack_mdposxoff value");
                    return;
                }
                try {
                    int angoff = Integer.parseInt(Console.osd_argv[1]);
                    int nSprite = Main.this.getSprite();
                    if (nSprite != -1) {
                        Engine.spriteext[nSprite].xoff = angoff;
                        Console.Println("sprite " + nSprite + " mdposxoff " + angoff);
                    }
                }
                catch (Exception e) {
                    Console.Println("type out of range");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("maphack_mdposyoff", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("maphack_mdposyoff value");
                    return;
                }
                try {
                    int angoff = Integer.parseInt(Console.osd_argv[1]);
                    int nSprite = Main.this.getSprite();
                    if (nSprite != -1) {
                        Engine.spriteext[nSprite].yoff = angoff;
                        Console.Println("sprite " + nSprite + " mdposyoff " + angoff);
                    }
                }
                catch (Exception e) {
                    Console.Println("type out of range");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("maphack_mdposzoff", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("maphack_mdposzoff value");
                    return;
                }
                try {
                    int angoff = Integer.parseInt(Console.osd_argv[1]);
                    int nSprite = Main.this.getSprite();
                    if (nSprite != -1) {
                        Engine.spriteext[nSprite].zoff = angoff;
                        Console.Println("sprite " + nSprite + " mdposzoff " + angoff);
                    }
                }
                catch (Exception e) {
                    Console.Println("type out of range");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("maphack_save", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                String name = "unknown";
                if (mUserFlag == UserFlag.UserMap && LEVELS.gUserMapInfo != null) {
                    name = Main.this.getFilename(LEVELS.gUserMapInfo.MapName);
                }
                if (mUserFlag != UserFlag.UserMap && LEVELS.currentEpisode != null) {
                    name = "e" + (Globals.pGameInfo.nEpisode + 1) + "m" + (Globals.pGameInfo.nLevel + 1);
                }
                String filename = String.valueOf(name) + ".mhk";
                FileResource fil = BuildGdx.compat.open(filename, Compat.Path.User, FileResource.Mode.Write);
                String checksum = "crc32 " + Globals.pGameInfo.uMapCRC + "\r\n";
                fil.writeBytes(checksum.getBytes(), checksum.length());
                int i = 0;
                while (i < Engine.MAXSPRITES) {
                    String msg;
                    if (Engine.spriteext[i].angoff != 0) {
                        msg = "sprite " + i + " angoff " + Engine.spriteext[i].angoff + "\r\n";
                        fil.writeBytes(msg.getBytes(), msg.length());
                    }
                    if (Engine.spriteext[i].xoff != 0) {
                        msg = "sprite " + i + " mdposxoff " + Engine.spriteext[i].xoff + "\r\n";
                        fil.writeBytes(msg.getBytes(), msg.length());
                    }
                    if (Engine.spriteext[i].yoff != 0) {
                        msg = "sprite " + i + " mdposyoff " + Engine.spriteext[i].yoff + "\r\n";
                        fil.writeBytes(msg.getBytes(), msg.length());
                    }
                    if (Engine.spriteext[i].zoff != 0) {
                        msg = "sprite " + i + " mdposzoff " + Engine.spriteext[i].zoff + "\r\n";
                        fil.writeBytes(msg.getBytes(), msg.length());
                    }
                    if ((Engine.spriteext[i].flags & 1) != 0) {
                        msg = "sprite " + i + " notmd\r\n";
                        fil.writeBytes(msg.getBytes(), msg.length());
                    }
                    ++i;
                }
                Console.Println("Saved to " + Compat.Path.User.getPath() + filename);
                fil.close();
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("maphack_load", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("maphack_load filename");
                    return;
                }
                String filename = Console.osd_argv[1];
                if (BuildGdx.cache.contains(filename, 0)) {
                    Maphack map = new Maphack(filename);
                    if (map.loadHack(Globals.pGameInfo.uMapCRC, Engine.spriteext)) {
                        Console.Println("Maphack is loaded");
                    } else {
                        Console.Println("Maphack isn't loaded. Wrong checksum");
                    }
                } else {
                    Console.Println("maphack_load: file not found");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("maphack_highlight", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                Globals.maphack_highlight = !Globals.maphack_highlight;
                Console.Println("Maphack highlight is " + (Globals.maphack_highlight ? "on" : "off"));
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("fastdemo", null, new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("fastdemo \"demo speed\"");
                    return;
                }
                try {
                    Main.engine.fastDemo.set(Integer.parseInt(Console.osd_argv[1]));
                }
                catch (Exception e) {
                    Console.Println("fastdemo: type out of range");
                }
            }
        }));
    }

    private void InitCutscenes() {
        String[] smknames;
        Console.Println("Initializing cutscenes");
        UserGroup group = BuildGdx.cache.add("Cutscenes", false);
        HashSet<String> paths = new HashSet<String>();
        int i = 0;
        while (i < 6) {
            EpisodeInfo ep = LEVELS.gEpisodeInfo[i];
            smknames = new String[]{ep.CutSceneA, ep.CutWavA, ep.CutSceneB, ep.CutWavB};
            int j = 0;
            while (j < smknames.length) {
                if (smknames[j] != null) {
                    File res = BuildGdx.compat.checkFile(smknames[j], Compat.Path.Absolute);
                    if (res != null) {
                        paths.add(String.valueOf(res.getParent()) + File.separator);
                        group.add(smknames[j], -1);
                    } else {
                        FileEntry entry;
                        int index = -1;
                        index = smknames[j].indexOf(":" + File.separator);
                        if (index != -1) {
                            smknames[j] = smknames[j].substring(index + 2);
                            if (j == 0) {
                                ep.CutSceneA = smknames[j];
                            } else if (j == 1) {
                                ep.CutWavA = smknames[j];
                            } else if (j == 2) {
                                ep.CutSceneB = smknames[j];
                            } else if (j == 3) {
                                ep.CutWavB = smknames[j];
                            }
                        }
                        if ((entry = BuildGdx.compat.checkFile(smknames[j])) != null) {
                            paths.add(String.valueOf(entry.getFile().getParent()) + File.separator);
                            group.add(entry, -1);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        smknames = new String[]{"logo.smk", "logo811m.wav", "gti.smk", "gti.wav"};
        int j = 0;
        while (j < smknames.length) {
            for (String path : paths) {
                File res = BuildGdx.compat.checkFile(String.valueOf(path) + smknames[j], Compat.Path.Absolute);
                if (res == null) continue;
                UserGroup.UserResource ures = group.add(smknames[j], -1);
                if (ures == null) break;
                ures.absolutePath = res.getAbsolutePath();
                break;
            }
            ++j;
        }
        if (group.numfiles == 0) {
            BuildGdx.cache.remove(group);
        }
    }

    public int getSprite() {
        int dx = Trig.Cos(Globals.gMe.pSprite.ang) >> 16;
        int dy = Trig.Sin(Globals.gMe.pSprite.ang) >> 16;
        int dz = (int)Globals.gMe.horizOff;
        Gameutils.HitScan(Globals.gMe.pSprite, Globals.gMe.viewOffZ, dx, dy, dz, Engine.pHitInfo, -65488, 0);
        return Engine.pHitInfo.hitsprite;
    }

    public void resetState() {
        Globals.kGameCrash = false;
        mUserFlag = UserFlag.None;
        LEVELS.currentEpisode = null;
        LOADSAVE.lastload = null;
        Globals.kFakeMultiplayer = false;
        if (LEVELS.usecustomarts || LEVELS.usecustomqavs) {
            LEVELS.resetEpisodeResources();
        }
        this.menu.mClose();
        this.menu.mOpen(this.menu.mMenus[0], -1);
        this.pInput.ctrlResetKeyStatus();
    }

    public void EndGame() {
        this.changeScreen(gLogoScreen.setTile(2050).setCallback(this.rMenu));
    }

    public void Disconnect() {
        this.changeScreen(gDisconnectScreen.setSkipping(this.rMenu));
    }

    public void GameWarning(String text) {
        BuildGdx.message.show("Warning: ", text, BuildMessage.MessageType.Info);
        Console.Println("Warning: " + text, Console.OSDTEXT_YELLOW);
    }

    public void dassert(String msg) {
        if (Globals.kGameCrash) {
            return;
        }
        this.ThrowError(msg);
        System.exit(0);
    }

    @Override
    public void GameMessage(String errorText) {
        BuildGdx.message.show("Error: ", errorText, BuildMessage.MessageType.Info);
        Console.Println("Game error: " + errorText, Console.OSDTEXT_RED);
        Globals.pGameInfo.uGameFlags = 2;
        Globals.pGameInfo.nLevel = 0;
        Globals.kGameCrash = true;
    }

    @Override
    public void show() {
        if (Main.cfg.showCutscenes && gCutsceneScreen.init("logo.smk", "logo811m.wav")) {
            this.changeScreen(gCutsceneScreen);
        } else {
            this.changeScreen(gLogoScreen);
        }
    }

    @Override
    protected byte[] reportData() {
        byte[] out = null;
        String text = "Mapname: " + Globals.boardfilename;
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + "UserFlag: " + (Object)((Object)mUserFlag);
        text = String.valueOf(text) + "\r\n";
        if (mUserFlag != UserFlag.UserMap && LEVELS.currentEpisode != null) {
            EpisodeInfo currentEpisode = LEVELS.currentEpisode;
            text = String.valueOf(text) + "Episode filename: " + currentEpisode.filename;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "Episode title: " + currentEpisode.Title;
            text = String.valueOf(text) + "\r\n";
        }
        if (Globals.pGameInfo != null) {
            text = String.valueOf(text) + "nDifficulty: " + Globals.pGameInfo.nDifficulty;
            text = String.valueOf(text) + "\r\n";
        } else {
            text = String.valueOf(text) + "it's shouldn't be null \r\n";
        }
        if (Globals.gMe != null && Globals.gMe.pSprite != null) {
            text = String.valueOf(text) + "PlayerX: " + Globals.gMe.pSprite.x;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerY: " + Globals.gMe.pSprite.y;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerZ: " + Globals.gMe.pSprite.z;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerAng: " + Globals.gMe.pSprite.ang;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerSect: " + Globals.gMe.pSprite.sectnum;
            text = String.valueOf(text) + "\r\n";
        }
        if (mUserFlag == UserFlag.UserMap && LEVELS.gUserMapInfo != null && LEVELS.gUserMapInfo.MapName != null) {
            ByteArray array = new ByteArray();
            byte[] data = BuildGdx.cache.getBytes(LEVELS.gUserMapInfo.MapName, 0);
            if (data != null) {
                text = String.valueOf(text) + "\r\n<------Start Map data------->\r\n";
                array.addAll(text.getBytes());
                array.addAll(data);
                array.addAll("\r\n<------End Map data------->\r\n".getBytes());
                out = Arrays.copyOf(array.items, array.size);
            }
        } else {
            out = text.getBytes();
        }
        return out;
    }

    public String getFilename(String path) {
        if (path != null) {
            int index = path.lastIndexOf("\\");
            if (index != -1) {
                path = path.substring(index + 1);
            } else {
                index = path.lastIndexOf("/");
                if (index != -1) {
                    path = path.substring(index + 1);
                }
            }
        }
        return path;
    }

    public static enum UserFlag {
        None,
        UserMap,
        Addon;

    }
}

