/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import java.util.HashMap;
import java.util.Map;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.SOUND;
import ru.m210projects.Blood.Types.SFX;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Script.Scriptfile;
import ru.m210projects.Build.Strhandler;

public class RFScript
extends Scriptfile {
    private final int T_DATA = 0;
    private final int T_RESOURCE = 1;
    private final int T_AS = 2;
    private final int T_SYMBOL = 3;
    private final int T_ERROR = 6;
    private final int T_EOF = 7;
    private HashMap<String, Integer> fileids;
    private final Map<String, Integer> basetokens = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("data", 0);
            this.put("resource", 1);
            this.put("as", 2);
            this.put(";", 3);
        }
    };

    public RFScript(Group gr, String name, byte[] buf) {
        super(name, buf);
        this.fileids = new HashMap();
        this.parse(gr);
    }

    private int gettoken(Map<String, Integer> list) {
        int tok = this.gettoken();
        if (tok == -2) {
            return 7;
        }
        Integer out = list.get(Strhandler.toLowerCase(this.textbuf.substring(tok, this.textptr)));
        if (out != null) {
            return out;
        }
        this.errorptr = this.textptr;
        return 6;
    }

    private Integer getValue() {
        String txt = this.getstring();
        int hexIndex = (txt = txt.replaceAll("[^0-9x-]", "")).indexOf("0x");
        if (hexIndex != -1) {
            txt = txt.substring(hexIndex + 2);
        }
        try {
            return Integer.parseInt(txt, hexIndex != -1 ? 16 : 10);
        }
        catch (Exception e) {
            return null;
        }
    }

    private int geteol() {
        int start = this.textptr;
        while (this.textptr < this.eof && this.textbuf.charAt(this.textptr) != ';') {
            ++this.textptr;
        }
        int end = this.textptr + 1;
        this.textptr = start;
        return end;
    }

    public HashMap<String, Integer> getIds() {
        return this.fileids;
    }

    @Override
    protected void preparse(byte[] data, int flen) {
        int numcr = 1;
        int i = 0;
        while (i < flen) {
            boolean cr = false;
            if (data[i] == 13) {
                i += data[i + 1] == 10 ? 1 : 0;
                cr = true;
            } else if (data[i] == 10) {
                i += data[i + 1] == 13 ? 1 : 0;
                cr = true;
            }
            if (cr) {
                ++numcr;
            }
            ++i;
        }
        this.linenum = numcr;
        this.lineoffs = new int[numcr];
        int nflen = 0;
        boolean space = false;
        int cs = 0;
        boolean inquote = false;
        numcr = 0;
        int i2 = 0;
        while (i2 < flen) {
            boolean cr = false;
            if (data[i2] == 13) {
                i2 += data[i2 + 1] == 10 ? 1 : 0;
                cr = true;
            } else if (data[i2] == 10) {
                i2 += data[i2 + 1] == 13 ? 1 : 0;
                cr = true;
            }
            if (cr) {
                this.lineoffs[numcr++] = nflen;
                inquote = false;
                if (cs == 1) {
                    cs = 0;
                }
                space = true;
            } else if (!(inquote || data[i2] != 32 && data[i2] != 9)) {
                space = true;
            } else {
                if (data[i2] == 47 && data[i2 + 1] == 47 && cs == 0) {
                    cs = 1;
                }
                if (data[i2] == 92 && data[i2 + 1] == 92 && cs == 0) {
                    cs = 1;
                }
                if (data[i2] == 47 && data[i2 + 1] == 42 && cs == 0) {
                    space = true;
                    cs = 2;
                }
                if (data[i2] == 42 && data[i2 + 1] == 47 && cs == 2) {
                    cs = 0;
                    ++i2;
                } else if (cs == 0) {
                    if (space) {
                        data[nflen++] = 0;
                        space = false;
                    }
                    if (data[i2] == 92 && data[i2 + 1] == 34) {
                        ++i2;
                        data[nflen++] = 34;
                    } else if (data[i2] == 34) {
                        inquote ^= true;
                    } else {
                        data[nflen++] = data[i2];
                    }
                }
            }
            ++i2;
        }
        data[nflen++] = 0;
        this.lineoffs[numcr] = nflen;
        data[nflen++] = 0;
        flen = nflen;
        this.textbuf = new String(data);
        this.textptr = 0;
        this.eof = nflen - 1;
    }

    private void nextLine(int line) {
        if (line < this.linenum) {
            this.textptr = this.lineoffs[line - 1];
        }
    }

    private void parse(Group group) {
        block8: while (!this.eof()) {
            int line = this.getlinum(this.textptr);
            if (this.textptr < this.lineoffs[0]) {
                --line;
            }
            int tokn = this.gettoken(this.basetokens);
            switch (tokn) {
                case 6: {
                    Console.Println("Error on line " + this.filename + ":" + line + ", skipping...", Console.OSDTEXT_RED);
                    this.nextLine(line);
                    break;
                }
                case 3: 
                case 7: {
                    break;
                }
                case 0: {
                    String sfxpath = this.getstring();
                    int dattoken = this.gettoken(this.basetokens);
                    if (dattoken == 2) {
                        try {
                            int soundId = this.getValue();
                            int relVol = this.getValue();
                            int pitch = this.getValue();
                            int pitchrange = this.getValue();
                            int format = this.getValue();
                            int loopStart = this.getValue();
                            String rawName = this.getstring();
                            int index = rawName.indexOf(";");
                            if (index != -1) {
                                rawName = rawName.substring(0, index);
                            }
                            SOUND.pSFXs[soundId] = new SFX(relVol, pitch, pitchrange, format, loopStart, rawName);
                            String idname = rawName;
                            if (idname.indexOf(".") == -1) {
                                idname = String.valueOf(idname) + ".raw";
                            }
                            this.fileids.put(idname, soundId);
                            if (group == null) break;
                            if (group.isRemovable()) {
                                group.add(sfxpath, SOUND.pSFXs[soundId].getBytes(), soundId);
                                break;
                            }
                            GroupResource res = group.open(idname);
                            if (res == null) break;
                            res.setIdentification(soundId);
                        }
                        catch (Exception e) {
                            Console.Println("Error on line " + this.filename + ":" + line + ", skipping...", Console.OSDTEXT_RED);
                            this.nextLine(line);
                        }
                        continue block8;
                    }
                    Console.Println("Error on line " + this.filename + ":" + line + ", skipping...", Console.OSDTEXT_RED);
                    this.nextLine(line);
                    break;
                }
                case 1: {
                    int eol = this.geteol();
                    String path = Main.game.getFilename(this.getstring());
                    if (path == null) break;
                    int optr = this.textptr;
                    int restoken = this.gettoken(this.basetokens);
                    String filename = Strhandler.toLowerCase(path);
                    filename = filename.replaceAll("[,;]", "");
                    if (restoken == 2) {
                        Integer value = null;
                        value = this.getValue();
                        if (value != null) {
                            GroupResource res;
                            int fileid = value;
                            this.fileids.put(filename, fileid);
                            if (group != null && (res = group.open(filename)) != null) {
                                res.setIdentification(fileid);
                            }
                        }
                    } else {
                        this.textptr = optr;
                    }
                    this.nextLine(line);
                }
            }
        }
    }
}

