/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import ru.m210projects.Blood.Gameutils;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.ScreenEffect;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Build.Script.TextureHDInfo;
import ru.m210projects.Build.Settings.BuildSettings;
import ru.m210projects.Build.Types.Palette;

public class Screen {
    public static byte[] tmpDAC = new byte[768];
    public static byte[][] palTable = new byte[5][];
    public static int curPalette;
    public static int gGammaLevels;
    public static byte[][] gammaTable;
    private static boolean restorepalette;

    static {
        gammaTable = new byte[16][256];
    }

    public static void scrCreateStdColors() {
        int i = 0;
        while (i < 32) {
            Globals.gStdColor[i] = Screen.scrFindClosestColor(Engine.palette, Globals.StdPal[i][0], Globals.StdPal[i][1], Globals.StdPal[i][2]);
            ++i;
        }
    }

    public static byte scrFindClosestColor(byte[] palette, int r, int g, int b) {
        int match = 0;
        int matchDist = Integer.MAX_VALUE;
        int i = 0;
        while (i < 256) {
            int db;
            int dr;
            int dist = 0;
            int dg = (palette[3 * i + 1] & 0xFF) - g;
            if ((dist += 1 * dg * dg) < matchDist && (dist += 1 * (dr = (palette[3 * i] & 0xFF) - r) * dr) < matchDist && (dist += 1 * (db = (palette[3 * i + 2] & 0xFF) - b) * db) < matchDist) {
                matchDist = dist;
                match = i;
                if (dist == 0) break;
            }
            ++i;
        }
        return (byte)match;
    }

    public static void scrLoadPLUs() {
        if (Globals.gFogMode) {
            byte[] buf = BuildGdx.cache.getBytes("FOG.FLU", 0);
            if (buf == null) {
                Console.Println("FOG.FLU not found", Console.OSDTEXT_RED);
                return;
            }
            int i = 0;
            while (i < 15) {
                int j = 0;
                while (j < 768) {
                    Engine.palookup[Globals.PLU[i].index][j] = buf[768 * i + j];
                    ++j;
                }
                ++i;
            }
            Engine.parallaxvisibility = 3072;
        } else {
            int i = 0;
            while (i < 15) {
                byte[] buf = BuildGdx.cache.getBytes(String.valueOf(Globals.PLU[i].name) + "." + "PLU", 0);
                if (buf == null) {
                    Console.Println(String.valueOf(Globals.PLU[i].name) + ".PLU not found", Console.OSDTEXT_RED);
                    return;
                }
                if (buf.length / 256 != 64) {
                    Console.Println("Incorrect PLU size", Console.OSDTEXT_RED);
                    return;
                }
                Engine.palookup[Globals.PLU[i].index] = buf;
                int colnum = 0;
                int colindex = Engine.palookup[Globals.PLU[i].index][colnum + 16128] & 0xFF;
                Engine.palookupfog[Globals.PLU[i].index][0] = Engine.palette[colindex];
                Engine.palookupfog[Globals.PLU[i].index][1] = Engine.palette[colindex + 1];
                Engine.palookupfog[Globals.PLU[i].index][2] = Engine.palette[colindex + 2];
                ++i;
            }
        }
    }

    public static void scrLoadPalette() {
        Console.Println("Loading palettes");
        Engine.palette = new byte[768];
        Engine.curpalette = new Palette();
        Engine.palookup = new byte[256][];
        int i = 0;
        while (i < Globals.PAL.length) {
            byte[] buf = BuildGdx.cache.getBytes(String.valueOf(Globals.PAL[i].name) + "." + "PAL", 0);
            if (buf == null) {
                Console.Println(String.valueOf(Globals.PAL[i].name) + ".PAL not found", Console.OSDTEXT_RED);
                return;
            }
            Screen.palTable[Globals.PAL[i].index] = buf;
            ++i;
        }
        System.arraycopy(palTable[0], 0, Engine.palette, 0, 768);
        Engine.paletteloaded = 1;
        Engine.numshades = (short)64;
        Screen.scrLoadPLUs();
        Console.Println("Loading translucency table", 0);
        Engine.transluc = BuildGdx.cache.getBytes("trans.tlu", 0);
        if (Engine.transluc == null) {
            Console.Println("TRANS.TLU not found", Console.OSDTEXT_RED);
            return;
        }
    }

    public static boolean scrSetGameMode(int davidoption, int daxdim, int daydim) {
        if (!Main.engine.setgamemode(davidoption, daxdim, daydim)) {
            Main.cfg.fullscreen = 0;
        }
        Engine.fullscreen = Main.cfg.fullscreen;
        Main.cfg.ScreenWidth = daxdim;
        Main.cfg.ScreenHeight = daydim;
        Screen.scrSetPalette(curPalette);
        return true;
    }

    public static void scrSetView(int mode) {
        switch (mode) {
            case 2: {
                if (Main.cfg.gOverlayMap == 1) {
                    View.gViewMode = 3;
                    break;
                }
                View.gViewMode = 4;
                break;
            }
            case 3: {
                if (Main.cfg.gOverlayMap != 0) {
                    View.gViewMode = 2;
                    break;
                }
                View.gViewMode = 4;
                break;
            }
            default: {
                View.gViewMode = 3;
                View.viewResizeView(Main.cfg.gViewSize);
            }
        }
    }

    public static void scrReset() {
        Globals.gMe.pickupEffect = 0;
        Globals.gMe.hitEffect = 0;
        Globals.gMe.blindEffect = 0;
        Globals.gMe.drownEffect = 0;
        ScreenEffect.resetEffects();
    }

    public static void scrSetPalette(int nPalette) {
        if (curPalette == nPalette) {
            return;
        }
        System.err.println("Palette has been changed to " + nPalette);
        curPalette = nPalette;
        Main.engine.setbrightness(BuildSettings.paletteGamma.get(), palTable[curPalette], GLRenderer.GLInvalidateFlag.All);
        if (Main.game.currentDef != null) {
            TextureHDInfo hdInfo = Main.game.currentDef.texInfo;
            if (nPalette == 1) {
                hdInfo.setPaletteTint(255, 100, 160, 255, 0);
            } else if (nPalette == 2) {
                hdInfo.setPaletteTint(255, 255, 120, 120, 0);
            } else if (nPalette == 3) {
                hdInfo.setPaletteTint(255, 180, 200, 50, 0);
            } else {
                hdInfo.setPaletteTint(255, 255, 255, 255, 0);
            }
        }
    }

    public static int coordsConvertXScaled(int coord, int bits) {
        int oxdim = Engine.xdim;
        int xdim = 4 * Engine.ydim / 3;
        int offset = oxdim - xdim;
        int normxofs = coord - 0xA00000;
        int wx = (xdim << 15) + Pragmas.scale(normxofs, xdim, 320L);
        wx += (oxdim - xdim) / 2;
        if ((bits & 0x100) == 256) {
            return wx - offset / 2 - 1;
        }
        if ((bits & 0x200) == 512) {
            return wx + offset / 2 - 1;
        }
        return wx - 1;
    }

    public static int coordsConvertYScaled(int coord) {
        int ydim = 3 * Engine.xdim / 4;
        int buildim = 200 * ydim / Engine.ydim;
        int normxofs = coord - (buildim << 15);
        int wy = (ydim << 15) + Pragmas.scale(normxofs, ydim, buildim);
        return wy;
    }

    public static void scrSetDac(int nTicks) {
        int pickupEffect = Globals.gPlayer[View.gViewIndex].pickupEffect;
        int hitEffect = Gameutils.ClipHigh(Globals.gPlayer[View.gViewIndex].hitEffect, 85);
        int blindEffect = Globals.gPlayer[View.gViewIndex].blindEffect;
        int drownEffect = Globals.gPlayer[View.gViewIndex].drownEffect;
        int scrR = pickupEffect + 2 * hitEffect - blindEffect - (drownEffect >> 6);
        int scrG = pickupEffect - 3 * hitEffect - blindEffect - (drownEffect >> 5);
        int scrB = pickupEffect + 3 * hitEffect + blindEffect + (drownEffect >> 6);
        boolean update = false;
        if ((scrR | scrG | scrG) != 0) {
            update = true;
            restorepalette = true;
        } else if (restorepalette) {
            update = true;
            restorepalette = false;
        }
        if (!update) {
            return;
        }
        int i = 0;
        while (i < 256) {
            Screen.tmpDAC[3 * i + 0] = (byte)Gameutils.ClipRange(Engine.curpalette.getRed(i) + scrR, 0, 255);
            Screen.tmpDAC[3 * i + 1] = (byte)Gameutils.ClipRange(Engine.curpalette.getGreen(i) + scrG, 0, 255);
            Screen.tmpDAC[3 * i + 2] = (byte)Gameutils.ClipRange(Engine.curpalette.getBlue(i) - scrB, 0, 255);
            ++i;
        }
        Main.engine.getrender().changepalette(tmpDAC);
    }

    public static void scrGLSetDac(int nTicks) {
        if (Main.game.menu == null) {
            return;
        }
        if (Main.game.menu.gShowMenu) {
            Main.engine.updateFade("DAMAGE", 0);
            Main.engine.updateFade("DROWN", 0);
            Main.engine.updateFade("BLIND", 0);
            Main.engine.updateFade("PICKUP", 0);
            return;
        }
        int pickup = Globals.gPlayer[View.gViewIndex].pickupEffect;
        int damage = Globals.gPlayer[View.gViewIndex].hitEffect;
        int choke = Globals.gPlayer[View.gViewIndex].blindEffect;
        int drown = Globals.gPlayer[View.gViewIndex].drownEffect;
        Main.engine.updateFade("DAMAGE", 3 * damage);
        Main.engine.updateFade("DROWN", drown);
        Main.engine.updateFade("BLIND", choke);
        Main.engine.updateFade("PICKUP", pickup);
        if ((pickup | damage | choke | drown) != 0) {
            Main.engine.showfade();
        }
    }
}

