/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood.Screens;

import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Screen;
import ru.m210projects.Blood.Strings;
import ru.m210projects.Blood.View;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.ScreenAdapters.LoadingAdapter;

public class LoadingScreen
extends LoadingAdapter {
    private Main app;

    public LoadingScreen(Main game) {
        super(game);
        this.app = game;
    }

    @Override
    public void draw(String title, float delta) {
        if (Globals.kGameCrash) {
            this.app.rMenu.run();
            return;
        }
        View.viewShowLoadingTile();
        this.engine.rotatesprite(0xA00000, 0x140000, 65536, 0, 2038, -128, 0, 78, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        this.app.getFont(1).drawText(160, 13, Strings.loading, -128, 0, BuildFont.TextAlign.Center, 2, false);
        this.app.getFont(3).drawText(160, 134, Strings.wait, -128, 0, BuildFont.TextAlign.Center, 2, false);
        this.app.getFont(1).drawText(160, 60, title, -128, 0, BuildFont.TextAlign.Center, 2, true);
    }

    @Override
    public void show() {
        super.show();
        Screen.scrSetPalette(0);
        Screen.scrReset();
        Screen.scrGLSetDac(0);
    }

    @Override
    public void pause() {
        if (BuildGdx.graphics.getFrameType() == BuildFrame.FrameType.GL) {
            BuildGdx.graphics.extra(BuildGraphics.Option.GLDefConfiguration, new Object[0]);
        }
    }

    @Override
    public void resume() {
        this.game.updateColorCorrection();
    }
}

