/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Blood;

import java.util.Arrays;
import ru.m210projects.Blood.Globals;
import ru.m210projects.Blood.Main;
import ru.m210projects.Blood.Types.PICANM;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Loader.Voxels.KVXLoader;
import ru.m210projects.Build.Loader.Voxels.Voxel;

public class Tile {
    public static int kSurfNone = 0;
    public static int kSurfStone = 1;
    public static int kSurfMetal = 2;
    public static int kSurfWood = 3;
    public static int kSurfFlesh = 4;
    public static int kSurfWater = 5;
    public static int kSurfDirt = 6;
    public static int kSurfClay = 7;
    public static int kSurfSnow = 8;
    public static int kSurfIce = 9;
    public static int kSurfLeaves = 10;
    public static int kSurfCloth = 11;
    public static int kSurfPlant = 12;
    public static int kSurfGoo = 13;
    public static int kSurfLava = 14;
    public static int kSurfMax = 15;
    public static int[] surfSfxLand = new int[]{-1, 600, 601, 602, 603, 604, 605, 605, 605, 600, 605, 605, 605, 604, 603};
    public static int[][] surfSfxMove = new int[][]{{-1, -1}, {802, 803}, {804, 805}, {806, 807}, {808, 809}, {810, 811}, {812, 813}, {814, 815}, {816, 817}, {818, 819}, {820, 821}, {822, 823}, {824, 825}, {826, 827}, {828, 829}};
    public static short[] gVoxelData = new short[Globals.kMaxTiles];
    public static byte[] shadeTable = new byte[Globals.kMaxTiles];

    public static void tileInit() {
        Tile.aPicInit();
        Tile.voxelsInit("VOXEL.DAT");
        Tile.shadeInit("SHADE.DAT");
    }

    public static void voxelsInit(String name) {
        Arrays.fill(gVoxelData, (short)-1);
        Resource bb = BuildGdx.cache.open(name, 0);
        if (bb != null) {
            int i = 0;
            while (i < bb.size() / 2) {
                Tile.gVoxelData[i] = bb.readShort();
                ++i;
            }
            bb.close();
        }
    }

    public static void tileLoadVoxel(int nTile) {
        Resource buffer;
        if (nTile < 0 || Globals.gPicAnm[nTile].view != 6 && Globals.gPicAnm[nTile].view != 7) {
            return;
        }
        short nVoxel = gVoxelData[nTile];
        if (Main.game.currentDef.mdInfo.getVoxel(nTile) == null && nVoxel >= 0 && nVoxel < 512 && (buffer = BuildGdx.cache.open(nVoxel, "KVX")) != null) {
            Voxel vox = KVXLoader.load(buffer);
            if (vox != null) {
                int i = 0;
                while (i < vox.zpiv.length) {
                    int n = i;
                    vox.zpiv[n] = vox.zpiv[n] + (Globals.gPicAnm[nTile].ycenter << 8) / (1 << i);
                    ++i;
                }
                if (vox.model != null) {
                    vox.model.zpiv += (float)Globals.gPicAnm[nTile].ycenter;
                }
            }
            Main.game.currentDef.mdInfo.addVoxelInfo(vox, nTile);
            buffer.close();
        }
    }

    public static void aPicInit() {
        int i = 0;
        while (i < Globals.kMaxTiles) {
            Globals.gPicAnm[i] = new PICANM(Engine.picanm[i]);
            ++i;
        }
    }

    public static void shadeInit(String name) {
        Resource data = BuildGdx.cache.open(name, 0);
        if (data == null) {
            return;
        }
        int pos = 0;
        while (data.hasRemaining()) {
            data.read(shadeTable, pos, Math.min(shadeTable.length, data.remaining()));
            pos += shadeTable.length;
        }
        data.close();
    }

    public static void tilePreloadTile(int nTile) {
        if (nTile < 0 || nTile >= Globals.kMaxTiles) {
            return;
        }
        int view = 0;
        switch (Globals.gPicAnm[nTile].view) {
            case 0: {
                view = 1;
                break;
            }
            case 1: {
                view = 5;
                break;
            }
            case 2: {
                view = 8;
                break;
            }
            case 3: {
                view = 2;
                break;
            }
            case 6: 
            case 7: {
                Tile.tileLoadVoxel(nTile);
                break;
            }
        }
        while (view > 0) {
            if (Globals.gPicAnm[nTile].type != 0) {
                int i = Globals.gPicAnm[nTile].frames;
                while (i >= 0) {
                    if (Globals.gPicAnm[nTile].type == 3) {
                        Main.gPrecacheScreen.addTile(nTile - i);
                    } else {
                        Main.gPrecacheScreen.addTile(nTile + i);
                    }
                    --i;
                }
            } else {
                Main.gPrecacheScreen.addTile(nTile);
            }
            nTile += Globals.gPicAnm[nTile].frames + 1;
            --view;
        }
    }
}

