/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Audio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class HMIMIDIP {
    public static final int NOTE_OFF = 128;
    public static final int NOTE_ON = 144;
    public static final int POLY_PRESSURE = 160;
    public static final int CONTROL_CHANGE = 176;
    public static final int PROGRAM_CHANGE = 192;
    public static final int CHANNEL_PRESSURE = 208;
    public static final int PITCH_BEND = 224;
    public static final int HMP_TRACK_COUNT_OFFSET = 48;
    public static final int HMP_DIVISION_OFFSET = 56;
    public static final int HMP_TRACK_OFFSET_0 = 776;
    public static final int HMP_TRACK_OFFSET_1 = 904;

    public static byte[] hmpinit(byte[] hmp) {
        ByteBuffer bb = ByteBuffer.wrap(hmp);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        byte[] tmp = new byte[32];
        bb.get(tmp);
        int TRACK_OFFSET = -1;
        String signature = new String(tmp, 0, 32);
        int index = signature.indexOf(0);
        signature = signature.substring(0, index).toUpperCase();
        if (signature.equals("HMIMIDIP013195")) {
            TRACK_OFFSET = 904;
        } else if (signature.equals("HMIMIDIP")) {
            TRACK_OFFSET = 776;
        } else {
            return null;
        }
        int nChunks = bb.getInt(48);
        int nBPM = bb.getInt(56);
        ByteBuffer mid = ByteBuffer.allocate(hmp.length);
        mid.putInt(1297377380);
        mid.putInt(6);
        mid.putShort((short)1);
        mid.putShort((short)nChunks);
        mid.putShort((short)(nBPM / 2));
        bb.position(TRACK_OFFSET);
        int i = 0;
        while (i < nChunks) {
            bb.getInt();
            int chunk_length = bb.getInt() - 12;
            bb.getInt();
            mid.put(new byte[]{77, 84, 114, 107});
            int pos = mid.position();
            mid.putInt(pos, HMIMIDIP.ProcessTrack(bb, chunk_length, mid));
            ++i;
        }
        return mid.array();
    }

    private static int ProcessTrack(ByteBuffer hmp, int size, ByteBuffer mid) {
        int runningStatus = -1;
        byte[] bytes = new byte[4];
        mid.putInt(0);
        int len = mid.position();
        int i = 0;
        while (i < size) {
            int n1 = 0;
            while (((bytes[n1] = hmp.get()) & 0x80) == 0) {
                ++n1;
            }
            int n2 = 0;
            while (n2 <= n1) {
                byte out = (byte)(bytes[n1 - n2] & 0x7F);
                if (n2 != n1) {
                    out = (byte)(out | 0x80);
                }
                mid.put(out);
                ++n2;
            }
            int sbyte = hmp.get() & 0xFF;
            if (sbyte == 0) break;
            if (sbyte == 255) {
                if (hmp.get() != 47 || hmp.get() != 0) break;
                mid.put((byte)-1);
                mid.put((byte)47);
                mid.put((byte)0);
                return mid.position() - len;
            }
            switch (sbyte & 0xF0) {
                case 128: 
                case 144: 
                case 160: 
                case 176: 
                case 224: {
                    if (sbyte != runningStatus) {
                        mid.put((byte)sbyte);
                    }
                    int d1 = hmp.get();
                    int d2 = hmp.get();
                    if ((sbyte & 0xF0) == 176) {
                        if (d1 == 110 && d2 == -1) {
                            d1 = 116;
                            d2 = 0;
                        }
                        if (d1 == 111) {
                            d1 = 117;
                            d2 = 127;
                        }
                    }
                    mid.put((byte)d1);
                    mid.put((byte)d2);
                    break;
                }
                case 192: 
                case 208: {
                    if (sbyte != runningStatus) {
                        mid.put((byte)sbyte);
                    }
                    mid.put(hmp.get());
                    break;
                }
                default: {
                    return mid.position() - len;
                }
            }
            runningStatus = sbyte;
            ++i;
        }
        return mid.position() - len;
    }
}

