/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build;

import ru.m210projects.Build.Types.LittleEndian;

public class BitHandler {
    public static final byte[] loMask = new byte[]{-1, 1, 3, 7, 15, 31, 63, 127, -1};
    public static final byte[] hiMask;
    public static final byte[] bitMask;

    static {
        byte[] byArray = new byte[9];
        byArray[0] = -1;
        byArray[1] = -2;
        byArray[2] = -4;
        byArray[3] = -8;
        byArray[4] = -16;
        byArray[5] = -32;
        byArray[6] = -64;
        byArray[7] = -128;
        hiMask = byArray;
        bitMask = new byte[4];
    }

    public static int buread(byte[] buffer, int bufferPos, int startBit, int endBit) {
        BitHandler.resetBitMask();
        byte sMask = hiMask[startBit];
        byte eMask = loMask[(endBit + 1) % 8];
        int nBytes = endBit / 8;
        BitHandler.bitMask[0] = sMask;
        BitHandler.bitMask[nBytes] = eMask;
        int mask = 0;
        int value = 0;
        switch (nBytes) {
            case 0: {
                mask = sMask & eMask;
                value = buffer[bufferPos] & 0xFF;
                break;
            }
            case 1: {
                mask = LittleEndian.getShort(bitMask, 0);
                value = LittleEndian.getUShort(buffer, bufferPos);
                break;
            }
            case 2: {
                int bm0 = bitMask[0] & 0xFF;
                int bm1 = bitMask[1] & 0xFF;
                int bm2 = bitMask[2] & 0xFF;
                mask = (bm2 << 16) + (bm1 << 8) + (bm0 << 0);
                value = (int)LittleEndian.getUInt(buffer, bufferPos);
                break;
            }
            case 3: {
                mask = LittleEndian.getInt(bitMask, 0);
                value = (int)LittleEndian.getUInt(buffer, bufferPos);
            }
        }
        return (value & mask) >> startBit;
    }

    public static int bsread(byte[] buffer, int bufferPos, int startBit, int endBit) {
        BitHandler.resetBitMask();
        byte sMask = hiMask[startBit];
        byte eMask = loMask[(endBit + 1) % 8];
        int nBytes = endBit / 8;
        BitHandler.bitMask[0] = sMask;
        BitHandler.bitMask[nBytes] = eMask;
        int mask = 0;
        int value = 0;
        switch (nBytes) {
            case 0: {
                mask = sMask & eMask;
                value = buffer[bufferPos] & 0xFF;
                break;
            }
            case 1: {
                mask = LittleEndian.getShort(bitMask, 0);
                value = LittleEndian.getUShort(buffer, bufferPos);
                break;
            }
            case 2: {
                int bm0 = bitMask[0] & 0xFF;
                int bm1 = bitMask[1] & 0xFF;
                int bm2 = bitMask[2] & 0xFF;
                mask = (bm2 << 16) + (bm1 << 8) + (bm0 << 0);
                value = (int)LittleEndian.getUInt(buffer, bufferPos);
                break;
            }
            case 3: {
                mask = LittleEndian.getInt(bitMask, 0);
                value = (int)LittleEndian.getUInt(buffer, bufferPos);
            }
        }
        int out = value & mask;
        if ((out & 1 << endBit) != 0) {
            out ^= 1 << endBit;
            out -= 1 << endBit;
        }
        return out >> startBit;
    }

    public static void bput(byte[] data, int bufferPos, int value, int startBit, int endBit) {
        BitHandler.resetBitMask();
        byte eMask = loMask[(endBit + 1) % 8];
        int nBytes = endBit / 8;
        BitHandler.bitMask[nBytes] = eMask;
        int mask = 0;
        switch (nBytes) {
            case 0: {
                mask = (hiMask[startBit] & eMask) >> startBit;
                int n = bufferPos;
                data[n] = (byte)(data[n] | (value & mask) << startBit);
                break;
            }
            case 1: {
                mask = LittleEndian.getShort(bitMask, 0);
                int val = value << startBit & mask;
                int n = bufferPos++;
                data[n] = (byte)(data[n] | (byte)(val & 0xFF));
                int n2 = bufferPos++;
                data[n2] = (byte)(data[n2] | (byte)(val >> 8 & 0xFF));
                break;
            }
            case 2: {
                int bm0 = bitMask[0] & 0xFF;
                int bm1 = bitMask[1] & 0xFF;
                int bm2 = bitMask[2] & 0xFF;
                mask = (bm2 << 16) + (bm1 << 8) + (bm0 << 0);
                int val = value << startBit & mask;
                int n = bufferPos++;
                data[n] = (byte)(data[n] | (byte)(val & 0xFF));
                int n3 = bufferPos++;
                data[n3] = (byte)(data[n3] | (byte)(val >> 8 & 0xFF));
                int n4 = bufferPos++;
                data[n4] = (byte)(data[n4] | (byte)(val >> 16 & 0xFF));
                break;
            }
            case 3: {
                mask = LittleEndian.getInt(bitMask, 0);
                int val = value << startBit & mask;
                int n = bufferPos++;
                data[n] = (byte)(data[n] | (byte)(val & 0xFF));
                int n5 = bufferPos++;
                data[n5] = (byte)(data[n5] | (byte)(val >> 8 & 0xFF));
                int n6 = bufferPos++;
                data[n6] = (byte)(data[n6] | (byte)(val >> 16 & 0xFF));
                int n7 = bufferPos++;
                data[n7] = (byte)(data[n7] | (byte)(val >> 24 & 0xFF));
            }
        }
    }

    public static void resetBitMask() {
        int i = 0;
        while (i < 4) {
            BitHandler.bitMask[i] = -1;
            ++i;
        }
    }
}

