/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.io.File;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.Pattern.Tools.NaturalComparator;
import ru.m210projects.Build.Strhandler;

public class FileEntry
implements Comparable<FileEntry> {
    private File file;
    private String extension;
    private String relPath;
    private DirectoryEntry parent;
    private long checksum;

    public FileEntry(File file, DirectoryEntry parent, String relPath) {
        this.file = file;
        this.parent = parent;
        String filename = file.getName();
        this.extension = Strhandler.toLowerCase(filename.substring(filename.lastIndexOf(46) + 1));
        this.relPath = relPath;
        this.checksum = -1L;
    }

    public long getChecksum() {
        if (this.checksum == -1L) {
            this.checksum = CRC32.getChecksum(this);
        }
        return this.checksum;
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return Strhandler.toLowerCase(this.file.getName());
    }

    public String getExtension() {
        return this.extension;
    }

    public String getPath() {
        return this.relPath;
    }

    public DirectoryEntry getParent() {
        return this.parent;
    }

    public String toString() {
        return String.valueOf(this.file.getAbsolutePath()) + ", Extension: " + this.extension;
    }

    @Override
    public int compareTo(FileEntry f) {
        String s1 = this.getName();
        String s2 = f.getName();
        return NaturalComparator.compare(s1, s2);
    }
}

