/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.FileHandle;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.Resource;

public class LZWDecoder
implements Closeable {
    private final Resource fil;
    private final int sizeof;
    private final int LZWSIZE = 16385;
    private byte[] lzwbuf1;
    private byte[] lzwbuf4;
    private byte[] lzwbuf5;
    private short[] lzwbuf2;
    private short[] lzwbuf3;

    public LZWDecoder(Resource res, int sizeof) {
        this.fil = res;
        this.sizeof = sizeof;
        this.lzwbuf1 = new byte[17409];
        this.lzwbuf2 = new short[17409];
        this.lzwbuf3 = new short[17409];
        this.lzwbuf4 = new byte[16385];
        this.lzwbuf5 = new byte[17409];
    }

    public int read(byte[] buf, int len) {
        Short leng;
        int dasizeof = this.sizeof;
        if (dasizeof > 16385) {
            len *= dasizeof;
            dasizeof = 1;
        }
        if ((leng = this.fil.readShort()) == null) {
            return -1;
        }
        if (this.fil.read(this.lzwbuf5, 0, (int)leng.shortValue()) != leng.shortValue()) {
            return -1;
        }
        int k = 0;
        int kgoal = this.lzwuncompress(this.lzwbuf5, leng.shortValue(), this.lzwbuf4);
        System.arraycopy(this.lzwbuf4, 0, buf, 0, dasizeof);
        k += dasizeof;
        int ptr = 0;
        int i = 1;
        while (i < len) {
            if (k >= kgoal) {
                leng = this.fil.readShort();
                if (leng == null) {
                    return ptr + dasizeof;
                }
                if (this.fil.read(this.lzwbuf5, 0, (int)leng.shortValue()) != leng.shortValue()) {
                    return -1;
                }
                k = 0;
                kgoal = this.lzwuncompress(this.lzwbuf5, leng.shortValue(), this.lzwbuf4);
            }
            int j = 0;
            while (j < dasizeof) {
                buf[ptr + j + dasizeof] = (byte)(buf[ptr + j] + this.lzwbuf4[j + k] & 0xFF);
                ++j;
            }
            k += dasizeof;
            ptr += dasizeof;
            ++i;
        }
        return ptr + dasizeof;
    }

    public int write(byte[] buf, int len) {
        int leng;
        if (!(this.fil instanceof FileResource)) {
            throw new UnsupportedOperationException("unsupported, won't implement");
        }
        FileResource fil = (FileResource)this.fil;
        if (fil.isClosed() || fil.getMode() != FileResource.Mode.Write) {
            return -1;
        }
        int dasizeof = this.sizeof;
        if (dasizeof > 16385) {
            len *= dasizeof;
            dasizeof = 1;
        }
        System.arraycopy(buf, 0, this.lzwbuf4, 0, dasizeof);
        int k = dasizeof;
        int ptr = 0;
        if (k > 16385 - dasizeof) {
            leng = this.lzwcompress(this.lzwbuf4, k, this.lzwbuf5);
            k = 0;
            fil.writeShort(leng);
            fil.writeBytes(this.lzwbuf5, leng);
        }
        int i = 1;
        while (i < len) {
            int j = 0;
            while (j < dasizeof) {
                this.lzwbuf4[j + k] = (byte)(buf[ptr + j + dasizeof] - buf[ptr + j] & 0xFF);
                ++j;
            }
            if ((k += dasizeof) > 16385 - dasizeof) {
                leng = this.lzwcompress(this.lzwbuf4, k, this.lzwbuf5);
                k = 0;
                fil.writeShort(leng);
                fil.writeBytes(this.lzwbuf5, leng);
            }
            ptr += dasizeof;
            ++i;
        }
        if (k > 0) {
            leng = this.lzwcompress(this.lzwbuf4, k, this.lzwbuf5);
            fil.writeShort(leng);
            fil.writeBytes(this.lzwbuf5, leng);
        }
        return len;
    }

    @Override
    public void close() {
        this.fil.close();
    }

    private int lzwcompress(byte[] lzwinbuf, int uncompleng, byte[] lzwoutbuf) {
        int intptr;
        int i = 255;
        while (i >= 0) {
            this.lzwbuf1[i] = (byte)i;
            this.lzwbuf3[i] = (short)(i + 1 & 0xFF);
            --i;
        }
        Arrays.fill(this.lzwbuf2, 0, 256, (short)-1);
        Arrays.fill(lzwoutbuf, 0, uncompleng + 15 + 3, (byte)0);
        ByteBuffer outbuf = ByteBuffer.wrap(lzwoutbuf);
        outbuf.order(ByteOrder.LITTLE_ENDIAN);
        short addrcnt = 256;
        int bytecnt1 = 0;
        int bitcnt = 32;
        int numbits = 8;
        short oneupnumbits = 256;
        short addr = 0;
        do {
            addr = (short)(lzwinbuf[bytecnt1] & 0xFF);
            while (++bytecnt1 != uncompleng) {
                if (this.lzwbuf2[addr] < 0) {
                    this.lzwbuf2[addr] = addrcnt;
                    break;
                }
                short newaddr = this.lzwbuf2[addr];
                while (this.lzwbuf1[newaddr] != lzwinbuf[bytecnt1]) {
                    short zx = this.lzwbuf3[newaddr];
                    if (zx < 0) {
                        this.lzwbuf3[newaddr] = addrcnt;
                        break;
                    }
                    newaddr = zx;
                }
                if (this.lzwbuf3[newaddr] != addrcnt && (addr = newaddr) >= 0) continue;
            }
            this.lzwbuf1[addrcnt] = lzwinbuf[bytecnt1];
            this.lzwbuf2[addrcnt] = -1;
            this.lzwbuf3[addrcnt] = -1;
            intptr = outbuf.getInt(bitcnt >> 3);
            outbuf.putInt(bitcnt >> 3, intptr | addr << (bitcnt & 7));
            bitcnt += numbits;
            if ((addr & (oneupnumbits >> 1) - 1) > (addrcnt - 1 & (oneupnumbits >> 1) - 1)) {
                --bitcnt;
            }
            if ((addrcnt = (short)(addrcnt + 1)) <= oneupnumbits) continue;
            ++numbits;
            oneupnumbits <<= 1;
        } while (bytecnt1 < uncompleng && bitcnt < uncompleng << 3);
        intptr = outbuf.getInt(bitcnt >> 3);
        outbuf.putInt(bitcnt >> 3, intptr | addr << (bitcnt & 7));
        bitcnt += numbits;
        if ((addr & (oneupnumbits >> 1) - 1) > (addrcnt - 1 & (oneupnumbits >> 1) - 1)) {
            --bitcnt;
        }
        outbuf.putShort(0, (short)uncompleng);
        if (bitcnt + 7 >> 3 < uncompleng) {
            outbuf.putShort(2, addrcnt);
            return bitcnt + 7 >> 3;
        }
        outbuf.putShort(2, (short)0);
        int i2 = 0;
        while (i2 < uncompleng) {
            outbuf.put(i2 + 4, lzwinbuf[i2]);
            ++i2;
        }
        return uncompleng + 4;
    }

    private int lzwuncompress(byte[] lzwinbuf, int compleng, byte[] lzwoutbuf) {
        ByteBuffer inbuf = ByteBuffer.wrap(lzwinbuf);
        inbuf.order(ByteOrder.LITTLE_ENDIAN);
        short strtot = inbuf.getShort(2);
        inbuf.position(4);
        if (strtot == 0) {
            inbuf.get(lzwoutbuf, 0, compleng - 4 + 3);
            return inbuf.getShort(0);
        }
        int i = 255;
        while (i >= 0) {
            this.lzwbuf2[i] = (short)i;
            this.lzwbuf3[i] = (short)i;
            --i;
        }
        short currstr = 256;
        int bitcnt = 32;
        int outbytecnt = 0;
        int numbits = 8;
        int oneupnumbits = 256;
        do {
            int intptr = inbuf.getInt(bitcnt >> 3);
            int dat = intptr >> (bitcnt & 7) & oneupnumbits - 1;
            bitcnt += numbits;
            if ((dat & (oneupnumbits >> 1) - 1) > (currstr - 1 & (oneupnumbits >> 1) - 1)) {
                dat &= (oneupnumbits >> 1) - 1;
                --bitcnt;
            }
            this.lzwbuf3[currstr] = (short)dat;
            int leng = 0;
            while (dat >= 256) {
                this.lzwbuf1[leng] = (byte)this.lzwbuf2[dat];
                ++leng;
                dat = this.lzwbuf3[dat];
            }
            lzwoutbuf[outbytecnt++] = (byte)dat;
            int i2 = leng - 1;
            while (i2 >= 0) {
                lzwoutbuf[outbytecnt++] = this.lzwbuf1[i2];
                --i2;
            }
            this.lzwbuf2[currstr - 1] = (short)dat;
            this.lzwbuf2[currstr] = (short)dat;
            if (++currstr <= oneupnumbits) continue;
            ++numbits;
            oneupnumbits <<= 1;
        } while (currstr < strtot);
        return inbuf.getShort(0);
    }
}

