/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Loader.MD2;

import com.badlogic.gdx.utils.BufferUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Loader.MD2.MD2Frame;
import ru.m210projects.Build.Loader.MD2.MD2Header;
import ru.m210projects.Build.Loader.MD2.MD2Model;
import ru.m210projects.Build.Loader.MD2.MD2Triangle;
import ru.m210projects.Build.Loader.Model;

public class MD2Loader {
    private static final byte[] charBuffer = new byte[16];

    public static Model load(Resource bb) {
        int j;
        MD2Header header = MD2Loader.loadHeader(bb);
        if (header.ident != 844121161 || header.version != 8) {
            return null;
        }
        MD2Triangle[] triangles = MD2Loader.loadTriangles(header, bb);
        float[] texCoords = MD2Loader.loadTexCoords(header, bb);
        MD2Frame[] frames = MD2Loader.loadFrames(header, bb);
        int[] glcmds = MD2Loader.loadGLCommands(header, bb);
        MD2Model out = new MD2Model();
        out.mdnum = 2;
        out.scale = 0.01f;
        out.numframes = header.numFrames;
        out.numverts = header.numVertices;
        out.numglcmds = header.numGLCommands;
        out.frames = frames;
        out.tris = triangles;
        out.glcmds = glcmds;
        out.indicesBuffer = BufferUtils.newShortBuffer(header.numTriangles * 3);
        int i = 0;
        while (i < header.numTriangles) {
            j = 0;
            while (j < 3) {
                out.indicesBuffer.put((short)(i * 3 + j));
                ++j;
            }
            ++i;
        }
        out.indicesBuffer.flip();
        out.verticesBuffer = BufferUtils.newFloatBuffer(header.numTriangles * 3 * 3);
        out.uv = BufferUtils.newFloatBuffer(header.numTriangles * 3 * 2);
        i = 0;
        while (i < header.numTriangles) {
            j = 0;
            while (j < 3) {
                short idx = triangles[i].texCoords[j];
                out.uv.put(texCoords[2 * idx]);
                out.uv.put(texCoords[2 * idx + 1]);
                ++j;
            }
            ++i;
        }
        out.uv.flip();
        return out;
    }

    private static MD2Frame[] loadFrames(MD2Header header, Resource bb) {
        bb.seek(header.offsetFrames, Resource.Whence.Set);
        MD2Frame[] frames = new MD2Frame[header.numFrames];
        int i = 0;
        while (i < header.numFrames) {
            MD2Frame frame = new MD2Frame();
            frame.vertices = new float[header.numVertices][3];
            float scaleX = bb.readFloat().floatValue();
            float scaleY = bb.readFloat().floatValue();
            float scaleZ = bb.readFloat().floatValue();
            float transX = bb.readFloat().floatValue();
            float transY = bb.readFloat().floatValue();
            float transZ = bb.readFloat().floatValue();
            bb.read(charBuffer);
            int len = 0;
            while (len < charBuffer.length) {
                if (charBuffer[len] == 0) break;
                ++len;
            }
            frame.name = new String(charBuffer, 0, len);
            int j = 0;
            while (j < header.numVertices) {
                float x = (float)(bb.readByte() & 0xFF) * scaleX + transX;
                float y = (float)(bb.readByte() & 0xFF) * scaleY + transY;
                float z = (float)(bb.readByte() & 0xFF) * scaleZ + transZ;
                bb.readByte();
                frame.vertices[j][0] = x;
                frame.vertices[j][1] = y;
                frame.vertices[j][2] = z;
                ++j;
            }
            frames[i] = frame;
            ++i;
        }
        return frames;
    }

    private static MD2Triangle[] loadTriangles(MD2Header header, Resource bb) {
        bb.seek(header.offsetTriangles, Resource.Whence.Set);
        MD2Triangle[] triangles = new MD2Triangle[header.numTriangles];
        int i = 0;
        while (i < header.numTriangles) {
            MD2Triangle triangle = new MD2Triangle();
            triangle.vertices[0] = bb.readShort();
            triangle.vertices[1] = bb.readShort();
            triangle.vertices[2] = bb.readShort();
            triangle.texCoords[0] = bb.readShort();
            triangle.texCoords[1] = bb.readShort();
            triangle.texCoords[2] = bb.readShort();
            triangles[i] = triangle;
            ++i;
        }
        return triangles;
    }

    private static float[] loadTexCoords(MD2Header header, Resource bb) {
        bb.seek(header.offsetTexCoords, Resource.Whence.Set);
        float[] texCoords = new float[header.numTexCoords * 2];
        float width = header.skinWidth;
        float height = header.skinHeight;
        int i = 0;
        while (i < header.numTexCoords) {
            short u = bb.readShort();
            short v = bb.readShort();
            texCoords[2 * i] = (float)u / width;
            texCoords[2 * i + 1] = (float)v / height;
            ++i;
        }
        return texCoords;
    }

    private static MD2Header loadHeader(Resource bb) {
        MD2Header header = new MD2Header();
        header.ident = bb.readInt();
        header.version = bb.readInt();
        header.skinWidth = bb.readInt();
        header.skinHeight = bb.readInt();
        header.frameSize = bb.readInt();
        header.numSkins = bb.readInt();
        header.numVertices = bb.readInt();
        header.numTexCoords = bb.readInt();
        header.numTriangles = bb.readInt();
        header.numGLCommands = bb.readInt();
        header.numFrames = bb.readInt();
        header.offsetSkin = bb.readInt();
        header.offsetTexCoords = bb.readInt();
        header.offsetTriangles = bb.readInt();
        header.offsetFrames = bb.readInt();
        header.offsetGLCommands = bb.readInt();
        header.offsetEnd = bb.readInt();
        return header;
    }

    public static int[] loadGLCommands(MD2Header header, Resource bb) {
        bb.seek(header.offsetGLCommands, Resource.Whence.Set);
        int[] glcmds = new int[header.numGLCommands];
        int i = 0;
        while (i < header.numGLCommands) {
            glcmds[i] = bb.readInt();
            ++i;
        }
        return glcmds;
    }
}

