/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.OnSceenDisplay;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.Input.InputCallback;
import ru.m210projects.Build.Input.KeyInput;
import ru.m210projects.Build.OnSceenDisplay.OSDCOMMAND;
import ru.m210projects.Build.OnSceenDisplay.OSDCVARFUNC;
import ru.m210projects.Build.OnSceenDisplay.OSDFunc;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;

public class Console {
    public static int OSDTEXT_RED = -2;
    public static int OSDTEXT_BLUE = -1;
    public static int OSDTEXT_GREEN = -1;
    public static int OSDTEXT_YELLOW = -1;
    public static int OSDTEXT_BROWN = -1;
    public static int OSDTEXT_GOLD = -1;
    public static int OSDTEXT_WHITE = -1;
    public static int OSDTEXT_GREY = -1;
    public static final int MAXLINES = 512;
    public static final int OSD_EDITLENGTH = 511;
    public static final int OSD_HISTORYDEPTH = 32;
    public static final int OSD_INITIALIZED = 1;
    public static final int OSD_DRAW = 2;
    public static final int OSD_CAPTURE = 4;
    public static final int OSD_OVERTYPE = 8;
    public static final int OSD_SHIFT = 16;
    public static final int OSD_CTRL = 32;
    public static final int OSD_CAPS = 64;
    public static int BGTILE = 2051;
    public static int BGCTILE = 2046;
    public static int BGTILE_SIZEX = 128;
    public static int BGTILE_SIZEY = 128;
    public static int BORDTILE = 2205;
    public static int BITSTH = 57;
    public static int BITSTL = 25;
    public static int BITS = 88;
    public static int BORDERANG = 0;
    public static int SHADE = 50;
    public static int PALETTE = 5;
    static OSDFunc func;
    private static final ByteArrayOutputStream logStream;
    public static final OSDCOMMAND osdpromptshade;
    public static final OSDCOMMAND osdpromptpal;
    public static final OSDCOMMAND osdeditshade;
    public static final OSDCOMMAND osdeditpal;
    public static final OSDCOMMAND osdtextshade;
    public static final OSDCOMMAND osdtextpal;
    static int osdflags;
    static char[][] osdtext;
    static short[][] osdfmt;
    static char[] osdver;
    static int osdverlen;
    static int osdvershade;
    static int osdverpal;
    static int osdpos;
    static int osdlines;
    static int osdrows;
    static int osdrowscur;
    public static int osdscroll;
    static int osdcols;
    static int osdmaxrows;
    static int osdhead;
    static int[] osdkey;
    static int keytime;
    static long osdscrtime;
    static int osdtextscale;
    static char[] osdeditbuf;
    static char[] osdedittmp;
    static int osdeditlen;
    static int osdeditcursor;
    static int osdeditwinstart;
    static int osdeditwinend;
    public static final int editlinewidth;
    static int osdhistorypos;
    static char[][] osdhistorybuf;
    static int osdhistorysize;
    static int osdhistorytotal;
    public static String[] osd_argv;
    public static int osd_argc;
    static int osdexeccount;
    static HashMap<String, OSDCOMMAND> osdvars;
    public static FileResource logfile;
    private static final InputCallback osdcallback;
    static boolean lastmatch;
    static int tabc;
    private static List<String> foundText;

    static {
        logStream = new ByteArrayOutputStream();
        osdpromptshade = new OSDCOMMAND("osdpromptshade", "osdpromptshade: sets the shade of the OSD prompt", 0.0f, 0, 255);
        osdpromptpal = new OSDCOMMAND("osdpromptpal", "osdpromptpal: sets the palette of the OSD prompt", 0.0f, 0, 255);
        osdeditshade = new OSDCOMMAND("osdeditshade", "osdeditshade: sets the shade of the OSD input text", 0.0f, 0, 7);
        osdeditpal = new OSDCOMMAND("osdeditpal", "osdeditpal: sets the palette of the OSD input text", 0.0f, 0, 255);
        osdtextshade = new OSDCOMMAND("osdtextshade", "osdtextshade: sets the shade of the OSD text", 0.0f, 0, 7);
        osdtextpal = new OSDCOMMAND("osdtextpal", "osdtextpal: sets the palette of the OSD text", 0.0f, 0, 255);
        osdflags = 0;
        osdtext = new char[512][];
        osdfmt = new short[512][];
        osdver = new char[64];
        osdpos = 0;
        osdlines = 1;
        osdrows = 20;
        osdrowscur = -1;
        osdscroll = 0;
        osdcols = 60;
        osdmaxrows = 20;
        osdhead = 0;
        osdkey = new int[4];
        keytime = 0;
        osdscrtime = 0L;
        osdtextscale = 65536;
        osdeditbuf = new char[512];
        osdedittmp = new char[512];
        osdeditlen = 0;
        osdeditcursor = 0;
        osdeditwinstart = 0;
        osdeditwinend = 56;
        editlinewidth = osdcols - 1 - 3;
        osdhistorypos = -1;
        osdhistorybuf = new char[32][512];
        osdhistorysize = 0;
        osdhistorytotal = 0;
        osd_argv = new String[80];
        osd_argc = 0;
        osdexeccount = 0;
        logfile = null;
        osdcallback = new InputCallback(){

            @Override
            public int run(int ch) {
                if (osdeditlen < 511 && ch < 128 && (ch = (osdflags & 0x10) != 0 ? KeyInput.gdxscantoascwithshift[ch] : KeyInput.gdxscantoasc[ch]) != 0) {
                    if (osdeditcursor <= osdeditlen - 1) {
                        if ((osdflags & 8) != 0) {
                            Console.osdeditbuf[Console.osdeditcursor++] = (char)ch;
                        } else {
                            System.arraycopy(osdeditbuf, osdeditcursor, osdeditbuf, osdeditcursor + 1, osdeditlen - osdeditcursor);
                            Console.osdeditbuf[Console.osdeditcursor++] = (char)ch;
                            ++osdeditlen;
                        }
                    } else {
                        Console.osdeditbuf[Console.osdeditlen++] = (char)ch;
                        osdeditcursor = osdeditlen;
                    }
                }
                return 0;
            }
        };
        foundText = new ArrayList<String>();
    }

    public static int RegisterCvar(OSDCOMMAND cvar) {
        if ((osdflags & 1) == 0) {
            Console.Init();
        }
        if (cvar.name == null || cvar.name.isEmpty()) {
            Console.Println("RegisterCvar(): can't register null cvar");
            return -1;
        }
        int pos = 0;
        while (pos < cvar.name.length()) {
            char cp = cvar.name.charAt(pos);
            if (cp >= '0' && cp <= '9') {
                Console.Println("RegisterCvar(): first character of cvar name \"" + cvar.name + "\" must not be a numeral");
                return -1;
            }
            if (cp < '0' || cp > '9' && cp < 'A' || cp > 'Z' && cp < 'a' && cp != '_' || cp > 'z') {
                Console.Println("RegisterCvar(): illegal character in cvar name \"" + cvar.name + "\"");
                return -1;
            }
            ++pos;
        }
        osdvars.put(cvar.name, cvar);
        return 0;
    }

    public static boolean Set(String cmd, int value) {
        OSDCOMMAND cvar = Console.Get(cmd);
        if (cvar != null) {
            return cvar.SetValue(value);
        }
        return false;
    }

    public static int Geti(String osdvar) {
        OSDCOMMAND var = Console.Get(osdvar);
        if (var != null) {
            return (int)var.value;
        }
        return 0;
    }

    public static float Getf(String osdvar) {
        OSDCOMMAND var = Console.Get(osdvar);
        if (var != null) {
            return var.value;
        }
        return 0.0f;
    }

    public static void setVersion(String version, int shade, int pal) {
        String fullname = String.valueOf(version) + " (BuildGdx: " + "20.062" + ")";
        System.arraycopy(fullname.toCharArray(), 0, osdver, 0, Math.min(64, fullname.length()));
        osdverlen = fullname.length();
        osdvershade = shade;
        osdverpal = pal;
    }

    public static void setParameters(int promptshade, int promptpal, int editshade, int editpal, int textshade, int textpal) {
        osdpromptshade.SetValue(promptshade);
        osdpromptpal.SetValue(promptpal);
        osdeditshade.SetValue(editshade);
        osdeditpal.SetValue(editpal);
        osdtextshade.SetValue(textshade);
        osdtextpal.SetValue(textpal);
    }

    public static void setFunction(OSDFunc func) {
        Console.func = func;
    }

    public static void Print(String text, int pal) {
        if (text == null || text.isEmpty()) {
            return;
        }
        if ((osdflags & 1) == 0) {
            Console.Init();
        }
        if (pal == OSDTEXT_RED) {
            System.err.println(text);
        } else {
            System.out.println(text);
        }
        Console.LogPrint(text);
        int chp = 0;
        int s = (int)Console.osdtextshade.value;
        do {
            if (text.charAt(chp) == '\n') {
                osdpos = 0;
                Console.LineFeed();
                continue;
            }
            if (text.charAt(chp) == '\r') {
                osdpos = 0;
                continue;
            }
            if (text.charAt(chp) == '\t') {
                int i = 0;
                while (i < 2) {
                    Console.osdtext[0][Console.osdpos++] = 32;
                    ++i;
                }
            } else {
                if (text.charAt(chp) == '^') {
                    String number = "";
                    if (chp + 1 >= text.length()) continue;
                    char num1 = text.charAt(chp + 1);
                    if (Strhandler.isdigit(num1)) {
                        char num2;
                        number = String.valueOf(number) + num1;
                        if (!Strhandler.isdigit(num2 = text.charAt(++chp + 1))) {
                            pal = Integer.parseInt(number, 10);
                            continue;
                        }
                        ++chp;
                        number = String.valueOf(number) + num2;
                        pal = Integer.parseInt(number, 10);
                        continue;
                    }
                    if (num1 == 'S' || num1 == 's') {
                        char num;
                        ++chp;
                        if (Strhandler.isdigit(num = text.charAt(++chp))) {
                            number = String.valueOf(number) + num;
                            s = Integer.parseInt(number, 10);
                            continue;
                        }
                    }
                    if (num1 == 'O' || num1 == 'o') {
                        ++chp;
                        pal = (int)Console.osdtextpal.value;
                        s = (int)Console.osdtextshade.value;
                        continue;
                    }
                }
                Console.osdtext[0][Console.osdpos] = text.charAt(chp);
                Console.osdfmt[0][Console.osdpos++] = (short)(pal + (s << 5));
                if (osdpos != osdcols) continue;
                osdpos = 0;
                if (chp >= text.length() - 1 || text.charAt(chp + 1) == '\u0000') continue;
                Console.LineFeed();
            }
        } while (++chp < text.length());
    }

    public static void Println(String text) {
        Console.Print(text, (int)Console.osdtextpal.value);
        osdpos = 0;
        Console.LineFeed();
    }

    public static void Println(String text, int pal) {
        Console.Print(text, pal);
        osdpos = 0;
        Console.LineFeed();
    }

    public static void Print(String text) {
        Console.Print(text, (int)Console.osdtextpal.value);
    }

    public static char[][] getTextPtr() {
        return osdtext;
    }

    public static short[][] getFmtPtr() {
        return osdfmt;
    }

    public static void SetLogFile(String fn) {
        if (logfile != null) {
            logfile.close();
        }
        logfile = null;
        if (fn != null) {
            logfile = BuildGdx.compat.open(Strhandler.toLowerCase(fn), Compat.Path.User, FileResource.Mode.Write);
        }
    }

    public static void CloseLogFile() {
        if (logfile != null) {
            logfile.close();
        }
        logfile = null;
    }

    public static void LogData(byte[] data) {
        if (logfile != null) {
            logfile.writeBytes(data, data.length);
        }
        Console.StreamData(data);
    }

    public static void StreamData(byte[] data) {
        try {
            logStream.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LogPrint(String str) {
        if (logfile != null) {
            Object object = Engine.lock;
            synchronized (object) {
                logfile.writeBytes(str.getBytes(), str.getBytes().length);
                logfile.writeBytes("\r\n".getBytes(), 2);
            }
        }
        Console.StreamPrint(str);
    }

    public static void StreamPrint(String str) {
        try {
            logStream.write(str.getBytes());
            logStream.write("\r\n".getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String GetLog() {
        return logStream.toString();
    }

    public static byte[] GetData() {
        return logStream.toByteArray();
    }

    public static boolean IsMoving() {
        return osdrowscur != -1 && osdrowscur != osdrows;
    }

    public static boolean IsShown() {
        return (osdflags & 2) != 0;
    }

    public static boolean IsInited() {
        return (osdflags & 1) != 0;
    }

    private static void Init() {
        osdlines = 1;
        osdflags |= 1;
        Console.osdtext[0] = new char[osdcols];
        Console.osdfmt[0] = new short[osdcols];
        Arrays.fill(osdfmt[0], (short)((int)(Console.osdtextpal.value + Console.osdtextshade.value) << 5));
        osdvars = new HashMap();
        Console.RegisterCvar(osdpromptshade);
        Console.RegisterCvar(osdpromptpal);
        Console.RegisterCvar(osdeditshade);
        Console.RegisterCvar(osdeditpal);
        Console.RegisterCvar(osdtextshade);
        Console.RegisterCvar(osdtextpal);
        Console.RegisterCvar(new OSDCOMMAND("help", "listsymbols: lists all registered functions, cvars and aliases", new OSDCVARFUNC(){

            @Override
            public void execute() {
                int maxwidth = 0;
                foundText.clear();
                for (String key : osdvars.keySet()) {
                    foundText.add(key);
                    maxwidth = Math.max(maxwidth, key.length());
                }
                maxwidth += 3;
                if (foundText.size() > 1) {
                    Collections.sort(foundText);
                    Console.Println("Symbol listing:", OSDTEXT_RED);
                    String msg = "  ";
                    int i = 0;
                    while (i < foundText.size()) {
                        msg = String.valueOf(msg) + (String)foundText.get(i);
                        int j = 0;
                        while (j < maxwidth - ((String)foundText.get(i)).length()) {
                            msg = String.valueOf(msg) + " ";
                            ++j;
                        }
                        if (msg.length() > osdcols - maxwidth) {
                            msg = String.valueOf(msg) + "\n";
                            Console.Print(msg);
                            if (i < foundText.size()) {
                                msg = "  ";
                            }
                        }
                        ++i;
                    }
                    if (msg.length() > 2) {
                        Console.Println(msg);
                    }
                    Console.Println("Found " + foundText.size() + " symbols", OSDTEXT_RED);
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("osdrows", "osdrows: sets the number of visible lines of the OSD", osdrows, new OSDCVARFUNC(){

            @Override
            public void execute() {
                osdrows = Integer.parseInt(osd_argv[1]);
                if (osdrows > osdmaxrows) {
                    osdrows = osdmaxrows;
                    Console.Set("osdrows", osdrows);
                }
                if (osdrowscur != -1) {
                    osdrowscur = osdrows;
                }
            }
        }, 0, 255));
        Console.RegisterCvar(new OSDCOMMAND("osdtextscale", "osdtextscale: sets the OSD text scale", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (osd_argc != 2) {
                    Console.Println("\"osdtextscale\" is \"" + String.format("%.2f", Float.valueOf((float)osdtextscale / 65535.0f)).replace(',', '.') + "\"");
                    Console.Println("osdtextscale: sets the OSD text scale");
                    return;
                }
                try {
                    float value = Float.parseFloat(osd_argv[1]);
                    if ((double)value > 0.5) {
                        Console.setTextScale((int)(value * 65536.0f));
                        osdtextscale = (int)(value * 65536.0f);
                        Console.ResizeDisplay(Engine.xdim, Engine.ydim);
                        if (osdrowscur != -1) {
                            osdrowscur = osdrows;
                        }
                    } else {
                        Console.Println("osdtextscale: out of range");
                    }
                }
                catch (Exception e) {
                    Console.Println("osdtextscale: out of range");
                }
            }
        }));
    }

    public static void setTextScale(int scale) {
        boolean isFullscreen = osdrowscur == osdmaxrows;
        osdtextscale = scale;
        if (!Console.IsInited() || func == null) {
            return;
        }
        Console.ResizeDisplay(Engine.xdim, Engine.ydim);
        if (isFullscreen) {
            Console.fullscreen(true);
        }
    }

    public static int getTextScale() {
        return osdtextscale;
    }

    public static void setCaptureKey(int sc, int num) {
        Console.osdkey[num] = sc;
    }

    private static void showDisplay(int onf) {
        osdflags = osdflags & 0xFFFFFFFD | -onf & 2;
    }

    private static void CaptureInput(boolean cap) {
        osdflags = osdflags & 0xFFFFFFCB | -(cap ? 1 : 0) & 4;
        func.showosd(cap ? 1 : 0);
        if (Engine.getInput() != null) {
            Engine.getInput().initMessageInput(null);
        }
    }

    public static void toggle() {
        osdscroll = -osdscroll;
        if (osdrowscur == -1) {
            osdscroll = 1;
        } else if (osdrowscur == osdrows) {
            osdscroll = -1;
        }
        osdrowscur += osdscroll;
        Console.CaptureInput(osdscroll == 1);
        osdscrtime = func.getticksfunc();
    }

    public static void fullscreen(boolean show) {
        osdrowscur = show ? osdmaxrows : -1;
        Console.showDisplay(show ? 1 : 0);
        if (func != null) {
            func.showosd(show ? 1 : 0);
        }
    }

    public static void HandleScanCode() {
        if ((osdflags & 1) == 0) {
            return;
        }
        int i = 0;
        while (i < 4) {
            if (Engine.getInput().keyStatusOnce(osdkey[i])) {
                Console.toggle();
                return;
            }
            ++i;
        }
        if ((osdflags & 4) == 0) {
            return;
        }
        keytime = func.gettime();
        if (Engine.getInput().keyStatusOnce(131)) {
            osdscroll = -1;
            --osdrowscur;
            Console.CaptureInput(false);
            osdscrtime = func.getticksfunc();
        }
        if (Engine.getInput().keyStatusOnce(92) && osdhead < osdlines - 2) {
            ++osdhead;
        }
        if (Engine.getInput().keyStatusOnce(93) && osdhead > 0) {
            --osdhead;
        }
        if (Engine.getInput().keyStatusOnce(3)) {
            if ((osdflags & 0x20) != 0) {
                osdhead = osdlines - 2;
            } else {
                osdeditwinstart = osdeditcursor = 0;
                osdeditwinend = osdeditwinstart + editlinewidth;
            }
        }
        if (Engine.getInput().keyStatusOnce(132)) {
            if ((osdflags & 0x20) != 0) {
                osdhead = 0;
            } else {
                osdeditcursor = osdeditlen;
                osdeditwinend = osdeditcursor;
                osdeditwinstart = osdeditwinend - editlinewidth;
                if (osdeditwinstart < 0) {
                    osdeditwinstart = 0;
                    osdeditwinend = editlinewidth;
                }
            }
        }
        if (Engine.getInput().keyStatusOnce(133)) {
            osdflags = osdflags & 0xFFFFFFF7 | -((osdflags & 8) == 0 ? 1 : 0) & 8;
        }
        if (Engine.getInput().keyStatusOnce(21)) {
            if (osdeditcursor > 0) {
                if ((osdflags & 0x20) != 0) {
                    while (osdeditcursor > 0) {
                        if (osdeditbuf[osdeditcursor - 1] != '>') break;
                        --osdeditcursor;
                    }
                    while (osdeditcursor > 0) {
                        if (osdeditbuf[osdeditcursor - 1] != '>') {
                            --osdeditcursor;
                            continue;
                        }
                        break;
                    }
                } else {
                    --osdeditcursor;
                }
            }
            if (osdeditcursor < osdeditwinstart) {
                osdeditwinend -= osdeditwinstart - osdeditcursor;
                osdeditwinstart -= osdeditwinstart - osdeditcursor;
            }
        }
        if (Engine.getInput().keyStatusOnce(22)) {
            if (osdeditcursor < osdeditlen) {
                if ((osdflags & 0x20) != 0) {
                    while (osdeditcursor < osdeditlen) {
                        if (osdeditbuf[osdeditcursor] == '>') break;
                        ++osdeditcursor;
                    }
                    while (osdeditcursor < osdeditlen) {
                        if (osdeditbuf[osdeditcursor] == '>') {
                            ++osdeditcursor;
                            continue;
                        }
                        break;
                    }
                } else {
                    ++osdeditcursor;
                }
            }
            if (osdeditcursor >= osdeditwinend) {
                osdeditwinstart += osdeditcursor - osdeditwinend;
                osdeditwinend += osdeditcursor - osdeditwinend;
            }
        }
        if (Engine.getInput().keyStatusOnce(19)) {
            Console.HistoryPrev();
        }
        if (Engine.getInput().keyStatusOnce(20)) {
            Console.HistoryNext();
        }
        osdflags = Engine.getInput().keyStatus(59) || Engine.getInput().keyStatus(60) ? (osdflags |= 0x10) : (osdflags &= 0xFFFFFFEF);
        osdflags = Engine.getInput().keyStatus(129) || Engine.getInput().keyStatus(130) ? (osdflags |= 0x20) : (osdflags &= 0xFFFFFFDF);
        if (Engine.getInput().keyStatusOnce(238)) {
            osdflags = osdflags & 0xFFFFFFBF | -((osdflags & 0x40) == 0 ? 1 : 0) & 0x40;
        }
        if (Engine.getInput().keyStatusOnce(67)) {
            if (osdeditcursor == 0 || osdeditlen == 0) {
                return;
            }
            if (osdeditcursor <= osdeditlen - 1) {
                System.arraycopy(osdeditbuf, osdeditcursor, osdeditbuf, osdeditcursor - 1, osdeditlen - osdeditcursor);
            }
            --osdeditlen;
            --osdeditcursor;
        }
        if (Engine.getInput().keyStatusOnce(66)) {
            if (osdeditlen > 0) {
                Console.osdeditbuf[Console.osdeditlen] = '\u0000';
                if (Strhandler.Bstrcmp(osdhistorybuf[0], osdeditbuf) != 0) {
                    i = 31;
                    while (i >= 1) {
                        System.arraycopy(osdhistorybuf[i - 1], 0, osdhistorybuf[i], 0, 512);
                        --i;
                    }
                    System.arraycopy(osdeditbuf, 0, osdhistorybuf[0], 0, 512);
                    if (osdhistorysize < 32) {
                        ++osdhistorysize;
                    }
                    ++osdhistorytotal;
                    ++osdexeccount;
                } else {
                    ++osdexeccount;
                }
                osdhistorypos = -1;
                String input = new String(osdeditbuf, 0, osdeditlen);
                if (Console.Dispatch(input) == -1) {
                    Console.Print("\"" + input + "\" is not a valid command or cvar\n", OSDTEXT_RED);
                }
            }
            osdhead = 0;
            osdeditlen = 0;
            osdeditcursor = 0;
            osdeditwinstart = 0;
            osdeditwinend = editlinewidth;
        }
        Engine.getInput().putMessage(osdcallback, false);
        if (Engine.getInput().keyStatusOnce(256)) {
            if (Engine.getInput().keyStatusOnce(61)) {
                Console.ListCommands();
            } else {
                lastmatch = false;
            }
        }
    }

    private static void HistoryPrev() {
        if (osdhistorypos >= osdhistorysize - 1) {
            return;
        }
        System.arraycopy(osdhistorybuf[++osdhistorypos], 0, osdeditbuf, 0, 512);
        osdeditcursor = 0;
        while (osdeditbuf[osdeditcursor] != '\u0000') {
            ++osdeditcursor;
        }
        osdeditlen = osdeditcursor;
        if (osdeditcursor < osdeditwinstart && (osdeditwinstart = (osdeditwinend = osdeditcursor) - editlinewidth) < 0) {
            osdeditwinend -= osdeditwinstart;
            osdeditwinstart = 0;
        }
    }

    private static void HistoryNext() {
        if (osdhistorypos < 0) {
            return;
        }
        if (osdhistorypos == 0) {
            osdeditlen = 0;
            osdeditcursor = 0;
            osdeditwinstart = 0;
            osdeditwinend = editlinewidth;
            osdhistorypos = -1;
            return;
        }
        System.arraycopy(osdhistorybuf[--osdhistorypos], 0, osdeditbuf, 0, 512);
        osdeditcursor = 0;
        while (osdeditbuf[osdeditcursor] != '\u0000') {
            ++osdeditcursor;
        }
        osdeditlen = osdeditcursor;
        if (osdeditcursor < osdeditwinstart && (osdeditwinstart = (osdeditwinend = osdeditcursor) - editlinewidth) < 0) {
            osdeditwinend -= osdeditwinstart;
            osdeditwinstart = 0;
        }
    }

    private static OSDCOMMAND Get(String osdvar) {
        if (osdvar == null || osdvar.isEmpty() || osdvars == null) {
            return null;
        }
        return osdvars.get(osdvar);
    }

    private static void TokenizeString(String text) {
        String osdvar;
        osd_argc = 0;
        if (text == null || text.isEmpty()) {
            return;
        }
        Arrays.fill(osd_argv, null);
        Console.osd_argv[++Console.osd_argc - 1] = osdvar = Strhandler.toLowerCase(text).trim();
        String var = null;
        int index = osdvar.indexOf(" ");
        while (index != -1) {
            var = osdvar.substring(0, index);
            osdvar = osdvar.substring(index).trim();
            Console.osd_argv[Console.osd_argc - 1] = var;
            Console.osd_argv[Console.osd_argc++] = osdvar;
            index = osdvar.indexOf(" ");
        }
    }

    private static void LineFeed() {
        System.arraycopy(osdtext, 0, osdtext, 1, Math.min(osdlines, 511));
        System.arraycopy(osdfmt, 0, osdfmt, 1, Math.min(osdlines, 511));
        Console.osdtext[0] = new char[osdcols];
        Console.osdfmt[0] = new short[osdcols];
        Arrays.fill(osdfmt[0], (short)((int)(Console.osdtextpal.value + Console.osdtextshade.value) << 5));
        if (osdlines < 512) {
            ++osdlines;
        }
    }

    private static void ListCommands() {
        if (!lastmatch) {
            char[] buf = osdeditbuf;
            int len = osdeditlen;
            int maxwidth = 0;
            String inputText = new String(buf, 0, len);
            if (inputText.isEmpty()) {
                return;
            }
            foundText.clear();
            for (String key : osdvars.keySet()) {
                if (!key.startsWith(inputText)) continue;
                foundText.add(key);
                maxwidth = Math.max(maxwidth, key.length());
            }
            maxwidth += 3;
            if (foundText.size() == 1) {
                osdeditlen = foundText.get(0).length();
                System.arraycopy(foundText.get(0).toCharArray(), 0, osdeditbuf, 0, osdeditlen);
                osdeditcursor = osdeditlen;
            } else if (foundText.size() > 1) {
                Collections.sort(foundText);
                Console.Println("Found " + foundText.size() + " possible completions for " + "\"" + inputText + "\"", OSDTEXT_RED);
                String msg = "  ";
                int i = 0;
                while (i < foundText.size()) {
                    msg = String.valueOf(msg) + foundText.get(i);
                    int j = 0;
                    while (j < maxwidth - foundText.get(i).length()) {
                        msg = String.valueOf(msg) + " ";
                        ++j;
                    }
                    if (msg.length() > osdcols - maxwidth) {
                        msg = String.valueOf(msg) + "\n";
                        Console.Print(msg);
                        if (i < foundText.size() - 1) {
                            msg = "  ";
                        }
                    }
                    ++i;
                }
                if (msg.length() > 2) {
                    Console.Println(msg);
                }
                Console.Println("Press TAB again to cycle through matches", OSDTEXT_RED);
                tabc = 0;
                lastmatch = true;
            }
        } else {
            String msg = foundText.get(tabc);
            tabc = tabc < foundText.size() - 1 ? ++tabc : 0;
            osdeditlen = msg.length();
            System.arraycopy(msg.toCharArray(), 0, osdeditbuf, 0, osdeditlen);
            osdeditcursor = osdeditlen;
        }
    }

    private static int Dispatch(String text) {
        if (osdvars != null) {
            OSDCOMMAND cvar;
            Console.TokenizeString(text);
            if (osd_argc >= 1 && (cvar = Console.Get(osd_argv[0])) != null) {
                int out = cvar.Set(osd_argv[1]);
                switch (out) {
                    case -1: {
                        text = String.valueOf(cvar.name) + " value out of range\n";
                        Console.Print(text);
                        return 0;
                    }
                    case 0: {
                        Console.Println(text);
                        return 0;
                    }
                    case 1: {
                        text = "\"" + cvar.name + "\"" + " is " + "\"" + (int)cvar.value + "\"\n" + cvar.desc + "\n";
                        Console.Print(text);
                        return 0;
                    }
                    case 2: {
                        return 0;
                    }
                }
            }
        }
        if (func.textHandler(text)) {
            return 0;
        }
        return -1;
    }

    public static void ResizeDisplay(int w, int h) {
        int newcols = func.getcolumnwidth(Pragmas.divscale(w, osdtextscale, 16));
        char[][] newosdtext = new char[512][];
        short[][] newosdfmt = new short[512][];
        int line = 0;
        int newline = 0;
        while (line != osdlines && newline < 512) {
            int pos = 0;
            newosdtext[newline] = new char[newcols];
            newosdfmt[newline] = new short[newcols];
            int swapline = newline;
            int ch = 0;
            while (ch < osdtext[line].length && osdtext[line][ch] != '\u0000') {
                if (pos >= newcols) {
                    newosdtext[++newline] = newosdtext[swapline];
                    newosdfmt[newline] = newosdfmt[swapline];
                    newosdtext[swapline] = new char[newcols];
                    newosdfmt[swapline] = new short[newcols];
                    pos = 0;
                }
                newosdtext[swapline][pos] = osdtext[line][ch];
                newosdfmt[swapline][pos] = osdfmt[line][ch];
                ++ch;
                ++pos;
            }
            ++line;
            ++newline;
        }
        osdtext = newosdtext;
        osdfmt = newosdfmt;
        osdlines = newline;
        osdcols = newcols;
        osdmaxrows = func.getrowheight(Pragmas.divscale(h, osdtextscale, 16)) - 2;
        if (osdrows > osdmaxrows) {
            osdrows = osdmaxrows;
            Console.Set("osdrows", osdrows);
        }
        osdpos = 0;
        osdhead = 0;
        osdeditwinstart = 0;
        osdeditwinend = editlinewidth;
    }

    public static void draw() {
        int shade;
        if ((osdflags & 1) == 0 || func == null) {
            return;
        }
        if (osdrowscur == 0) {
            Console.showDisplay((osdflags & 2) != 0 ? 0 : 1);
        }
        if (osdrowscur == osdrows || osdrowscur == osdmaxrows) {
            osdscroll = 0;
        } else {
            long j;
            if (osdrowscur < osdrows && osdscroll == 1 || osdrowscur < -1) {
                j = func.getticksfunc() - osdscrtime;
                while (j > -1L) {
                    j -= (long)(200 / osdrows);
                    if (++osdrowscur > osdrows - 1) break;
                }
            }
            if (osdrowscur > -1 && osdscroll == -1 || osdrowscur > osdrows) {
                j = func.getticksfunc() - osdscrtime;
                while (j > -1L) {
                    j -= (long)(200 / osdrows);
                    if (--osdrowscur < 1) break;
                }
            }
            osdscrtime = func.getticksfunc();
        }
        if ((osdflags & 2) == 0 || osdrowscur <= 0) {
            return;
        }
        int topoffs = osdhead;
        int row = osdrowscur - 1;
        int lines = Math.min(osdlines - osdhead, osdrowscur);
        func.clearbg(osdcols, Pragmas.mulscale(osdrowscur + 1, osdtextscale, 16));
        while (lines > 0) {
            func.drawosdstr(0, row, topoffs, osdcols, (int)Console.osdtextshade.value, (int)Console.osdtextpal.value, osdtextscale);
            ++topoffs;
            --lines;
            --row;
        }
        int offset = (osdflags & 0x50) == 80 && osdhead > 0 ? 1 : 0;
        int n = shade = (int)Console.osdpromptshade.value != 0 ? (int)Console.osdpromptshade.value : Engine.sintable[Engine.totalclock << 4 & 0x7FF] >> 11;
        if (osdhead == osdlines - 1) {
            func.drawchar(0, osdrowscur, '~', shade, (int)Console.osdpromptpal.value, osdtextscale);
        } else if (osdhead > 0) {
            func.drawchar(0, osdrowscur, '^', shade, (int)Console.osdpromptpal.value, osdtextscale);
        }
        if ((osdflags & 0x40) != 0) {
            func.drawchar(osdhead > 0 ? 1 : 0, osdrowscur, 'C', shade, (int)Console.osdpromptpal.value, osdtextscale);
        }
        if ((osdflags & 0x10) != 0) {
            func.drawchar(1 + ((osdflags & 0x40) != 0 && osdhead > 0 ? 1 : 0), osdrowscur, 'H', shade, (int)Console.osdpromptpal.value, osdtextscale);
        }
        func.drawchar(2 + offset, osdrowscur, '>', shade, (int)Console.osdpromptpal.value, osdtextscale);
        int len = Math.min(osdcols - 1 - 3 - offset, osdeditlen - osdeditwinstart);
        int x = len - 1;
        while (x >= 0) {
            func.drawchar(3 + x + offset, osdrowscur, osdeditbuf[x], (int)Console.osdeditshade.value << 1, (int)Console.osdeditpal.value, osdtextscale);
            --x;
        }
        func.drawcursor(offset += 3 + osdeditcursor - osdeditwinstart, osdrowscur, osdflags & 8, keytime, osdtextscale);
        if (osdver != null) {
            func.drawstr(osdcols - osdverlen + 2, osdrowscur - (offset >= osdcols - osdverlen + 2 ? 1 : 0), osdver, osdverlen, Engine.sintable[Engine.totalclock << 4 & 0x7FF] >> 11, osdverpal, osdtextscale);
        }
    }
}

