/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern;

import com.badlogic.gdx.math.Vector2;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.Input.KeyInput;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Settings.BuildConfig;

public abstract class BuildControls {
    public int oldPosX;
    public int oldPosY;
    public boolean[] maxisstatus;
    public Vector2 mouseMove;
    public Vector2 stick1;
    public Vector2 stick2;
    protected BuildControllers gpmanager;
    protected BuildConfig pCfg;

    public BuildControls(BuildConfig cfg, BuildControllers gpmanager) {
        this.pCfg = cfg;
        this.gpmanager = gpmanager;
        this.gpmanager.setDeadZone((float)cfg.gJoyDeadZone / 65536.0f);
        this.maxisstatus = new boolean[cfg.keymap.length];
        this.mouseMove = new Vector2();
        this.stick1 = new Vector2();
        this.stick2 = new Vector2();
    }

    public float getScaleX() {
        return 4.0f;
    }

    public float getScaleY() {
        return 0.25f;
    }

    public void resetMousePos() {
        if (BuildGdx.app.isActive()) {
            BuildGdx.input.setCursorPosition(Engine.xdim / 2, Engine.ydim / 2);
        }
        this.oldPosX = Engine.xdim / 2;
        this.oldPosY = Engine.ydim / 2;
    }

    public void ctrlMouseHandler() {
        this.mouseMove.set(0.0f, 0.0f);
        Arrays.fill(this.maxisstatus, false);
        if (this.pCfg.useMouse) {
            int dx = BuildGdx.input.getX() - this.oldPosX;
            int dy = BuildGdx.input.getY() - this.oldPosY;
            if (dx != 0) {
                if (dx > 0) {
                    if (this.pCfg.mouseaxis[1] != -1) {
                        this.maxisstatus[this.pCfg.mouseaxis[1]] = true;
                    }
                } else if (this.pCfg.mouseaxis[0] != -1) {
                    this.maxisstatus[this.pCfg.mouseaxis[0]] = true;
                }
            }
            if (dy != 0) {
                if (dy > 0) {
                    if (this.pCfg.mouseaxis[3] != -1) {
                        this.maxisstatus[this.pCfg.mouseaxis[3]] = true;
                    }
                } else if (this.pCfg.mouseaxis[2] != -1) {
                    this.maxisstatus[this.pCfg.mouseaxis[2]] = true;
                }
            }
            float sensscale = (float)this.pCfg.gSensitivity / 65536.0f;
            float xscale = sensscale * this.getScaleX();
            float yscale = sensscale * this.getScaleY();
            this.mouseMove.set((float)dx * xscale, (float)dy * yscale);
            this.resetMousePos();
        }
    }

    public float ctrlGetMouseMove() {
        return this.mouseMove.y * (float)this.pCfg.gMouseMoveSpeed / 65536.0f;
    }

    public float ctrlGetMouseLook(boolean invert) {
        if (invert) {
            return -this.mouseMove.y * (float)this.pCfg.gMouseLookSpeed / 65536.0f;
        }
        return this.mouseMove.y * (float)this.pCfg.gMouseLookSpeed / 65536.0f;
    }

    public float ctrlGetMouseTurn() {
        return this.mouseMove.x * (float)this.pCfg.gMouseTurnSpeed / 65536.0f;
    }

    public float ctrlGetMouseStrafe() {
        return this.mouseMove.x * (float)this.pCfg.gMouseStrafeSpeed / 2097152.0f;
    }

    public void ctrlJoyHandler() {
        this.stick1.set(0.0f, 0.0f);
        this.stick2.set(0.0f, 0.0f);
        if (this.gpmanager.isValidDevice(this.pCfg.gJoyDevice)) {
            this.stick1.set(this.gpmanager.getStickValue(this.pCfg.gJoyDevice, this.pCfg.gJoyTurnAxis, this.pCfg.gJoyLookAxis));
            this.stick2.set(this.gpmanager.getStickValue(this.pCfg.gJoyDevice, this.pCfg.gJoyStrafeAxis, this.pCfg.gJoyMoveAxis));
        }
    }

    public Vector2 ctrlGetStick(JoyStick stick) {
        if (stick == JoyStick.Turning) {
            return this.stick1;
        }
        return this.stick2;
    }

    public boolean ctrlPadStatusOnce(BuildConfig.KeyType buttonCode) {
        if (buttonCode instanceof BuildConfig.MenuKeys) {
            return this.gpmanager.isValidDevice(this.pCfg.gJoyDevice) && this.gpmanager.buttonStatusOnce(this.pCfg.gJoyDevice, this.pCfg.gJoyMenukeys[((BuildConfig.MenuKeys)buttonCode).getJoyNum()]);
        }
        return this.gpmanager.isValidDevice(this.pCfg.gJoyDevice) && this.gpmanager.buttonStatusOnce(this.pCfg.gJoyDevice, this.pCfg.gpadkeys[buttonCode.getNum()]);
    }

    public boolean ctrlPadStatus(BuildConfig.KeyType buttonCode) {
        if (buttonCode instanceof BuildConfig.MenuKeys) {
            return this.gpmanager.isValidDevice(this.pCfg.gJoyDevice) && this.gpmanager.buttonStatus(this.pCfg.gJoyDevice, this.pCfg.gJoyMenukeys[((BuildConfig.MenuKeys)buttonCode).getJoyNum()]);
        }
        return this.gpmanager.isValidDevice(this.pCfg.gJoyDevice) && this.gpmanager.buttonStatus(this.pCfg.gJoyDevice, this.pCfg.gpadkeys[buttonCode.getNum()]);
    }

    public boolean ctrlAxisStatusOnce(int keyId) {
        if (keyId >= 0 && this.maxisstatus[keyId]) {
            this.maxisstatus[keyId] = false;
            return true;
        }
        return false;
    }

    public boolean ctrlAxisStatus(int keyId) {
        return keyId >= 0 && this.maxisstatus[keyId];
    }

    public boolean ctrlKeyStatusOnce(int keyId) {
        return Engine.getInput().keyStatusOnce(keyId);
    }

    public boolean ctrlKeyStatus(int keyId) {
        return Engine.getInput().keyStatus(keyId);
    }

    public boolean ctrlKeyPressed(int keyId) {
        return Engine.getInput().keyPressed(keyId);
    }

    public boolean ctrlGetInputKey(BuildConfig.KeyType keyName, boolean once) {
        KeyInput input = Engine.getInput();
        int key1 = this.pCfg.primarykeys[keyName.getNum()];
        int key2 = this.pCfg.secondkeys[keyName.getNum()];
        int keyM = this.pCfg.mousekeys[keyName.getNum()];
        if (once) {
            return input.keyStatusOnce(key1) || input.keyStatusOnce(key2) || input.keyStatusOnce(keyM) || this.ctrlAxisStatusOnce(keyName.getNum()) || this.ctrlPadStatusOnce(keyName);
        }
        return input.keyStatus(key1) || input.keyStatus(key2) || input.keyStatus(keyM) || this.ctrlAxisStatus(keyName.getNum()) || this.ctrlPadStatus(keyName);
    }

    public void ctrlResetKeyStatus() {
        Engine.getInput().resetKeyStatus();
        this.gpmanager.resetButtonStatus();
    }

    public void ctrlResetInput() {
        this.ctrlResetKeyStatus();
        Arrays.fill(Engine.getInput().hitkey, false);
    }

    public boolean ctrlMenuMouse() {
        return this.pCfg.menuMouse;
    }

    public BuildControllers ctrlGetGamepadManager() {
        return this.gpmanager;
    }

    public void ctrlSetDeadZone(float value) {
        this.gpmanager.setDeadZone(value);
    }

    public boolean ctrlIsValidDevice(int deviceIndex) {
        return this.gpmanager.isValidDevice(deviceIndex) && this.gpmanager.getControllers() > 0;
    }

    public int ctrlGetControllers() {
        return this.gpmanager.getControllers();
    }

    public String ctrlGetControllerName(int num) {
        return this.gpmanager.getControllerName(num);
    }

    public abstract void ctrlGetInput(BuildNet.NetInput var1);

    public static enum JoyStick {
        Turning,
        Moving;

    }
}

