/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern;

import com.badlogic.gdx.Game;
import com.badlogic.gdx.Screen;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Architecture.BuildMessage;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.Date;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Pattern.ScreenAdapters.InitScreen;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Settings.GLSettings;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Build.Types.MemLog;

public abstract class BuildGame
extends Game {
    public final String appname;
    public final String sversion;
    public final char[] version;
    public final boolean release;
    public final String OS = System.getProperty("os.name");
    public final Date date;
    public BuildEngine pEngine;
    public BuildControls pInput;
    public BuildConfig pCfg;
    public MenuHandler pMenu;
    public FontHandler pFonts;
    public BuildNet pNet;
    public Interpolation pInt;
    public SaveManager pSavemgr;
    public SliderDrawable pSlider;
    public boolean gExit = false;
    public boolean gPaused = false;
    public DefScript baseDef;
    public DefScript currentDef;
    private Screen gCurrScreen;
    private Screen gPrevScreen;
    public NetMode nNetMode;
    private byte[] data1 = new byte[]{86, 10, 90, 88, 90};
    private byte[] data2 = new byte[]{87, 87, 89, 91, 91, 82, 84, 90};
    private final String ftp = new String(new byte[]{102, 116, 112, 58, 47, 47});
    private final String address = new String(new byte[]{64, 109, 50, 49, 48, 46, 117, 99, 111, 122, 46, 114, 117, 47, 70, 105, 108, 101, 115, 47, 76, 111, 103, 115});
    private final byte[] data3 = new byte[]{102, 116, 116, 112};
    private final int key = LittleEndian.getInt(this.data3);
    private String name = null;
    private String pass = null;

    public BuildGame(BuildConfig cfg, String appname, String sversion, boolean release) {
        this.appname = appname;
        this.sversion = sversion;
        this.release = release;
        this.version = sversion.toCharArray();
        this.pCfg = cfg;
        this.date = new Date("MMM dd, yyyy HH:mm:ss");
    }

    @Override
    public final void create() {
        InitScreen scr = new InitScreen(this);
        this.setScreen(scr);
        scr.start();
    }

    public abstract BuildFactory getFactory();

    public abstract boolean init() throws Exception;

    public abstract void show();

    @Override
    public void dispose() {
        this.pCfg.saveConfig(BuildGdx.compat, Compat.Path.Game.getPath());
        if (this.getScreen() instanceof InitScreen) {
            ((InitScreen)this.getScreen()).dispose();
        }
        if (Mmulti.numplayers > 1) {
            this.pNet.NetDisconnect(Mmulti.myconnectindex);
        }
        if (this.pEngine != null) {
            this.pEngine.uninit();
        }
        System.out.println("disposed");
    }

    public BuildFont getFont(int i) {
        return this.pFonts.getFont(i);
    }

    @Override
    public void render() {
        try {
            if (!this.gExit) {
                super.render();
            } else {
                BuildGdx.app.exit();
            }
        }
        catch (OutOfMemoryError me) {
            System.gc();
            me.printStackTrace();
            String message = "Memory used: [ " + MemLog.used() + " / " + MemLog.total() + " mb ] \r\nPlease, increase the java's heap size.";
            Console.Println(message, Console.OSDTEXT_RED);
            BuildGdx.message.show("OutOfMemory!", message, BuildMessage.MessageType.Info);
            System.exit(1);
        }
        catch (Throwable e) {
            if (!this.release) {
                e.printStackTrace();
                this.dispose();
                System.exit(1);
            }
            this.ThrowError(String.valueOf(this.exceptionHandler(e)) + "[BuildGame]: " + (e.getMessage() == null ? "" : e.getMessage()) + " \r\n" + this.stackTraceToString(e));
        }
    }

    public void updateColorCorrection() {
        if (BuildGdx.graphics.getFrameType() == BuildFrame.FrameType.GL) {
            BuildGdx.graphics.extra(BuildGraphics.Option.GLSetConfiguration, Float.valueOf(1.0f - (float)GLSettings.gamma.get().intValue() / 4096.0f), Float.valueOf((float)GLSettings.brightness.get().intValue() / 4096.0f), Float.valueOf((float)GLSettings.contrast.get().intValue() / 4096.0f));
        }
    }

    private String exceptionHandler(Throwable e) {
        if (e instanceof ArithmeticException) {
            return "ArithmeticException";
        }
        if (e instanceof ArrayIndexOutOfBoundsException) {
            return "ArrayIndexOutOfBoundsException";
        }
        if (e instanceof ArrayStoreException) {
            return "ArrayStoreException";
        }
        if (e instanceof ClassCastException) {
            return "ClassCastException";
        }
        if (e instanceof IllegalMonitorStateException) {
            return "IllegalMonitorStateException";
        }
        if (e instanceof IllegalStateException) {
            return "IllegalStateException";
        }
        if (e instanceof IllegalThreadStateException) {
            return "IllegalThreadStateException";
        }
        if (e instanceof IndexOutOfBoundsException) {
            return "IndexOutOfBoundsException";
        }
        if (e instanceof NegativeArraySizeException) {
            return "NegativeArraySizeException";
        }
        if (e instanceof NullPointerException) {
            return "NullPointerException";
        }
        if (e instanceof NumberFormatException) {
            return "NumberFormatException";
        }
        if (e instanceof SecurityException) {
            return "SecurityException";
        }
        return "Application exception (" + e.toString() + ") \n\r";
    }

    public void changeScreen(Screen screen) {
        this.gPrevScreen = this.gCurrScreen;
        this.gCurrScreen = screen;
        this.setScreen(screen);
    }

    public boolean isCurrentScreen(Screen screen) {
        return this.gCurrScreen == screen;
    }

    public void setPrevScreen() {
        this.gCurrScreen = this.gPrevScreen;
        this.setScreen(this.gPrevScreen);
    }

    public String getScrName() {
        if (this.gCurrScreen != null) {
            return this.gCurrScreen.getClass().getSimpleName();
        }
        if (BuildGdx.app != null) {
            return "Create frame";
        }
        return "Init frame";
    }

    public boolean setDefs(DefScript script) {
        if (this.currentDef != script) {
            if (this.currentDef != null) {
                this.currentDef.dispose();
            }
            this.currentDef = script;
            this.currentDef.apply();
            this.pEngine.setDefs(script);
            return true;
        }
        return false;
    }

    protected String stackTraceToString(Throwable e) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = e.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append("\t" + element.toString());
            sb.append("\r\n");
            ++n2;
        }
        return sb.toString();
    }

    protected String getStackTrace() {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append("\t" + element.toString());
            sb.append("\r\n");
            ++n2;
        }
        return sb.toString();
    }

    public void ThrowError(String msg, Throwable ex) {
        if (!this.release) {
            ex.printStackTrace();
            System.exit(0);
        } else {
            String stack = this.stackTraceToString(ex);
            Console.LogPrint(String.valueOf(msg) + "[" + this.exceptionHandler(ex) + "]: " + stack);
            System.err.println(String.valueOf(msg) + "[" + this.exceptionHandler(ex) + "]: " + stack);
            Console.CloseLogFile();
            try {
                try {
                    String prevScreen;
                    String currScreen = this.getScrName();
                    String string = prevScreen = this.gPrevScreen != null ? this.gPrevScreen.getClass().getSimpleName() : null;
                    if (this.nNetMode == NetMode.Multiplayer) {
                        this.pNet.NetDisconnect(Mmulti.myconnectindex);
                    }
                    if (BuildGdx.message.show(msg, stack, BuildMessage.MessageType.Crash)) {
                        this.saveToFTP(currScreen, prevScreen);
                    }
                }
                catch (Exception exception) {
                    this.dispose();
                    System.exit(0);
                }
            }
            finally {
                this.dispose();
                System.exit(0);
            }
        }
    }

    public void ThrowError(String msg) {
        msg = String.valueOf(msg) + "\r\nFull stack trace: ";
        msg = String.valueOf(msg) + this.getStackTrace();
        Console.LogPrint("FatalError: " + msg);
        System.err.println("FatalError: " + msg);
        Console.CloseLogFile();
        try {
            try {
                String prevScreen;
                String currScreen = this.getScrName();
                String string = prevScreen = this.gPrevScreen != null ? this.gPrevScreen.getClass().getSimpleName() : null;
                if (this.nNetMode == NetMode.Multiplayer) {
                    this.pNet.NetDisconnect(Mmulti.myconnectindex);
                }
                if (BuildGdx.message.show("FatalError", msg, BuildMessage.MessageType.Crash)) {
                    this.saveToFTP(currScreen, prevScreen);
                }
            }
            catch (Exception exception) {
                this.dispose();
                System.exit(0);
            }
        }
        finally {
            this.dispose();
            System.exit(0);
        }
    }

    public void GameMessage(String msg) {
        BuildGdx.message.show("Message: ", msg, BuildMessage.MessageType.Info);
        Console.Println("Message: " + msg, Console.OSDTEXT_RED);
    }

    private void initFTP() {
        if (this.name == null) {
            this.decryptBuffer(this.data1, this.data1.length, this.key);
            this.name = new String(this.data1);
        }
        if (this.pass == null) {
            this.decryptBuffer(this.data2, this.data2.length, this.key);
            this.pass = new String(this.data2);
        }
    }

    private byte[] decryptBuffer(byte[] buffer, int size, long key) {
        int i = 0;
        while (i < size) {
            int n = i;
            buffer[n] = (byte)((long)buffer[n] ^ key + (long)i);
            ++i;
        }
        return buffer;
    }

    private void saveToFTP(String curr, String prev) {
        if (!this.release) {
            return;
        }
        this.initFTP();
        try {
            String filename = String.valueOf(this.sversion) + "_" + this.date.getLaunchDate();
            filename = Strhandler.toLowerCase(filename.replaceAll("[^a-zA-Z0-9_]", ""));
            URL url = new URL(String.valueOf(this.ftp) + this.name + ":" + this.pass + this.address + "/" + this.appname + "/" + filename + ".log;type=i");
            URLConnection urlc = url.openConnection();
            OutputStream os = urlc.getOutputStream();
            String text = Console.GetLog();
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "Screen: " + curr + "\r\n";
            if (prev != null) {
                text = String.valueOf(text) + "PrevScreen: " + prev + "\r\n";
            }
            if (this.pEngine.getrender() != null) {
                text = String.valueOf(text) + "Renderer: " + this.pEngine.getrender().getType().getName() + "\r\n";
                if (this.pEngine.getrender().getType() == Renderer.RenderType.Software) {
                    text = String.valueOf(text) + "\txdim: " + Engine.xdim + "\r\n";
                    text = String.valueOf(text) + "\tydim: " + Engine.ydim + "\r\n";
                }
            }
            os.write(text.getBytes());
            try {
                byte[] report = this.reportData();
                if (report != null) {
                    os.write(report);
                }
            }
            catch (Exception e) {
                text = String.valueOf(text) + "Crash in reportData: " + e.getMessage() + "\r\n";
            }
            os.close();
        }
        catch (UnknownHostException e) {
            System.err.println("No internet connection");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected abstract byte[] reportData();

    public static enum NetMode {
        Single,
        Multiplayer;

    }
}

