/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Settings.BuildConfig;

public abstract class MenuKeyboardList
extends MenuList {
    public int l_set = 0;
    public MenuHandler.MenuOpt l_pressedId;
    protected BuildConfig.KeyType[] keynames;
    protected BuildConfig cfg;
    protected SliderDrawable slider;
    protected int scrollerX;
    protected int scrollerHeight;
    protected int touchY;
    protected boolean isTouched;
    public int pal_left;
    public int pal_right;

    public MenuKeyboardList(SliderDrawable slider, BuildConfig cfg, BuildFont font, int x, int y, int width, int len, MenuProc callback) {
        super(null, font, x, y, width, 0, null, callback, len);
        this.slider = slider;
        this.cfg = cfg;
        this.keynames = cfg.keymap;
        this.len = this.keynames.length;
    }

    public abstract String getKeyName(int var1);

    @Override
    public int mFontOffset() {
        return this.font.getHeight() + 2;
    }

    @Override
    public void draw(MenuHandler handler) {
        int px = this.x;
        int py = this.y;
        int i = this.l_nMin;
        while (i >= 0 && i < this.l_nMin + this.nListItems && i < this.len) {
            int shade = handler.getShade(i == this.l_nFocus ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
            int pal1 = this.pal_left;
            int pal2 = this.pal_right;
            if (i == this.l_nFocus) {
                pal2 = pal1 = handler.getPal(this.font, this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus]);
            }
            String text = this.keynames[i].getName();
            String key = this.getKeyName(this.cfg.primarykeys[i]);
            if (this.cfg.secondkeys[i] != 0) {
                key = String.valueOf(key) + " or " + this.getKeyName(this.cfg.secondkeys[i]);
            }
            if (i == this.l_nFocus && this.l_set == 1 && (Engine.totalclock & 0x20) != 0) {
                key = "____";
            }
            char[] k = key.toCharArray();
            this.font.drawText(px, py, text.toCharArray(), shade, pal1, BuildFont.TextAlign.Left, 2, this.fontShadow);
            this.font.drawText(this.x + this.width / 2 - 1 - this.font.getWidth(k) + 40, py, k, shade, pal2, BuildFont.TextAlign.Left, 2, this.fontShadow);
            key = this.cfg.mousekeys[i] != 0 ? this.getKeyName(this.cfg.mousekeys[i]) : " - ";
            if (i == this.l_nFocus && this.l_set == 1 && (Engine.totalclock & 0x20) != 0) {
                key = "____";
            }
            k = key.toCharArray();
            this.font.drawText(this.x + this.width - this.slider.getScrollerWidth() - 2 - this.font.getWidth(k), py, k, shade, pal2, BuildFont.TextAlign.Left, 2, this.fontShadow);
            py += this.mFontOffset();
            ++i;
        }
        this.scrollerHeight = this.nListItems * this.mFontOffset();
        int nList = Gameutils.BClipLow(this.len - this.nListItems, 1);
        int posy = this.y + (this.scrollerHeight - this.slider.getScrollerHeight()) * this.l_nMin / nList;
        this.scrollerX = this.x + this.width - this.slider.getScrollerWidth() + 5;
        this.slider.drawScrollerBackground(this.scrollerX, this.y, this.scrollerHeight, 0, 0);
        this.slider.drawScroller(this.scrollerX, posy, handler.getShade(this.isTouched ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null), 0);
        handler.mPostDraw(this);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if (this.l_set == 0) {
            switch (opt) {
                case MWUP: {
                    this.ListMouseWheelUp(handler);
                    return false;
                }
                case MWDW: {
                    this.ListMouseWheelDown(handler, this.len);
                    return false;
                }
                case UP: {
                    this.ListUp(handler, this.len);
                    return false;
                }
                case DW: {
                    this.ListDown(handler, this.len);
                    return false;
                }
                case ENTER: 
                case LMB: {
                    if ((this.flags & 4) == 0) {
                        return false;
                    }
                    if (opt == MenuHandler.MenuOpt.LMB && this.isTouched) {
                        if (this.len <= this.nListItems) {
                            return false;
                        }
                        int nList = Gameutils.BClipLow(this.len - this.nListItems, 1);
                        int nRange = this.scrollerHeight;
                        int py = this.y;
                        this.l_nFocus = -1;
                        this.l_nMin = Gameutils.BClipRange((this.touchY - py) * nList / nRange, 0, nList);
                        return false;
                    }
                    if (this.l_nFocus != -1 && this.callback != null) {
                        this.callback.run(handler, this);
                    }
                    Engine.getInput().resetKeyStatus();
                    return false;
                }
                case DELETE: {
                    if (this.l_nFocus == -1) {
                        return false;
                    }
                    this.cfg.primarykeys[this.l_nFocus] = 0;
                    this.cfg.secondkeys[this.l_nFocus] = 0;
                    this.cfg.mousekeys[this.l_nFocus] = 0;
                    if (this.l_nFocus == BuildConfig.GameKeys.Show_Console.getNum()) {
                        Console.setCaptureKey(this.cfg.primarykeys[this.l_nFocus], 0);
                        Console.setCaptureKey(this.cfg.secondkeys[this.l_nFocus], 1);
                        Console.setCaptureKey(this.cfg.mousekeys[this.l_nFocus], 2);
                    }
                    return false;
                }
                case PGUP: {
                    this.ListPGUp(handler);
                    return false;
                }
                case PGDW: {
                    this.ListPGDown(handler, this.len);
                    return false;
                }
                case HOME: {
                    this.ListHome(handler);
                    return false;
                }
                case END: {
                    this.ListEnd(handler, this.len);
                    return false;
                }
            }
            return this.m_pMenu.mNavigation(opt);
        }
        this.l_pressedId = opt;
        if ((this.flags & 4) != 0 && this.callback != null) {
            this.callback.run(handler, this);
        }
        if (this.l_nFocus == BuildConfig.GameKeys.Menu_Toggle.getNum()) {
            Engine.getInput().resetKeyStatus();
        }
        return false;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.l_set != 0) {
            return false;
        }
        if (!BuildGdx.input.isTouched()) {
            this.isTouched = false;
        }
        this.touchY = my;
        if (mx > this.scrollerX && mx < this.scrollerX + this.slider.getScrollerWidth()) {
            this.isTouched = BuildGdx.input.isTouched();
            return true;
        }
        if (!this.isTouched) {
            int py = this.y;
            int i = this.l_nMin;
            while (i >= 0 && i < this.l_nMin + this.nListItems && i < this.len) {
                if (my >= py && my < py + this.font.getHeight()) {
                    this.l_nFocus = i;
                    return true;
                }
                py += this.mFontOffset();
                ++i;
            }
        }
        return false;
    }
}

