/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.MenuItems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuProc;
import ru.m210projects.Build.Pattern.Tools.SaveManager;
import ru.m210projects.Build.Strhandler;

public abstract class MenuSlotList
extends MenuList {
    public boolean deleteQuestion;
    public List<SaveManager.SaveInfo> text;
    public MenuProc updateCallback;
    public MenuProc confirmCallback;
    public List<SaveManager.SaveInfo> displayed;
    protected final boolean saveList;
    public int nListOffset;
    public boolean typing;
    public char[] typingBuf = new char[16];
    public String typed;
    public int yHelpText;
    public int helpPal;
    public BuildFont questionFont;
    public BuildFont desriptionFont;
    public int specPal;
    public int backgroundPal;
    public int transparent = 1;
    public boolean owncursor = false;
    protected SaveManager saveManager;
    protected Engine draw;
    protected int nBackground;
    protected int listPal;

    public MenuSlotList(Engine draw, SaveManager saveManager, BuildFont font, int x, int y, int yHelpText, int width, int nListItems, MenuProc updateCallback, MenuProc confirmCallback, int listPal, int specPal, int nBackground, boolean saveList) {
        super(null, font, x, y, width, 0, null, null, nListItems);
        this.draw = draw;
        this.saveManager = saveManager;
        this.nBackground = nBackground;
        this.typing = false;
        this.text = saveManager.getList();
        this.nListItems = nListItems;
        this.nListOffset = 0;
        this.updateCallback = updateCallback;
        this.confirmCallback = confirmCallback;
        this.saveList = saveList;
        this.displayed = new ArrayList<SaveManager.SaveInfo>();
        this.yHelpText = yHelpText;
        this.questionFont = font;
        this.helpPal = listPal;
        this.specPal = specPal;
        this.listPal = listPal;
        this.desriptionFont = font;
    }

    public String FileName() {
        int ptr = this.l_nFocus;
        if (this.saveList) {
            --ptr;
        }
        if (ptr == -1 || this.displayed.size() == 0) {
            return "Empty slot";
        }
        return this.displayed.get((int)ptr).filename;
    }

    public String SaveName() {
        int ptr = this.l_nFocus;
        if (this.saveList) {
            --ptr;
        }
        if (ptr == -1 || this.displayed.size() == 0) {
            return "Empty slot";
        }
        return this.displayed.get((int)ptr).name;
    }

    @Override
    public void draw(MenuHandler handler) {
        int shade;
        int py;
        this.len = this.displayed.size();
        this.draw.rotatesprite(this.x + this.width / 2 - 5 << 16, this.y - 3 << 16, 65536, 0, this.nBackground, 128, this.backgroundPal, 0x1A | this.transparent, 0, 0, Gameutils.coordsConvertXScaled(this.x + this.width, Gameutils.ConvertType.Normal), Gameutils.coordsConvertYScaled(this.y + this.nListItems * this.mFontOffset() + 3));
        if (this.displayed.size() > 0) {
            py = this.y;
            if (this.saveList) {
                ++this.len;
            }
            int i = this.l_nMin;
            while (i >= 0 && i < this.l_nMin + this.nListItems && i < this.len) {
                int ptr = i;
                if (this.saveList) {
                    --ptr;
                }
                shade = handler.getShade(i == this.l_nFocus && !this.deleteQuestion ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
                char[] rtext = i == 0 && this.saveList ? Strhandler.toCharArray("New savegame") : Strhandler.toCharArray(this.displayed.get((int)ptr).name);
                int pal = ptr >= 0 && (this.displayed.get((int)ptr).filename.equals("autosave.sav") || this.displayed.get((int)ptr).filename.startsWith("quicksav")) ? this.specPal : this.listPal;
                if (i == this.l_nFocus && this.m_pMenu.mGetFocusedItem(this) && this.typing) {
                    Arrays.fill(this.typingBuf, '\u0000');
                    char[] buf = Engine.getInput().getMessageBuffer();
                    int messlen = Engine.getInput().getMessageLength();
                    if (!this.owncursor) {
                        ++messlen;
                    }
                    System.arraycopy(buf, 0, this.typingBuf, 0, Math.min(messlen, this.typingBuf.length));
                    rtext = this.typingBuf;
                    shade = -128;
                }
                this.font.drawText(this.x + this.width / 2 + this.nListOffset, py, rtext, shade, pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
                py += this.mFontOffset();
                ++i;
            }
        } else {
            char[] rtext;
            py = this.y;
            int shade2 = handler.getShade(this.l_nFocus != -1 ? this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus] : null);
            if (this.saveList) {
                rtext = Strhandler.toCharArray("New saved game");
                if (this.typing) {
                    Arrays.fill(this.typingBuf, '\u0000');
                    char[] buf = Engine.getInput().getMessageBuffer();
                    int messlen = Engine.getInput().getMessageLength();
                    if (!this.owncursor) {
                        ++messlen;
                    }
                    System.arraycopy(buf, 0, this.typingBuf, 0, Math.min(messlen, this.typingBuf.length));
                    rtext = this.typingBuf;
                    shade2 = -128;
                }
            } else {
                rtext = Strhandler.toCharArray("List is empty");
            }
            this.font.drawText(this.x + this.width / 2 + this.nListOffset, py, rtext, shade2, this.listPal, BuildFont.TextAlign.Left, 2, this.fontShadow);
        }
        this.pal = this.helpPal;
        if (this.deleteQuestion) {
            int tile = this.nBackground;
            float kv = (float)Engine.tilesizx[tile] / (float)Engine.tilesizy[tile];
            float kt = (float)Engine.xdim / (float)Engine.ydim;
            float scale = kv >= kt ? (float)(Engine.ydim + 1) / (float)Engine.tilesizy[tile] : (float)(Engine.xdim + 1) / (float)Engine.tilesizx[tile];
            this.draw.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 4, 0x18 | this.transparent, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            shade = handler.getShade(this.m_pMenu.m_pItems[this.m_pMenu.m_nFocus]);
            char[] ctext = Strhandler.toCharArray("Do you want to delete \"" + this.SaveName() + "\"");
            this.questionFont.drawText(160 - this.questionFont.getWidth(ctext) / 2, 100, ctext, shade, this.pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
            ctext = Strhandler.toCharArray("[Y/N]");
            this.questionFont.drawText(160 - this.questionFont.getWidth(ctext) / 2, 110, ctext, shade, this.pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
        } else {
            char[] ctext = Strhandler.toCharArray("Press \"DELETE\" to remove the savegame file");
            this.desriptionFont.drawText(160 - this.desriptionFont.getWidth(ctext) / 2, this.yHelpText, ctext, 0, this.pal, BuildFont.TextAlign.Left, 2, this.fontShadow);
        }
        handler.mPostDraw(this);
    }

    @Override
    public boolean callback(MenuHandler handler, MenuHandler.MenuOpt opt) {
        if (this.deleteQuestion) {
            if (Engine.getInput().getKey(53) != 0 || opt == MenuHandler.MenuOpt.ENTER) {
                this.saveManager.delete(this.FileName());
                this.updateList();
                Engine.getInput().setKey(53, 0);
                if (this.l_nFocus >= this.displayed.size()) {
                    int len = this.displayed.size();
                    if (this.saveList) {
                        ++len;
                    }
                    this.l_nFocus = len - 1;
                    this.l_nMin = len - this.nListItems;
                    if (this.l_nMin < 0) {
                        this.l_nMin = 0;
                    }
                }
                if (this.updateCallback != null) {
                    this.updateCallback.run(handler, this);
                }
                this.deleteQuestion = false;
            }
            if (Engine.getInput().getKey(42) != 0 || opt == MenuHandler.MenuOpt.ESC || opt == MenuHandler.MenuOpt.RMB) {
                Engine.getInput().setKey(42, 0);
                this.deleteQuestion = false;
            }
            return false;
        }
        int focus = this.l_nFocus;
        int len = this.displayed.size();
        if (this.saveList) {
            ++len;
            --focus;
        }
        if (this.typing) {
            if (opt != MenuHandler.MenuOpt.ESC) {
                if (Engine.getInput().putMessage(this.typingBuf.length, !this.owncursor, false, false) == 1 || opt == MenuHandler.MenuOpt.ENTER) {
                    this.typed = new String(Engine.getInput().getMessageBuffer(), 0, Engine.getInput().getMessageLength());
                    this.typing = false;
                    if (this.confirmCallback != null) {
                        this.confirmCallback.run(handler, this);
                    }
                }
            } else {
                this.typing = false;
            }
        } else {
            switch (opt) {
                case DELETE: {
                    if (!this.saveList && this.displayed.size() > 0 && this.l_nFocus != -1 || this.saveList && this.l_nFocus != 0) {
                        this.deleteQuestion = true;
                    }
                    return false;
                }
                case MWUP: {
                    this.ListMouseWheelUp(handler);
                    return false;
                }
                case MWDW: {
                    if (this.text != null) {
                        this.ListMouseWheelDown(handler, len);
                    }
                    return false;
                }
                case UP: {
                    this.ListUp(handler, len);
                    if (this.updateCallback != null) {
                        this.updateCallback.run(handler, this);
                    }
                    return false;
                }
                case DW: {
                    this.ListDown(handler, len);
                    if (this.updateCallback != null) {
                        this.updateCallback.run(handler, this);
                    }
                    return false;
                }
                case LEFT: {
                    this.ListLeft(handler);
                    if (this.updateCallback != null) {
                        this.updateCallback.run(handler, this);
                    }
                    return false;
                }
                case RIGHT: {
                    this.ListRight(handler);
                    if (this.updateCallback != null) {
                        this.updateCallback.run(handler, this);
                    }
                    return false;
                }
                case ENTER: 
                case LMB: {
                    if (this.l_nFocus != -1 && len > 0) {
                        if (this.saveList) {
                            if (this.l_nFocus == 0) {
                                Engine.getInput().initMessageInput(null);
                            } else {
                                Engine.getInput().initMessageInput(this.displayed.get((int)focus).name);
                            }
                            this.typing = true;
                            return false;
                        }
                        if (this.confirmCallback != null) {
                            this.confirmCallback.run(handler, this);
                        }
                        Engine.getInput().resetKeyStatus();
                    }
                    return false;
                }
                case ESC: 
                case RMB: {
                    this.ListEscape(handler, opt);
                    return true;
                }
                case PGUP: {
                    this.ListPGUp(handler);
                    if (this.updateCallback != null) {
                        this.updateCallback.run(handler, this);
                    }
                    return false;
                }
                case PGDW: {
                    this.ListPGDown(handler, len);
                    if (this.updateCallback != null) {
                        this.updateCallback.run(handler, this);
                    }
                    return false;
                }
                case HOME: {
                    this.ListHome(handler);
                    if (this.updateCallback != null) {
                        this.updateCallback.run(handler, this);
                    }
                    return false;
                }
                case END: {
                    this.ListEnd(handler, len);
                    if (this.updateCallback != null) {
                        this.updateCallback.run(handler, this);
                    }
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void open() {
        this.l_nFocus = 0;
        this.l_nMin = 0;
        Iterator<SaveManager.SaveInfo> i = this.text.iterator();
        while (i.hasNext()) {
            SaveManager.SaveInfo s = i.next();
            if (this.checkFile(s.filename)) continue;
            i.remove();
        }
        this.updateList();
        if (this.updateCallback != null) {
            this.updateCallback.run(null, this);
        }
    }

    public abstract boolean checkFile(String var1);

    public void updateList() {
        this.displayed.clear();
        this.displayed.addAll(this.text);
        if (this.saveList) {
            Iterator<SaveManager.SaveInfo> i = this.displayed.iterator();
            while (i.hasNext()) {
                SaveManager.SaveInfo s = i.next();
                if (!s.filename.equals("autosave.sav") && !s.filename.startsWith("quicksav")) continue;
                i.remove();
            }
        }
    }

    @Override
    public void close() {
        this.deleteQuestion = false;
        this.typing = false;
    }

    @Override
    public boolean mouseAction(int mx, int my) {
        if (this.deleteQuestion || this.typing) {
            return false;
        }
        if (this.displayed.size() > 0) {
            int px = this.x;
            int py = this.y;
            int len = this.displayed.size();
            if (this.saveList) {
                ++len;
            }
            int ol_nFocus = this.l_nFocus;
            int i = this.l_nMin;
            while (i >= 0 && i < this.l_nMin + this.nListItems && i < len) {
                if (mx > px && mx < px + this.width - 14 && my > py && my < py + this.font.getHeight()) {
                    this.l_nFocus = i;
                    if (ol_nFocus != i && this.updateCallback != null) {
                        this.updateCallback.run(null, this);
                    }
                    return true;
                }
                py += this.mFontOffset();
                ++i;
            }
        }
        return false;
    }
}

