/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;

public class LogoScreen
extends SkippableAdapter {
    protected int nTile;
    protected float gTicks;
    protected float gShowTime;
    protected Runnable callback;

    public LogoScreen(BuildGame game, float gShowTime) {
        super(game);
        this.gShowTime = gShowTime;
    }

    public LogoScreen setTile(int nTile) {
        this.nTile = nTile;
        return this;
    }

    public LogoScreen setCallback(Runnable callback) {
        this.callback = callback;
        this.skipCallback = callback;
        return this;
    }

    @Override
    public void show() {
        this.gTicks = 0.0f;
        this.game.pInput.ctrlResetKeyStatus();
    }

    @Override
    public void draw(float delta) {
        float f;
        this.gTicks += delta;
        if (f >= this.gShowTime && this.callback != null) {
            BuildGdx.app.postRunnable(this.callback);
            this.callback = null;
        }
        this.engine.clearview(0);
        this.engine.rotatesprite(0xA00000, 0x640000, 65536, 0, this.nTile, 0, 0, 74, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void pause() {
        if (BuildGdx.graphics.getFrameType() == BuildFrame.FrameType.GL) {
            BuildGdx.graphics.extra(BuildGraphics.Option.GLDefConfiguration, new Object[0]);
        }
    }

    @Override
    public void resume() {
        this.game.updateColorCorrection();
    }
}

