/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.ScreenAdapters;

import com.badlogic.gdx.ScreenAdapter;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Settings.BuildConfig;

public abstract class SkippableAdapter
extends ScreenAdapter {
    protected BuildGame game;
    protected Engine engine;
    protected boolean escSkip;
    protected Runnable skipCallback;

    public SkippableAdapter(BuildGame game) {
        this.game = game;
        this.engine = game.pEngine;
    }

    public SkippableAdapter setSkipping(Runnable skipCallback) {
        this.game.pInput.ctrlResetKeyStatus();
        this.skipCallback = skipCallback;
        return this;
    }

    public SkippableAdapter escSkipping(boolean escSkip) {
        this.escSkip = escSkip;
        return this;
    }

    public abstract void draw(float var1);

    public void skip() {
        if (this.skipCallback != null) {
            BuildGdx.app.postRunnable(this.skipCallback);
            this.skipCallback = null;
        }
        this.game.pInput.ctrlResetKeyStatus();
    }

    @Override
    public final void render(float delta) {
        this.engine.clearview(0);
        this.engine.sampletimer();
        this.skippingHandler();
        this.draw(delta);
        this.engine.nextpage();
    }

    private boolean skippingHandler() {
        if (this.escSkip && (this.game.pInput.ctrlGetInputKey(BuildConfig.GameKeys.Menu_Toggle, true) || this.game.pInput.ctrlPadStatusOnce(BuildConfig.GameKeys.Menu_Toggle)) || !this.escSkip && this.game.pInput.ctrlKeyStatusOnce(256)) {
            this.skip();
            return true;
        }
        return false;
    }

    @Override
    public void pause() {
        if (BuildGdx.graphics.getFrameType() == BuildFrame.FrameType.GL) {
            BuildGdx.graphics.extra(BuildGraphics.Option.GLDefConfiguration, new Object[0]);
        }
    }

    @Override
    public void resume() {
        this.game.updateColorCorrection();
    }
}

