/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Pattern.Tools;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.PropertyIgnoreCase;

public class IniFile {
    protected Map<String, Integer> context;
    protected List<Integer> pointer;
    protected List<Integer> length;
    protected int nContext = -1;
    protected PropertyIgnoreCase ini;
    protected StringReader reader;
    protected String name;
    protected byte[] data;
    private FileEntry file;

    protected IniFile() {
    }

    public IniFile(byte[] data, String name, FileEntry file) {
        this.name = Strhandler.toLowerCase(name);
        this.file = file;
        this.init(data);
    }

    public FileEntry getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public boolean set(String context) {
        context = Strhandler.toLowerCase(context);
        try {
            this.nContext = this.context.get(context);
        }
        catch (Exception e) {
            this.nContext = -1;
            return false;
        }
        String l = new String(this.data, (int)this.pointer.get(this.nContext), (int)this.length.get(this.nContext));
        if (!l.contains("\\\\")) {
            l = l.replace("\\", "\\\\");
        }
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = new StringReader(l);
        try {
            this.ini.clear();
            this.ini.load(this.reader);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.nContext = -1;
            return false;
        }
        return true;
    }

    public String GetKeyString(String key) {
        String out = this.ini.getPropertyIgnoreCase(key);
        if (out != null) {
            out = out.trim();
        }
        return out;
    }

    public String GetKeyString(String key, int num) {
        String line = this.ini.getPropertyIgnoreCase(key);
        if (line == null) {
            return null;
        }
        line = line.trim();
        int startpos = 0;
        int pos = 0;
        int keynum = 0;
        int mark = 0;
        while (pos < line.length()) {
            if (line.charAt(pos) == '\"') {
                ++mark;
            }
            if (mark < 2) {
                ++pos;
                continue;
            }
            if (line.charAt(pos) == ',') {
                if (keynum == num) break;
                ++keynum;
                mark = 0;
                startpos = pos + 1;
            }
            ++pos;
        }
        if (keynum != num) {
            return null;
        }
        line = line.substring(startpos, pos);
        line = line.replaceAll("\"", "");
        line = line.trim();
        return line;
    }

    public int GetKeyInt(String key, int num) {
        String line = this.ini.getPropertyIgnoreCase(key);
        if (line == null) {
            return 0;
        }
        line = line.trim();
        int startpos = 0;
        int pos = 0;
        int keynum = 0;
        while (pos < line.length()) {
            if (line.charAt(pos) == ',') {
                if (keynum == num) break;
                ++keynum;
                startpos = pos + 1;
            }
            ++pos;
        }
        line = line.substring(startpos, pos);
        line = line.replaceAll("[^0-9]", "");
        if (!line.isEmpty()) {
            return Integer.parseInt(line);
        }
        return 0;
    }

    public int GetKeyInt(String key) {
        String s = this.ini.getPropertyIgnoreCase(key);
        if (s != null && !s.isEmpty()) {
            if (!(s = s.replaceAll("[^0-9-]", "")).isEmpty()) {
                return Integer.parseInt(s);
            }
            return 0;
        }
        return -1;
    }

    public List<String> getPropertyList() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<Object, Object> entry : this.ini.entrySet()) {
            result.add((String)entry.getKey());
        }
        return result;
    }

    protected boolean isContext(String line) {
        return (line = line.trim()).startsWith("[") && line.endsWith("]");
    }

    protected void init(byte[] data) {
        this.data = data;
        if (data == null) {
            return;
        }
        this.ini = new PropertyIgnoreCase();
        this.context = new HashMap<String, Integer>();
        this.pointer = new ArrayList<Integer>();
        this.length = new ArrayList<Integer>();
        int ptr = 0;
        while (ptr < data.length) {
            char c;
            String line = "";
            while (ptr < data.length && (c = (char)data[ptr++]) != '\n') {
                line = String.valueOf(line) + c;
            }
            if (!this.isContext(line)) continue;
            this.pointer.add(ptr - line.length() - 1);
            line = Strhandler.toLowerCase(line.replaceAll("[^a-zA-Z0-9_-]", ""));
            this.context.put(line, this.pointer.size() - 1);
        }
        if (this.pointer.size() > 0) {
            int i = 0;
            while (i < this.pointer.size() - 1) {
                if (i + 1 < this.pointer.size()) {
                    this.length.add(this.pointer.get(i + 1) - this.pointer.get(i));
                }
                ++i;
            }
            this.length.add(data.length - this.pointer.get(this.pointer.size() - 1));
        }
    }

    public void close() {
        this.data = null;
        if (this.ini != null) {
            this.ini.clear();
            this.ini = null;
        }
    }
}

