/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Map;
import ru.m210projects.Build.Architecture.BuildApplication;
import ru.m210projects.Build.Architecture.BuildGdx;

public class BTexture
extends GLTexture {
    TextureData data;
    static final Map<BuildApplication, Array<BTexture>> managedTextures = new HashMap<BuildApplication, Array<BTexture>>();
    final int width;
    final int height;

    public BTexture(Pixmap pixmap, boolean useMipMaps) {
        super(3553, BuildGdx.gl.glGenTexture());
        this.width = pixmap.getWidth();
        this.height = pixmap.getHeight();
        this.data = new PixmapTextureData(pixmap, null, useMipMaps, false);
        this.load(this.data);
        if (this.data.isManaged()) {
            BTexture.addManagedTexture(BuildGdx.app, this);
        }
    }

    public BTexture(int width, int height) {
        super(3553);
        this.width = width;
        this.height = height;
    }

    private static void addManagedTexture(BuildApplication app, BTexture texture) {
        Array<BTexture> managedTextureArray = managedTextures.get(app);
        if (managedTextureArray == null) {
            managedTextureArray = new Array();
        }
        managedTextureArray.add(texture);
        managedTextures.put(app, managedTextureArray);
    }

    public void load(TextureData data) {
        if (this.data != null && data.isManaged() != this.data.isManaged()) {
            throw new GdxRuntimeException("New data must have the same managed status as the old data");
        }
        this.data = data;
        if (!data.isPrepared()) {
            data.prepare();
        }
        this.bind();
        BTexture.uploadImageData(3553, data);
        this.setFilter(this.minFilter, this.magFilter);
        this.setWrap(this.uWrap, this.vWrap);
        BuildGdx.gl.glBindTexture(this.glTarget, 0);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public boolean isManaged() {
        return false;
    }

    @Override
    protected void reload() {
    }

    @Override
    public void dispose() {
        if (this.glHandle == 0) {
            return;
        }
        this.delete();
        if (this.data != null && this.data.isManaged() && managedTextures.get(BuildGdx.app) != null) {
            managedTextures.get(BuildGdx.app).removeValue(this, true);
        }
    }
}

