/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.BuildApplication;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.Types.AndroidTextureBuffer;
import ru.m210projects.Build.Render.Types.DirectTextureBuffer;
import ru.m210projects.Build.Render.Types.FastTextureBuffer;
import ru.m210projects.Build.Render.Types.TextureBuffer;
import ru.m210projects.Build.Settings.GLSettings;

public class ImageUtils {
    private static final int TEX_MAX_SIZE = 1024;
    private static TextureBuffer tmp_buffer;

    public static PicInfo loadPic(int xsiz, int ysiz, int tsizx, int tsizy, byte[] data, int dapal, boolean clamped, boolean alphaMode, Renderer.PixelFormat type) {
        TextureBuffer buffer = ImageUtils.getTmpBuffer();
        buffer.clear();
        if (data != null && (tsizx * tsizy > data.length || data.length == 0)) {
            data = null;
        }
        boolean hasalpha = false;
        if (data == null) {
            buffer.putInt(0, 0);
            tsizy = 1;
            tsizx = 1;
            hasalpha = true;
        } else {
            if (alphaMode && type != Renderer.PixelFormat.Pal8) {
                int i = 0;
                while (i < data.length) {
                    if (data[i] == -1) {
                        hasalpha = true;
                        break;
                    }
                    ++i;
                }
            }
            int dptr = 0;
            int sptr = 0;
            int xoffs = xsiz << 2;
            if (clamped) {
                buffer.fill(0, xsiz * ysiz << 2, (byte)0);
                int i = 0;
                while (i < tsizx << 2) {
                    dptr = i;
                    int j = 0;
                    while (j < tsizy) {
                        buffer.putInt(dptr, ImageUtils.getColor(data[sptr++], dapal, alphaMode, type));
                        dptr += xoffs;
                        ++j;
                    }
                    i += 4;
                }
            } else {
                int len = data.length;
                int i = 0;
                while (i < xoffs) {
                    int p = 0;
                    dptr = i;
                    int j = 0;
                    while (j < ysiz) {
                        buffer.putInt(dptr, ImageUtils.getColor(data[sptr + p++], dapal, alphaMode, type));
                        dptr += xoffs;
                        if (p >= tsizy) {
                            p = 0;
                        }
                        ++j;
                    }
                    if ((sptr += tsizy) >= len) {
                        sptr = 0;
                    }
                    i += 4;
                }
            }
        }
        if (type == Renderer.PixelFormat.Rgb && data != null && hasalpha && !GLSettings.textureFilter.get().retro) {
            ImageUtils.fixtransparency(buffer, tsizx, tsizy, xsiz, ysiz, clamped);
        }
        return new PicInfo(buffer.getBuffer(), hasalpha);
    }

    private static int getColor(int dacol, int dapal, boolean alphaMode, Renderer.PixelFormat type) {
        dacol &= 0xFF;
        if (type == Renderer.PixelFormat.Pal8) {
            return dacol;
        }
        if (type == Renderer.PixelFormat.Pal8A) {
            if (alphaMode && dacol == 255) {
                return dacol;
            }
            return dacol | 0xFF000000;
        }
        if (alphaMode && dacol == 255) {
            return Engine.curpalette.getRGBA(0, (byte)0);
        }
        if (dacol >= Engine.palookup[dapal].length) {
            return 0;
        }
        if (Engine.UseBloodPal && dapal == 1) {
            int shade = Math.min(Math.max(Engine.globalshade, 0), Engine.numshades - 1);
            dacol = Engine.palookup[dapal][dacol + (shade << 8)] & 0xFF;
        } else {
            dacol = Engine.palookup[dapal][dacol] & 0xFF;
        }
        return Engine.curpalette.getRGBA(dacol, (byte)-1);
    }

    private static void fixtransparency(TextureBuffer dapic, int daxsiz, int daysiz, int daxsiz2, int daysiz2, boolean clamping) {
        int dox = daxsiz2 - 1;
        int doy = daysiz2 - 1;
        if (clamping) {
            dox = Math.min(dox, daxsiz);
            doy = Math.min(doy, daysiz);
        } else {
            daxsiz = daxsiz2;
            daysiz = daysiz2;
        }
        --daxsiz;
        --daysiz;
        int y = doy;
        while (y >= 0) {
            int wpptr = y * daxsiz2 + dox;
            int x = dox;
            while (x >= 0) {
                block15: {
                    int wp = wpptr << 2;
                    if (dapic.get(wp + 3) == 0) {
                        int rgb;
                        int j = 0;
                        int b = 0;
                        int g = 0;
                        int r = 0;
                        int index = wp - 4;
                        if (x > 0 && dapic.get(index + 3) != 0) {
                            r += dapic.get(index + 0) & 0xFF;
                            g += dapic.get(index + 1) & 0xFF;
                            b += dapic.get(index + 2) & 0xFF;
                            ++j;
                        }
                        index = wp + 4;
                        if (x < daxsiz && dapic.get(index + 3) != 0) {
                            r += dapic.get(index + 0) & 0xFF;
                            g += dapic.get(index + 1) & 0xFF;
                            b += dapic.get(index + 2) & 0xFF;
                            ++j;
                        }
                        index = wp - (daxsiz2 << 2);
                        if (y > 0 && dapic.get(index + 3) != 0) {
                            r += dapic.get(index + 0) & 0xFF;
                            g += dapic.get(index + 1) & 0xFF;
                            b += dapic.get(index + 2) & 0xFF;
                            ++j;
                        }
                        index = wp + (daxsiz2 << 2);
                        if (y < daysiz && dapic.get(index + 3) != 0) {
                            r += dapic.get(index + 0) & 0xFF;
                            g += dapic.get(index + 1) & 0xFF;
                            b += dapic.get(index + 2) & 0xFF;
                            ++j;
                        }
                        switch (j) {
                            case 0: 
                            case 1: {
                                rgb = ((dapic.get(wp + 3) & 0xFF) << 24) + (b << 16) + (g << 8) + (r << 0);
                                break;
                            }
                            case 2: {
                                rgb = ((dapic.get(wp + 3) & 0xFF) << 24) + (b + 1 >> 1 << 16) + (g + 1 >> 1 << 8) + (r + 1 >> 1 << 0);
                                break;
                            }
                            case 3: {
                                rgb = ((dapic.get(wp + 3) & 0xFF) << 24) + (b * 85 + 128 >> 8 << 16) + (g * 85 + 128 >> 8 << 8) + (r * 85 + 128 >> 8 << 0);
                                break;
                            }
                            case 4: {
                                rgb = ((dapic.get(wp + 3) & 0xFF) << 24) + (b + 2 >> 2 << 16) + (g + 2 >> 2 << 8) + (r + 2 >> 2 << 0);
                                break;
                            }
                            default: {
                                break block15;
                            }
                        }
                        dapic.putInt(wp, rgb);
                    }
                }
                --x;
                --wpptr;
            }
            --y;
        }
    }

    public static TextureBuffer getTmpBuffer() {
        if (tmp_buffer == null) {
            int size = 0x400000;
            try {
                tmp_buffer = BuildGdx.app.getPlatform() != BuildApplication.Platform.Android ? new FastTextureBuffer(size) : new AndroidTextureBuffer(size);
            }
            catch (Exception e) {
                e.printStackTrace();
                tmp_buffer = new DirectTextureBuffer(size);
            }
        }
        return tmp_buffer;
    }

    public static class PicInfo {
        public final ByteBuffer pic;
        public final boolean hasalpha;

        public PicInfo(ByteBuffer pic, boolean hasalpha) {
            this.pic = pic;
            this.hasalpha = hasalpha;
        }
    }
}

