/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Render.TextureHandle.BTexture;
import ru.m210projects.Build.Render.TextureHandle.Hicreplctyp;
import ru.m210projects.Build.Render.TextureHandle.ImageUtils;
import ru.m210projects.Build.Render.TextureHandle.Pthtyp;
import ru.m210projects.Build.Render.TextureHandle.TextureUtils;
import ru.m210projects.Build.Render.Types.GLFilter;
import ru.m210projects.Build.Render.Types.TextureBuffer;
import ru.m210projects.Build.Script.TextureHDInfo;
import ru.m210projects.Build.Settings.GLSettings;

public class TextureCache {
    private Renderer.PixelFormat type = Renderer.PixelFormat.Rgb;
    private final Pthtyp[] cache = new Pthtyp[Engine.MAXTILES];
    private TextureHDInfo info;
    private ShaderProgram shader;
    private BTexture[] palette;

    public TextureCache() {
        boolean useShader = false;
        if (useShader) {
            this.shader = this.createShader();
        }
        this.changePalette(Engine.palette);
    }

    public void setTextureInfo(TextureHDInfo info) {
        this.info = info;
    }

    private Pthtyp get(int picnum, int palnum, boolean clamped, int surfnum) {
        Pthtyp pth = this.cache[picnum];
        while (pth != null) {
            if (pth.picnum == picnum && pth.palnum == palnum && pth.isClamped() == clamped && pth.skyface == surfnum) {
                return pth;
            }
            pth = pth.next;
        }
        return null;
    }

    private void add(Pthtyp tex) {
        tex.next = this.cache[tex.picnum];
        this.cache[tex.picnum] = tex;
    }

    public Renderer.PixelFormat getFormat() {
        return this.type;
    }

    public void invalidate(int dapicnum, int dapalnum, boolean clamped) {
        this.invalidate(this.get(dapicnum, dapalnum, clamped, 0));
    }

    public void invalidateall() {
        int j = Engine.MAXTILES - 1;
        while (j >= 0) {
            Pthtyp pth = this.cache[j];
            while (pth != null) {
                this.invalidate(pth);
                pth = pth.next;
            }
            --j;
        }
    }

    private Pthtyp gloadTileArtAlloc(int dapic, int dapal, boolean clamping, boolean alpha, Pthtyp pth) {
        return this.loadTileArt(dapic, dapal, clamping, alpha, pth, true);
    }

    private Pthtyp loadTileArtNoAlloc(int dapic, int dapal, boolean clamping, boolean alpha, Pthtyp pth) {
        return this.loadTileArt(dapic, dapal, clamping, alpha, pth, false);
    }

    private Pthtyp gloadHighTileAlloc(int dapic, int dapal, boolean clamping, boolean alpha, int facen, Hicreplctyp hicr, Pthtyp pth, int effect) {
        return this.loadHighTile(dapic, dapal, clamping, alpha, facen, hicr, pth, effect, true);
    }

    private Pthtyp loadHighTileNoAlloc(int dapic, int dapal, boolean clamping, boolean alpha, int facen, Hicreplctyp hicr, Pthtyp pth, int effect) {
        return this.loadHighTile(dapic, dapal, clamping, alpha, facen, hicr, pth, effect, false);
    }

    private Pthtyp loadTileArt(int dapic, int dapal, boolean clamping, boolean alpha, Pthtyp pth, boolean doalloc) {
        int intexfmt;
        short tsizx = Engine.tilesizx[dapic];
        short tsizy = Engine.tilesizy[dapic];
        int xsiz = TextureUtils.calcSize(tsizx);
        int ysiz = TextureUtils.calcSize(tsizy);
        if (Engine.palookup[dapal] == null) {
            dapal = 0;
        }
        ImageUtils.PicInfo picInfo = ImageUtils.loadPic(xsiz, ysiz, tsizx, tsizy, Engine.waloff[dapic], dapal, clamping, alpha, this.type);
        if (pth.glpic != null && (pth.glpic.getWidth() != xsiz || pth.glpic.getHeight() != ysiz)) {
            pth.glpic.dispose();
            doalloc = true;
        }
        if (doalloc) {
            try {
                pth.glpic = new BTexture(xsiz, ysiz);
            }
            catch (Exception e) {
                return null;
            }
        }
        TextureUtils.bindTexture(pth.glpic);
        int n = picInfo.hasalpha ? (this.type == Renderer.PixelFormat.Pal8A ? 6410 : 6408) : (intexfmt = 6407);
        if (BuildGdx.app.getType() == Application.ApplicationType.Android) {
            intexfmt = 6408;
        }
        TextureUtils.uploadBoundTexture(doalloc, xsiz, ysiz, intexfmt, 6408, picInfo.pic);
        TextureUtils.setupBoundTexture(GLSettings.textureFilter.get(), GLSettings.textureAnisotropy.get());
        int wrap = !clamping ? 10497 : (GLInfo.clamptoedge ? 33071 : 10496);
        TextureUtils.setupBoundTextureWrap(wrap);
        pth.picnum = (short)dapic;
        pth.palnum = (short)dapal;
        pth.effects = 0;
        pth.setClamped(clamping);
        pth.setHasAlpha(picInfo.hasalpha);
        pth.hicr = null;
        return pth;
    }

    private Pthtyp loadHighTile(int dapic, int dapal, boolean clamping, boolean alpha, int facen, Hicreplctyp hicr, Pthtyp pth, int effect, boolean doalloc) {
        if (hicr == null) {
            return null;
        }
        String fn = null;
        if (facen > 0) {
            if (hicr.skybox == null) {
                return null;
            }
            if (facen > 6) {
                return null;
            }
            if (hicr.skybox.face[facen - 1] == null) {
                return null;
            }
            fn = hicr.skybox.face[facen - 1];
        } else {
            if (hicr.filename == null) {
                return null;
            }
            fn = hicr.filename;
        }
        if (!BuildGdx.cache.contains(fn, 0)) {
            Console.Print("hightile: " + fn + "(pic " + dapic + ") not found");
            if (facen > 0) {
                hicr.skybox.ignore = 1;
            } else {
                hicr.ignore = 1;
            }
            return null;
        }
        if (doalloc) {
            byte[] data = BuildGdx.cache.getBytes(fn, 0);
            if (data == null) {
                return null;
            }
            try {
                Pixmap pix = new Pixmap(data, 0, data.length);
                int psizx = TextureUtils.calcSize(pix.getWidth());
                int psizy = TextureUtils.calcSize(pix.getHeight());
                pth.sizx = (short)pix.getWidth();
                pth.sizy = (short)pix.getHeight();
                if (psizx != pix.getWidth() || psizy != pix.getHeight()) {
                    Pixmap npix = new Pixmap(psizx, psizy, pix.getFormat());
                    npix.setFilter(Pixmap.Filter.NearestNeighbour);
                    if (!clamping) {
                        int i = 0;
                        while (i < 2) {
                            npix.drawPixmap(pix, 0, 0, pth.sizx, pth.sizy, 0, i * pth.sizy, psizx, pth.sizy);
                            ++i;
                        }
                        pth.sizx = (short)psizx;
                    } else {
                        npix.drawPixmap(pix, 0, 0);
                    }
                    pix.dispose();
                    pix = npix;
                }
                pth.glpic = new BTexture(pix, true);
                pix.dispose();
            }
            catch (Exception e) {
                if (facen > 0) {
                    hicr.skybox.ignore = 1;
                } else {
                    hicr.ignore = 1;
                }
                return null;
            }
        }
        short tsizx = pth.sizx;
        short tsizy = pth.sizy;
        TextureUtils.bindTexture(pth.glpic);
        TextureUtils.setupBoundTexture(GLSettings.textureFilter.get(), GLSettings.textureAnisotropy.get());
        int wrap = !clamping ? 10497 : (GLInfo.clamptoedge ? 33071 : 10496);
        TextureUtils.setupBoundTextureWrap(wrap);
        pth.picnum = (short)dapic;
        pth.palnum = (short)dapal;
        pth.effects = 0;
        pth.setClamped(clamping);
        pth.setHasAlpha(alpha);
        pth.setHighTile(true);
        if (facen > 0) {
            pth.setSkyboxFace(true);
        }
        pth.hicr = hicr;
        if (facen > 0) {
            pth.scalex = (float)tsizx / 64.0f;
            pth.scaley = (float)tsizy / 64.0f;
        } else {
            pth.scalex = (float)tsizx / (float)Engine.tilesizx[dapic];
            pth.scaley = (float)tsizy / (float)Engine.tilesizy[dapic];
        }
        return pth;
    }

    private Pthtyp cache_tryart(int dapicnum, int dapalnum, boolean clamping, boolean alpha) {
        Pthtyp pth = this.get(dapicnum, dapalnum, clamping, 0);
        if (pth != null) {
            if (pth.isInvalidated()) {
                pth.setInvalidated(false);
                pth = this.loadTileArtNoAlloc(dapicnum, dapalnum, clamping, alpha, pth);
            }
        } else {
            pth = this.gloadTileArtAlloc(dapicnum, dapalnum, clamping, alpha, new Pthtyp());
            if (pth != null) {
                this.add(pth);
            }
        }
        return pth;
    }

    public Pthtyp cache(int dapicnum, int dapalnum, short skybox, boolean clamping, boolean alpha) {
        Hicreplctyp si;
        Hicreplctyp hicreplctyp = si = GLSettings.useHighTile.get() != false && this.info != null ? this.info.findTexture(dapicnum, dapalnum, skybox) : null;
        if (si == null) {
            if (skybox != 0 || dapalnum >= 252) {
                return null;
            }
            return this.cache_tryart(dapicnum, dapalnum, clamping, alpha);
        }
        Pthtyp pth = this.get(dapicnum, dapalnum, clamping, skybox);
        if (pth != null && pth.hicr == null && si.skybox == null) {
            this.dispose(dapicnum);
            pth = null;
        }
        if (pth != null) {
            if (pth.isInvalidated()) {
                pth.setInvalidated(false);
                pth = this.loadHighTileNoAlloc(dapicnum, dapalnum, clamping, alpha, skybox, si, pth, si.palnum > 0 || this.info == null ? 0 : this.info.getPaletteEffect(dapalnum));
                if (pth == null) {
                    if (skybox != 0) {
                        return null;
                    }
                    return this.cache_tryart(dapicnum, dapalnum, clamping, alpha);
                }
            }
        } else {
            if (dapalnum != 0 && this.info.findTexture(dapicnum, 0, skybox) == si && (pth = this.get(dapicnum, 0, clamping, skybox)) != null) {
                return pth;
            }
            pth = this.gloadHighTileAlloc(dapicnum, dapalnum, clamping, alpha, skybox, si, new Pthtyp(), si.palnum > 0 || this.info == null ? 0 : this.info.getPaletteEffect(dapalnum));
            if (pth != null) {
                pth.skyface = skybox;
                this.add(pth);
            } else {
                return this.cache_tryart(dapicnum, dapalnum, clamping, alpha);
            }
        }
        return pth;
    }

    public void updateSettings(GLFilter filter) {
        int anisotropy = GLSettings.textureAnisotropy.get();
        int i = Engine.MAXTILES - 1;
        while (i >= 0) {
            Pthtyp pth = this.cache[i];
            while (pth != null) {
                TextureUtils.bindTexture(pth.glpic);
                TextureUtils.setupBoundTexture(filter, anisotropy);
                if (!filter.retro) {
                    pth.setInvalidated(true);
                }
                pth = pth.next;
            }
            --i;
        }
    }

    private void invalidate(Pthtyp pth) {
        if (pth == null) {
            return;
        }
        if (pth.hicr == null) {
            pth.setInvalidated(true);
        }
    }

    public boolean clampingMode(int dameth) {
        return (dameth & 4) >> 2 == 1;
    }

    public boolean alphaMode(int dameth) {
        return (dameth & 0x100) == 0;
    }

    public boolean gltexmayhavealpha(int dapicnum, int dapalnum) {
        Pthtyp pth = this.cache[dapicnum];
        while (pth != null) {
            if (pth.picnum == dapicnum && pth.palnum == dapalnum) {
                return pth.hasAlpha();
            }
            pth = pth.next;
        }
        return true;
    }

    public void uninit() {
        int i = Engine.MAXTILES - 1;
        while (i >= 0) {
            this.dispose(i);
            --i;
        }
    }

    public void dispose(int tilenum) {
        Pthtyp pth = this.cache[tilenum];
        while (pth != null) {
            Pthtyp next = pth.next;
            pth.glpic.dispose();
            pth = next;
        }
        this.cache[tilenum] = null;
    }

    public void savetexture(ByteBuffer pixels, int tw, int th, int w, int h, int num) {
        Pixmap pixmap = new Pixmap(w, h, Pixmap.Format.RGB888);
        int i = 0;
        while (i < tw * th) {
            int row = (int)Math.floor(i / tw);
            int col = i % tw;
            if (col < w && row < h) {
                pixmap.setColor((float)(pixels.get(4 * i) & 0xFF) / 255.0f, (float)(pixels.get(4 * i + 1) & 0xFF) / 255.0f, (float)(pixels.get(4 * i + 2) & 0xFF) / 255.0f, 1.0f);
                pixmap.drawPixel(col, row);
            }
            ++i;
        }
        PixmapIO.writePNG(new FileHandle("texture" + num + ".png"), pixmap);
        System.out.println("texture" + num + ".png saved!");
        pixmap.dispose();
    }

    private BTexture createPalette(byte[] paldata, int shade) {
        TextureBuffer buffer = ImageUtils.getTmpBuffer();
        buffer.clear();
        int p = 0;
        while (p < 256) {
            int pal = p;
            if (Engine.palookup[pal] == null) {
                pal = 0;
            }
            int i = 0;
            while (i < 256) {
                int dacol = Engine.palookup[pal][i + (shade << 8)] & 0xFF;
                buffer.putBytes(paldata, 3 * dacol, 3);
                ++i;
            }
            ++p;
        }
        BTexture palette = new BTexture(256, 256);
        palette.bind(1);
        BuildGdx.gl.glTexImage2D(3553, 0, 6407, palette.getWidth(), palette.getHeight(), 0, 6407, 5121, buffer.getBuffer());
        TextureUtils.setupBoundTexture(GLSettings.glfiltermodes[0], 0);
        return palette;
    }

    public void changePalette(byte[] pal) {
        if (!this.isUseShader()) {
            return;
        }
        int i = 0;
        while (i < Engine.numshades) {
            if (this.palette[i] != null) {
                this.palette[i].dispose();
            }
            this.palette[i] = this.createPalette(pal, i);
            ++i;
        }
    }

    private ShaderProgram createShader() {
        String vertex = "void main()\r\n{\r\n\tgl_Position = gl_ModelViewProjectionMatrix * gl_Vertex; //ftransform();\r\n\tgl_ClipVertex = gl_ModelViewMatrix * gl_Vertex;\r\n\tgl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;\r\n}";
        String fragment = "uniform sampler2D u_texture;\r\nuniform sampler2D u_colorTable;\r\nuniform float u_pal;\r\nuniform float u_alpha;\r\n\r\nvoid main()\r\n{\t\r\n\tfloat index = texture2D(u_texture, gl_TexCoord[0].xy).r;\r\n\tif(index == 1.0) discard;\r\n\t\r\n\tvec3 color = texture2D(u_colorTable, vec2(index, u_pal / 256.0)).rgb;\t\r\n\tgl_FragColor = vec4(color, u_alpha);\r\n}";
        ShaderProgram shader = new ShaderProgram(vertex, fragment);
        if (!shader.isCompiled()) {
            Console.Println("Shader compile error: " + shader.getLog(), Console.OSDTEXT_RED);
        }
        this.palette = new BTexture[Engine.numshades];
        BuildGdx.gl.glActiveTexture(33984);
        return shader;
    }

    public void bindShader() {
        if (this.shader != null) {
            this.shader.begin();
        }
    }

    public void unbindShader() {
        if (this.shader != null) {
            this.shader.end();
            BuildGdx.gl.glActiveTexture(33984);
        }
    }

    public void setShaderParams(int pal, int shade) {
        if (this.shader == null) {
            return;
        }
        this.palette[shade].bind(1);
        this.shader.setUniformi("u_colorTable", 1);
        this.shader.setUniformf("u_pal", (float)pal);
    }

    public void shaderTransparent(float alpha) {
        if (this.shader != null) {
            this.shader.setUniformf("u_alpha", alpha);
        }
    }

    public boolean isUseShader() {
        return this.shader != null;
    }
}

