/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.TextureHandle;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Render.GLInfo;
import ru.m210projects.Build.Render.TextureHandle.BTexture;
import ru.m210projects.Build.Render.Types.GLFilter;
import ru.m210projects.Build.Settings.GLSettings;

public class TextureUtils {
    public static int calcSize(int size) {
        int nsize = 1;
        if (GLInfo.texnpot == 0) {
            while (nsize < size) {
                nsize *= 2;
            }
            return nsize;
        }
        return size == 0 ? 1 : size;
    }

    public static void bindTexture(BTexture tex) {
        tex.bind();
    }

    public static void deleteTexture(BTexture tex) {
        tex.dispose();
    }

    public static void uploadBoundTexture(boolean doalloc, int xsiz, int ysiz, int intexfmt, int texfmt, ByteBuffer pic) {
        int mipLevel = TextureUtils.calcMipLevel(xsiz, ysiz, GLInfo.gltexmaxsize);
        if (mipLevel == 0) {
            if (doalloc) {
                BuildGdx.gl.glTexImage2D(3553, 0, intexfmt, xsiz, ysiz, 0, texfmt, 5121, pic);
            } else {
                BuildGdx.gl.glTexSubImage2D(3553, 0, 0, 0, xsiz, ysiz, texfmt, 5121, pic);
            }
        } else {
            System.err.println("Uploading non-zero mipmap level textures is unimplemented");
        }
        if (GLSettings.textureFilter.get().mipmaps) {
            if (GLInfo.supportsGenerateMipmaps) {
                BuildGdx.gl.glGenerateMipmap(3553);
            } else {
                TextureUtils.generateMipMapCPU(doalloc, mipLevel, xsiz, ysiz, intexfmt, texfmt, pic);
            }
        }
    }

    private static void generateMipMapCPU(boolean doalloc, int mipLevel, int xsiz, int ysiz, int intexfmt, int texfmt, ByteBuffer pic) {
        int x2 = xsiz;
        int y2 = ysiz;
        int j = 1;
        while (x2 > 1 || y2 > 1) {
            int x3 = Math.max(1, x2 >> 1);
            int y3 = Math.max(1, y2 >> 1);
            int y = 0;
            while (y < y3) {
                int wpptr = y * x3;
                int rpptr = (y << 1) * x2;
                int x = 0;
                while (x < x3) {
                    block17: {
                        int rgb;
                        int wp = wpptr << 2;
                        int rp = rpptr << 2;
                        int k = 0;
                        int a = 0;
                        int b = 0;
                        int g = 0;
                        int r = 0;
                        int index = rp;
                        if (pic.get(index + 3) != 0) {
                            r += pic.get(index + 0) & 0xFF;
                            g += pic.get(index + 1) & 0xFF;
                            b += pic.get(index + 2) & 0xFF;
                            a += pic.get(index + 3) & 0xFF;
                            ++k;
                        }
                        index = rp + 4;
                        if ((x << 1) + 1 < x2 && pic.get(index + 3) != 0) {
                            r += pic.get(index + 0) & 0xFF;
                            g += pic.get(index + 1) & 0xFF;
                            b += pic.get(index + 2) & 0xFF;
                            a += pic.get(index + 3) & 0xFF;
                            ++k;
                        }
                        if ((y << 1) + 1 < y2) {
                            index = rp + (x2 << 2);
                            if (pic.get(index + 3) != 0) {
                                r += pic.get(index + 0) & 0xFF;
                                g += pic.get(index + 1) & 0xFF;
                                b += pic.get(index + 2) & 0xFF;
                                a += pic.get(index + 3) & 0xFF;
                                ++k;
                            }
                            index = rp + (x2 + 1 << 2);
                            if ((x << 1) + 1 < x2 && pic.get(index + 3) != 0) {
                                r += pic.get(index + 0) & 0xFF;
                                g += pic.get(index + 1) & 0xFF;
                                b += pic.get(index + 2) & 0xFF;
                                a += pic.get(index + 3) & 0xFF;
                                ++k;
                            }
                        }
                        switch (k) {
                            case 0: 
                            case 1: {
                                rgb = (a << 24) + (b << 16) + (g << 8) + (r << 0);
                                break;
                            }
                            case 2: {
                                rgb = (a + 1 >> 1 << 24) + (b + 1 >> 1 << 16) + (g + 1 >> 1 << 8) + (r + 1 >> 1 << 0);
                                break;
                            }
                            case 3: {
                                rgb = (a * 85 + 128 >> 8 << 24) + (b * 85 + 128 >> 8 << 16) + (g * 85 + 128 >> 8 << 8) + (r * 85 + 128 >> 8 << 0);
                                break;
                            }
                            case 4: {
                                rgb = (a + 2 >> 2 << 24) + (b + 2 >> 2 << 16) + (g + 2 >> 2 << 8) + (r + 2 >> 2 << 0);
                                break;
                            }
                            default: {
                                break block17;
                            }
                        }
                        pic.putInt(wp, rgb);
                    }
                    ++x;
                    ++wpptr;
                    rpptr += 2;
                }
                ++y;
            }
            if (j >= mipLevel) {
                if (doalloc) {
                    BuildGdx.gl.glTexImage2D(3553, j - mipLevel, intexfmt, x3, y3, 0, texfmt, 5121, pic);
                } else {
                    BuildGdx.gl.glTexSubImage2D(3553, j - mipLevel, 0, 0, x3, y3, texfmt, 5121, pic);
                }
            }
            x2 = x3;
            y2 = y3;
            ++j;
        }
    }

    private static int calcMipLevel(int xsiz, int ysiz, int maxsize) {
        int mipLevel = 0;
        while (xsiz >> mipLevel > 1 << maxsize || ysiz >> mipLevel > 1 << maxsize) {
            ++mipLevel;
        }
        return mipLevel;
    }

    public static void setupBoundTexture(GLFilter filter, int anisotropy) {
        filter.apply();
        if (anisotropy >= 1) {
            BuildGdx.gl.glTexParameteri(3553, 34046, anisotropy);
        }
    }

    public static void setupBoundTextureWrap(int wrap) {
        BuildGdx.gl.glTexParameteri(3553, 10242, wrap);
        BuildGdx.gl.glTexParameteri(3553, 10243, wrap);
    }
}

