/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Render.Types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Render.Types.TextureBuffer;

public class DirectTextureBuffer
implements TextureBuffer {
    private ByteBuffer bb;

    public DirectTextureBuffer(int size) {
        this.bb = ByteBuffer.allocateDirect(size).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public byte get(int i) {
        return this.bb.get(i);
    }

    @Override
    public int getInt(int i) {
        return this.bb.getInt(i);
    }

    @Override
    public void putBytes(byte[] src, int srcPos, int length) {
        this.bb.put(src, srcPos, length);
    }

    @Override
    public void put(int offset, byte value) {
        this.bb.put(offset, value);
    }

    @Override
    public void putInt(int offset, int value) {
        this.bb.putInt(offset, value);
    }

    @Override
    public void fill(int offset, int length, byte value) {
        int i = 0;
        while (i < length) {
            this.bb.put(offset + i, value);
            ++i;
        }
    }

    @Override
    public void clear() {
        this.bb.clear();
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.bb;
    }
}

