/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Script;

import com.badlogic.gdx.graphics.Pixmap;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.CRC32;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Loader.MD2.MD2Loader;
import ru.m210projects.Build.Loader.MD3.MD3Loader;
import ru.m210projects.Build.Loader.MDModel;
import ru.m210projects.Build.Loader.Voxels.KVXLoader;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Script.AudioInfo;
import ru.m210projects.Build.Script.ModelInfo;
import ru.m210projects.Build.Script.Scriptfile;
import ru.m210projects.Build.Script.TextureHDInfo;
import ru.m210projects.Build.Strhandler;

public class DefScript {
    protected boolean disposable;
    public final TextureHDInfo texInfo;
    public final ModelInfo mdInfo;
    public final AudioInfo audInfo;
    protected final Engine engine;
    protected FileEntry currentAddon;
    protected HashMap<String, List<String>> addonsIncludes;
    protected DefTile[] tiles = new DefTile[Engine.MAXTILES];
    private final Map<String, Token> basetokens = new HashMap<String, Token>(){
        private static final long serialVersionUID = 1L;
        {
            Token tok = new IncludeToken();
            this.put("#include", tok);
            this.put("include", tok);
            this.put("defineskybox", new DefineSkyboxToken());
            this.put("definetint", new DefineTint());
            this.put("model", new ModelToken());
            this.put("voxel", new VoxelToken());
            this.put("skybox", new SkyboxToken());
            tok = new TextureToken();
            this.put("tile", tok);
            this.put("texture", tok);
            this.put("tilefromtexture", new TileFromTextureToken());
            this.put("animtilerange", new AnimRangeToken());
            tok = new AudioToken();
            this.put("sound", tok);
            this.put("music", tok);
            this.put("includeif", new AddonToken());
        }
    };

    public DefScript(DefScript src, FileEntry addon) {
        this.disposable = true;
        this.texInfo = new TextureHDInfo(src.texInfo);
        this.mdInfo = new ModelInfo(src.mdInfo, src.disposable);
        this.audInfo = new AudioInfo(src.audInfo);
        this.engine = src.engine;
        int i = 0;
        while (i < Engine.MAXTILES) {
            if (src.tiles[i] != null) {
                this.tiles[i] = new DefTile(src.tiles[i]);
            }
            ++i;
        }
        if (src.addonsIncludes != null) {
            this.addonsIncludes = new HashMap();
            for (String key : src.addonsIncludes.keySet()) {
                List<String> list = src.addonsIncludes.get(key);
                ArrayList<String> clone = new ArrayList<String>(list.size());
                clone.addAll(list);
                this.addonsIncludes.put(key, clone);
            }
        }
        this.currentAddon = addon;
    }

    public DefScript(BuildEngine engine, boolean disposable) {
        this.disposable = disposable;
        this.texInfo = new TextureHDInfo();
        this.mdInfo = new ModelInfo();
        this.audInfo = new AudioInfo();
        this.engine = engine;
    }

    public boolean loadScript(FileEntry file) {
        if (file == null) {
            Console.Println("Def error: script not found", Console.OSDTEXT_RED);
            return false;
        }
        FileResource res = BuildGdx.compat.open(file);
        byte[] data = res.getBytes();
        res.close();
        if (data == null) {
            Console.Println("File is exists, but data == null! Path:" + file.getPath());
            return false;
        }
        Scriptfile script = new Scriptfile(file.getPath(), data);
        script.path = file.getParent().getRelativePath();
        try {
            this.defsparser(script);
        }
        catch (Exception e) {
            e.printStackTrace();
            Console.Println("Def error: the script " + file.getPath() + " has errors", Console.OSDTEXT_RED);
            return false;
        }
        return true;
    }

    public boolean loadScript(String name, byte[] buf) {
        if (buf == null) {
            Console.Println("Def error: script not found", Console.OSDTEXT_RED);
            return false;
        }
        try {
            this.defsparser(new Scriptfile(name, buf));
        }
        catch (Exception e) {
            e.printStackTrace();
            Console.Println("Def error: the script " + name + " has errors", Console.OSDTEXT_RED);
            return false;
        }
        return true;
    }

    protected void addToken(String name, Token token) {
        this.basetokens.put(name, token);
    }

    protected boolean addDefTile(DefTile texstatus, int tile) {
        DefTile def = this.tiles[tile];
        if (def != null && def.crc32 != 0L) {
            if (texstatus.crc32 == 0L) {
                texstatus.next = def;
                this.tiles[tile] = texstatus;
            } else if (def.crc32 != texstatus.crc32) {
                def = this.tiles[tile].getLast();
                def.next = texstatus;
            } else if (def.internal || this.disposable) {
                this.tiles[tile] = texstatus;
            }
        } else if (def == null || def.internal || this.disposable) {
            this.tiles[tile] = texstatus;
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void defsparser(Scriptfile script) {
        Console.Println("Loading " + script.filename + "...");
        while (true) {
            Token basetoken;
            if ((basetoken = (Token)this.gettoken(script, this.basetokens)) == null) {
                continue;
            }
            if (basetoken == BaseToken.EOF) {
                return;
            }
            Object object = Engine.lock;
            synchronized (object) {
                basetoken.parse(script);
            }
        }
    }

    protected Object gettoken(Scriptfile sf, Map<String, ?> list) {
        if (sf == null) {
            return BaseToken.Error;
        }
        int tok = sf.gettoken();
        if (tok == -2) {
            return BaseToken.EOF;
        }
        Object out = list.get(Strhandler.toLowerCase(sf.textbuf.substring(tok, sf.textptr)));
        if (out != null) {
            return out;
        }
        sf.errorptr = sf.textptr;
        return BaseToken.Error;
    }

    protected String getFile(Scriptfile script) {
        String fn = script.getstring();
        if (fn == null) {
            return null;
        }
        fn = FileUtils.getCorrectPath(fn);
        if (script.path != null) {
            fn = String.valueOf(script.path) + File.separator + fn;
        }
        return fn;
    }

    protected boolean check_tile(String defcmd, int tile, Scriptfile script, int cmdtokptr) {
        if (tile >= Engine.MAXTILES) {
            Console.Println("Error: " + defcmd + ": Invalid tile number on line " + script.filename + ":" + script.getlinum(cmdtokptr), Console.OSDTEXT_RED);
            return true;
        }
        return false;
    }

    protected boolean check_tile_range(String defcmd, int tilebeg, int tileend, Scriptfile script, int cmdtokptr) {
        if (tileend < tilebeg) {
            Console.Println("Warning: " + defcmd + ": backwards tile range on line " + script.filename + ":" + script.getlinum(cmdtokptr), Console.OSDTEXT_YELLOW);
            int tmp = tilebeg;
            tilebeg = tileend;
            tileend = tmp;
        }
        if (tilebeg >= Engine.MAXTILES || tileend >= Engine.MAXTILES) {
            Console.Println("Error: " + defcmd + ": Invalid tile range on line " + script.filename + ":" + script.getlinum(cmdtokptr), Console.OSDTEXT_RED);
            return true;
        }
        return false;
    }

    protected int getPtr(Scriptfile script, int line) {
        if (line <= 2) {
            return script.lineoffs[0];
        }
        if (line <= script.linenum) {
            return script.lineoffs[line - 2];
        }
        return script.eof;
    }

    public void dispose() {
        if (!this.disposable) {
            return;
        }
        this.engine.loadpics();
        int i = 0;
        while (i < Engine.MAXTILES) {
            if (this.tiles[i] != null) {
                this.texInfo.remove(i, 0);
                Engine.waloff[i] = null;
                this.tiles[i] = null;
            }
            ++i;
        }
        this.mdInfo.dispose();
    }

    public void apply() {
        int i;
        List<String> defs;
        if (this.addonsIncludes != null && this.currentAddon != null && (defs = this.addonsIncludes.get(this.currentAddon.getName())) != null) {
            i = 0;
            while (i < defs.size() / 2) {
                String fn = defs.get(2 * i + 1);
                Resource res = BuildGdx.cache.open(fn, 0);
                if (res == null) {
                    Console.Println("Warning: Failed including " + fn + " as module", Console.OSDTEXT_RED);
                } else {
                    Scriptfile included = new Scriptfile(fn, res.getBytes());
                    included.path = defs.get(2 * i);
                    this.defsparser(included);
                    res.close();
                }
                ++i;
            }
        }
        i = 0;
        while (i < Engine.MAXTILES) {
            block11: {
                DefTile tile;
                block12: {
                    long crc32;
                    if (this.tiles[i] == null) break block11;
                    tile = this.tiles[i];
                    if (tile.crc32 == 0L) break block12;
                    byte[] data = Engine.waloff[i];
                    if (data == null) {
                        data = this.engine.loadtile(i);
                    }
                    long l = crc32 = data != null ? CRC32.getChecksum(data) : -1L;
                    if (crc32 == tile.crc32) break block12;
                    boolean found = false;
                    while (tile.next != null) {
                        tile = tile.next;
                        if (tile.crc32 != 0L && crc32 != tile.crc32) continue;
                        found = true;
                        break;
                    }
                    if (!found) break block11;
                }
                if (tile.waloff != null) {
                    this.engine.invalidatetile(i, -1, -1);
                    Engine.waloff[i] = new byte[tile.waloff.length];
                    System.arraycopy(tile.waloff, 0, Engine.waloff[i], 0, tile.waloff.length);
                    Engine.tilesizx[i] = tile.sizx;
                    Engine.tilesizy[i] = tile.sizy;
                    int n = i;
                    Engine.picanm[n] = Engine.picanm[n] & 0xFF0000FF;
                    int n2 = i;
                    Engine.picanm[n2] = Engine.picanm[n2] | (tile.xoffset & 0xFF) << 8;
                    int n3 = i;
                    Engine.picanm[n3] = Engine.picanm[n3] | (tile.yoffset & 0xFF) << 16;
                    this.engine.setpicsiz(i);
                    this.texInfo.addTexture(i, 0, tile.hrp, (float)(255 - (tile.alphacut & 0xFF)) * 0.003921569f, 1.0f, 1.0f, 1.0f, 1.0f, 0);
                }
            }
            ++i;
        }
    }

    protected class AddonToken
    implements Token {
        protected AddonToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            String fn;
            String addon;
            DefScript def = DefScript.this;
            if (def.addonsIncludes == null) {
                def.addonsIncludes = new HashMap();
            }
            if ((addon = script.getstring()) != null && (fn = def.getFile(script)) != null) {
                if (def.addonsIncludes.get(addon) == null) {
                    ArrayList list = new ArrayList();
                    def.addonsIncludes.put(addon, list);
                }
                def.addonsIncludes.get(addon).add(script.path);
                def.addonsIncludes.get(addon).add(fn);
            }
            return BaseToken.Ok;
        }
    }

    protected class AnimRangeToken
    implements Token {
        protected AnimRangeToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            Integer tile0 = script.getsymbol();
            if (tile0 == null) {
                return BaseToken.Error;
            }
            Integer tile1 = script.getsymbol();
            if (tile1 == null) {
                return BaseToken.Error;
            }
            Integer speed = script.getsymbol();
            if (speed == null) {
                return BaseToken.Error;
            }
            Integer anm = script.getsymbol();
            if (anm == null) {
                return BaseToken.Error;
            }
            int length = tile1 - tile0;
            if (length <= 0) {
                Console.Println("Warning: Animation lenght < 0, skipping", Console.OSDTEXT_RED);
                return BaseToken.Warning;
            }
            int n = tile0;
            Engine.picanm[n] = Engine.picanm[n] & 0xF0FFFF00;
            int n2 = tile0;
            Engine.picanm[n2] = Engine.picanm[n2] | ((anm & 3) << 6 | (speed & 0xF) << 24 | length & 0x3F);
            return BaseToken.Ok;
        }
    }

    protected class AudioToken
    implements Token {
        private final Map<String, AudioTokens> sound_musictokens = new HashMap<String, AudioTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("id", AudioTokens.ID);
                this.put("midi", AudioTokens.ID);
                this.put("map", AudioTokens.ID);
                this.put("file", AudioTokens.FILE);
            }
        };
        private static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$AudioTokens;

        protected AudioToken() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public BaseToken parse(Scriptfile script) {
            t_id = null;
            t_file = null;
            dummy = script.getbraces();
            if (dummy != -1) ** GOTO lbl21
            return BaseToken.Error;
lbl-1000:
            // 1 sources

            {
                tk = DefScript.this.gettoken(script, this.sound_musictokens);
                if (tk instanceof BaseToken) {
                    line = script.getlinum(script.ltextptr);
                    Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                    continue;
                }
                switch (AudioToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$AudioTokens()[((AudioTokens)tk).ordinal()]) {
                    default: {
                        break;
                    }
                    case 1: {
                        t = script.getstring();
                        if (t == null) continue block4;
                        t_id = t.trim();
                        break;
                    }
                    case 2: {
                        t_file = DefScript.this.getFile(script);
                    }
                }
lbl21:
                // 6 sources

                ** while (script.textptr < dummy)
            }
lbl22:
            // 1 sources

            script.skipbrace(dummy);
            DefScript.this.audInfo.addDigitalInfo(t_id, t_file);
            return BaseToken.Ok;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$AudioTokens() {
            if ($SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$AudioTokens != null) {
                return $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$AudioTokens;
            }
            int[] nArray = new int[AudioTokens.values().length];
            try {
                nArray[AudioTokens.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[AudioTokens.ID.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$AudioTokens = nArray;
            return nArray;
        }
    }

    public static enum AudioTokens {
        ID,
        FILE;

    }

    public static enum BaseToken implements Token
    {
        Ok,
        Warning,
        Error,
        EOF;


        @Override
        public BaseToken parse(Scriptfile script) {
            return this;
        }
    }

    protected static class DefTile {
        public long crc32;
        public byte[] waloff;
        public short sizx;
        public short sizy;
        public byte xoffset;
        public byte yoffset;
        public String hrp;
        public byte alphacut;
        public final boolean internal;
        public int optional;
        public DefTile next;

        public DefTile(DefTile src) {
            this.crc32 = src.crc32;
            this.waloff = src.waloff;
            this.sizx = src.sizx;
            this.sizy = src.sizy;
            this.xoffset = src.xoffset;
            this.yoffset = src.yoffset;
            this.hrp = src.hrp;
            this.alphacut = src.alphacut;
            this.internal = src.internal;
            this.optional = src.optional;
            if (src.next != null) {
                this.next = new DefTile(src.next);
            }
        }

        public DefTile(int sizx, int sizy, long crc32, boolean internal) {
            this.sizx = (short)sizx;
            this.sizy = (short)sizy;
            this.crc32 = crc32;
            this.internal = internal;
        }

        public DefTile getLast() {
            DefTile out = this;
            DefTile n;
            while ((n = out.next) != null) {
                out = n;
            }
            return out;
        }
    }

    protected class DefineSkyboxToken
    extends SkyboxToken {
        protected DefineSkyboxToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            int stile = -1;
            int spal = 0;
            String[] sfn = new String[6];
            Integer ivalue = script.getsymbol();
            if (ivalue != null) {
                stile = ivalue;
            }
            if ((ivalue = script.getsymbol()) != null) {
                spal = ivalue;
            }
            script.getsymbol();
            sfn[0] = DefScript.this.getFile(script);
            sfn[1] = DefScript.this.getFile(script);
            sfn[2] = DefScript.this.getFile(script);
            sfn[3] = DefScript.this.getFile(script);
            sfn[4] = DefScript.this.getFile(script);
            sfn[5] = DefScript.this.getFile(script);
            if (this.addSkybox(script, stile, spal, sfn)) {
                return BaseToken.Ok;
            }
            return BaseToken.Error;
        }
    }

    protected class DefineTint
    implements Token {
        protected DefineTint() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            Integer pal = script.getsymbol();
            if (pal == null) {
                return BaseToken.Error;
            }
            Integer r = script.getsymbol();
            if (r == null) {
                return BaseToken.Error;
            }
            Integer g = script.getsymbol();
            if (g == null) {
                return BaseToken.Error;
            }
            Integer b = script.getsymbol();
            if (b == null) {
                return BaseToken.Error;
            }
            Integer f = script.getsymbol();
            if (f == null) {
                return BaseToken.Error;
            }
            DefScript.this.texInfo.setPaletteTint(pal, r, g, b, f);
            return BaseToken.Ok;
        }
    }

    protected class IncludeToken
    implements Token {
        protected IncludeToken() {
        }

        @Override
        public BaseToken parse(Scriptfile script) {
            String fn = DefScript.this.getFile(script);
            if (fn == null) {
                return BaseToken.Warning;
            }
            this.include(DefScript.this, fn, script, script.ltextptr);
            return BaseToken.Ok;
        }

        private void include(DefScript def, String fn, Scriptfile script, int cmdtokptr) {
            byte[] data = BuildGdx.cache.getBytes(fn, 0);
            if (data == null) {
                if (cmdtokptr == 0) {
                    Console.Println("Warning: Failed including " + fn + " as module", Console.OSDTEXT_YELLOW);
                } else {
                    Console.Println("Warning: Failed including " + fn + " on line " + script.filename + ":" + script.getlinum(cmdtokptr), Console.OSDTEXT_YELLOW);
                }
                return;
            }
            Scriptfile included = new Scriptfile(fn, data);
            included.path = script.path;
            def.defsparser(included);
        }
    }

    protected class ModelToken
    implements Token {
        protected int modelskin = -1;
        protected int lastmodelskin = -1;
        protected int seenframe = 0;
        protected final Map<String, ModelTokens> modeltokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("scale", ModelTokens.SCALE);
                this.put("shade", ModelTokens.SHADE);
                this.put("zadd", ModelTokens.ZADD);
                this.put("frame", ModelTokens.FRAME);
                this.put("anim", ModelTokens.ANIM);
                this.put("skin", ModelTokens.SKIN);
                this.put("hud", ModelTokens.HUD);
            }
        };
        private final Map<String, ModelTokens> modelframetokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("frame", ModelTokens.FRAME);
                this.put("name", ModelTokens.FRAME);
                this.put("tile", ModelTokens.TILE);
                this.put("tile0", ModelTokens.TILE0);
                this.put("tile1", ModelTokens.TILE1);
            }
        };
        private final Map<String, ModelTokens> modelanimtokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("frame0", ModelTokens.FRAME0);
                this.put("frame1", ModelTokens.FRAME1);
                this.put("fps", ModelTokens.FPS);
                this.put("flags", ModelTokens.FLAGS);
            }
        };
        private final Map<String, ModelTokens> modelskintokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("pal", ModelTokens.PAL);
                this.put("file", ModelTokens.FILE);
                this.put("surf", ModelTokens.SURF);
                this.put("surface", ModelTokens.SURF);
            }
        };
        private final Map<String, ModelTokens> modelhudtokens = new HashMap<String, ModelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("tile", ModelTokens.TILE);
                this.put("tile0", ModelTokens.TILE0);
                this.put("tile1", ModelTokens.TILE1);
                this.put("xadd", ModelTokens.XADD);
                this.put("yadd", ModelTokens.YADD);
                this.put("zadd", ModelTokens.ZADD);
                this.put("angadd", ModelTokens.ANGADD);
                this.put("hide", ModelTokens.HIDE);
                this.put("nobob", ModelTokens.NOBOB);
                this.put("flipped", ModelTokens.FLIPPED);
                this.put("nodepth", ModelTokens.NODEPTH);
            }
        };
        private static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$ModelTokens;

        protected ModelToken() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public BaseToken parse(Scriptfile script) {
            mdscale = 1.0;
            mzadd = 0.0;
            myoffset = 0.0;
            shadeoffs = 0;
            mdflags = 0;
            model_ok = true;
            this.lastmodelskin = 0;
            this.modelskin = 0;
            this.seenframe = 0;
            modelfn = script.getstring();
            if (modelfn == null) {
                return BaseToken.Error;
            }
            modelend = script.getbraces();
            if (modelend == -1) {
                return BaseToken.Error;
            }
            res = BuildGdx.cache.open(modelfn, 0);
            if (res == null) {
                Console.Println("Warning: File not found" + modelfn, Console.OSDTEXT_YELLOW);
                script.textptr = modelend + 1;
                return BaseToken.Warning;
            }
            m = null;
            sign = res.readInt();
            res.seek(0L, Resource.Whence.Set);
            switch (sign) {
                case 844121161: {
                    m = MD2Loader.load(res);
                    break;
                }
                case 860898377: {
                    m = MD3Loader.load(res);
                    break;
                }
                default: {
                    if (!res.getExtension().equals("kvx")) break;
                    m = KVXLoader.load((Resource)res).model;
                }
            }
            res.close();
            if (m != null) ** GOTO lbl311
            Console.Println("Warning: Failed loading MD2/MD3 model " + modelfn, Console.OSDTEXT_YELLOW);
            script.textptr = modelend + 1;
            return BaseToken.Warning;
lbl-1000:
            // 1 sources

            {
                tk = DefScript.this.gettoken(script, this.modeltokens);
                if (tk instanceof BaseToken) {
                    line = script.getlinum(script.ltextptr);
                    Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                    continue;
                }
                token = (ModelTokens)tk;
                switch (ModelToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$ModelTokens()[token.ordinal()]) {
                    default: {
                        break;
                    }
                    case 1: {
                        dvalue = script.getdouble();
                        if (dvalue == null) continue block56;
                        mdscale = dvalue;
                        break;
                    }
                    case 2: {
                        ivalue = script.getsymbol();
                        if (ivalue == null) continue block56;
                        shadeoffs = ivalue;
                        break;
                    }
                    case 5: {
                        dvalue = script.getdouble();
                        if (dvalue == null) continue block56;
                        mzadd = dvalue;
                        break;
                    }
                    case 6: {
                        frametokptr = script.ltextptr;
                        happy = true;
                        framename = null;
                        ftilenume = -1;
                        ltilenume = -1;
                        tilex = 0;
                        smoothduration = 0.1;
                        frameend = script.getbraces();
                        if (frameend != -1) ** GOTO lbl100
                        break;
lbl-1000:
                        // 1 sources

                        {
                            tk = DefScript.this.gettoken(script, this.modelframetokens);
                            if (tk instanceof BaseToken) {
                                line = script.getlinum(script.ltextptr);
                                Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                                continue;
                            }
                            switch (ModelToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$ModelTokens()[((ModelTokens)tk).ordinal()]) {
                                default: {
                                    break;
                                }
                                case 6: {
                                    framename = script.getstring();
                                    break;
                                }
                                case 12: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block57;
                                    ltilenume = ftilenume = ivalue.intValue();
                                    break;
                                }
                                case 13: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block57;
                                    ftilenume = ivalue;
                                    break;
                                }
                                case 14: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block57;
                                    ltilenume = ivalue;
                                }
                            }
lbl100:
                            // 10 sources

                            ** while (script.textptr < frameend)
                        }
lbl101:
                        // 1 sources

                        script.skipbrace(frameend);
                        if (DefScript.this.check_tile_range("model: frame", ftilenume, ltilenume, script, frametokptr)) {
                            model_ok = false;
                            break;
                        }
                        tilex = ftilenume;
                        while (tilex <= ltilenume && happy) {
                            switch (DefScript.this.mdInfo.addModelInfo(m, tilex, framename, Math.max(0, this.modelskin), (float)smoothduration)) {
                                case -1: {
                                    happy = false;
                                    break;
                                }
                                case -2: {
                                    Console.Println("Invalid tile number on line " + script.filename + ":" + script.getlinum(frametokptr), Console.OSDTEXT_RED);
                                    happy = false;
                                    break;
                                }
                                case -3: {
                                    Console.Println("Invalid frame name on line " + script.filename + ":" + script.getlinum(frametokptr), Console.OSDTEXT_RED);
                                    happy = false;
                                    break;
                                }
                            }
                            model_ok &= happy;
                            ++tilex;
                        }
                        this.seenframe = 1;
                        break;
                    }
                    case 9: {
                        animtokptr = script.ltextptr;
                        happy = true;
                        startframe = null;
                        endframe = null;
                        flags = 0;
                        dfps = 1.0;
                        animend = script.getbraces();
                        if (animend != -1) ** GOTO lbl157
                        break;
lbl-1000:
                        // 1 sources

                        {
                            tk = DefScript.this.gettoken(script, this.modelanimtokens);
                            if (tk instanceof BaseToken) {
                                line = script.getlinum(script.ltextptr);
                                Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                                continue;
                            }
                            switch (ModelToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$ModelTokens()[((ModelTokens)tk).ordinal()]) {
                                default: {
                                    break;
                                }
                                case 7: {
                                    startframe = script.getstring();
                                    break;
                                }
                                case 8: {
                                    endframe = script.getstring();
                                    break;
                                }
                                case 15: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block59;
                                    dfps = dvalue;
                                    break;
                                }
                                case 16: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block59;
                                    flags = ivalue;
                                }
                            }
lbl157:
                            // 9 sources

                            ** while (script.textptr < animend)
                        }
lbl158:
                        // 1 sources

                        script.skipbrace(animend);
                        if (startframe == null) {
                            Console.Println("Error: missing 'start frame' for anim definition near line " + script.filename + ":" + script.getlinum(animtokptr), Console.OSDTEXT_RED);
                            happy = false;
                        }
                        if (endframe == null) {
                            Console.Println("Error: missing 'end frame' for anim definition near line " + script.filename + ":" + script.getlinum(animtokptr), Console.OSDTEXT_RED);
                            happy = false;
                        }
                        model_ok &= happy;
                        if (!happy || m.mdnum < 2) continue block56;
                        switch (((MDModel)m).setAnimation(startframe, endframe, (int)(dfps * 65.536), flags)) {
                            case -2: {
                                Console.Println("Invalid starting frame name on line " + script.filename + ":" + script.getlinum(animtokptr), Console.OSDTEXT_RED);
                                model_ok = false;
                                break;
                            }
                            case -3: {
                                Console.Println("Invalid ending frame name on line " + script.filename + ":" + script.getlinum(animtokptr), Console.OSDTEXT_RED);
                                model_ok = false;
                            }
                        }
                        continue block56;
                    }
                    case 10: {
                        skintokptr = script.ltextptr;
                        skinfn = null;
                        palnum = 0;
                        surfnum = 0;
                        param = 1.0;
                        specpower = 1.0;
                        specfactor = 1.0;
                        skinend = script.getbraces();
                        if (skinend != -1) ** GOTO lbl206
                        break;
lbl-1000:
                        // 1 sources

                        {
                            tk = DefScript.this.gettoken(script, this.modelskintokens);
                            if (tk instanceof BaseToken) {
                                line = script.getlinum(script.ltextptr);
                                Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                                continue;
                            }
                            switch (ModelToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$ModelTokens()[((ModelTokens)tk).ordinal()]) {
                                default: {
                                    break;
                                }
                                case 17: {
                                    palnum = script.getsymbol();
                                    break;
                                }
                                case 18: {
                                    skinfn = DefScript.this.getFile(script);
                                    break;
                                }
                                case 19: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block60;
                                    surfnum = ivalue;
                                }
                            }
lbl206:
                            // 7 sources

                            ** while (script.textptr < skinend)
                        }
lbl207:
                        // 1 sources

                        script.skipbrace(skinend);
                        if (skinfn == null) {
                            Console.Println("Error: missing 'skin filename' for skin definition near line " + script.filename + ":" + script.getlinum(skintokptr), Console.OSDTEXT_RED);
                            model_ok = false;
                            break;
                        }
                        if (this.seenframe != 0) {
                            this.modelskin = ++this.lastmodelskin;
                        }
                        this.seenframe = 0;
                        ModelToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$ModelTokens()[token.ordinal()];
                        if (!BuildGdx.cache.contains(skinfn, 0) || m.mdnum < 2) continue block56;
                        switch (((MDModel)m).setSkin(skinfn, palnum, Math.max(0, this.modelskin), surfnum, param, specpower, specfactor)) {
                            case -2: {
                                Console.Println("Invalid skin filename on line " + script.filename + ":" + script.getlinum(skintokptr), Console.OSDTEXT_RED);
                                model_ok = false;
                                break;
                            }
                            case -3: {
                                Console.Println("Invalid palette number on line " + script.filename + ":" + script.getlinum(skintokptr), Console.OSDTEXT_RED);
                                model_ok = false;
                            }
                        }
                        continue block56;
                    }
                    case 11: {
                        hudtokptr = script.ltextptr;
                        happy = true;
                        ftilenume = -1;
                        ltilenume = -1;
                        tilex = 0;
                        flags = 0;
                        fov = -1;
                        xadd = 0.0;
                        yadd = 0.0;
                        zadd = 0.0;
                        angadd = 0.0;
                        frameend = script.getbraces();
                        if (frameend != -1) ** GOTO lbl298
                        break;
lbl-1000:
                        // 1 sources

                        {
                            tk = DefScript.this.gettoken(script, this.modelhudtokens);
                            if (tk instanceof BaseToken) {
                                line = script.getlinum(script.ltextptr);
                                Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                                continue;
                            }
                            switch (ModelToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$ModelTokens()[((ModelTokens)tk).ordinal()]) {
                                default: {
                                    break;
                                }
                                case 12: {
                                    ivalue = script.getsymbol();
                                    if (ivalue != null) {
                                        ftilenume = ivalue;
                                    }
                                    ltilenume = ftilenume;
                                    break;
                                }
                                case 13: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block61;
                                    ftilenume = ivalue;
                                    break;
                                }
                                case 14: {
                                    ivalue = script.getsymbol();
                                    if (ivalue == null) continue block61;
                                    ltilenume = ivalue;
                                    break;
                                }
                                case 3: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block61;
                                    xadd = dvalue;
                                    break;
                                }
                                case 4: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block61;
                                    yadd = dvalue;
                                    break;
                                }
                                case 5: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block61;
                                    zadd = dvalue;
                                    break;
                                }
                                case 20: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block61;
                                    angadd = dvalue;
                                    break;
                                }
                                case 21: {
                                    flags |= 1;
                                    break;
                                }
                                case 22: {
                                    flags |= 2;
                                    break;
                                }
                                case 23: {
                                    flags |= 4;
                                    break;
                                }
                                case 24: {
                                    flags |= 8;
                                }
                            }
lbl298:
                            // 20 sources

                            ** while (script.textptr < frameend)
                        }
lbl299:
                        // 1 sources

                        script.skipbrace(frameend);
                        if (DefScript.this.check_tile_range("hud", ftilenume, ltilenume, script, hudtokptr)) {
                            model_ok = false;
                            break;
                        }
                        tilex = ftilenume;
                        while (tilex <= ltilenume && happy) {
                            if (DefScript.this.mdInfo.addHudInfo(tilex, xadd, yadd, zadd, (short)angadd, flags, fov) == -2) {
                                Console.Println("Invalid tile number on line " + script.filename + ":" + script.getlinum(hudtokptr), Console.OSDTEXT_RED);
                                happy = false;
                            }
                            model_ok &= happy;
                            ++tilex;
                        }
                        break block4;
                    }
                }
lbl311:
                // 22 sources

                ** while (script.textptr < modelend)
            }
lbl312:
            // 1 sources

            script.skipbrace(modelend);
            if (!model_ok) {
                if (m != null) {
                    Console.Println("Removing model " + modelfn + " due to errors.", Console.OSDTEXT_YELLOW);
                    DefScript.this.mdInfo.removeModelInfo(m);
                }
                return BaseToken.Error;
            }
            m.setMisc((float)mdscale, shadeoffs, (float)mzadd, (float)myoffset, mdflags);
            this.lastmodelskin = 0;
            this.modelskin = 0;
            this.seenframe = 0;
            return BaseToken.Ok;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$ModelTokens() {
            if ($SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$ModelTokens != null) {
                return $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$ModelTokens;
            }
            int[] nArray = new int[ModelTokens.values().length];
            try {
                nArray[ModelTokens.ANGADD.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.ANIM.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.FILE.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.FLAGS.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.FLIPPED.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.FPS.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.FRAME.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.FRAME0.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.FRAME1.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.HIDE.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.HUD.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.NOBOB.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.NODEPTH.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.PAL.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.SCALE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.SHADE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.SKIN.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.SURF.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.TILE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.TILE0.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.TILE1.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.XADD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.YADD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[ModelTokens.ZADD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$ModelTokens = nArray;
            return nArray;
        }
    }

    protected static enum ModelTokens {
        SCALE,
        SHADE,
        XADD,
        YADD,
        ZADD,
        FRAME,
        FRAME0,
        FRAME1,
        ANIM,
        SKIN,
        HUD,
        TILE,
        TILE0,
        TILE1,
        FPS,
        FLAGS,
        PAL,
        FILE,
        SURF,
        ANGADD,
        HIDE,
        NOBOB,
        FLIPPED,
        NODEPTH;

    }

    protected class SkyboxToken
    implements Token {
        private final String[] skyfaces = new String[]{"front face", "right face", "back face", "left face", "top face", "bottom face"};
        private final Map<String, SkyboxTokens> skyboxtokens = new HashMap<String, SkyboxTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("tile", SkyboxTokens.TILE);
                this.put("pal", SkyboxTokens.PAL);
                this.put("ft", SkyboxTokens.FRONT);
                this.put("front", SkyboxTokens.FRONT);
                this.put("forward", SkyboxTokens.FRONT);
                this.put("rt", SkyboxTokens.RIGHT);
                this.put("right", SkyboxTokens.RIGHT);
                this.put("bk", SkyboxTokens.BACK);
                this.put("back", SkyboxTokens.BACK);
                this.put("lf", SkyboxTokens.LEFT);
                this.put("left", SkyboxTokens.LEFT);
                this.put("lt", SkyboxTokens.LEFT);
                this.put("up", SkyboxTokens.TOP);
                this.put("top", SkyboxTokens.TOP);
                this.put("ceiling", SkyboxTokens.TOP);
                this.put("ceil", SkyboxTokens.TOP);
                this.put("dn", SkyboxTokens.BOTTOM);
                this.put("bottom", SkyboxTokens.BOTTOM);
                this.put("floor", SkyboxTokens.BOTTOM);
                this.put("down", SkyboxTokens.BOTTOM);
            }
        };
        private static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$SkyboxTokens;

        protected SkyboxToken() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public BaseToken parse(Scriptfile script) {
            stile = -1;
            spal = 0;
            sfn = new String[6];
            sskyend = script.getbraces();
            if (sskyend != -1) ** GOTO lbl45
            return BaseToken.Error;
lbl-1000:
            // 1 sources

            {
                try {
                    tk = DefScript.this.gettoken(script, this.skyboxtokens);
                    if (tk instanceof BaseToken) {
                        line = script.getlinum(script.ltextptr);
                        Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                        continue;
                    }
                    switch (SkyboxToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$SkyboxTokens()[((SkyboxTokens)tk).ordinal()]) {
                        case 1: {
                            ivalue = script.getsymbol();
                            if (ivalue == null) continue block12;
                            stile = ivalue;
                            break;
                        }
                        case 2: {
                            ivalue = script.getsymbol();
                            if (ivalue == null) continue block12;
                            spal = ivalue;
                            break;
                        }
                        case 3: {
                            sfn[0] = DefScript.this.getFile(script);
                            break;
                        }
                        case 4: {
                            sfn[1] = DefScript.this.getFile(script);
                            break;
                        }
                        case 5: {
                            sfn[2] = DefScript.this.getFile(script);
                            break;
                        }
                        case 6: {
                            sfn[3] = DefScript.this.getFile(script);
                            break;
                        }
                        case 7: {
                            sfn[4] = DefScript.this.getFile(script);
                            break;
                        }
                        case 8: {
                            sfn[5] = DefScript.this.getFile(script);
                            break;
                        }
                    }
                    continue;
                }
                catch (Exception var7_8) {
                    // empty catch block
                }
lbl45:
                // 6 sources

                ** while (script.textptr < sskyend)
            }
lbl46:
            // 1 sources

            script.skipbrace(sskyend);
            if (this.addSkybox(script, stile, spal, sfn)) {
                return BaseToken.Ok;
            }
            return BaseToken.Error;
        }

        public boolean addSkybox(Scriptfile script, int stile, int spal, String[] sfn) {
            if (stile < 0) {
                Console.Println("Error: skybox: missing 'tile number' near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                return false;
            }
            int i = 0;
            while (i < 6) {
                if (sfn[i] == null) {
                    Console.Println("Error: skybox: missing " + this.skyfaces[i] + " filename' near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                    return false;
                }
                if (!BuildGdx.cache.contains(sfn[i], 0)) {
                    Console.Println("Error: file \"" + sfn[i] + "\" does not exist", Console.OSDTEXT_RED);
                    return false;
                }
                ++i;
            }
            DefScript.this.texInfo.addSkybox(stile, spal, sfn);
            return true;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$SkyboxTokens() {
            if ($SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$SkyboxTokens != null) {
                return $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$SkyboxTokens;
            }
            int[] nArray = new int[SkyboxTokens.values().length];
            try {
                nArray[SkyboxTokens.BACK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SkyboxTokens.BOTTOM.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SkyboxTokens.FRONT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SkyboxTokens.LEFT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SkyboxTokens.PAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SkyboxTokens.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SkyboxTokens.TILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SkyboxTokens.TOP.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$SkyboxTokens = nArray;
            return nArray;
        }
    }

    public static enum SkyboxTokens {
        TILE,
        PAL,
        FRONT,
        RIGHT,
        BACK,
        LEFT,
        TOP,
        BOTTOM;

    }

    protected class TextureToken
    implements Token {
        private final Map<String, TextureTokens> texturetokens = new HashMap<String, TextureTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("pal", TextureTokens.PAL);
                this.put("detail", TextureTokens.DETAIL);
                this.put("glow", TextureTokens.GLOW);
                this.put("specular", TextureTokens.SPECULAR);
                this.put("normal", TextureTokens.NORMAL);
                this.put("file", TextureTokens.FILE);
                this.put("name", TextureTokens.FILE);
                this.put("alphacut", TextureTokens.ALPHACUT);
                this.put("detailscale", TextureTokens.XSCALE);
                this.put("scale", TextureTokens.XSCALE);
                this.put("xscale", TextureTokens.XSCALE);
                this.put("intensity", TextureTokens.XSCALE);
                this.put("yscale", TextureTokens.YSCALE);
                this.put("specpower", TextureTokens.SPECPOWER);
                this.put("specularpower", TextureTokens.SPECPOWER);
                this.put("parallaxscale", TextureTokens.SPECPOWER);
                this.put("specfactor", TextureTokens.SPECFACTOR);
                this.put("specularfactor", TextureTokens.SPECFACTOR);
                this.put("parallaxbias", TextureTokens.SPECFACTOR);
                this.put("nocompress", TextureTokens.NOCOMPRESS);
                this.put("nodownsize", TextureTokens.NODOWNSIZE);
            }
        };
        private static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TextureTokens;

        protected TextureToken() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public BaseToken parse(Scriptfile script) {
            ttile = -1;
            ttile = script.getsymbol();
            if (ttile == null) {
                return BaseToken.Error;
            }
            textureend = script.getbraces();
            if (textureend != -1) ** GOTO lbl102
            return BaseToken.Error;
lbl-1000:
            // 1 sources

            {
                tk = DefScript.this.gettoken(script, this.texturetokens);
                if (tk instanceof BaseToken) {
                    line = script.getlinum(script.ltextptr);
                    Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                    continue;
                }
                token = (TextureTokens)tk;
                switch (TextureToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TextureTokens()[token.ordinal()]) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        tpal = -1;
                        tfn = null;
                        alphacut = -1.0;
                        xscale = 1.0;
                        yscale = 1.0;
                        specpower = 1.0;
                        specfactor = 1.0;
                        flags = 0;
                        if ((token != TextureTokens.PAL || (tpal = script.getsymbol()) != null) && (palend = script.getbraces()) != -1) ** GOTO lbl68
                        break;
lbl-1000:
                        // 1 sources

                        {
                            tk = DefScript.this.gettoken(script, this.texturetokens);
                            if (tk instanceof BaseToken) {
                                line = script.getlinum(script.ltextptr);
                                Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                                continue;
                            }
                            switch (TextureToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TextureTokens()[((TextureTokens)tk).ordinal()]) {
                                default: {
                                    break;
                                }
                                case 1: {
                                    tfn = DefScript.this.getFile(script);
                                    break;
                                }
                                case 7: {
                                    if (token != TextureTokens.PAL || (dvalue = script.getdouble()) == null) continue block21;
                                    alphacut = dvalue;
                                    break;
                                }
                                case 8: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block21;
                                    xscale = dvalue;
                                    break;
                                }
                                case 9: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block21;
                                    yscale = dvalue;
                                    break;
                                }
                                case 10: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block21;
                                    specpower = dvalue;
                                    break;
                                }
                                case 11: {
                                    dvalue = script.getdouble();
                                    if (dvalue == null) continue block21;
                                    specfactor = dvalue;
                                    break;
                                }
                                case 12: {
                                    flags |= 1;
                                    break;
                                }
                                case 13: {
                                    flags |= 16;
                                }
                            }
lbl68:
                            // 16 sources

                            ** while (script.textptr < palend)
                        }
lbl69:
                        // 1 sources

                        script.skipbrace(palend);
                        switch (TextureToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TextureTokens()[token.ordinal()]) {
                            default: {
                                break;
                            }
                            case 2: {
                                xscale = 1.0 / xscale;
                                yscale = 1.0 / yscale;
                                break;
                            }
                            case 3: {
                                tpal = 255;
                                xscale = 1.0 / xscale;
                                yscale = 1.0 / yscale;
                                break;
                            }
                            case 4: {
                                tpal = 254;
                                break;
                            }
                            case 5: {
                                tpal = 253;
                                break;
                            }
                            case 6: {
                                tpal = 252;
                            }
                        }
                        if (ttile >= Engine.MAXTILES) continue block20;
                        if (token == TextureTokens.PAL && tpal >= 252) {
                            Console.Println("Error: missing or invalid 'palette number' for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                            return BaseToken.Error;
                        }
                        if (tfn == null) {
                            Console.Println("Error: missing 'file name' for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                            return BaseToken.Error;
                        }
                        if (!BuildGdx.cache.contains(tfn, 0)) {
                            Console.Println("Error: file \"" + tfn + "\" not found for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                            return BaseToken.Error;
                        }
                        DefScript.this.texInfo.addTexture(ttile, tpal, tfn, (float)alphacut, (float)xscale, (float)yscale, (float)specpower, (float)specfactor, flags);
                    }
                }
lbl102:
                // 6 sources

                ** while (script.textptr < textureend)
            }
lbl103:
            // 1 sources

            script.skipbrace(textureend);
            if (ttile >= Engine.MAXTILES) {
                Console.Println("Error: missing or invalid 'tile number' for texture definition near line " + script.filename + ":" + script.getlinum(script.ltextptr), Console.OSDTEXT_RED);
                return BaseToken.Error;
            }
            return BaseToken.Ok;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TextureTokens() {
            if ($SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TextureTokens != null) {
                return $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TextureTokens;
            }
            int[] nArray = new int[TextureTokens.values().length];
            try {
                nArray[TextureTokens.ALPHACUT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.DETAIL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.FILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.GLOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.NOCOMPRESS.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.NODOWNSIZE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.NORMAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.PAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.SPECFACTOR.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.SPECPOWER.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.SPECULAR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.XSCALE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TextureTokens.YSCALE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TextureTokens = nArray;
            return nArray;
        }
    }

    protected static enum TextureTokens {
        FILE,
        PAL,
        DETAIL,
        GLOW,
        SPECULAR,
        NORMAL,
        ALPHACUT,
        XSCALE,
        YSCALE,
        SPECPOWER,
        SPECFACTOR,
        NOCOMPRESS,
        NODOWNSIZE;

    }

    protected class TileFromTextureToken
    implements Token {
        protected final Map<String, TileTextureTokens> tilefromtexturetokens = new HashMap<String, TileTextureTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("file", TileTextureTokens.FILE);
                this.put("name", TileTextureTokens.FILE);
                this.put("alphacut", TileTextureTokens.ALPHACUT);
                this.put("xoffset", TileTextureTokens.XOFFSET);
                this.put("xoff", TileTextureTokens.XOFFSET);
                this.put("yoffset", TileTextureTokens.YOFFSET);
                this.put("yoff", TileTextureTokens.YOFFSET);
                this.put("texture", TileTextureTokens.TEXTURE);
                this.put("ifcrc", TileTextureTokens.CRC);
            }
        };
        private static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TileTextureTokens;

        protected TileFromTextureToken() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public BaseToken parse(Scriptfile script) {
            def = DefScript.this;
            ttexturetokptr = script.ltextptr;
            fn = null;
            tile = -1;
            talphacut = 255;
            xoffset = null;
            yoffset = null;
            tilecrc = 0L;
            istexture = false;
            tile = script.getsymbol();
            if (tile == null) {
                return BaseToken.Error;
            }
            ttextureend = script.getbraces();
            if (ttextureend != -1) ** GOTO lbl60
            return BaseToken.Error;
lbl-1000:
            // 1 sources

            {
                tk = def.gettoken(script, this.tilefromtexturetokens);
                if (tk instanceof BaseToken) {
                    line = script.getlinum(script.ltextptr);
                    Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                    continue;
                }
                switch (TileFromTextureToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TileTextureTokens()[((TileTextureTokens)tk).ordinal()]) {
                    default: {
                        break;
                    }
                    case 1: {
                        fn = def.getFile(script);
                        break;
                    }
                    case 2: {
                        value = script.getsymbol();
                        if (value != null) {
                            talphacut = value;
                        }
                        talphacut = Gameutils.BClipRange(talphacut, 0, 255);
                        break;
                    }
                    case 3: {
                        xoffs = script.getstring();
                        if (xoffs.toUpperCase().equals("ART")) {
                            xoffset = (byte)((Engine.picanm[tile] & 65280) >> 8);
                            break;
                        }
                        try {
                            xoffset = Byte.parseByte(xoffs);
                        }
                        catch (Exception e) {
                            Console.Println("Xoffset value out of range. Value: \"" + xoffs + "\" was disabled.", Console.OSDTEXT_RED);
                        }
                        continue block12;
                    }
                    case 4: {
                        yoffs = script.getstring();
                        if (yoffs.toUpperCase().equals("ART")) {
                            yoffset = (byte)((Engine.picanm[tile] & 0xFF0000) >> 16);
                            break;
                        }
                        try {
                            yoffset = Byte.parseByte(yoffs);
                        }
                        catch (Exception e) {
                            Console.Println("Yoffset value out of range. Value: \"" + yoffs + "\" was disabled.", Console.OSDTEXT_RED);
                        }
                        continue block12;
                    }
                    case 5: {
                        istexture = true;
                        break;
                    }
                    case 6: {
                        tilecrc = (long)script.getsymbol().intValue() & 0xFFFFFFFFL;
                    }
                }
lbl60:
                // 13 sources

                ** while (script.textptr < ttextureend)
            }
lbl61:
            // 1 sources

            script.skipbrace(ttextureend);
            if (this.addTile(script, fn, tile, xoffset, yoffset, tilecrc, talphacut, istexture, ttexturetokptr) != null) {
                return BaseToken.Ok;
            }
            return BaseToken.Error;
        }

        protected DefTile addTile(Scriptfile script, String fn, Integer tile, Byte xoffset, Byte yoffset, long tilecrc, int talphacut, boolean istexture, int ttexturetokptr) {
            DefScript def = DefScript.this;
            if (tile < 0 || tile >= Engine.MAXTILES) {
                Console.Println("Error: missing or invalid 'tile number' for texture definition near line " + script.filename + ":" + script.getlinum(ttexturetokptr), Console.OSDTEXT_RED);
                return null;
            }
            if (fn == null) {
                String ext = FileUtils.getExtension(script.filename);
                DefTile deftile = new DefTile(Engine.tilesizx[tile], Engine.tilesizy[tile], tilecrc, ext != null && ext.equals("dat"));
                if (xoffset != null) {
                    deftile.xoffset = xoffset;
                }
                if (yoffset != null) {
                    deftile.yoffset = yoffset;
                }
                if (xoffset == null && yoffset == null) {
                    Console.Println("Error: missing 'file name' for tilefromtexture definition near line " + script.filename + ":" + script.getlinum(ttexturetokptr), Console.OSDTEXT_RED);
                }
                if (def.addDefTile(deftile, tile)) {
                    return deftile;
                }
                return null;
            }
            String ext = FileUtils.getExtension(script.filename);
            DefTile texstatus = this.ImportTileFromTexture(fn, tile, tilecrc, talphacut, istexture, ext != null && ext.equals("dat"));
            if (texstatus == null) {
                return null;
            }
            if (xoffset != null) {
                texstatus.xoffset = xoffset;
            }
            if (yoffset != null) {
                texstatus.yoffset = yoffset;
            }
            if (!def.addDefTile(texstatus, tile)) {
                Console.Println("Error: \"" + fn + "\" has more than one tile, in tilefromtexture definition near line " + script.filename + ":" + script.getlinum(ttexturetokptr), Console.OSDTEXT_RED);
                return null;
            }
            return texstatus;
        }

        protected DefTile ImportTileFromTexture(String fn, int tile, long crc32, int alphacut, boolean istexture, boolean internal) {
            DefScript def = DefScript.this;
            byte[] data = BuildGdx.cache.getBytes(fn, 0);
            if (data == null) {
                Console.Println("ImportTileFromTexture error: file " + fn + " not found!", Console.OSDTEXT_RED);
                return null;
            }
            Pixmap pix = new Pixmap(data, 0, data.length);
            pix.setFilter(Pixmap.Filter.NearestNeighbour);
            Pixmap.Format fmt = pix.getFormat();
            int xsiz = pix.getWidth();
            int ysiz = pix.getHeight();
            DefTile deftile = new DefTile(xsiz, ysiz, crc32, internal);
            deftile.waloff = new byte[xsiz * ysiz];
            ByteBuffer bb = pix.getPixels();
            byte[] waloff = deftile.waloff;
            int y = 0;
            while (y < ysiz) {
                int x = 0;
                while (x < xsiz) {
                    int r = (bb.get() & 0xFF) >> 2;
                    int g = (bb.get() & 0xFF) >> 2;
                    int b = (bb.get() & 0xFF) >> 2;
                    waloff[x * ysiz + y] = fmt == Pixmap.Format.RGBA4444 || fmt == Pixmap.Format.RGBA8888 ? (bb.get() == 0 ? -1 : def.engine.getclosestcol(Engine.palette, r, g, b)) : def.engine.getclosestcol(Engine.palette, r, g, b);
                    ++x;
                }
                ++y;
            }
            if (istexture) {
                deftile.hrp = fn;
                deftile.alphacut = (byte)alphacut;
            }
            return deftile;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TileTextureTokens() {
            if ($SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TileTextureTokens != null) {
                return $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TileTextureTokens;
            }
            int[] nArray = new int[TileTextureTokens.values().length];
            try {
                nArray[TileTextureTokens.ALPHACUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.CRC.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.FILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.TEXTURE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.XOFFSET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[TileTextureTokens.YOFFSET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$TileTextureTokens = nArray;
            return nArray;
        }
    }

    public static enum TileTextureTokens {
        FILE,
        ALPHACUT,
        XOFFSET,
        YOFFSET,
        TEXTURE,
        CRC;

    }

    public static interface Token {
        public BaseToken parse(Scriptfile var1);
    }

    protected class VoxelToken
    implements Token {
        private final Map<String, VoxelTokens> voxeltokens = new HashMap<String, VoxelTokens>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("tile", VoxelTokens.TILE);
                this.put("tile0", VoxelTokens.TILE0);
                this.put("tile1", VoxelTokens.TILE1);
                this.put("scale", VoxelTokens.SCALE);
                this.put("rotate", VoxelTokens.ROTATE);
            }
        };
        private static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$VoxelTokens;

        protected VoxelToken() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public BaseToken parse(Scriptfile script) {
            vscale = 1.0;
            tile0 = Engine.MAXTILES;
            tile1 = -1;
            tilex = -1;
            vrotate = false;
            fn = DefScript.this.getFile(script);
            if (fn == null) {
                return BaseToken.Error;
            }
            vmodelend = script.getbraces();
            if (vmodelend == -1) {
                return BaseToken.Error;
            }
            res = BuildGdx.cache.open(fn, 0);
            if (res == null) {
                Console.Println("Warning: File not found" + fn, Console.OSDTEXT_YELLOW);
                script.textptr = vmodelend + 1;
                return BaseToken.Warning;
            }
            vox = KVXLoader.load(res);
            res.close();
            if (vox != null) ** GOTO lbl60
            Console.Println("Warning: Failed loading MD2/MD3 model " + fn, Console.OSDTEXT_YELLOW);
            script.textptr = vmodelend + 1;
            return BaseToken.Warning;
lbl-1000:
            // 1 sources

            {
                tk = DefScript.this.gettoken(script, this.voxeltokens);
                if (tk instanceof BaseToken) {
                    line = script.getlinum(script.ltextptr);
                    Console.Println(String.valueOf(script.filename) + " has unknown token \"" + Strhandler.toLowerCase(script.textbuf.substring(script.ltextptr, script.textptr)) + "\" on line: " + Strhandler.toLowerCase(script.textbuf.substring(DefScript.this.getPtr(script, line), DefScript.this.getPtr(script, line + 1))), Console.OSDTEXT_RED);
                    continue;
                }
                switch (VoxelToken.$SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$VoxelTokens()[((VoxelTokens)tk).ordinal()]) {
                    case 1: {
                        tilex = script.getsymbol();
                        if (DefScript.this.check_tile("voxel", tilex, script, script.ltextptr)) continue block7;
                        DefScript.this.mdInfo.addVoxelInfo(vox, tilex);
                        break;
                    }
                    case 2: {
                        ivalue = script.getsymbol();
                        if (ivalue == null) break;
                        tile0 = ivalue;
                        break;
                    }
                    case 3: {
                        ivalue = script.getsymbol();
                        if (ivalue != null) {
                            tile1 = ivalue;
                        }
                        if (DefScript.this.check_tile_range("voxel", tile0, tile1, script, script.ltextptr)) continue block7;
                        tilex = tile0;
                        while (tilex <= tile1) {
                            DefScript.this.mdInfo.addVoxelInfo(vox, tilex);
                            ++tilex;
                        }
                        continue block7;
                    }
                    case 4: {
                        dvalue = script.getdouble();
                        if (dvalue == null) break;
                        vscale = dvalue;
                        break;
                    }
                    case 5: {
                        vrotate = true;
                        break;
                    }
                }
lbl60:
                // 12 sources

                ** while (script.textptr < vmodelend)
            }
lbl61:
            // 1 sources

            script.skipbrace(vmodelend);
            vox.getModel().setMisc((float)vscale, 0, 0.0f, 0.0f, vrotate != false ? 2 : 0);
            return BaseToken.Ok;
        }

        static /* synthetic */ int[] $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$VoxelTokens() {
            if ($SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$VoxelTokens != null) {
                return $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$VoxelTokens;
            }
            int[] nArray = new int[VoxelTokens.values().length];
            try {
                nArray[VoxelTokens.ROTATE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VoxelTokens.SCALE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VoxelTokens.TILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VoxelTokens.TILE0.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[VoxelTokens.TILE1.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$ru$m210projects$Build$Script$DefScript$VoxelTokens = nArray;
            return nArray;
        }
    }

    public static enum VoxelTokens {
        TILE,
        TILE0,
        TILE1,
        SCALE,
        ROTATE;

    }
}

