/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.Types;

import com.badlogic.gdx.graphics.Texture;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Render.TextureHandle.BTexture;
import ru.m210projects.Build.Render.TextureHandle.Pthtyp;
import ru.m210projects.Build.Render.TextureHandle.TextureCache;
import ru.m210projects.Build.Types.TileFont;

public class SmallTextFont
extends TileFont {
    public SmallTextFont() {
        super(TileFont.FontType.Bitmap, Engine.smalltextfont, 4, 6, 16, 16);
        this.sizx = 128;
        this.sizy = 128;
    }

    @Override
    public Pthtyp getGL(TextureCache textureCache, int col) {
        if (this.atlas == null) {
            this.init(textureCache, col);
        }
        return this.atlas;
    }

    @Override
    public Pthtyp init(TextureCache textureCache, int col) {
        this.atlas = new Pthtyp();
        this.atlas.glpic = new BTexture(128, 128);
        this.atlas.sizx = (short)128;
        this.atlas.sizy = (short)128;
        byte[] tbuf = new byte[this.sizx * this.sizy];
        ByteBuffer fbuf = ByteBuffer.allocateDirect(this.sizx * this.sizy).order(ByteOrder.LITTLE_ENDIAN);
        int h = 0;
        while (h < 256) {
            int tptr = h % 16 * 8 + h / 16 * this.sizx * 8;
            int i = 1;
            while (i < 7) {
                int j = 2;
                while (j < 6) {
                    if ((Engine.smalltextfont[h * 8 + i] & Engine.pow2char[7 - j]) != 0) {
                        tbuf[tptr + j - 2] = -1;
                    }
                    ++j;
                }
                tptr += this.sizx;
                ++i;
            }
            ++h;
        }
        fbuf.put(tbuf);
        fbuf.rewind();
        this.atlas.glpic.bind();
        BuildGdx.gl.glTexImage2D(3553, 0, 6406, this.sizx, this.sizy, 0, 6406, 5121, fbuf);
        this.atlas.glpic.setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        return this.atlas;
    }
}

