/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Build.desktop.AWT;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JFrame;
import ru.m210projects.Build.desktop.AWT.JCanvas;

public class JDisplay
extends WindowAdapter {
    protected final JFrame m_frame;
    private final JCanvas canvas;
    private boolean isCloseRequested = false;
    private boolean isFocus;
    private boolean isActive;
    private final GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private boolean isFullscreen;
    private boolean wasResized;
    private boolean undecorated;
    private Runnable rebuildCallback;

    public JDisplay(int width, int height, boolean undecorated) {
        this.canvas = new JCanvas(width, height);
        this.m_frame = this.buildFrame(undecorated);
        this.updateSize(width, height);
        this.isFullscreen = false;
    }

    protected void setRebuildCallback(Runnable handleCallback) {
        this.rebuildCallback = handleCallback;
    }

    public DisplayMode[] getDisplayModes() {
        return this.device.getDisplayModes();
    }

    public JFrame buildFrame(boolean undecorated) {
        JFrame frame = new JFrame(MouseInfo.getPointerInfo().getDevice().getDefaultConfiguration());
        frame.setUndecorated(undecorated);
        frame.add(this.canvas);
        frame.setDefaultCloseOperation(3);
        frame.addWindowListener(this);
        frame.addWindowFocusListener(this);
        this.undecorated = undecorated;
        return frame;
    }

    public void dispose() {
        this.m_frame.setVisible(false);
        this.m_frame.dispose();
    }

    protected void update() {
        this.canvas.repaint();
    }

    public int getWidth() {
        return this.canvas.getWidth();
    }

    public int getHeight() {
        return this.canvas.getHeight();
    }

    public boolean isCloseRequested() {
        return this.isCloseRequested;
    }

    public boolean isActive() {
        return this.isFocus && this.isActive;
    }

    public boolean setFullscreenMode(DisplayMode mode) {
        if (!this.device.isFullScreenSupported()) {
            return false;
        }
        this.setUndecorated(true);
        this.device.setFullScreenWindow(this.m_frame);
        if (this.device.isDisplayChangeSupported()) {
            this.device.setDisplayMode(mode);
        }
        this.updateSize(mode.getWidth(), mode.getHeight());
        this.isFullscreen = true;
        return true;
    }

    public boolean setWindowedMode(DisplayMode mode) {
        this.setUndecorated(this.undecorated);
        this.device.setFullScreenWindow(null);
        if (this.device.isDisplayChangeSupported()) {
            this.device.setDisplayMode(mode);
        }
        this.updateSize(mode.getWidth(), mode.getHeight());
        this.isFullscreen = false;
        return true;
    }

    public DisplayMode getDesktopDisplayMode() {
        return this.device.getDisplayMode();
    }

    public void updateSize(int width, int height) {
        Dimension size = this.canvas.getSize();
        if (size.width == width && size.height == height && this.canvas.getWidth() == width && this.canvas.getHeight() == height) {
            return;
        }
        this.wasResized = true;
        size = new Dimension(width, height);
        this.canvas.setSize(width, height);
        this.canvas.setPreferredSize(size);
        this.canvas.setMinimumSize(size);
        this.canvas.setMaximumSize(size);
        this.canvas.setBackground(Color.black);
        if (!this.isFullscreen()) {
            int oldX = this.getX();
            int oldY = this.getY();
            this.m_frame.pack();
            this.m_frame.setLocationRelativeTo(null);
            if (this.m_frame.isVisible()) {
                if (this.undecorated) {
                    DisplayMode mode = this.getDesktopDisplayMode();
                    oldX = mode.getWidth() / 2 - this.m_frame.getWidth() / 2;
                    oldY = mode.getHeight() / 2 - this.m_frame.getHeight() / 2;
                }
                this.m_frame.setLocation(oldX, oldY);
            }
        }
        this.canvas.validate();
    }

    public boolean wasResized() {
        boolean out = this.wasResized;
        this.wasResized = false;
        return out;
    }

    protected JCanvas getCanvas() {
        return this.canvas;
    }

    public void setTitle(String title) {
        this.m_frame.setTitle(title);
    }

    public int getX() {
        return this.m_frame.getX();
    }

    public int getY() {
        return this.m_frame.getY();
    }

    public void setUndecorated(boolean undecorated) {
        if (this.m_frame.isUndecorated() == undecorated) {
            return;
        }
        this.m_frame.dispose();
        this.m_frame.setUndecorated(undecorated);
        this.m_frame.setVisible(true);
        if (this.rebuildCallback != null) {
            this.rebuildCallback.run();
        }
    }

    public void setResizable(boolean resizable) {
        this.m_frame.setResizable(resizable);
    }

    public void setLocation(int x, int y) {
        if (x == -1 && y == -1) {
            return;
        }
        this.m_frame.setLocation(x, y);
    }

    public void setIcon(List<Image> icons) {
        this.m_frame.setIconImages(icons);
    }

    public boolean isFullscreen() {
        return this.isFullscreen;
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.isCloseRequested = true;
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.isActive = true;
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        this.isActive = false;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.isFocus = true;
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.isFocus = false;
    }
}

