/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.BuildSmacker;

import java.nio.ByteBuffer;

public class Header {
    private static final int RING_FRAME = 1;
    private static final int AUDIO_COMPRESSED = Integer.MIN_VALUE;
    private static final int AUDIO_PRESENT = 0x40000000;
    private static final int AUDIO_BITDEPTH = 0x20000000;
    private static final int AUDIO_CHANNELS = 0x10000000;
    private static final int AUDIO_COMPRESSED_V2 = 0xC000000;
    private static final int AUDIO_RATE = 0xFFFFFF;
    private Signature signature;
    public int Width;
    public int Height;
    public int Frames;
    public int FrameRate;
    public int Flags;
    public int TreesSize;
    public int MMap_Size;
    public int MClr_Size;
    public int Full_Size;
    public int Type_Size;
    public int[] AudioSize;
    public int[] AudioRate;

    public Header(ByteBuffer fp) throws Exception {
        if (fp == null || fp.capacity() == 0) {
            throw new NullPointerException("Buffer is null");
        }
        if (fp.get() != 83 || fp.get() != 77 || fp.get() != 75) {
            throw new Exception("Invalid SMK signature");
        }
        switch (fp.get()) {
            case 50: {
                this.signature = Signature.SMK2;
                break;
            }
            case 52: {
                this.signature = Signature.SMK4;
                break;
            }
            default: {
                throw new Exception("Unsupported SMK signature");
            }
        }
        this.Width = fp.getInt();
        this.Height = fp.getInt();
        this.Frames = fp.getInt();
        int rate = fp.getInt();
        this.FrameRate = rate > 0 ? rate * 1000 : (rate < 0 ? rate * -10 : 100000);
        this.Flags = fp.getInt();
        if ((this.Flags & 1) != 0) {
            ++this.Frames;
        }
        this.AudioSize = new int[7];
        int i = 0;
        while (i < 7) {
            this.AudioSize[i] = fp.getInt();
            ++i;
        }
        this.TreesSize = fp.getInt();
        this.MMap_Size = fp.getInt();
        this.MClr_Size = fp.getInt();
        this.Full_Size = fp.getInt();
        this.Type_Size = fp.getInt();
        this.AudioRate = new int[7];
        i = 0;
        while (i < 7) {
            this.AudioRate[i] = fp.getInt();
            ++i;
        }
        fp.getInt();
    }

    public boolean isAudioExists(int num) {
        return (this.AudioRate[num] & 0x40000000) != 0;
    }

    public int getAudioRate(int num) {
        if (this.isAudioExists(num)) {
            return this.AudioRate[num] & 0xFFFFFF;
        }
        return -1;
    }

    public AudioBits getAudioBits(int num) {
        if (this.isAudioExists(num)) {
            return (this.AudioRate[num] & 0x20000000) != 0 ? AudioBits.aud16bit : AudioBits.aud8bit;
        }
        return null;
    }

    public AudioChannels getAudioChannels(int num) {
        if (this.isAudioExists(num)) {
            return (this.AudioRate[num] & 0x10000000) != 0 ? AudioChannels.Stereo : AudioChannels.Mono;
        }
        return null;
    }

    public AudioCompression getAudioCompressionType(int num) {
        if (this.isAudioExists(num)) {
            if ((this.AudioRate[num] & Integer.MIN_VALUE) != 0) {
                return AudioCompression.DPCM;
            }
            if ((this.AudioRate[num] & 0xC000000) != 0) {
                return AudioCompression.Bink;
            }
            return AudioCompression.PCM;
        }
        return null;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public static enum AudioBits {
        aud8bit(8),
        aud16bit(16);

        private int bits;

        private AudioBits(int bits) {
            this.bits = bits;
        }

        public int get() {
            return this.bits;
        }
    }

    public static enum AudioChannels {
        Mono(0),
        Stereo(1);

        private int ch;

        private AudioChannels(int ch) {
            this.ch = ch;
        }

        public int get() {
            return this.ch + 1;
        }
    }

    public static enum AudioCompression {
        PCM,
        DPCM,
        Bink;

    }

    public static enum Signature {
        SMK2,
        SMK4;

    }
}

