/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.BuildSmacker;

import java.util.Arrays;
import ru.m210projects.BuildSmacker.BitBuffer;

public abstract class HuffmanTree {
    private Node t;
    private int[] cache = new int[3];

    public HuffmanTree(BitBuffer b) throws Exception {
        if (b == null) {
            throw new Exception("HuffmanTree BitBuffer == null");
        }
        if (b.getBit() == 0) {
            throw new Exception("HuffmanTree initialization failed!");
        }
        Node low8 = new Node(b);
        Node hi8 = new Node(b);
        int i = 0;
        while (i < 3) {
            short lowval = b.getByte();
            this.cache[i] = b.getByte();
            this.cache[i] = lowval | this.cache[i] << 8;
            ++i;
        }
        this.t = new Node(b, this.cache, low8, hi8);
        if (b.getBit() != 0) {
            throw new Exception("ERROR: final getBit returned 1");
        }
    }

    private int lookup(BitBuffer b, Node t) {
        if (t == null) {
            return -1;
        }
        if (t.b0 == null) {
            int val = ((Node)t).u.value;
            if (((Node)t).u.escapecode != 255) {
                val = this.cache[((Node)t).u.escapecode];
            }
            if (this.cache[0] != val) {
                this.cache[2] = this.cache[1];
                this.cache[1] = this.cache[0];
                this.cache[0] = val;
            }
            return val;
        }
        if (b.getBit() != 0) {
            return this.lookup(b, ((Node)t).u.b1);
        }
        return this.lookup(b, t.b0);
    }

    protected abstract void message(String var1);

    public int getCode(BitBuffer b) {
        int s = this.lookup(b, this.t);
        if (s < 0) {
            this.message("HuffmanTree lookup error");
            return -1;
        }
        return s;
    }

    public void reset() {
        Arrays.fill(this.cache, 0);
    }

    public static class Node {
        private Node b0;
        private Union u = new Union();

        private Node() {
        }

        private Node(BitBuffer b, int[] cache, Node low8, Node hi8) throws Exception {
            if (b.getBit() != 0) {
                this.b0 = new Node(b, cache, low8, hi8);
                this.u.b1 = new Node(b, cache, low8, hi8);
                return;
            }
            int lowval = low8.lookup(b);
            this.u.value = hi8.lookup(b);
            this.u.value = lowval | this.u.value << 8;
            this.u.escapecode = this.u.value == cache[0] ? (short)0 : (this.u.value == cache[1] ? (short)1 : (this.u.value == cache[2] ? (short)2 : (short)255));
        }

        private Node build(BitBuffer b) throws Exception {
            if (b.getBit() != 0) {
                this.b0 = new Node().build(b);
                this.u.b1 = new Node().build(b);
                return this;
            }
            this.u.value = b.getByte();
            this.u.escapecode = (short)255;
            return this;
        }

        public Node(BitBuffer b) throws Exception {
            if (b.getBit() == 0) {
                throw new Exception("Warning: initial getBit returned 0");
            }
            this.build(b);
            if (b.getBit() != 0) {
                throw new Exception("Error: final getBit returned 1");
            }
        }

        public int lookup(BitBuffer b) {
            if (this.b0 == null) {
                return this.u.value;
            }
            if (b.getBit() != 0) {
                return this.u.b1.lookup(b);
            }
            return this.b0.lookup(b);
        }

        private class Union {
            Node b1;
            int value;
            short escapecode;

            private Union() {
            }
        }
    }
}

