/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Factory;

import java.io.File;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Audio.BuildAudio;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.FileUtils;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Loader.WAVLoader;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Input;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Menus.NetworkMenu;
import ru.m210projects.Duke3D.Player;
import ru.m210projects.Duke3D.Premap;
import ru.m210projects.Duke3D.ResourceHandler;
import ru.m210projects.Duke3D.Screen;
import ru.m210projects.Duke3D.Sector;
import ru.m210projects.Duke3D.Sounds;
import ru.m210projects.Duke3D.Types.PLocation;
import ru.m210projects.Duke3D.Types.PlayerStruct;
import ru.m210projects.Duke3D.Types.RTS;
import ru.m210projects.Duke3D.Types.VOC;
import ru.m210projects.Duke3D.View;

public class DukeNetwork
extends BuildNet {
    public int PlayerSyncRequest = -1;
    public int PlayerSyncTrail = -1;
    public PLocation[] predictFifo = new PLocation[256];
    public PLocation predict = new PLocation();
    public PLocation predictOld = new PLocation();
    private char[] recbuf = new char[80];
    public final int nNetVersion = 500;
    public static final byte kPacketMessage = 4;
    public static final byte kPacketSound = 5;
    public static final byte kPacketProfile = 6;
    public static final byte kPacketContentRequest = 8;
    public static final byte kPacketContentAnswer = 9;
    public static final byte kPacketPlayer = 10;
    public byte[] gContentFound = new byte[16];
    public Main app;

    public DukeNetwork(Main app) {
        super(app);
        this.app = app;
        int i = 0;
        while (i < 256) {
            this.predictFifo[i] = new PLocation();
            ++i;
        }
        Arrays.fill(this.gContentFound, (byte)-1);
    }

    @Override
    public BuildNet.NetInput newInstance() {
        return new Input();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int GetPackets(byte[] p, int ptr, int len, int nPlayer) {
        switch (p[ptr++]) {
            case 9: {
                this.gContentFound[nPlayer] = p[ptr];
                return 1;
            }
            case 10: {
                num = this.packbuf[ptr++];
                trail = LittleEndian.getInt(p, ptr);
                this.PlayerSyncRequest = num;
                this.PlayerSyncTrail = trail;
                break;
            }
            case 8: {
                pathlen = LittleEndian.getInt(p, ptr);
                if (pathlen >= p.length - (ptr += 4)) {
                    pathlen = p.length - ptr - 1;
                }
                path = FileUtils.getCorrectPath(new String(p, ptr, pathlen));
                crc32 = LittleEndian.getUInt(p, ptr += pathlen);
                mycrc = -1L;
                fil = BuildGdx.compat.checkFile(path);
                ini = ResourceHandler.levelGetEpisode(path);
                found = 0;
                if (fil != null || ini != null) {
                    network = (NetworkMenu)this.app.menu.mMenus[11];
                    if (ini != null) {
                        mycrc = ini.getFile().getChecksum();
                        if (mycrc == crc32) {
                            found = 1;
                            network.setEpisode(ini);
                        } else {
                            found = 2;
                            Console.Println("Player" + nPlayer + " - " + Globals.ud.user_name[nPlayer] + " tried to set user content. User content found, but has a different checksum!", Console.OSDTEXT_RED);
                            Console.Println("Make sure that you have the same content: " + File.separator + path, Console.OSDTEXT_RED);
                            if (!Console.IsShown()) {
                                Console.toggle();
                            }
                        }
                    } else if (fil != null && fil.getExtension().equals("map")) {
                        mycrc = fil.getChecksum();
                        if (mycrc == crc32) {
                            found = 1;
                            network.setMap(fil);
                        } else {
                            found = 2;
                            Console.Println("Player" + nPlayer + " - " + Globals.ud.user_name[nPlayer] + " tried to set user content. User content found, but has a different checksum!", Console.OSDTEXT_RED);
                            Console.Println("Make sure that you have the same content: " + File.separator + path, Console.OSDTEXT_RED);
                            if (!Console.IsShown()) {
                                Console.toggle();
                            }
                        }
                    }
                } else {
                    Console.Println("Player" + nPlayer + " - " + Globals.ud.user_name[nPlayer] + " tried to set user content. User content not found!", Console.OSDTEXT_RED);
                    Console.Println("Make sure that you have content at the same path: " + File.separator + path, Console.OSDTEXT_RED);
                    if (!Console.IsShown()) {
                        Console.toggle();
                    }
                }
                this.packbuf[0] = 9;
                this.packbuf[1] = found;
                Mmulti.sendpacket(nPlayer, this.packbuf, 2);
                return 1;
            }
            case -4: {
                this.retransmit(nPlayer, this.packbuf, len);
                ptr = 5;
                nCheckVersion = LittleEndian.getInt(p, ptr);
                Globals.pNetInfo.set(p, ptr += 4);
                i = Mmulti.connecthead;
                while (i >= 0) {
                    Premap.resetweapons(i);
                    Premap.resetinventory(i);
                    i = Mmulti.connectpoint2[i];
                }
                if (nCheckVersion != 500) {
                    this.game.GameMessage("These versions of Duke3D cannot play together.");
                    this.NetDisconnect(Mmulti.myconnectindex);
                    return -1;
                }
                if (!this.WaitForAllPlayers(0)) break;
                Main.gGameScreen.newgame(true, ((NetworkMenu)this.app.menu.mMenus[11]).getFile(), Globals.pNetInfo.nEpisode, Globals.pNetInfo.nLevel, Globals.pNetInfo.nDifficulty);
                break;
            }
            case 7: {
                return this.GetDisconnectPacket(p, ptr, len, nPlayer, new BuildNet.DisconnectCallback(){

                    @Override
                    public void invoke(int nDelete) {
                        if (Globals.ud.rec != null) {
                            Globals.ud.rec.close();
                        }
                        Globals.ud.multimode = Mmulti.numplayers - 1;
                        if (DukeNetwork.this.game.isCurrentScreen(Main.gGameScreen)) {
                            Player.quickkill(Globals.ps[nDelete]);
                            Main.engine.deletesprite(Globals.ps[nDelete].i);
                        }
                        Strhandler.buildString(Globals.buf, 0, Globals.ud.user_name[nDelete], " is history!");
                        Screen.vscrn(Globals.ud.screen_size);
                        View.adduserquote(Globals.buf);
                    }
                });
            }
            case 5: {
                this.retransmit(nPlayer, this.packbuf, len);
                if (Main.cfg.noSound || Globals.ud.lockout == 1 || !BuildGdx.audio.IsInited(BuildAudio.Driver.Sound) || !RTS.RTS_Started) break;
                rtsptr = RTS.RTS_GetSound(this.packbuf[1]);
                if (rtsptr[0] != 67) ** GOTO lbl86
                voc = new VOC(rtsptr);
                voice = BuildGdx.audio.newSound(voc.sampledata, voc.samplerate, voc.samplesize, 255);
                if (voice != null) {
                    voice.setGlobal(1);
                    voice.play(1.0f);
                }
                ** GOTO lbl96
lbl86:
                // 1 sources

                try {
                    wav = new WAVLoader(rtsptr);
                    voice = BuildGdx.audio.newSound(wav.data, wav.rate, wav.bits, 255);
                    if (voice != null) {
                        voice.setGlobal(1);
                        voice.play(1.0f);
                    }
                }
                catch (Exception e) {
                    break;
                }
lbl96:
                // 3 sources

                RTS.rtsplaying = (char)7;
                break;
            }
            case 4: {
                this.retransmit(nPlayer, this.packbuf, len);
                i = 0;
                while (i < len - 2) {
                    this.recbuf[i] = (char)this.packbuf[i + 2];
                    ++i;
                }
                this.recbuf[len - 2] = '\u0000';
                View.adduserquote(this.recbuf);
                Sounds.sound(243);
                break;
            }
            case 6: {
                this.retransmit(nPlayer, this.packbuf, len);
                nP = this.packbuf[1];
                len = 0;
                i = 3;
                while (this.packbuf[i] != 0) {
                    ++i;
                    ++len;
                }
                Globals.ud.user_name[nP] = new String(this.packbuf, 3, len);
                j = ++i;
                while (i - j < 10) {
                    Globals.ud.wchoice[nP][i - j] = this.packbuf[i];
                    ++i;
                }
                Globals.ps[nP].aim_mode = this.packbuf[i++];
                Globals.ps[nP].auto_aim = this.packbuf[i++];
                break;
            }
            case -1: {
                this.game.gExit = true;
            }
        }
        return 0;
    }

    @Override
    public void UpdatePrediction(BuildNet.NetInput input) {
        int i;
        int k;
        Input syn = (Input)input;
        this.predictOld.copy(this.predict);
        PlayerStruct p = Globals.ps[Mmulti.myconnectindex];
        short backcstat = Engine.sprite[p.i].cstat;
        Engine.sprite[p.i].cstat = (short)(Engine.sprite[p.i].cstat & 0xFFFFFEFE);
        int sb_snum = syn.bits;
        short psect = this.predict.sectnum;
        short psectlotag = Engine.sector[psect].lotag;
        boolean spritebridge = false;
        boolean shrunk = Engine.sprite[p.i].yrepeat < 32;
        Main.engine.getzrange(this.predict.x, this.predict.y, this.predict.z, psect, 163, 65537);
        int cz = Engine.zr_ceilz;
        int hz = Engine.zr_ceilhit;
        int fz = Engine.zr_florz;
        int lz = Engine.zr_florhit;
        int j = Main.engine.getflorzofslope(psect, this.predict.x, this.predict.y);
        if ((lz & 0xC000) == 16384 && psectlotag == 1 && Pragmas.klabs(this.predict.z - j) > 13824) {
            psectlotag = 0;
        }
        if (p.aim_mode == 0 && this.predict.onground && psectlotag != 2 && (Engine.sector[psect].floorstat & 2) != 0) {
            int x = (int)((double)this.predict.x + Gameutils.BCosAngle(Gameutils.BClampAngle(this.predict.ang)) / 32.0);
            int y = (int)((double)this.predict.y + Gameutils.BSinAngle(Gameutils.BClampAngle(this.predict.ang)) / 32.0);
            short tempsect = psect;
            if ((tempsect = Main.engine.updatesector(x, y, tempsect)) >= 0) {
                k = Main.engine.getflorzofslope(psect, x, y);
                if (psect == tempsect) {
                    this.predict.horizoff = (short)(this.predict.horizoff + Pragmas.mulscale(j - k, 160L, 16));
                } else if (Pragmas.klabs(Main.engine.getflorzofslope(tempsect, x, y) - k) <= 1024) {
                    this.predict.horizoff = (short)(this.predict.horizoff + Pragmas.mulscale(j - k, 160L, 16));
                }
            }
        }
        if (this.predict.horizoff > 0) {
            this.predict.horizoff = (short)(this.predict.horizoff - ((this.predict.horizoff >> 3) + 1));
        } else if (this.predict.horizoff < 0) {
            this.predict.horizoff = (short)(this.predict.horizoff + ((-this.predict.horizoff >> 3) + 1));
        }
        if (hz >= 0 && (hz & 0xC000) == 49152 && Engine.sprite[hz &= Engine.MAXSPRITES - 1].statnum == 1 && Engine.sprite[hz].extra >= 0) {
            hz = 0;
            cz = Main.engine.getceilzofslope(psect, this.predict.x, this.predict.y);
        }
        if (lz >= 0 && (lz & 0xC000) == 49152) {
            j = lz & Engine.MAXSPRITES - 1;
            if ((Engine.sprite[j].cstat & 0x21) == 33) {
                psectlotag = 0;
                spritebridge = true;
            }
            if (Actors.badguy(Engine.sprite[j]) && Engine.sprite[j].xrepeat > 24 && Pragmas.klabs(Engine.sprite[p.i].z - Engine.sprite[j].z) < 21504) {
                j = Main.engine.getangle(Engine.sprite[j].x - this.predict.x, Engine.sprite[j].y - this.predict.y);
                this.predict.xvel -= Engine.sintable[j + 512 & 0x7FF] << 4;
                this.predict.yvel -= Engine.sintable[j & 0x7FF] << 4;
            }
        }
        if (Engine.sprite[p.i].extra <= 0) {
            short sect;
            if (psectlotag == 2) {
                if (p.on_warping_sector == 0 && Pragmas.klabs(this.predict.z - fz) > 4864) {
                    this.predict.z += 348;
                }
                Main.engine.clipmove(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, 0L, 0L, 164, 1024, 1024, 65537);
                if (Engine.clipmove_sectnum != -1) {
                    this.predict.x = Engine.clipmove_x;
                    this.predict.y = Engine.clipmove_y;
                    this.predict.z = Engine.clipmove_z;
                    this.predict.sectnum = Engine.clipmove_sectnum;
                }
            }
            if ((sect = Main.engine.updatesector(this.predict.x, this.predict.y, this.predict.sectnum)) != -1) {
                this.predict.sectnum = sect;
            }
            Main.engine.pushmove(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, 128, 1024, 5120, 65537);
            if (Engine.pushmove_sectnum != -1) {
                this.predict.x = Engine.pushmove_x;
                this.predict.y = Engine.pushmove_y;
                this.predict.z = Engine.pushmove_z;
                this.predict.sectnum = Engine.pushmove_sectnum;
            }
            this.predict.horiz = 100.0f;
            this.predict.horizoff = 0;
            this.predictFifo[this.gPredictTail & 0xFF].copy(this.predict);
            ++this.gPredictTail;
            Engine.sprite[p.i].cstat = backcstat;
            return;
        }
        int doubvel = 4;
        if (p.on_crane < 0) {
            if (p.one_eighty_count < 0) {
                this.predict.ang += 128.0f;
            }
            i = 40;
            if (psectlotag == 2) {
                this.predict.jumpingcounter = 0;
                if ((sb_snum & 1) != 0) {
                    if (this.predict.zvel > 0) {
                        this.predict.zvel = 0;
                    }
                    this.predict.zvel -= 348;
                    if (this.predict.zvel < -1536) {
                        this.predict.zvel = -1536;
                    }
                } else if ((sb_snum & 2) != 0) {
                    if (this.predict.zvel < 0) {
                        this.predict.zvel = 0;
                    }
                    this.predict.zvel += 348;
                    if (this.predict.zvel > 1536) {
                        this.predict.zvel = 1536;
                    }
                } else {
                    if (this.predict.zvel < 0) {
                        this.predict.zvel += 256;
                        if (this.predict.zvel > 0) {
                            this.predict.zvel = 0;
                        }
                    }
                    if (this.predict.zvel > 0) {
                        this.predict.zvel -= 256;
                        if (this.predict.zvel < 0) {
                            this.predict.zvel = 0;
                        }
                    }
                }
                if (this.predict.zvel > 2048) {
                    this.predict.zvel >>= 1;
                }
                this.predict.z += this.predict.zvel;
                if (this.predict.z > fz - 3840) {
                    this.predict.z += fz - 3840 - this.predict.z >> 1;
                }
                if (this.predict.z < cz + 1024) {
                    this.predict.z = cz + 1024;
                    this.predict.zvel = 0;
                }
            } else if (p.jetpack_on != 0) {
                this.predict.onground = false;
                this.predict.jumpingcounter = 0;
                this.predict.hardlanding = 0;
                if (p.jetpack_on < 11) {
                    this.predict.z -= p.jetpack_on << 7;
                }
                j = shrunk ? 512 : 2048;
                if ((sb_snum & 1) != 0) {
                    this.predict.z -= j;
                }
                if ((sb_snum & 2) != 0) {
                    this.predict.z += j;
                }
                if (this.predict.z > fz - ((k = !shrunk && (psectlotag == 0 || psectlotag == 2) ? 32 : 16) << 8)) {
                    this.predict.z += fz - (k << 8) - this.predict.z >> 1;
                }
                if (this.predict.z < cz + 4608) {
                    this.predict.z = cz + 4608;
                }
            } else if (psectlotag != 2) {
                if (psectlotag == 1 && p.spritebridge == 0) {
                    i = !shrunk ? 34 : 12;
                }
                if (this.predict.z < fz - (i << 8) && !Sector.floorspace(psect) && !Sector.ceilingspace(psect)) {
                    if ((sb_snum & 3) == 0 && this.predict.onground && (Engine.sector[psect].floorstat & 2) != 0 && this.predict.z >= fz - (i << 8) - 4096) {
                        this.predict.z = fz - (i << 8);
                    } else {
                        this.predict.onground = false;
                        this.predict.zvel += Globals.currentGame.getCON().gc + 80;
                        if (this.predict.zvel >= 6144) {
                            this.predict.zvel = 6144;
                        }
                    }
                } else {
                    if (psectlotag != 1 && psectlotag != 2 && !this.predict.onground && this.predict.zvel > 3072) {
                        this.predict.hardlanding = (byte)(this.predict.zvel >> 10);
                    }
                    this.predict.onground = true;
                    if (i == 40) {
                        k = fz - (i << 8) - this.predict.z >> 1;
                        if (Pragmas.klabs(k) < 256) {
                            k = 0;
                        }
                        this.predict.z += k;
                        this.predict.zvel -= 768;
                        if (this.predict.zvel < 0) {
                            this.predict.zvel = 0;
                        }
                    } else if (this.predict.jumpingcounter == 0) {
                        this.predict.z += fz - (i << 7) - this.predict.z >> 1;
                        if (p.on_warping_sector == 0 && this.predict.z > fz - 4096) {
                            this.predict.z = fz - 4096;
                            this.predict.zvel >>= 1;
                        }
                    }
                    if ((sb_snum & 2) != 0) {
                        this.predict.z += 2816;
                    }
                    if ((sb_snum & 1) == 0 && this.predict.jumpingtoggle == 1) {
                        this.predict.jumpingtoggle = 0;
                    } else if ((sb_snum & 1) != 0 && this.predict.jumpingtoggle == 0 && this.predict.jumpingcounter == 0 && fz - cz > 14336) {
                        this.predict.jumpingcounter = 1;
                        this.predict.jumpingtoggle = 1;
                    }
                    if (this.predict.jumpingcounter != 0 && (sb_snum & 1) == 0) {
                        this.predict.jumpingcounter = 0;
                    }
                }
                if (this.predict.jumpingcounter != 0) {
                    if ((sb_snum & 1) == 0 && this.predict.jumpingtoggle == 1) {
                        this.predict.jumpingtoggle = 0;
                    }
                    if (this.predict.jumpingcounter < 1280) {
                        if (psectlotag == 1 && this.predict.jumpingcounter > 768) {
                            this.predict.jumpingcounter = 0;
                            this.predict.zvel = -512;
                        } else {
                            this.predict.zvel -= Engine.sintable[1920 + this.predict.jumpingcounter & 0x7FF] / 12;
                            this.predict.jumpingcounter = (short)(this.predict.jumpingcounter + 180);
                            this.predict.onground = false;
                        }
                    } else {
                        this.predict.jumpingcounter = 0;
                        this.predict.zvel = 0;
                    }
                }
                this.predict.z += this.predict.zvel;
                if (this.predict.z < cz + 1024) {
                    this.predict.jumpingcounter = 0;
                    if (this.predict.zvel < 0) {
                        this.predict.yvel = 0;
                        this.predict.xvel = 0;
                    }
                    this.predict.zvel = 128;
                    this.predict.z = cz + 1024;
                }
            }
            if (p.fist_incs != 0 || p.transporter_hold > 2 || this.predict.hardlanding != 0 || p.access_incs > 0 || p.knee_incs > 0 || p.curr_weapon == 8 && p.kickback_pic > 1 && p.kickback_pic < 4) {
                doubvel = 0;
                this.predict.xvel = 0;
                this.predict.yvel = 0;
            } else if (syn.avel != 0.0f) {
                long tempang = (long)(syn.avel * 2.0f);
                this.predict.ang = psectlotag == 2 ? (this.predict.ang += (float)((tempang - (tempang >> 3)) * (long)Pragmas.ksgn(doubvel))) : (this.predict.ang += (float)(tempang * (long)Pragmas.ksgn(doubvel)));
                this.predict.ang = Gameutils.BClampAngle(this.predict.ang);
            }
            if (this.predict.xvel != 0 || this.predict.yvel != 0 || syn.fvel != 0 || syn.svel != 0) {
                if (p.steroids_amount > 0 && p.steroids_amount < 400) {
                    doubvel <<= 1;
                }
                this.predict.xvel += syn.fvel * doubvel << 6;
                this.predict.yvel += syn.svel * doubvel << 6;
                if (p.curr_weapon == 0 && p.kickback_pic > 10 && this.predict.onground || this.predict.onground && (sb_snum & 2) != 0) {
                    this.predict.xvel = Pragmas.mulscale(this.predict.xvel, Globals.currentGame.getCON().dukefriction - 8192, 16);
                    this.predict.yvel = Pragmas.mulscale(this.predict.yvel, Globals.currentGame.getCON().dukefriction - 8192, 16);
                } else if (psectlotag == 2) {
                    this.predict.xvel = Pragmas.mulscale(this.predict.xvel, Globals.currentGame.getCON().dukefriction - 5120, 16);
                    this.predict.yvel = Pragmas.mulscale(this.predict.yvel, Globals.currentGame.getCON().dukefriction - 5120, 16);
                } else {
                    this.predict.xvel = Pragmas.mulscale(this.predict.xvel, Globals.currentGame.getCON().dukefriction, 16);
                    this.predict.yvel = Pragmas.mulscale(this.predict.yvel, Globals.currentGame.getCON().dukefriction, 16);
                }
                if (Pragmas.klabs(this.predict.xvel) < 2048 && Pragmas.klabs(this.predict.yvel) < 2048) {
                    this.predict.yvel = 0;
                    this.predict.xvel = 0;
                }
                if (shrunk) {
                    this.predict.xvel = Pragmas.mulscale(this.predict.xvel, Globals.currentGame.getCON().dukefriction - (Globals.currentGame.getCON().dukefriction >> 1) + (Globals.currentGame.getCON().dukefriction >> 2), 16);
                    this.predict.yvel = Pragmas.mulscale(this.predict.yvel, Globals.currentGame.getCON().dukefriction - (Globals.currentGame.getCON().dukefriction >> 1) + (Globals.currentGame.getCON().dukefriction >> 2), 16);
                }
            }
        }
        i = psectlotag == 1 || spritebridge ? 1024 : 5120;
        Main.engine.clipmove(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, this.predict.xvel, this.predict.yvel, 164, 1024, i, 65537);
        if (Engine.clipmove_sectnum != -1) {
            this.predict.x = Engine.clipmove_x;
            this.predict.y = Engine.clipmove_y;
            this.predict.z = Engine.clipmove_z;
            this.predict.sectnum = Engine.clipmove_sectnum;
        }
        Main.engine.pushmove(this.predict.x, this.predict.y, this.predict.z, this.predict.sectnum, 164, 1024, 1024, 65537);
        if (Engine.pushmove_sectnum != -1) {
            this.predict.x = Engine.pushmove_x;
            this.predict.y = Engine.pushmove_y;
            this.predict.z = Engine.pushmove_z;
            this.predict.sectnum = Engine.pushmove_sectnum;
        }
        if (p.jetpack_on == 0 && psectlotag != 1 && psectlotag != 2 && shrunk) {
            this.predict.z += 7680;
        }
        if ((sb_snum & 0x40000) != 0 || this.predict.hardlanding != 0) {
            this.predict.returntocenter = (byte)9;
        }
        if ((sb_snum & 0x2000) != 0) {
            this.predict.returntocenter = (byte)9;
            if ((sb_snum & 0x20) != 0) {
                this.predict.horiz += 6.0f;
            }
            this.predict.horiz += 6.0f;
        } else if ((sb_snum & 0x4000) != 0) {
            this.predict.returntocenter = (byte)9;
            if ((sb_snum & 0x20) != 0) {
                this.predict.horiz -= 6.0f;
            }
            this.predict.horiz -= 6.0f;
        } else if ((sb_snum & 8) != 0) {
            if ((sb_snum & 0x20) != 0) {
                this.predict.horiz += 6.0f;
            }
            this.predict.horiz += 6.0f;
        } else if ((sb_snum & 0x10) != 0) {
            if ((sb_snum & 0x20) != 0) {
                this.predict.horiz -= 6.0f;
            }
            this.predict.horiz -= 6.0f;
        }
        if (this.predict.returntocenter > 0 && (sb_snum & 0x2000) == 0 && (sb_snum & 0x4000) == 0) {
            this.predict.returntocenter = (byte)(this.predict.returntocenter - 1);
            this.predict.horiz += 33.0f - this.predict.horiz / 3.0f;
        }
        if (p.aim_mode != 0) {
            this.predict.horiz += syn.horz / 2.0f;
        } else {
            if (this.predict.horiz > 95.0f && this.predict.horiz < 105.0f) {
                this.predict.horiz = 100.0f;
            }
            if (this.predict.horizoff > -5 && this.predict.horizoff < 5) {
                this.predict.horizoff = 0;
            }
        }
        if (this.predict.hardlanding > 0) {
            this.predict.hardlanding = (byte)(this.predict.hardlanding - 1);
            this.predict.horiz -= (float)(this.predict.hardlanding << 4);
        }
        if (this.predict.horiz > 299.0f) {
            this.predict.horiz = 299.0f;
        } else if (this.predict.horiz < -99.0f) {
            this.predict.horiz = -99.0f;
        }
        if (p.knee_incs > 0) {
            this.predict.horiz -= 48.0f;
            this.predict.returntocenter = (byte)9;
        }
        this.predictFifo[this.gPredictTail & 0xFF].copy(this.predict);
        ++this.gPredictTail;
        Engine.sprite[p.i].cstat = backcstat;
    }

    @Override
    public void CorrectPrediction() {
        if (Mmulti.numplayers < 2) {
            return;
        }
        PLocation pFifo = this.predictFifo[this.gNetFifoTail - 1 & 0xFF];
        PlayerStruct p = Globals.ps[Mmulti.myconnectindex];
        if (pFifo.ang == p.ang && pFifo.horiz == p.horiz && pFifo.x == p.posx && pFifo.y == p.posy && pFifo.z == p.posz && pFifo.lookang == p.look_ang && pFifo.rotscrnang == p.rotscrnang) {
            return;
        }
        this.predict.reset();
        this.predictOld.copy(p.prevView);
        this.gPredictTail = this.gNetFifoTail;
        while (this.gPredictTail < this.gNetFifoHead[Mmulti.myconnectindex]) {
            this.UpdatePrediction(this.gFifoInput[this.gPredictTail & 0xFF][Mmulti.myconnectindex]);
        }
    }

    @Override
    public void CalcChecksum() {
        if ((Mmulti.numplayers >= 2 || Globals.mFakeMultiplayer) && (this.gNetFifoTail & 7) == 7) {
            Arrays.fill(this.gChecksum, 0);
            this.gChecksum[0] = Main.engine.getrand();
            int i = Mmulti.connecthead;
            while (i >= 0) {
                this.gChecksum[1] = (int)((long)this.gChecksum[1] ^ this.Checksum(Globals.ps[i].getBytes(), 1129));
                this.gChecksum[2] = (int)((long)this.gChecksum[2] ^ this.Checksum(Engine.sprite[Globals.ps[i].i].getBytes(), 44));
                i = Mmulti.connectpoint2[i];
            }
            i = 0;
            while (i < this.gChecksum.length) {
                LittleEndian.putInt(this.gCheckFifo[Mmulti.myconnectindex], 16 * (this.gCheckHead[Mmulti.myconnectindex] & 0xFF) + 4 * i, this.gChecksum[i]);
                ++i;
            }
            short s = Mmulti.myconnectindex;
            this.gCheckHead[s] = this.gCheckHead[s] + 1;
        }
        if (this.PlayerSyncRequest != -1) {
            if (Mmulti.myconnectindex != Mmulti.connecthead && this.gNetFifoTail < this.PlayerSyncTrail) {
                return;
            }
            int pnum = this.PlayerSyncRequest;
            Console.Println("Player: " + pnum);
            Console.Println(Globals.ps[pnum].toString());
            Console.Println("Sprite: ");
            Console.Println(Engine.sprite[Globals.ps[pnum].i].toString());
            Console.Println("gNetFifoTail: " + this.gNetFifoTail);
            this.PlayerSyncTrail = -1;
            this.PlayerSyncRequest = -1;
        }
    }

    @Override
    public void NetDisconnect(int nPlayer) {
        super.NetDisconnect(nPlayer);
        this.app.Disconnect();
    }

    public boolean WaitForContentCheck(String filepath, long crc32, int timeout) {
        int i;
        Arrays.fill(this.gContentFound, (byte)-1);
        if (Mmulti.numplayers < 2) {
            return true;
        }
        this.WaitForSend();
        int ptr = 0;
        this.packbuf[ptr++] = 8;
        int len = Math.min(filepath.length(), 246);
        LittleEndian.putInt(this.packbuf, ptr, len);
        System.arraycopy(filepath.getBytes(), 0, this.packbuf, ptr += 4, len);
        LittleEndian.putUInt(this.packbuf, ptr += len, crc32);
        this.sendtoall(this.packbuf, ptr += 4);
        this.gContentFound[Mmulti.myconnectindex] = 1;
        long starttime = System.currentTimeMillis();
        block0: do {
            long time = System.currentTimeMillis() - starttime;
            if (timeout != 0 && time > (long)timeout) {
                Console.Println("Connection timed out!", Console.OSDTEXT_YELLOW);
                return false;
            }
            this.GetPackets();
            i = Mmulti.connecthead;
            while (i >= 0) {
                if (this.gContentFound[i] == -1) continue block0;
                if (Mmulti.myconnectindex != Mmulti.connecthead) {
                    i = -1;
                    continue block0;
                }
                i = Mmulti.connectpoint2[i];
            }
        } while (i >= 0);
        i = Mmulti.connecthead;
        while (i >= 0) {
            if (this.gContentFound[i] != 1) {
                return false;
            }
            i = Mmulti.connectpoint2[i];
        }
        return true;
    }

    public void getnames() {
        Globals.ud.user_name[Mmulti.myconnectindex] = Main.cfg.pName;
        byte[] buf = new byte[256];
        if (Mmulti.numplayers > 1) {
            buf[0] = 6;
            buf[1] = (byte)Mmulti.myconnectindex;
            buf[2] = -109;
            int l = 3;
            char[] name = Strhandler.toCharArray(Main.cfg.pName);
            int i = 0;
            while (i < Main.cfg.pName.length() && name[i] != '\u0000') {
                buf[l++] = (byte)name[i];
                ++i;
            }
            buf[l++] = 0;
            i = 0;
            while (i < 10) {
                Globals.ud.wchoice[Mmulti.myconnectindex][i] = Globals.ud.wchoice[0][i];
                buf[l++] = (byte)Globals.ud.wchoice[0][i];
                ++i;
            }
            buf[l++] = (byte)Globals.ps[Mmulti.myconnectindex].aim_mode;
            buf[l++] = (byte)Globals.ps[Mmulti.myconnectindex].auto_aim;
            this.WaitForSend();
            this.sendtoall(buf, l);
            this.GetPackets();
        }
    }

    public void SendMessage(int sendmessagecommand, char[] buf, int len) {
        if (sendmessagecommand != -1 || Globals.ud.multimode < 3) {
            Globals.tempbuf[0] = 4;
            Globals.tempbuf[2] = 0;
            this.recbuf[0] = '\u0000';
            if (Globals.ud.multimode < 3) {
                sendmessagecommand = 2;
            }
            int pos = Strhandler.buildString(this.recbuf, 0, Globals.ud.user_name[Mmulti.myconnectindex], ": ");
            System.arraycopy(buf, 0, this.recbuf, pos, len);
            this.recbuf[pos += len] = '\u0000';
            int i = 0;
            while (i < this.recbuf.length) {
                Globals.tempbuf[2 + i] = (byte)this.recbuf[i];
                ++i;
            }
            if (sendmessagecommand >= Globals.ud.multimode) {
                Globals.tempbuf[1] = -1;
                this.sendtoall(Globals.tempbuf, pos + 2);
                View.adduserquote(this.recbuf);
                View.quotebotgoal = View.quotebot += 8;
            } else if (sendmessagecommand >= 0) {
                Globals.tempbuf[1] = (byte)sendmessagecommand;
                if (Mmulti.myconnectindex != Mmulti.connecthead) {
                    sendmessagecommand = Mmulti.connecthead;
                }
                Mmulti.sendpacket(sendmessagecommand, Globals.tempbuf, pos + 2);
            }
        }
    }

    @Override
    public void ComputerInput(int i) {
        if (Globals.ud.playerai != 0) {
            Player.computergetinput(i, (Input)this.gFifoInput[this.gNetFifoHead[i] & 0xFF][i]);
        }
    }
}

