/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Duke3D.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.ScreenAdapters.PrecacheAdapter;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Duke3D.Actors;
import ru.m210projects.Duke3D.Globals;
import ru.m210projects.Duke3D.Main;
import ru.m210projects.Duke3D.Premap;

public class PrecacheScreen
extends PrecacheAdapter {
    private Main app;

    public PrecacheScreen(Main app) {
        super(app);
        this.app = app;
        this.addQueue("Preload sounds...", new Runnable(){

            @Override
            public void run() {
                PrecacheScreen.this.precachenecessarysounds();
            }
        });
        this.addQueue("Preload floor and ceiling tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.numsectors) {
                    PrecacheScreen.this.addTile(Engine.sector[i].floorpicnum);
                    PrecacheScreen.this.addTile(Engine.sector[i].ceilingpicnum);
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
                i = 0;
                while (i < Engine.numsectors) {
                    if ((Engine.sector[i].ceilingstat & 1) != 0) {
                        if (Engine.sector[i].ceilingpicnum == 89) {
                            int j = 0;
                            while (j < 5) {
                                PrecacheScreen.this.addTile(Engine.sector[i].ceilingpicnum + j);
                                ++j;
                            }
                        } else {
                            PrecacheScreen.this.addTile(Engine.sector[i].ceilingpicnum);
                        }
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload wall tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.numwalls) {
                    int j;
                    PrecacheScreen.this.addTile(Engine.wall[i].picnum);
                    switch (Engine.wall[i].picnum) {
                        case 336: {
                            j = 0;
                            while (j < 3) {
                                PrecacheScreen.this.addTile(Engine.wall[i].picnum + j);
                                ++j;
                            }
                            break;
                        }
                        case 120: 
                        case 122: {
                            PrecacheScreen.this.addTile(Engine.wall[i].picnum);
                            break;
                        }
                        case 268: 
                        case 269: 
                        case 270: {
                            int k = 268;
                            while (k < 271) {
                                PrecacheScreen.this.addTile(k);
                                ++k;
                            }
                            break;
                        }
                    }
                    if (Engine.wall[i].overpicnum >= 0) {
                        PrecacheScreen.this.addTile(Engine.wall[i].overpicnum);
                        switch (Engine.wall[i].overpicnum) {
                            case 663: {
                                j = 0;
                                while (j < 3) {
                                    PrecacheScreen.this.addTile(663 + j);
                                    ++j;
                                }
                                break;
                            }
                        }
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload sprite tiles...", new Runnable(){

            @Override
            public void run() {
                PrecacheScreen.this.cachegoodsprites();
                int i = 0;
                while (i < Engine.numsectors) {
                    short j = Engine.headspritesect[i];
                    while (j >= 0) {
                        if (Engine.sprite[j].xrepeat != 0 && Engine.sprite[j].yrepeat != 0 && (Engine.sprite[j].cstat & 0x8000) == 0) {
                            PrecacheScreen.this.cachespritenum(j);
                        }
                        j = Engine.nextspritesect[j];
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload other tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.MAXTILES) {
                    if (Engine.waloff[i] == null) {
                        PrecacheScreen.this.engine.loadtile(i);
                    }
                    ++i;
                }
            }
        });
    }

    @Override
    public void draw(String title, int i) {
        if (Globals.kGameCrash) {
            this.app.show();
            return;
        }
        this.engine.rotatesprite(0xA00000, 0x640000, 65536, 0, 3281, 0, 0, 74, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        if (Main.mUserFlag != Main.UserFlag.UserMap || Globals.boardfilename == null) {
            this.app.getFont(2).drawText(160, 90, Strhandler.toCharArray("Entering "), -128, 0, BuildFont.TextAlign.Center, 2, false);
            if (Globals.currentGame.episodes[Globals.ud.volume_number] != null && Globals.currentGame.episodes[Globals.ud.volume_number].gMapInfo[Globals.ud.level_number] != null && Globals.currentGame.episodes[Globals.ud.volume_number].gMapInfo[Globals.ud.level_number].title != null) {
                this.game.getFont(2).drawText(160, 114, Globals.currentGame.episodes[Globals.ud.volume_number].gMapInfo[Globals.ud.level_number].title, -128, 0, BuildFont.TextAlign.Center, 2, false);
            }
        } else if (Globals.boardfilename != null) {
            this.app.getFont(2).drawText(160, 90, Strhandler.toCharArray("Entering usermap"), -128, 0, BuildFont.TextAlign.Center, 2, false);
            this.app.getFont(2).drawText(160, 114, Globals.boardfilename, -128, 0, BuildFont.TextAlign.Center, 2, false);
        }
        this.app.getFont(1).drawText(160, 146, title, -128, 10, BuildFont.TextAlign.Center, 2, false);
    }

    private void precachenecessarysounds() {
        int i = 0;
        while (i < 500) {
            if (Globals.Sound[i].ptr == null) {
                Premap.getsound(i);
            }
            ++i;
        }
    }

    private void cachespritenum(int i) {
        int j;
        if (Globals.ud.monsters_off && Actors.badguy(Engine.sprite[i])) {
            return;
        }
        int maxc = 1;
        switch (Engine.sprite[i].picnum) {
            case 981: {
                this.addTile(950);
                j = 921;
                while (j < 925) {
                    this.addTile(j);
                    j = (short)(j + 1);
                }
                break;
            }
            case 569: {
                this.addTile(615);
                j = 921;
                while (j < 925) {
                    this.addTile(j);
                    j = (short)(j + 1);
                }
                break;
            }
            case 571: {
                this.addTile(573);
                j = 921;
                while (j < 925) {
                    this.addTile(j);
                    j = (short)(j + 1);
                }
                break;
            }
            case 1062: {
                maxc = 2;
                break;
            }
            case 921: {
                maxc = 4;
                break;
            }
            case 1280: {
                maxc = 44;
                break;
            }
            case 1680: 
            case 1681: 
            case 1715: 
            case 1725: 
            case 1741: 
            case 1744: {
                j = 1680;
                while (j < 1752) {
                    this.addTile(j);
                    j = (short)(j + 1);
                }
                j = 1768;
                while (j < 1779) {
                    this.addTile(j);
                    j = (short)(j + 1);
                }
                maxc = 0;
                break;
            }
            case 904: {
                maxc = 5;
                j = 1026;
                while (j < 1030) {
                    this.addTile(j);
                    j = (short)(j + 1);
                }
                break;
            }
            case 4610: 
            case 4611: {
                maxc = 90;
                break;
            }
            case 2630: 
            case 2710: 
            case 2760: {
                maxc = 30;
                break;
            }
            case 1820: 
            case 1821: 
            case 1920: 
            case 1921: {
                maxc = 38;
                break;
            }
            case 1960: {
                maxc = 13;
                break;
            }
            case 2000: 
            case 2045: {
                maxc = 61;
                break;
            }
            case 1550: {
                maxc = 30;
                break;
            }
            case 2120: 
            case 2150: 
            case 2160: 
            case 2165: {
                j = 2201;
                while (j < 2212) {
                    this.addTile(j);
                    j = (short)(j + 1);
                }
                maxc = 80;
                break;
            }
            case 1405: {
                maxc = 0;
                if (Globals.ud.multimode <= 1) break;
                maxc = 5;
                j = 1420;
                while (j < 1526) {
                    this.addTile(j);
                    j = (short)(j + 1);
                }
                break;
            }
            case 100: {
                maxc = 14;
                break;
            }
            case 1880: {
                maxc = 10;
                break;
            }
            case 1079: 
            case 1238: 
            case 1247: {
                maxc = 3;
                break;
            }
            case 621: 
            case 1227: {
                maxc = 5;
            }
        }
        j = Engine.sprite[i].picnum;
        while (j < Engine.sprite[i].picnum + maxc) {
            this.addTile(j);
            j = (short)(j + 1);
        }
    }

    private void cachegoodsprites() {
        int i;
        if (Globals.ud.screen_size >= 2) {
            this.addTile(2462);
            if (Globals.ud.multimode > 1) {
                this.addTile(2465);
                i = 3072;
                while (i < 3135) {
                    this.addTile(i);
                    i = (short)(i + 1);
                }
            }
        }
        this.addTile(502);
        i = 2822;
        while (i < 2916) {
            this.addTile(i);
            i = (short)(i + 1);
        }
        i = 550;
        while (i < 553) {
            this.addTile(i);
            i = (short)(i + 1);
        }
        i = 2940;
        while (i < 3022) {
            this.addTile(i);
            i = (short)(i + 1);
        }
        i = 2270;
        while (i < 2284) {
            this.addTile(i);
            i = (short)(i + 1);
        }
        i = 2310;
        while (i < 2324) {
            this.addTile(i);
            i = (short)(i + 1);
        }
        i = 2324;
        while (i < 2328) {
            this.addTile(i);
            i = (short)(i + 1);
        }
        i = 2524;
        while (i < 2527) {
            this.addTile(i);
            i = (short)(i + 1);
        }
        i = 1890;
        while (i < 1911) {
            this.addTile(i);
            i = (short)(i + 1);
        }
        this.addTile(952);
        i = 2528;
        while (i < 2536) {
            this.addTile(i);
            i = (short)(i + 1);
        }
        this.addTile(550);
        i = 2245;
        while (i < 2270) {
            this.addTile(i);
            i = (short)(i + 1);
        }
        i = 2400;
        while (i < 2419) {
            this.addTile(i);
            i = (short)(i + 1);
        }
        i = 2329;
        while (i < 2333) {
            this.addTile(i);
            i = (short)(i + 1);
        }
    }
}

