/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP;

import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Sounds;
import ru.m210projects.LSP.Sprites;
import ru.m210projects.LSP.Types.PlayerStruct;

public class Enemies {
    public static int[] gEnemyClock = new int[Engine.MAXSPRITES];
    public static short[] gMoveStatus = new short[Engine.MAXSPRITES];
    public static short[] nKills = new short[6];
    public static short[] nTotalKills = new short[6];
    public static int nEnemyKills;
    public static int nEnemyMax;
    private static Object[] attackFrames;
    private static short[] timeCounter;
    private static short[] frameIndex;
    private static Frame[] blueattack;
    private static Callback greencallback;
    private static Frame[] greenattack;
    private static Callback redcallback;
    private static Frame[] redattack;
    private static Callback purpcallback;
    private static Frame[] purpattack;
    private static Callback yellowcallback;
    private static Frame[] yellattack;
    private static int ocount;
    private static BuildPos out;

    static {
        attackFrames = new Object[Engine.MAXSPRITES];
        timeCounter = new short[Engine.MAXSPRITES];
        frameIndex = new short[Engine.MAXSPRITES];
        blueattack = new Frame[]{new Frame(1556, 20, null), new Frame(1557, 12, new Callback(){

            @Override
            public void invoke(int i) {
                SPRITE spr = Engine.sprite[i];
                short target = spr.hitag;
                if (target != -1) {
                    int dx = Globals.gPlayer[target].x - spr.x;
                    int dy = Globals.gPlayer[target].y - spr.y;
                    if (Pragmas.klabs(dx) + Pragmas.klabs(dy) < 1024) {
                        Sprites.changehealth(target, -((Main.engine.krand() & 3) + Globals.nDifficult));
                        Sounds.playsound(31, i);
                    }
                }
            }
        }), new Frame(1558, 12, null)};
        greencallback = new Callback(){

            @Override
            public void invoke(int i) {
                SPRITE nspr = Enemies.buildProjectile(i, Engine.sprite[i].hitag, (Main.engine.krand() & 3) + 2032);
                nspr.z -= 7168;
                nspr.picnum = (short)1840;
                nspr.shade = (byte)-20;
                nspr.xrepeat = (short)32;
                nspr.yrepeat = (short)32;
                nspr.lotag = (short)(-4 - Globals.nDifficult);
                Sounds.playsound(6, i);
            }
        };
        greenattack = new Frame[]{new Frame(1812, 12, null), new Frame(1813, 12, greencallback), new Frame(1814, 12, null)};
        redcallback = new Callback(){

            @Override
            public void invoke(int i) {
                SPRITE nspr = Enemies.buildProjectile(i, Engine.sprite[i].hitag, (Main.engine.krand() & 1) + 2032);
                nspr.z -= 5120;
                nspr.picnum = (short)2096;
                nspr.shade = (byte)-20;
                nspr.lotag = (short)(-8 - Globals.nDifficult);
                Sounds.playsound(8, i);
            }
        };
        redattack = new Frame[]{new Frame(2068, 8, null), new Frame(2069, 8, null), new Frame(2070, 8, null), new Frame(2071, 8, null), new Frame(2072, 8, null), new Frame(2073, 12, redcallback)};
        purpcallback = new Callback(){

            @Override
            public void invoke(int i) {
                SPRITE nspr = Enemies.buildProjectile(i, Engine.sprite[i].hitag, (Main.engine.krand() & 1) + 2040);
                nspr.z -= 5120;
                nspr.picnum = (short)2352;
                nspr.shade = (byte)-20;
                nspr.lotag = (short)(-16 - Globals.nDifficult);
                Sounds.playsound(0, i);
            }
        };
        purpattack = new Frame[]{new Frame(2324, 8, null), new Frame(2325, 8, null), new Frame(2326, 8, null), new Frame(2327, 16, purpcallback)};
        yellowcallback = new Callback(){

            @Override
            public void invoke(int i) {
                SPRITE nspr = Enemies.buildProjectile(i, Engine.sprite[i].hitag, (Main.engine.krand() & 1) + 2040);
                nspr.z -= 5120;
                nspr.picnum = (short)2608;
                nspr.shade = (byte)-25;
                nspr.lotag = (short)(-32 - Globals.nDifficult);
                Sounds.playsound(2, i);
            }
        };
        yellattack = new Frame[]{new Frame(2580, 20, null), new Frame(2581, 12, null), new Frame(2582, 12, yellowcallback), new Frame(2583, 12, null)};
        out = new BuildPos();
    }

    private static void setframes(short i, Frame[] frms) {
        SPRITE spr = Engine.sprite[i];
        spr.extra = spr.picnum;
        Enemies.frameIndex[i] = 0;
        Enemies.attackFrames[i] = frms;
        spr.picnum = frms[0].tile;
        Enemies.timeCounter[i] = frms[0].ticksPerFrame;
    }

    private static boolean frameprocess(Frame[] frms, short spr) {
        short s = spr;
        timeCounter[s] = (short)(timeCounter[s] - 4);
        if (Main.cfg.bOriginal) {
            switch (Engine.sprite[spr].extra) {
                case 1792: {
                    greencallback.invoke(spr);
                    break;
                }
                case 2048: {
                    redcallback.invoke(spr);
                    break;
                }
                case 2304: {
                    purpcallback.invoke(spr);
                    break;
                }
                case 2560: {
                    yellowcallback.invoke(spr);
                }
            }
        }
        if (timeCounter[spr] < 0) {
            short s2 = spr;
            frameIndex[s2] = (short)(frameIndex[s2] + 1);
            if (frameIndex[s2] >= frms.length) {
                Engine.sprite[spr].picnum = Engine.sprite[spr].extra;
                Main.engine.changespritestat(spr, 1);
                Enemies.attackFrames[spr] = null;
                return true;
            }
            Frame frm = frms[frameIndex[spr]];
            short s3 = spr;
            timeCounter[s3] = (short)(timeCounter[s3] + frm.ticksPerFrame);
            if (frm.trigger != null) {
                frm.trigger.invoke(spr);
            }
            Engine.sprite[spr].picnum = frm.tile;
        }
        return false;
    }

    private static SPRITE buildProjectile(int i, int target, int dang) {
        SPRITE spr = Engine.sprite[i];
        short j = Main.engine.insertsprite(spr.sectnum, (short)6);
        if (j == -1) {
            return null;
        }
        SPRITE nspr = Engine.sprite[j];
        nspr.x = spr.x;
        nspr.y = spr.y;
        nspr.z = spr.z;
        nspr.cstat = (short)128;
        nspr.xrepeat = (short)64;
        nspr.yrepeat = (short)64;
        int dx = Globals.gPlayer[target].x - spr.x;
        int dy = Globals.gPlayer[target].y - spr.y;
        nspr.ang = (short)(Main.engine.getangle(dx, dy) + dang & 0x7FF);
        nspr.xvel = (short)(Engine.sintable[nspr.ang + 2560 & 0x7FF] >> 6);
        nspr.yvel = (short)(Engine.sintable[nspr.ang + 2048 & 0x7FF] >> 6);
        nspr.zvel = (short)((Globals.gPlayer[target].z + 8192 - nspr.z << 8) / Main.engine.ksqrt(dx * dx + dy * dy));
        nspr.owner = (short)i;
        nspr.hitag = (short)target;
        return nspr;
    }

    public static void inienemies() {
        Arrays.fill(gMoveStatus, (short)1);
        Arrays.fill(nKills, (short)0);
        Arrays.fill(nTotalKills, (short)0);
        nEnemyKills = 0;
        nEnemyMax = 0;
        Engine.picanm[1556] = 0;
        Engine.picanm[1812] = 0;
        Engine.picanm[2068] = 0;
        Engine.picanm[2324] = 0;
        Engine.picanm[2580] = 0;
        short i = 0;
        while (i < 1024) {
            SPRITE spr = Engine.sprite[i];
            if (spr.statnum < 32) {
                switch (spr.picnum) {
                    case 232: 
                    case 1410: {
                        Main.engine.changespritestat(i, 2);
                        spr.lotag = (short)9999;
                        break;
                    }
                    case 1536: {
                        Main.engine.changespritestat(i, 2);
                        spr.lotag = (short)24;
                        nTotalKills[1] = (short)(nTotalKills[1] + 1);
                        ++nEnemyMax;
                        break;
                    }
                    case 1792: {
                        Main.engine.changespritestat(i, 2);
                        spr.lotag = (short)48;
                        nTotalKills[2] = (short)(nTotalKills[2] + 1);
                        ++nEnemyMax;
                        break;
                    }
                    case 2048: {
                        Main.engine.changespritestat(i, 2);
                        spr.lotag = (short)72;
                        nTotalKills[3] = (short)(nTotalKills[3] + 1);
                        ++nEnemyMax;
                        break;
                    }
                    case 2304: {
                        Main.engine.changespritestat(i, 2);
                        spr.lotag = (short)240;
                        nTotalKills[4] = (short)(nTotalKills[4] + 1);
                        ++nEnemyMax;
                        break;
                    }
                    case 2560: {
                        Main.engine.changespritestat(i, 2);
                        spr.lotag = (short)480;
                        nTotalKills[5] = (short)(nTotalKills[5] + 1);
                        ++nEnemyMax;
                    }
                }
                switch (spr.picnum) {
                    case 50: 
                    case 232: 
                    case 1410: 
                    case 1536: 
                    case 1600: 
                    case 1700: 
                    case 1792: 
                    case 2048: 
                    case 2304: 
                    case 2560: {
                        spr.cstat = (short)(spr.cstat | 0x101);
                    }
                }
                if (Globals.nNextMap == 6) {
                    switch (spr.picnum) {
                        case 249: 
                        case 1116: 
                        case 1126: 
                        case 1136: 
                        case 1146: 
                        case 1156: 
                        case 1166: 
                        case 1179: 
                        case 1192: 
                        case 1203: 
                        case 1214: 
                        case 1225: 
                        case 1259: 
                        case 1328: 
                        case 1335: 
                        case 1341: 
                        case 1345: 
                        case 1354: 
                        case 1358: 
                        case 1364: 
                        case 1369: 
                        case 1374: 
                        case 1840: 
                        case 1844: 
                        case 2096: 
                        case 2352: 
                        case 2356: 
                        case 2608: {
                            Main.engine.deletesprite(i);
                            break;
                        }
                    }
                }
            }
            i = (short)(i + 1);
        }
    }

    public static void enemydie(int i) {
        SPRITE spr = Engine.sprite[i];
        if (spr.statnum == 20) {
            return;
        }
        switch (spr.picnum) {
            case 1536: {
                nKills[1] = (short)(nKills[1] + 1);
                ++nEnemyKills;
                break;
            }
            case 1792: {
                nKills[2] = (short)(nKills[2] + 1);
                ++nEnemyKills;
                break;
            }
            case 2048: {
                nKills[3] = (short)(nKills[3] + 1);
                ++nEnemyKills;
                break;
            }
            case 2304: {
                nKills[4] = (short)(nKills[4] + 1);
                ++nEnemyKills;
                break;
            }
            case 2560: {
                nKills[5] = (short)(nKills[5] + 1);
                ++nEnemyKills;
            }
        }
        short sec = 0;
        while (sec < Engine.numsectors) {
            short j = Engine.headspritesect[sec];
            while (j != -1) {
                switch (Engine.sprite[j].picnum) {
                    case 1536: 
                    case 1792: 
                    case 2048: 
                    case 2304: 
                    case 2560: {
                        SPRITE pspr = Engine.sprite[j];
                        if (!Main.engine.cansee(spr.x, spr.y, spr.z, spr.sectnum, pspr.x, pspr.y, pspr.z - (Engine.tilesizy[pspr.picnum] << 7), pspr.sectnum) || pspr.statnum != 2) break;
                        Main.engine.changespritestat(j, 1);
                    }
                }
                j = Engine.nextspritesect[j];
            }
            sec = (short)(sec + 1);
        }
        spr.picnum = spr.picnum != 2304 && spr.picnum != 2560 ? (short)(spr.picnum + (4 * (Main.engine.krand() & 1) + 28)) : (short)(spr.picnum + 28);
        spr.cstat = 0;
        spr.lotag = (short)240;
        spr.owner = spr.picnum;
        Main.engine.changespritestat((short)i, 20);
    }

    private static int findplayer(int i) {
        int mindist = Integer.MAX_VALUE;
        short target = Mmulti.connecthead;
        short p = Mmulti.connecthead;
        while (p >= 0) {
            int dist = Pragmas.klabs(Engine.sprite[i].x - Globals.gPlayer[p].x) + Pragmas.klabs(Engine.sprite[i].y - Globals.gPlayer[p].y);
            if (dist < mindist) {
                mindist = dist;
                target = p;
            }
            p = Mmulti.connectpoint2[p];
        }
        return target;
    }

    public static void moveenemies() {
        SPRITE spr;
        short nexti;
        boolean canAttack = false;
        int count = 0;
        short i = Engine.headspritestat[21];
        while (i >= 0) {
            nexti = Engine.nextspritestat[i];
            spr = Engine.sprite[i];
            switch (spr.extra) {
                case 1536: 
                case 1792: 
                case 2048: 
                case 2304: 
                case 2560: {
                    if (Enemies.frameprocess((Frame[])attackFrames[i], i)) break;
                    ++count;
                }
            }
            i = nexti;
        }
        i = Engine.headspritestat[1];
        while (i >= 0) {
            nexti = Engine.nextspritestat[i];
            int target = Enemies.findplayer(i);
            int v56 = Main.engine.krand();
            SPRITE spr2 = Engine.sprite[i];
            switch (spr2.picnum) {
                case 232: {
                    if (!Main.cfg.bOriginal && Globals.totalmoves % 4 != 0 || !Main.engine.cansee(Globals.gPlayer[target].x, Globals.gPlayer[target].y, Globals.gPlayer[target].z, Globals.gPlayer[target].sectnum, spr2.x, spr2.y, spr2.z - (Engine.tilesizy[232] << 7), spr2.sectnum) || (Main.engine.krand() & 3) != 0) break;
                    short j = Main.engine.insertsprite(spr2.sectnum, (short)6);
                    Engine.sprite[j].x = spr2.x;
                    Engine.sprite[j].y = spr2.y;
                    Engine.sprite[j].z = spr2.z - 2560;
                    Engine.sprite[j].cstat = (short)128;
                    Engine.sprite[j].picnum = (short)1179;
                    Engine.sprite[j].shade = (byte)-20;
                    Engine.sprite[j].xrepeat = (short)32;
                    Engine.sprite[j].yrepeat = (short)32;
                    Engine.sprite[j].ang = (short)(Main.engine.krand() & 0x7FF);
                    Engine.sprite[j].xvel = (short)(Engine.sintable[Engine.sprite[j].ang + 2560 & 0x7FF] >> 6);
                    Engine.sprite[j].yvel = (short)(Engine.sintable[Engine.sprite[j].ang + 2048 & 0x7FF] >> 6);
                    int dx = Globals.gPlayer[target].x - Engine.sprite[j].y;
                    int dy = Globals.gPlayer[target].y - Engine.sprite[j].x;
                    Engine.sprite[j].zvel = (short)((Globals.gPlayer[target].z + 2048 - Engine.sprite[j].z << 8) / Main.engine.ksqrt(dx * dx + dy * dy));
                    Engine.sprite[j].owner = i;
                    Engine.sprite[j].lotag = (short)-8;
                    break;
                }
                case 1410: {
                    if (!Main.cfg.bOriginal && Globals.totalmoves % 4 != 0 || !Main.engine.cansee(spr2.x, spr2.y, spr2.z - (Engine.tilesizy[spr2.picnum] << 7), spr2.sectnum, Globals.gPlayer[target].x, Globals.gPlayer[target].y, Globals.gPlayer[target].z, Globals.gPlayer[target].sectnum) || (Main.engine.krand() & 7) != 0) break;
                    short j = Main.engine.insertsprite(spr2.sectnum, (short)6);
                    Engine.sprite[j].x = spr2.x;
                    Engine.sprite[j].y = spr2.y;
                    Engine.sprite[j].z = spr2.z - 2560;
                    Engine.sprite[j].cstat = (short)128;
                    Engine.sprite[j].picnum = (short)1322;
                    Engine.sprite[j].shade = (byte)-20;
                    Engine.sprite[j].xrepeat = (short)32;
                    Engine.sprite[j].yrepeat = (short)32;
                    int dx = Globals.gPlayer[target].x - spr2.x;
                    int dy = Globals.gPlayer[target].y - spr2.y;
                    Engine.sprite[j].ang = (short)((Main.engine.krand() & 1) + Main.engine.getangle(dx, dy) + 2040 & 0x7FF);
                    Engine.sprite[j].xvel = (short)(Engine.sintable[Engine.sprite[j].ang + 2560 & 0x7FF] >> 6);
                    Engine.sprite[j].yvel = (short)(Engine.sintable[Engine.sprite[j].ang + 2048 & 0x7FF] >> 6);
                    Engine.sprite[j].zvel = (short)((Globals.gPlayer[target].z + 2048 - Engine.sprite[j].z << 8) / Main.engine.ksqrt(dx * dx + dy * dy));
                    Engine.sprite[j].owner = i;
                    Engine.sprite[j].lotag = (short)-16;
                    Sounds.playsound(0, i);
                    break;
                }
                case 1536: 
                case 1792: 
                case 2048: 
                case 2304: 
                case 2560: {
                    if (!Gameutils.isValidSector(spr2.sectnum)) break;
                    ++count;
                    if (Globals.lockclock - gEnemyClock[i] < 0) {
                        Enemies.gEnemyClock[i] = Globals.lockclock;
                    }
                    Main.game.pInt.setsprinterpolate(i, spr2);
                    if (spr2.z < Engine.sector[spr2.sectnum].floorz) {
                        spr2.z += 1152;
                    }
                    int h = Engine.tilesizy[spr2.picnum] * spr2.yrepeat << 2;
                    int zTop = spr2.z - h;
                    if (spr2.z >= Engine.sector[spr2.sectnum].floorz && zTop < Engine.sector[spr2.sectnum].floorz) {
                        spr2.z = Engine.sector[spr2.sectnum].floorz;
                    }
                    if (Engine.sector[spr2.sectnum].lotag == 4 || Engine.sector[spr2.sectnum].lotag == 5) {
                        spr2.z = Engine.sector[spr2.sectnum].floorz + h / 2;
                    }
                    int dx = Globals.gPlayer[target].x - spr2.x;
                    int dy = Globals.gPlayer[target].y - spr2.y;
                    int dz = Globals.gPlayer[target].z + 8192 - spr2.z;
                    short ang = Main.engine.getangle(dx, dy);
                    int dang = (1024 + ang - spr2.ang & 0x7FF) - 1024;
                    boolean cansee = Main.engine.cansee(Globals.gPlayer[target].x, Globals.gPlayer[target].y, Globals.gPlayer[target].z, Globals.gPlayer[target].sectnum, spr2.x, spr2.y, spr2.z, spr2.sectnum);
                    if (spr2.picnum == 1536) {
                        canAttack = false;
                        if (cansee && Pragmas.klabs(dx) + Pragmas.klabs(dy) < 1024 && Pragmas.klabs(dz) < 8192) {
                            spr2.ang = ang;
                            canAttack = true;
                        }
                    } else {
                        canAttack = cansee;
                    }
                    if (v56 % 10 == 9 && gMoveStatus[i] != 1) {
                        if (gMoveStatus[i] == 2 && Globals.lockclock - gEnemyClock[i] > 180 || gMoveStatus[i] == 0) {
                            Enemies.gMoveStatus[i] = 1;
                            Enemies.gEnemyClock[i] = Globals.lockclock;
                        }
                    } else if (v56 % 10 == 0 && Pragmas.klabs(dang) < 256) {
                        if (Globals.lockclock - gEnemyClock[i] > 60) {
                            if (canAttack && target != -1 && Globals.gPlayer[target].nHealth > 0) {
                                spr2.hitag = (short)target;
                                switch (spr2.picnum) {
                                    case 1792: {
                                        Enemies.setframes(i, greenattack);
                                        break;
                                    }
                                    case 2048: {
                                        Enemies.setframes(i, redattack);
                                        break;
                                    }
                                    case 2304: {
                                        Enemies.setframes(i, purpattack);
                                        break;
                                    }
                                    case 2560: {
                                        Enemies.setframes(i, yellattack);
                                        break;
                                    }
                                    case 1536: {
                                        Enemies.setframes(i, blueattack);
                                    }
                                }
                                Main.engine.changespritestat(i, 21);
                                Enemies.gMoveStatus[i] = 0;
                                break;
                            }
                            Enemies.gEnemyClock[i] = Globals.lockclock;
                        }
                    } else if (Globals.lockclock - gEnemyClock[i] > 120) {
                        Engine.sprite[i].ang = ang;
                        int v30 = (Main.engine.krand() & 0x100) - 128;
                        Engine.sprite[i].ang = (short)(v30 + Engine.sprite[i].ang & 0x7FF);
                        Enemies.gEnemyClock[i] = Globals.lockclock;
                    }
                    if (gMoveStatus[i] == 0) break;
                    Enemies.out.x = Engine.sintable[spr2.ang + 512 & 0x7FF] >> 9;
                    Enemies.out.y = Engine.sintable[spr2.ang & 0x7FF] >> 9;
                    if (Pragmas.klabs(dang) < 256) {
                        out = Enemies.sub_16849(target, i, Enemies.out.x, Enemies.out.y);
                    }
                    short sect = spr2.sectnum;
                    short move = Main.engine.movesprite(i, Enemies.out.x, Enemies.out.y, 0, spr2.clipdist << 2, 1024, 1024, 65537, 4);
                    Main.engine.pushmove(spr2.x, spr2.y, spr2.z - h / 2, sect, spr2.clipdist << 2, 1024, 1024, 65537);
                    spr2.x = Engine.pushmove_x;
                    spr2.y = Engine.pushmove_y;
                    spr2.z = Engine.pushmove_z + h / 2;
                    if (sect != Engine.pushmove_sectnum) {
                        Main.engine.changespritesect(i, Engine.pushmove_sectnum);
                    }
                    if (move == 0) break;
                    if (spr2.picnum == 1536) {
                        if ((Main.engine.krand() & 3) != 0) break;
                        Engine.sprite[i].ang = Main.engine.getangle(dx, dy);
                        break;
                    }
                    spr2.ang = (spr2.ang + 2048 - ang & 0x7FF) >= 1024 ? (short)(spr2.ang + 8) : (short)(spr2.ang + 2048 - 8);
                    spr2.ang = (short)(spr2.ang & 0x7FF);
                }
            }
            i = nexti;
        }
        if (count < 1 && ocount != count) {
            Globals.nMusicClock = Globals.lockclock;
        }
        if (count < 1 && Globals.maps[Globals.mapnum].music - 1 != Sounds.currSong) {
            if (Globals.lockclock - Globals.nMusicClock > 780) {
                Sounds.startmusic(Globals.maps[Globals.mapnum].music - 1);
            }
        } else if (count > 1 && Sounds.currSong != 7) {
            Sounds.startmusic(7);
        }
        ocount = count;
        i = Engine.headspritestat[20];
        while (i >= 0) {
            nexti = Engine.nextspritestat[i];
            spr = Engine.sprite[i];
            spr.lotag = (short)(spr.lotag - 4);
            if (spr.lotag < 210 && spr.lotag > 175) {
                spr.picnum = (short)(spr.owner + 1);
            } else if (spr.lotag < 155 && spr.lotag > 120) {
                spr.picnum = (short)(spr.owner + 2);
            } else if (spr.lotag < 75 && spr.lotag > 45) {
                spr.picnum = (short)(spr.owner + 3);
            } else if (spr.lotag < 0) {
                spr.picnum = (short)(spr.owner + 8);
                Main.engine.changespritestat(i, 0);
            }
            i = nexti;
        }
        i = Engine.headspritestat[2];
        while (i >= 0) {
            nexti = Engine.nextspritestat[i];
            short p = Mmulti.connecthead;
            while (p >= 0) {
                if (Enemies.isvisible(i, p)) {
                    Main.engine.changespritestat(i, 1);
                    switch (Engine.sprite[i].picnum) {
                        case 1536: {
                            Sounds.playsound(28, i);
                            break;
                        }
                        case 1792: {
                            Sounds.playsound(34, i);
                            break;
                        }
                        case 2048: {
                            Sounds.playsound(53, i);
                            break;
                        }
                        case 2304: {
                            Sounds.playsound(52, i);
                            break;
                        }
                        case 2560: {
                            Sounds.playsound(63, i);
                        }
                    }
                }
                p = Mmulti.connectpoint2[p];
            }
            i = nexti;
        }
    }

    public static boolean isvisible(int i, int target) {
        PlayerStruct plr = Globals.gPlayer[target];
        SPRITE spr = Engine.sprite[i];
        short sin = Engine.sintable[spr.ang & 0x7FF];
        short cos = Engine.sintable[spr.ang + 512 & 0x7FF];
        if (plr.sectnum >= 0 && cos * (plr.x - spr.x) + sin * (plr.y - spr.y) >= 0) {
            return Main.engine.cansee(plr.x, plr.y, plr.z, plr.sectnum, spr.x, spr.y, spr.z - (Engine.tilesizy[spr.picnum] << 7), spr.sectnum);
        }
        return false;
    }

    private static BuildPos sub_16849(int nTarget, short nSprite, int xvel, int yvel) {
        int vel;
        boolean v19 = false;
        boolean v18 = false;
        int dx = Globals.gPlayer[nTarget].x - Engine.sprite[nSprite].x;
        int dy = Globals.gPlayer[nTarget].y - Engine.sprite[nSprite].y;
        Enemies.out.x = xvel;
        Enemies.out.y = yvel;
        if (xvel < 0 && dx - xvel < -350 || xvel > 0 && dx - xvel > 350) {
            v19 = true;
        }
        if (yvel < 0 && dy - yvel < -350 || yvel > 0 && dy - yvel > 350) {
            v18 = true;
        }
        if (!v19) {
            vel = dx < 0 ? dx + 350 : dx - 350;
            Enemies.out.x = Pragmas.klabs(vel) == vel == (Pragmas.klabs(xvel) == xvel) ? vel : 0;
        }
        if (!v18) {
            vel = dy < 0 ? dy + 350 : dy - 350;
            Enemies.out.y = Pragmas.klabs(vel) == vel == (Pragmas.klabs(yvel) == yvel) ? vel : 0;
        }
        return out;
    }

    private static interface Callback {
        public void invoke(int var1);
    }

    private static class Frame {
        public short tile;
        public Callback trigger;
        public short ticksPerFrame;

        public Frame(int tile, int ticksPerFrame, Callback trigger) {
            this.tile = (short)tile;
            this.ticksPerFrame = (short)ticksPerFrame;
            this.trigger = trigger;
        }
    }
}

