/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Factory;

import com.badlogic.gdx.Screen;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.GameAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Types.BuildPos;
import ru.m210projects.Build.Types.InvalidVersionException;
import ru.m210projects.Build.Types.Palette;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Build.Types.SmallTextFont;
import ru.m210projects.Build.Types.TextFont;
import ru.m210projects.LSP.Fonts.StandartFont;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Types.SECTORV4;
import ru.m210projects.LSP.Types.WALLV4;

public class LSPEngine
extends BuildEngine {
    public static final String sIntroTiles = "L0ART000.DAT";
    public static final String sGameTiles = "L1ART000.DAT";

    public LSPEngine(BuildGame game) throws Exception {
        super(game, 4);
        this.tilesPath = sIntroTiles;
        this.fpscol = 4;
    }

    @Override
    public int setrendermode(Renderer render) {
        if (this.render != null && this.render != render && render.getType() != Renderer.RenderType.Software) {
            ((StandartFont)Main.game.getFont(1)).reinit();
            final Screen screen = Main.game.getScreen();
            if (screen instanceof GameAdapter) {
                Main.gPrecacheScreen.init(true, new Runnable(){

                    @Override
                    public void run() {
                        Main.game.changeScreen(screen);
                        if (Main.game.isCurrentScreen(Main.gGameScreen)) {
                            Main.game.pNet.ready2send = true;
                        }
                    }
                });
                Main.game.changeScreen(Main.gPrecacheScreen);
            }
        }
        return super.setrendermode(render);
    }

    public void setTilesPath(int mapnum) {
        String newPath = sIntroTiles;
        if (mapnum != 0) {
            newPath = sGameTiles;
        }
        if (newPath.equals(this.tilesPath)) {
            return;
        }
        int tile = 770;
        byte[] data = null;
        short sizx = 0;
        short sizy = 0;
        if (newPath.equals(sGameTiles) && Main.engine.loadtile(tile) != null) {
            sizx = tilesizx[tile];
            sizy = tilesizy[tile];
            data = new byte[sizx * sizy];
            System.arraycopy(waloff[tile], 0, data, 0, data.length);
        }
        int kMaxTiles = MAXTILES - USERTILES;
        Arrays.fill(tilesizx, 0, kMaxTiles, (short)0);
        Arrays.fill(tilesizy, 0, kMaxTiles, (short)0);
        Arrays.fill(picanm, 0, kMaxTiles, 0);
        Arrays.fill((Object[])waloff, 0, kMaxTiles, null);
        this.tilesPath = newPath;
        Main.engine.loadpics();
        if (data != null) {
            LSPEngine.waloff[tile] = data;
            LSPEngine.tilesizx[tile] = sizx;
            LSPEngine.tilesizy[tile] = sizy;
        }
        if (newPath.equals(sGameTiles)) {
            Main.game.setDefs(new DefScript(Main.game.baseDef, null));
        } else {
            Main.game.setDefs(Main.game.baseDef);
        }
    }

    @Override
    public byte getclosestcol(byte[] palette, int r, int g, int b) {
        int match = 0;
        int matchDist = Integer.MAX_VALUE;
        int i = 0;
        while (i < 256) {
            int db;
            int dr;
            int dist = 0;
            int dg = (palette[3 * i + 1] & 0xFF) - g;
            if ((dist += 1 * dg * dg) < matchDist && (dist += 1 * (dr = (palette[3 * i] & 0xFF) - r) * dr) < matchDist && (dist += 1 * (db = (palette[3 * i + 2] & 0xFF) - b) * db) < matchDist) {
                matchDist = dist;
                match = i;
                if (dist == 0) break;
            }
            ++i;
        }
        return (byte)match;
    }

    public BuildPos loadboard(Resource fil) throws InvalidVersionException {
        BuildPos pos = new BuildPos();
        this.mapversion = fil.readInt();
        if (this.mapversion != 4) {
            fil.close();
            throw new InvalidVersionException(String.valueOf(fil.getFullName()) + ": invalid map version( v" + this.mapversion + " )!");
        }
        this.initspritelists();
        Arrays.fill(show2dsector, (byte)0);
        Arrays.fill(show2dsprite, (byte)0);
        Arrays.fill(show2dwall, (byte)0);
        pos.x = fil.readInt();
        pos.y = fil.readInt();
        pos.z = fil.readInt();
        pos.ang = fil.readShort();
        pos.sectnum = fil.readShort();
        numsectors = fil.readShort();
        numwalls = fil.readShort();
        numsprites = fil.readShort();
        int sectorid = 0;
        while (sectorid < numsectors) {
            LSPEngine.sector[sectorid] = new SECTORV4(fil);
            ++sectorid;
        }
        int wallid = 0;
        while (wallid < numwalls) {
            LSPEngine.wall[wallid] = new WALLV4(fil);
            ++wallid;
        }
        int sizeof = 40;
        byte[] sprites = new byte[sizeof * numsprites];
        fil.read(sprites);
        ByteBuffer bb = ByteBuffer.wrap(sprites).order(ByteOrder.LITTLE_ENDIAN);
        int spriteid = 0;
        while (spriteid < numsprites) {
            SPRITE spr = sprite[spriteid];
            spr.x = bb.getInt();
            spr.y = bb.getInt();
            spr.z = bb.getInt();
            spr.cstat = bb.get();
            spr.shade = bb.get();
            spr.xrepeat = (short)(bb.get() & 0xFF);
            spr.yrepeat = (short)(bb.get() & 0xFF);
            spr.picnum = bb.getShort();
            spr.ang = bb.getShort();
            spr.xvel = bb.getShort();
            spr.yvel = bb.getShort();
            spr.zvel = bb.getShort();
            spr.owner = bb.getShort();
            spr.sectnum = bb.getShort();
            spr.statnum = bb.getShort();
            spr.lotag = bb.getShort();
            spr.hitag = bb.getShort();
            bb.getInt();
            spr.extra = (short)-1;
            spr.clipdist = 32;
            this.insertsprite(spr.sectnum, spr.statnum);
            ++spriteid;
        }
        pos.sectnum = this.updatesector(pos.x, pos.y, pos.sectnum);
        fil.close();
        if (this.inside(pos.x, pos.y, pos.sectnum) == -1) {
            throw new RuntimeException("Player should be in a sector!");
        }
        return pos;
    }

    public short movesprite(short spritenum, int dx, int dy, int dz, int clipdist, int ceildist, int flordist, int cliptype, int vel) {
        SPRITE spr = sprite[spritenum];
        Main.game.pInt.setsprinterpolate(spritenum, spr);
        int zoffs = (spr.cstat & 0x80) == 0 ? -(tilesizy[spr.picnum] * spr.yrepeat << 1) : 0;
        short dasectnum = spr.sectnum;
        int daz = spr.z + zoffs;
        short retval = (short)this.clipmove(spr.x, spr.y, daz, dasectnum, vel * dx << 11, vel * dy << 11, clipdist, ceildist, flordist, cliptype);
        if (clipmove_sectnum != -1) {
            spr.x = clipmove_x;
            spr.y = clipmove_y;
            daz = clipmove_z;
            dasectnum = clipmove_sectnum;
        }
        if (dasectnum != spr.sectnum && dasectnum >= 0) {
            Main.engine.changespritesect(spritenum, dasectnum);
        }
        short oldcstat = spr.cstat;
        spr.cstat = (short)(spr.cstat & 0xFFFFFFFE);
        Main.engine.getzrange(spr.x, spr.y, spr.z - 1, spr.sectnum, clipdist, cliptype);
        spr.cstat = oldcstat;
        daz = spr.z + zoffs + (vel * dz >> 3);
        if (daz <= zr_ceilz || daz > zr_florz) {
            if (retval != 0) {
                return retval;
            }
            return (short)(0x4000 | dasectnum);
        }
        spr.z = daz - zoffs;
        return retval;
    }

    @Override
    public BuildPos loadboard(String filename) throws InvalidVersionException, FileNotFoundException, RuntimeException {
        Resource fil = BuildGdx.cache.open(filename, 0);
        if (fil == null) {
            this.mapversion = 4;
            throw new FileNotFoundException("Map " + filename + " not found!");
        }
        BuildPos pos = this.loadboard(fil);
        if (pos != null) {
            return pos;
        }
        return super.loadboard(filename);
    }

    @Override
    public void loadpalette() throws Exception {
        if (paletteloaded != 0) {
            return;
        }
        palette = new byte[768];
        curpalette = new Palette();
        palookup = new byte[256][];
        Console.Println("Loading palettes");
        Resource fil = BuildGdx.cache.open("palette.dat", 0);
        if (fil == null) {
            throw new Exception("Failed to load \"palette.dat\"!");
        }
        numshades = (short)(fil.size() - 768 >> 7);
        if ((numshades & 1) <= 0) {
            numshades = (short)(numshades >> 1);
        } else {
            numshades = (short)(numshades - 255 >> 1);
            if (transluc == null) {
                transluc = new byte[65536];
            }
        }
        fil.read(palette);
        globalpal = 0;
        Console.Println("Loading gamma correcion tables");
        if (palookup[globalpal] == null) {
            LSPEngine.palookup[LSPEngine.globalpal] = new byte[numshades << 8];
        }
        fil.read(palookup[globalpal], 0, numshades << 8);
        LSPEngine.palookup[251] = new byte[numshades << 8];
        int i = 0;
        while (i < 256) {
            LSPEngine.palookup[251][i] = (byte)i;
            ++i;
        }
        if (transluc != null) {
            Console.Println("Loading translucency table");
            byte[] tmp = new byte[256];
            int i2 = 0;
            while (i2 < 255) {
                fil.read(tmp, 0, 255 - i2);
                System.arraycopy(tmp, 0, transluc, (i2 << 8) + i2 + 1, 255 - i2);
                int j = i2 + 1;
                while (j < 256) {
                    LSPEngine.transluc[(j << 8) + i2] = transluc[(i2 << 8) + j];
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 256) {
                LSPEngine.transluc[(i2 << 8) + i2] = (byte)i2;
                ++i2;
            }
        }
        fil.close();
        this.initfastcolorlookup(30, 59, 11);
        paletteloaded = 1;
        byte[] remapbuf = new byte[256];
        remapbuf[58] = 96;
        remapbuf[57] = 96;
        remapbuf[56] = 96;
        this.makepalookup(96, remapbuf, 0, 0, 0, 1);
        remapbuf[58] = -29;
        remapbuf[57] = -29;
        remapbuf[56] = -29;
        this.makepalookup(228, remapbuf, 0, 0, 0, 1);
        remapbuf[58] = 17;
        remapbuf[57] = 17;
        remapbuf[56] = 17;
        remapbuf[227] = 17;
        remapbuf[163] = -82;
        remapbuf[0] = 28;
        this.makepalookup(70, remapbuf, 0, 0, 0, 1);
    }

    @Override
    public void loadtables() throws Exception {
        if (tablesloaded == 0) {
            this.initksqrt();
            sintable = new short[2048];
            textfont = new byte[2048];
            smalltextfont = new byte[2048];
            radarang = new short[640];
            Resource res = BuildGdx.cache.open("tables.dat", 0);
            if (res == null) {
                throw new Exception("ERROR: Failed to load TABLES.DAT!");
            }
            byte[] buf = new byte[4096];
            res.read(buf);
            ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(sintable);
            res.seek(4096L, Resource.Whence.Current);
            buf = new byte[640];
            res.read(buf);
            ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(radarang, 0, 320);
            LSPEngine.radarang[320] = 16384;
            res.read(textfont);
            res.read(smalltextfont);
            pTextfont = new TextFont();
            pSmallTextfont = new SmallTextFont();
            this.calcbritable();
            res.close();
            tablesloaded = 1;
        }
    }

    @Override
    public short getangle(int xvect, int yvect) {
        if ((xvect | yvect) == 0) {
            return 0;
        }
        if (xvect == 0) {
            return (short)(512 + ((yvect < 0 ? 1 : 0) << 10));
        }
        if (yvect == 0) {
            return (short)((xvect < 0 ? 1 : 0) << 10);
        }
        if (xvect == yvect) {
            return (short)(256 + ((xvect < 0 ? 1 : 0) << 10));
        }
        if (xvect == -yvect) {
            return (short)(768 + ((xvect > 0 ? 1 : 0) << 10));
        }
        if (Pragmas.klabs(xvect) > Pragmas.klabs(yvect)) {
            return (short)(radarang[160 + Pragmas.scale(160L, yvect, xvect)] + ((xvect < 0 ? 1 : 0) << 10) & 0x7FF);
        }
        return (short)(radarang[160 - Pragmas.scale(160L, xvect, yvect)] + 512 + ((yvect < 0 ? 1 : 0) << 10) & 0x7FF);
    }
}

