/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.LSP.Screens;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Compat;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.FileResource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.LSP.Config;
import ru.m210projects.LSP.Factory.LSPMenuHandler;
import ru.m210projects.LSP.Globals;
import ru.m210projects.LSP.LoadSave;
import ru.m210projects.LSP.Main;
import ru.m210projects.LSP.Screens.GameScreen;
import ru.m210projects.LSP.Types.DemoFile;

public class DemoScreen
extends GameScreen {
    public static String firstdemofile;
    public int nDemonum = -1;
    public List<String> demofiles = new ArrayList<String>();
    public DemoFile demfile;

    public DemoScreen(Main game) {
        super(game);
    }

    @Override
    public void show() {
        LoadSave.lastload = null;
    }

    public boolean showDemo(String name, String ini) {
        this.demfile = null;
        try {
            this.demfile = new DemoFile(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.demfile == null || this.demfile.reccnt == 0) {
            Console.Println("Can't play the demo file: " + name, Console.OSDTEXT_RED);
            return false;
        }
        if (Mmulti.numplayers > 1) {
            this.game.pNet.NetDisconnect(Mmulti.myconnectindex);
        }
        Globals.nDifficult = (short)this.demfile.skill;
        Globals.recstat = 2;
        Main.gDemoScreen.newgame(this.demfile.map);
        Console.Println("Playing demo " + name);
        return true;
    }

    @Override
    protected void startboard(final Runnable startboard) {
        Main.gPrecacheScreen.init(false, new Runnable(){

            @Override
            public void run() {
                startboard.run();
                DemoScreen.this.pNet.ResetTimers();
                Globals.lockclock = 0;
                ((DemoScreen)DemoScreen.this).pNet.ready2send = false;
            }
        });
        this.game.changeScreen(Main.gPrecacheScreen);
    }

    @Override
    public void render(float delta) {
        this.KeyHandler();
        if (Mmulti.numplayers > 1) {
            this.pNet.GetPackets();
        }
        this.DemoRender();
        float smoothratio = 65536.0f;
        if (!this.game.gPaused && ((smoothratio = (float)this.pEngine.getsmoothratio()) < 0.0f || smoothratio > 65536.0f)) {
            smoothratio = Gameutils.BClipRange(smoothratio, 0.0f, 65536.0f);
        }
        this.game.pInt.dointerpolations(smoothratio);
        this.DrawWorld(smoothratio);
        this.DrawHud(smoothratio);
        this.game.pInt.restoreinterpolations();
        if (this.pMenu.gShowMenu) {
            this.pMenu.mDrawMenu();
        }
        this.PostFrame(this.pNet);
        if (this.pCfg.gShowFPS) {
            this.pEngine.printfps(this.pCfg.gFpsScale);
        }
        this.pEngine.sampletimer();
        this.pEngine.nextpage();
    }

    @Override
    public void KeyHandler() {
        this.pEngine.handleevents();
        LSPMenuHandler menu = this.game.menu;
        if (menu.gShowMenu) {
            Main.engine.handleevents();
            menu.mKeyHandler(this.game.pInput, BuildGdx.graphics.getDeltaTime());
            return;
        }
        if (Console.IsShown()) {
            return;
        }
        BuildControls input = this.game.pInput;
        if (input.ctrlGetInputKey(BuildConfig.GameKeys.Menu_Toggle, true)) {
            menu.mOpen(menu.mMenus[0], -1);
        }
        if (input.ctrlGetInputKey(Config.LSPKeys.Show_Loadmenu, true)) {
            if (this.game.nNetMode == BuildGame.NetMode.Single) {
                menu.mOpen(menu.mMenus[3], -1);
            }
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Quit, true)) {
            menu.mOpen(menu.mMenus[6], -1);
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Show_Options, true)) {
            menu.mOpen(menu.mMenus[10], -1);
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Show_Sounds, true)) {
            menu.mOpen(menu.mMenus[8], -1);
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Gamma, true)) {
            menu.mOpen(menu.mMenus[11], -1);
        } else if (input.ctrlGetInputKey(Config.LSPKeys.Make_Screenshot, true)) {
            this.makeScreenshot();
        }
    }

    private void DemoRender() {
        this.pNet.ready2send = false;
        if (!this.game.isCurrentScreen(this)) {
            return;
        }
        if (!this.game.gPaused && this.demfile != null) {
            while (Engine.totalclock >= Globals.lockclock + 4) {
                short j = Mmulti.connecthead;
                while (j >= 0) {
                    this.pNet.gFifoInput[this.pNet.gNetFifoHead[j] & 0xFF][j].Copy(this.demfile.recsync[this.demfile.rcnt][j]);
                    short s = j;
                    this.pNet.gNetFifoHead[s] = this.pNet.gNetFifoHead[s] + 1;
                    --this.demfile.reccnt;
                    j = Mmulti.connectpoint2[j];
                }
                if (this.demfile.reccnt <= 0) {
                    if (!this.showDemo()) {
                        this.game.changeScreen(Main.gMenuScreen);
                    }
                    return;
                }
                ++this.demfile.rcnt;
                Main.engine.updatesmoothticks();
                this.game.pInt.clearinterpolations();
                this.ProcessFrame(this.pNet);
            }
        } else {
            Globals.lockclock = Engine.totalclock;
        }
    }

    public boolean showDemo() {
        this.nDemonum = this.nDemonum < this.demofiles.size() - 1 ? ++this.nDemonum : 0;
        if (this.demofiles != null && this.demofiles.size() > 0) {
            return this.showDemo(this.demofiles.get(this.nDemonum), null);
        }
        return false;
    }

    public void demoscan() {
        byte[] buf = new byte[4];
        FileResource fil = null;
        for (FileEntry file : BuildGdx.compat.getDirectory(Compat.Path.Game).getFiles().values()) {
            if (!file.getExtension().equals("dmo")) continue;
            String name = file.getFile().getName();
            fil = BuildGdx.compat.open(file);
            if (fil == null) continue;
            fil.read(buf, 0, 4);
            fil.read(buf, 0, 1);
            int version = buf[0] & 0xFF;
            if (version == 100) {
                this.demofiles.add(name);
            }
            fil.close();
        }
        if (this.demofiles.size() != 0) {
            Collections.sort(this.demofiles);
        }
        Console.Println("There are " + this.demofiles.size() + " demo(s) in the loop", Console.OSDTEXT_GOLD);
    }
}

