/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Launcher.desktop.GameEntries;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Launcher.desktop.CheckFiles;
import ru.m210projects.Launcher.desktop.GameEntries.GameEntry;
import ru.m210projects.Launcher.desktop.GameEntries.ResFile;
import ru.m210projects.Launcher.desktop.Main;
import ru.m210projects.Tekwar.Config;

public abstract class TekwarEntry
extends GameEntry {
    public boolean isDemo = false;

    public TekwarEntry() {
        super("TekWarGDX", Main.appversion);
    }

    @Override
    public URL getLogo() {
        return this.getClass().getResource("/Headers/headertw.png");
    }

    @Override
    public URL getIcon16() {
        return this.getClass().getResource("/Games/Tekwar/tekwar16.png");
    }

    @Override
    public String[] getIcons() {
        String[] icons = new String[]{"Games/Tekwar/tekwar16.png", "Games/Tekwar/tekwar32.png", "Games/Tekwar/tekwar128.png"};
        return icons;
    }

    @Override
    public String getResourceName() {
        return "TekWar";
    }

    @Override
    public ResFile[] getResourceFiles() {
        ResFile[] resources = new ResFile[]{new ResFile("smkmm.smk"), new ResFile("tiles000.art"), new ResFile("tables.dat"), new ResFile("palette.dat"), new ResFile("songs"), new ResFile("sounds")};
        return resources;
    }

    public ResFile[] getDemoResource() {
        ResFile[] resources = new ResFile[]{new ResFile("city.map"), new ResFile("tiles000.art"), new ResFile("tables.dat"), new ResFile("palette.dat"), new ResFile("songs"), new ResFile("sounds")};
        return resources;
    }

    @Override
    public CheckFiles checkResources(String path, boolean errorMessage) {
        File directory = new File(path);
        File[] fList = directory.listFiles();
        if (fList == null) {
            return new CheckFiles(false, null);
        }
        HashMap<String, File> filesMap = new HashMap<String, File>();
        File[] fileArray = fList;
        int n = fList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            filesMap.put(Strhandler.toLowerCase(file.getName()), file);
            ++n2;
        }
        ResFile[] resources = this.getResourceFiles();
        String missingFiles = "<html>";
        this.isDemo = false;
        boolean found = true;
        int i = 0;
        while (i < resources.length) {
            if (filesMap.get(resources[i].name) == null) {
                found = false;
                if (errorMessage) {
                    Console.Println(String.valueOf(this.appname) + " error: " + resources[i].name + " is missing!");
                }
                missingFiles = String.valueOf(missingFiles) + resources[i].name.toUpperCase() + " is missing<br>";
            }
            ++i;
        }
        if (found) {
            return new CheckFiles(true, null);
        }
        if (errorMessage) {
            Console.Println(String.valueOf(this.appname) + ": trying to find demo version");
        }
        found = true;
        this.isDemo = true;
        resources = this.getDemoResource();
        i = 0;
        while (i < resources.length) {
            if (resources[i].name.equals("SOUNDS") && ((File)filesMap.get(resources[i].name)).length() != 0x20A000L) {
                found = false;
                if (!errorMessage) break;
                Console.Println(String.valueOf(this.appname) + " demo error: " + resources[i].name + " is missing!");
                break;
            }
            if (filesMap.get(resources[i].name) == null) {
                found = false;
                if (!errorMessage) break;
                Console.Println(String.valueOf(this.appname) + " demo error: " + resources[i].name + " is missing!");
                break;
            }
            ++i;
        }
        if (found) {
            return new CheckFiles(true, null);
        }
        return new CheckFiles(false, String.valueOf(missingFiles) + "</html>");
    }

    @Override
    public BuildConfig buildConfig(String path) {
        this.currentConfig = new Config(path, String.valueOf(this.appname) + ".ini");
        return this.currentConfig;
    }

    @Override
    public BuildGame getGame(String[] args) {
        if (this.isDemo) {
            Console.Println("Demo version detected");
        }
        return new ru.m210projects.Tekwar.Main(this.getConfig(), this.appname, this.sversion, true, this.isDemo);
    }
}

