/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Factory;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.CommonMenus.MenuRendererSettings;
import ru.m210projects.Build.Pattern.CommonMenus.MenuVideoMode;
import ru.m210projects.Build.Pattern.MenuItems.BuildMenu;
import ru.m210projects.Build.Pattern.MenuItems.MenuButton;
import ru.m210projects.Build.Pattern.MenuItems.MenuConteiner;
import ru.m210projects.Build.Pattern.MenuItems.MenuFileBrowser;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuItem;
import ru.m210projects.Build.Pattern.MenuItems.MenuJoyList;
import ru.m210projects.Build.Pattern.MenuItems.MenuKeyboardList;
import ru.m210projects.Build.Pattern.MenuItems.MenuList;
import ru.m210projects.Build.Pattern.MenuItems.MenuResolutionList;
import ru.m210projects.Build.Pattern.MenuItems.MenuScroller;
import ru.m210projects.Build.Pattern.MenuItems.MenuSlider;
import ru.m210projects.Build.Pattern.MenuItems.MenuVariants;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Menus.MenuInterfaceSet;
import ru.m210projects.Powerslave.Screens.MenuScreen;
import ru.m210projects.Powerslave.Sound;

public class PSMenuHandler
extends MenuHandler {
    public static final int MAIN = 0;
    public static final int GAME = 1;
    public static final int NEWGAME = 2;
    public static final int LOAD = 3;
    public static final int SAVE = 4;
    public static final int OPTIONS = 5;
    public static final int AUDIO = 6;
    public static final int COLORCORR = 7;
    public static final int QUIT = 8;
    public static final int QUITTITLE = 9;
    public static final int ENDGAME = 10;
    public static final int ADDON = 11;
    public static final int CORRUPTLOAD = 12;
    public BuildMenu[] mMenus = new BuildMenu[18];
    private Engine engine;
    private BuildGame app;
    private int oldValue;
    private long soundTime;

    public PSMenuHandler(BuildGame app) {
        this.engine = app.pEngine;
        this.app = app;
    }

    @Override
    public int getShade(MenuItem item) {
        int shade = 32;
        if (item != null && item.isFocused()) {
            shade = 32 - (Engine.totalclock & 0x3F);
        }
        return shade;
    }

    @Override
    public int getPal(BuildFont font, MenuItem item) {
        if (item != null) {
            if (!item.isEnabled()) {
                return 20;
            }
            return item.pal;
        }
        return 0;
    }

    @Override
    public void mDrawMenu() {
        if (!(this.app.getScreen() instanceof MenuScreen || this.app.pMenu.getCurrentMenu() instanceof MenuRendererSettings || this.app.pMenu.getCurrentMenu() instanceof MenuInterfaceSet)) {
            int tile = Globals.BACKGROUND;
            float kv = (float)Engine.tilesizx[tile] / (float)Engine.tilesizy[tile];
            float kt = (float)Engine.xdim / (float)Engine.ydim;
            float scale = kv >= kt ? (float)(Engine.ydim + 1) / (float)Engine.tilesizy[tile] : (float)(Engine.xdim + 1) / (float)Engine.tilesizx[tile];
            this.engine.rotatesprite(0, 0, (int)(scale * 65536.0f), 0, tile, 127, 0, 25, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        }
        super.mDrawMenu();
    }

    @Override
    public void mDrawMouse(int x, int y) {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(65536L, Engine.ydim, 200L);
        int czoom = Pragmas.mulscale(32768L, Pragmas.mulscale(zoom, this.app.pCfg.gMouseCursorSize, 16), 16);
        int xoffset = 0;
        int yoffset = 0;
        int ang = 0;
        this.engine.rotatesprite(x + xoffset << 16, y + yoffset << 16, czoom, ang, 9217, 0, 0, 8, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
    }

    @Override
    public void mDrawBackButton() {
        if (!this.app.pCfg.menuMouse) {
            return;
        }
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        if (this.mCount > 1) {
            int shade = 16 + Pragmas.mulscale(16L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
            this.engine.rotatesprite(0, Engine.ydim - Pragmas.mulscale(Engine.tilesizy[9216], zoom, 16) << 16, zoom, 0, 9216, shade, 0, 24, 0, 0, Pragmas.mulscale(zoom, Engine.tilesizx[9216] - 1, 16), Engine.ydim - 1);
        }
    }

    @Override
    public boolean mCheckBackButton(int mx, int my) {
        int zoom = Pragmas.scale(16384L, Engine.ydim, 200L);
        int size = Pragmas.mulscale(Engine.tilesizx[9216], zoom, 16);
        int bx = 0;
        int by = Engine.ydim - Pragmas.mulscale(Engine.tilesizy[9216], zoom, 16);
        return mx >= bx && mx < bx + size && my >= by && my < by + size;
    }

    @Override
    public void mSound(MenuItem item, MenuHandler.MenuOpt opt) {
        switch (opt) {
            case Open: {
                Sound.PlayLocalSound(33, 0);
                break;
            }
            case Close: {
                Sound.PlayLocalSound(31, 0);
                break;
            }
            case UP: 
            case DW: 
            case PGUP: 
            case PGDW: 
            case HOME: 
            case END: 
            case MCHANGE: {
                Sound.PlayLocalSound(35, 0);
                break;
            }
            case LEFT: 
            case RIGHT: 
            case ENTER: 
            case MWUP: 
            case MWDW: {
                if (opt == MenuHandler.MenuOpt.ENTER && item instanceof MenuConteiner && item.getClass().getEnclosingClass() == MenuVideoMode.class) break;
                if (item instanceof MenuSlider) {
                    if (Sound.GetLocalSound() != 23 || !Sound.LocalSoundPlaying()) {
                        Sound.PlayLocalSound(23, 0);
                    }
                } else {
                    Sound.PlayLocalSound(35, 0);
                }
                this.soundTime = System.currentTimeMillis();
                break;
            }
            case LMB: {
                if (item instanceof MenuSlider) {
                    MenuSlider slider = (MenuSlider)item;
                    if (this.oldValue == slider.value) break;
                    this.oldValue = slider.value;
                    if (Sound.GetLocalSound() != 23 || !Sound.LocalSoundPlaying()) {
                        Sound.PlayLocalSound(23, 0);
                    }
                    this.soundTime = System.currentTimeMillis();
                    break;
                }
                if (item instanceof MenuScroller || item instanceof MenuFileBrowser || item instanceof MenuKeyboardList) break;
                Sound.PlayLocalSound(35, 0);
                break;
            }
        }
        if (Sound.GetLocalSound() == 23 && System.currentTimeMillis() - this.soundTime >= 200L) {
            Sound.StopLocalSound();
        }
    }

    @Override
    public void mPostDraw(MenuItem item) {
        int shade = 8 - (Engine.totalclock & 0x3F);
        if (item.isFocused()) {
            if (item instanceof MenuButton) {
                int py = item.y;
                int scale = 48000;
                if (item.align == 1) {
                    int centre = 80;
                    if (item.font == this.app.getFont(1)) {
                        this.engine.rotatesprite(160 + (centre >> 1) + 35 << 16, py << 16, scale, 1024, 3468, shade, 0, 14, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                        this.engine.rotatesprite(160 - (centre >> 1) - 35 << 16, py << 16, scale, 0, 3468, shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                    } else {
                        this.engine.rotatesprite(160 - (item.font.getWidth(item.text) >> 1) - 12 << 16, item.y + 2 << 16, 16384, 0, 3468, shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                    }
                } else {
                    this.engine.rotatesprite(item.x - 10 << 16, item.y + 2 << 16, 16384, 0, 3468, shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
            } else if (item instanceof MenuList) {
                if (item instanceof MenuResolutionList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    int py = list.y + (focus - list.l_nMin) * list.mFontOffset();
                    this.engine.rotatesprite(px + 45 << 16, py + 2 << 16, 16384, 0, 3468, shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                } else if (item instanceof MenuKeyboardList || item instanceof MenuJoyList) {
                    MenuList list = (MenuList)item;
                    int px = list.x;
                    int py = list.y + (list.l_nFocus - list.l_nMin) * list.mFontOffset();
                    int focus = list.l_nFocus;
                    if (focus == -1 || focus < list.l_nMin || focus >= list.l_nMin + list.nListItems) {
                        return;
                    }
                    this.engine.rotatesprite(px - 10 << 16, py + 2 << 16, 16384, 0, 3468, shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
                }
            } else if (item instanceof MenuVariants) {
                this.engine.rotatesprite(item.x - 20 << 16, item.y - 1 << 16, 16384, 0, 3468, shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            } else {
                this.engine.rotatesprite(item.x - 10 << 16, item.y + 2 << 16, 16384, 0, 3468, shade, 0, 10, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
        }
    }
}

