/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Anim;
import ru.m210projects.Powerslave.Bullet;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Light;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Random;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Seq;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Sprites;
import ru.m210projects.Powerslave.Type.GrenadeStruct;
import ru.m210projects.Powerslave.Type.SafeLoader;
import ru.m210projects.Powerslave.Weapons;

public class Grenade {
    public static final int MAX_GRENADES = 50;
    private static int nGrenadeCount;
    private static int nGrenadesFree;
    public static short[] GrenadeFree;
    public static short[] nGrenadePlayer;
    public static GrenadeStruct[] GrenadeList;

    static {
        GrenadeFree = new short[50];
        nGrenadePlayer = new short[50];
        GrenadeList = new GrenadeStruct[50];
    }

    public static void InitGrenades() {
        nGrenadeCount = 0;
        int i = 0;
        while (i < 50) {
            Grenade.GrenadeFree[i] = i;
            if (GrenadeList[i] == null) {
                Grenade.GrenadeList[i] = new GrenadeStruct();
            }
            i = (short)(i + 1);
        }
        nGrenadesFree = 50;
    }

    public static ByteBuffer saveGrenades() {
        ByteBuffer bb = ByteBuffer.allocate(1804);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)nGrenadeCount);
        bb.putShort((short)nGrenadesFree);
        int i = 0;
        while (i < 50) {
            bb.putShort(GrenadeFree[i]);
            bb.putShort(nGrenadePlayer[i]);
            GrenadeList[i].save(bb);
            ++i;
        }
        return bb;
    }

    public static void loadGrenades(SafeLoader loader, Resource bb) {
        if (bb != null) {
            loader.nGrenadeCount = bb.readShort().shortValue();
            loader.nGrenadesFree = bb.readShort().shortValue();
            int i = 0;
            while (i < 50) {
                loader.GrenadeFree[i] = bb.readShort();
                loader.nGrenadePlayer[i] = bb.readShort();
                if (loader.GrenadeList[i] == null) {
                    loader.GrenadeList[i] = new GrenadeStruct();
                }
                loader.GrenadeList[i].load(bb);
                ++i;
            }
        } else {
            nGrenadeCount = loader.nGrenadeCount;
            nGrenadesFree = loader.nGrenadesFree;
            System.arraycopy(loader.GrenadeFree, 0, GrenadeFree, 0, 50);
            System.arraycopy(loader.nGrenadePlayer, 0, nGrenadePlayer, 0, 50);
            int i = 0;
            while (i < 50) {
                if (GrenadeList[i] == null) {
                    Grenade.GrenadeList[i] = new GrenadeStruct();
                }
                GrenadeList[i].copy(loader.GrenadeList[i]);
                ++i;
            }
        }
    }

    public static int GrabGrenade() {
        return GrenadeFree[--nGrenadesFree];
    }

    public static void DestroyGrenade(int a1) {
        RunList.DoSubRunRec(Grenade.GrenadeList[a1].field_6);
        RunList.SubRunRec(Grenade.GrenadeList[a1].field_8);
        RunList.DoSubRunRec(Engine.sprite[Grenade.GrenadeList[a1].nSprite].lotag - 1);
        Main.engine.mydeletesprite(Grenade.GrenadeList[a1].nSprite);
        Grenade.GrenadeFree[Grenade.nGrenadesFree] = (short)a1;
        ++nGrenadesFree;
    }

    public static void BounceGrenade(int a1, int a2) {
        Grenade.GrenadeList[a1].field_10 >>= 1;
        Grenade.GrenadeList[a1].xvel = Grenade.GrenadeList[a1].field_10 * (Engine.sintable[a2 + 512 & 0x7FF] >> 5);
        Grenade.GrenadeList[a1].yvel = Grenade.GrenadeList[a1].field_10 * (Engine.sintable[a2 & 0x7FF] >> 5);
        Sound.D3PlayFX(Sound.StaticSound[3], Grenade.GrenadeList[a1].nSprite);
    }

    public static void ThrowGrenade(int a1, int a2, int a3, int a4, int a5) {
        short v7 = Globals.nPlayerGrenade[a1];
        if (v7 >= 0) {
            short nPlayer = Globals.PlayerList[a1].spriteId;
            short nGrenade = Grenade.GrenadeList[v7].nSprite;
            Main.engine.mychangespritesect(nGrenade, Globals.nPlayerViewSect[a1]);
            Engine.sprite[nGrenade].x = Engine.sprite[nPlayer].x;
            Engine.sprite[nGrenade].y = Engine.sprite[nPlayer].y;
            Engine.sprite[nGrenade].z = Engine.sprite[nPlayer].z;
            Engine.sprite[nGrenade].ang = Engine.sprite[nPlayer].ang;
            Engine.sprite[nGrenade].cstat = (short)(Engine.sprite[nGrenade].cstat & 0x7FF);
            if (a5 >= -3000) {
                Grenade.GrenadeList[v7].field_10 = 32 * (Main.cfg.bGrenadeFix && !Globals.isOriginal() ? 90 - Grenade.GrenadeList[v7].field_E : Globals.totalvel[a1]) + (90 - Grenade.GrenadeList[v7].field_E) * (90 - Grenade.GrenadeList[v7].field_E);
                Engine.sprite[nGrenade].zvel = (short)(-64 * a5 - 4352);
                int dist = 8 * Engine.sprite[nPlayer].clipdist;
                int hitMove = Main.engine.movesprite(nGrenade, dist * Engine.sintable[Engine.sprite[nPlayer].ang + 512 & 0x7FF], Engine.sintable[Engine.sprite[nPlayer].ang & 0x7FF] * dist, a4, 0, 0, 1);
                if ((hitMove & 0x8000) != 0) {
                    Grenade.BounceGrenade(v7, Main.engine.GetWallNormal(hitMove & 0x3FFF));
                }
            } else {
                Grenade.GrenadeList[v7].field_10 = 0;
                Engine.sprite[nGrenade].zvel = Engine.sprite[nPlayer].zvel;
            }
            Grenade.GrenadeList[v7].xvel = Grenade.GrenadeList[v7].field_10 * (Engine.sintable[Engine.sprite[nPlayer].ang + 512 & 0x7FF] >> 4);
            Grenade.GrenadeList[v7].yvel = Grenade.GrenadeList[v7].field_10 * (Engine.sintable[Engine.sprite[nPlayer].ang & 0x7FF] >> 4);
            Globals.nPlayerGrenade[a1] = -1;
        }
    }

    public static int BuildGrenade(int a1) {
        if (nGrenadesFree != 0) {
            int nGrenade = Grenade.GrabGrenade();
            short nPlayer = Globals.PlayerList[a1].spriteId;
            short spr = Main.engine.insertsprite(Globals.nPlayerViewSect[a1], (short)201);
            if (spr < 0 || spr >= Engine.MAXSPRITES) {
                Main.game.ThrowError("spr>=0 && spr<MAXSPRITES");
                return -1;
            }
            SPRITE pSprite = Engine.sprite[spr];
            pSprite.x = Engine.sprite[nPlayer].x;
            pSprite.y = Engine.sprite[nPlayer].y;
            pSprite.z = Engine.sprite[nPlayer].z - 3840;
            pSprite.shade = (byte)-64;
            pSprite.xrepeat = (short)20;
            pSprite.yrepeat = (short)20;
            pSprite.cstat = Short.MIN_VALUE;
            pSprite.picnum = 1;
            pSprite.pal = 0;
            pSprite.clipdist = 30;
            pSprite.xoffset = 0;
            pSprite.yoffset = 0;
            pSprite.ang = Engine.sprite[nPlayer].ang;
            pSprite.yvel = 0;
            pSprite.owner = nPlayer;
            pSprite.xvel = 0;
            pSprite.zvel = 0;
            pSprite.hitag = 0;
            pSprite.lotag = (short)(RunList.HeadRun() + 1);
            pSprite.extra = (short)-1;
            Grenade.GrenadeList[nGrenade].field_E = (short)90;
            Grenade.GrenadeList[nGrenade].field_2 = 0;
            Grenade.GrenadeList[nGrenade].field_0 = (short)16;
            Grenade.GrenadeList[nGrenade].field_10 = -1;
            Grenade.GrenadeList[nGrenade].nSprite = spr;
            Grenade.GrenadeList[nGrenade].ActionSeq = 0;
            Grenade.GrenadeList[nGrenade].field_C = 0;
            Grenade.GrenadeList[nGrenade].field_6 = (short)RunList.AddRunRec(pSprite.lotag - 1, 0xF0000 | nGrenade);
            Grenade.GrenadeList[nGrenade].field_8 = (short)RunList.AddRunRec(RunList.NewRun, 0xF0000 | nGrenade);
            Grenade.nGrenadePlayer[nGrenade] = (short)a1;
            Globals.nPlayerGrenade[a1] = (short)nGrenade;
        }
        return -1;
    }

    public static void ExplodeGrenade(int a1) {
        int v18;
        int v16;
        short nPlayer = nGrenadePlayer[a1];
        short spr = Grenade.GrenadeList[a1].nSprite;
        Grenade.GrenadeList[a1].field_C = 1;
        SPRITE pSprite = Engine.sprite[spr];
        short sectnum = pSprite.sectnum;
        if ((Globals.SectFlag[sectnum] & 0x2000) != 0) {
            v16 = 75;
            v18 = 60;
        } else if (pSprite.z >= Engine.sector[sectnum].floorz) {
            v16 = 34;
            v18 = 150;
        } else {
            v16 = 36;
            v18 = 200;
        }
        if (Grenade.GrenadeList[a1].field_10 < 0) {
            short v9 = Globals.PlayerList[nPlayer].spriteId;
            pSprite.z = Engine.sprite[v9].z;
            pSprite.x = Engine.sprite[v9].x + (Engine.sintable[Engine.sprite[v9].ang + 512 & 0x7FF] >> 5);
            pSprite.y = Engine.sprite[v9].y + (Engine.sintable[Engine.sprite[v9].ang & 0x7FF] >> 5);
            Main.engine.changespritesect(spr, Engine.sprite[v9].sectnum);
            if (Globals.PlayerList[nPlayer].invisibility == 0) {
                Globals.PlayerList[nPlayer].HealthAmount = 1;
            }
        }
        int force = Bullet.BulletInfo[4].force;
        if (Globals.nPlayerDouble[nPlayer] > 0) {
            force = 2 * Bullet.BulletInfo[4].force;
        }
        Sprites.RadialDamageEnemy(spr, force, Bullet.BulletInfo[4].inf_10);
        Anim.BuildAnim(-1, v16, 0, pSprite.x, pSprite.y, pSprite.z, pSprite.sectnum, v18, 4);
        Light.AddFlash(pSprite.sectnum, pSprite.x, pSprite.y, pSprite.z, 128);
        Grenade.nGrenadePlayer[a1] = -1;
        Grenade.DestroyGrenade(a1);
    }

    public static void FuncGrenade(int a1, int a2, int RunPtr) {
        short nGrenade = (short)(RunList.RunData[RunPtr].RunEvent & 0xFFFF);
        if (nGrenade < 0 || nGrenade >= 50) {
            Main.game.ThrowError("nGrenade>=0 && nGrenade<MAX_GRENADES");
            return;
        }
        short nSprite = Grenade.GrenadeList[nGrenade].nSprite;
        int nSeq = Grenade.GrenadeList[nGrenade].field_C != 0 ? Seq.SeqOffsets[34] : Grenade.GrenadeList[nGrenade].ActionSeq + Seq.SeqOffsets[33];
        switch (a1 & 0x7F0000) {
            case 131072: {
                int v10 = Grenade.GrenadeList[nGrenade].field_2 >> 8;
                Seq.MoveSequence(nSprite, nSeq, v10);
                Engine.sprite[nSprite].picnum = (short)Seq.GetSeqPicnum2(nSeq, v10);
                Grenade.GrenadeList[nGrenade].field_E = (short)(Grenade.GrenadeList[nGrenade].field_E - 1);
                if (Grenade.GrenadeList[nGrenade].field_E == 0) {
                    short nPlayer = nGrenadePlayer[nGrenade];
                    if (Grenade.GrenadeList[nGrenade].field_10 < 0) {
                        Globals.PlayerList[nPlayer].weaponState = 0;
                        Globals.PlayerList[nPlayer].seqOffset = 0;
                        if (Globals.PlayerList[nPlayer].AmmosAmount[4] != 0) {
                            Globals.PlayerList[nPlayer].weaponFire = 0;
                        } else {
                            Weapons.SelectNewWeapon(nPlayer);
                            Globals.PlayerList[nPlayer].currentWeapon = Globals.PlayerList[nPlayer].newWeapon;
                            Globals.PlayerList[nPlayer].newWeapon = (short)-1;
                        }
                    }
                    Grenade.ExplodeGrenade(nGrenade);
                    return;
                }
                if (Grenade.GrenadeList[nGrenade].field_10 < 0) {
                    return;
                }
                Grenade.GrenadeList[nGrenade].field_2 = (short)(Grenade.GrenadeList[nGrenade].field_2 + Grenade.GrenadeList[nGrenade].field_0);
                int v19 = Grenade.GrenadeList[nGrenade].field_2 >> 8;
                if (v19 < 0) {
                    Grenade.GrenadeList[nGrenade].field_2 = (short)(Grenade.GrenadeList[nGrenade].field_2 + (Seq.SeqSize[nSeq] << 8));
                } else if (v19 >= Seq.SeqSize[nSeq]) {
                    if (Grenade.GrenadeList[nGrenade].field_C != 0) {
                        Grenade.DestroyGrenade(nGrenade);
                        return;
                    }
                    Grenade.GrenadeList[nGrenade].field_2 = 0;
                }
                if (Grenade.GrenadeList[nGrenade].field_C != 0) {
                    return;
                }
                short zvel = Engine.sprite[nSprite].zvel;
                Sprites.Gravity(nSprite);
                int hitMove = Main.engine.movesprite(nSprite, Grenade.GrenadeList[nGrenade].xvel, Grenade.GrenadeList[nGrenade].yvel, Engine.sprite[nSprite].zvel, Engine.sprite[nSprite].clipdist >> 1, Engine.sprite[nSprite].clipdist >> 1, 1);
                if (hitMove == 0) {
                    return;
                }
                if ((hitMove & 0x20000) != 0) {
                    if (zvel != 0) {
                        if (Globals.SectDamage[Engine.sprite[nSprite].sectnum] > 0) {
                            Grenade.ExplodeGrenade(nGrenade);
                            return;
                        }
                        Grenade.GrenadeList[nGrenade].field_0 = (short)Globals.totalmoves;
                        Sound.D3PlayFX(Sound.StaticSound[3], nSprite);
                        Engine.sprite[nSprite].zvel = (short)(-(zvel >> 1));
                        if (Engine.sprite[nSprite].zvel > -1280) {
                            Sound.D3PlayFX(Sound.StaticSound[5], nSprite);
                            Grenade.GrenadeList[nGrenade].field_0 = 0;
                            Grenade.GrenadeList[nGrenade].field_2 = 0;
                            Engine.sprite[nSprite].zvel = 0;
                            Grenade.GrenadeList[nGrenade].ActionSeq = 1;
                        }
                    }
                    Grenade.GrenadeList[nGrenade].field_0 = (short)(255 - 2 * Random.RandomByte());
                    Grenade.GrenadeList[nGrenade].xvel -= Grenade.GrenadeList[nGrenade].xvel >> 4;
                    Grenade.GrenadeList[nGrenade].yvel -= Grenade.GrenadeList[nGrenade].yvel >> 4;
                }
                switch (hitMove & 0xC000) {
                    case 32768: {
                        Grenade.BounceGrenade(nGrenade, Main.engine.GetWallNormal(hitMove & 0x3FFF));
                        Grenade.GrenadeList[nGrenade].field_2 = 0;
                        return;
                    }
                    case 49152: {
                        Grenade.BounceGrenade(nGrenade, Engine.sprite[hitMove & 0x3FFF].ang);
                        Grenade.GrenadeList[nGrenade].field_2 = 0;
                        return;
                    }
                }
                return;
            }
            case 589824: {
                Seq.PlotSequence((short)(a1 & 0xFFFF), nSeq, Grenade.GrenadeList[nGrenade].field_2 >> 8, 1);
                return;
            }
            case 655360: {
                if (nSprite != Globals.nRadialSpr && Grenade.GrenadeList[nGrenade].field_C == 0 && Sprites.CheckRadialDamage(nSprite) > 280) {
                    Grenade.GrenadeList[nGrenade].field_E = (short)(Random.RandomSize(4) + 1);
                }
                return;
            }
        }
    }
}

