/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Screens;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.PrecacheAdapter;
import ru.m210projects.Build.Strhandler;
import ru.m210projects.Powerslave.Globals;

public class PrecacheScreen
extends PrecacheAdapter {
    public PrecacheScreen(BuildGame game) {
        super(game);
        this.addQueue("Preload floor and ceiling tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.numsectors) {
                    PrecacheScreen.this.addTile(Engine.sector[i].floorpicnum);
                    PrecacheScreen.this.addTile(Engine.sector[i].ceilingpicnum);
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload wall tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.numwalls) {
                    PrecacheScreen.this.addTile(Engine.wall[i].picnum);
                    if (Engine.wall[i].overpicnum >= 0) {
                        PrecacheScreen.this.addTile(Engine.wall[i].overpicnum);
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(0);
            }
        });
        this.addQueue("Preload sprite tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.MAXSPRITES) {
                    if (Engine.sprite[i].statnum < 1024) {
                        PrecacheScreen.this.cachespritenum(i);
                    }
                    ++i;
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload hud tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 3522;
                while (i <= 3554) {
                    PrecacheScreen.this.addTile(i);
                    ++i;
                }
                i = 9220;
                while (i <= 9271) {
                    PrecacheScreen.this.addTile(i);
                    ++i;
                }
                PrecacheScreen.this.doprecache(1);
            }
        });
        this.addQueue("Preload other tiles...", new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < Engine.MAXTILES) {
                    if (Engine.waloff[i] == null) {
                        PrecacheScreen.this.engine.loadtile(i);
                    }
                    ++i;
                }
            }
        });
    }

    @Override
    protected void draw(String title, int index) {
        this.engine.clearview(96);
        this.engine.rotatesprite(0xA00000, 0x640000, 65536, 0, Globals.BACKGROUND, -128, 0, 74, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        this.game.getFont(1).drawText(160, 100, Strhandler.toCharArray("Loading"), 0, 0, BuildFont.TextAlign.Center, 2, true);
        this.game.getFont(1).drawText(160, 114, title, 0, 0, BuildFont.TextAlign.Center, 2, true);
    }

    private void cachespritenum(int i) {
        short maxc = 1;
        int j = Engine.sprite[i].picnum;
        while (j < Engine.sprite[i].picnum + maxc) {
            this.addTile(j);
            ++j;
        }
    }
}

