/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Powerslave.Enemies.Ra;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Grenade;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Map;
import ru.m210projects.Powerslave.Player;
import ru.m210projects.Powerslave.RunList;
import ru.m210projects.Powerslave.Sound;
import ru.m210projects.Powerslave.Type.StatusAnim;
import ru.m210projects.Powerslave.View;
import ru.m210projects.Powerslave.Weapons;

public class Seq {
    private static short[] nGunPicnum = new short[]{488, 490, 491, 878, 899, 3455};
    public static final int SEQMAX = 4096;
    public static int sequences;
    public static short[] SeqBase;
    public static short[] SeqSize;
    public static short[] SeqFlag;
    public static int[] SeqOffsets;
    public static final int FRAMEMAX = 18000;
    public static int frames;
    public static short[] FrameBase;
    public static short[] FrameSize;
    public static short[] FrameFlag;
    public static short[] FrameSound;
    public static final int CHUNKMAX = 21000;
    public static int chunks;
    public static short[] ChunkXpos;
    public static short[] ChunkYpos;
    public static short[] ChunkPict;
    public static short[] ChunkFlag;
    public static int centerx;
    public static int centery;

    static {
        SeqBase = new short[4096];
        SeqSize = new short[4096];
        SeqFlag = new short[4096];
        SeqOffsets = new int[78];
        FrameBase = new short[18000];
        FrameSize = new short[18000];
        FrameFlag = new short[18000];
        FrameSound = new short[18000];
        ChunkXpos = new short[21000];
        ChunkYpos = new short[21000];
        ChunkPict = new short[21000];
        ChunkFlag = new short[21000];
    }

    public static void LoadSequences() {
        String[] SeqNames = new String[]{"rothands.seq", "sword.seq", "pistol.seq", "m_60.seq", "flamer.seq", "grenade.seq", "cobra.seq", "bonesaw.seq", "scramble.seq", "glove.seq", "mummy.seq", "skull.seq", "poof.seq", "kapow.seq", "fireball.seq", "bubble.seq", "spider.seq", "anubis.seq", "anuball.seq", "fish.seq", "snakehed.seq", "snakbody.seq", "wasp.seq", "cobrapow.seq", "scorp.seq", "joe.seq", "status.seq", "dead.seq", "deadex.seq", "anupoof.seq", "skulpoof.seq", "bullet.seq", "shadow.seq", "grenroll.seq", "grenboom.seq", "splash.seq", "grenpow.seq", "skulstrt.seq", "firepoof.seq", "bloodhit.seq", "lion.seq", "items.seq", "lavag.seq", "lsplash.seq", "lavashot.seq", "smokebal.seq", "firepot.seq", "rex.seq", "set.seq", "queen.seq", "roach.seq", "hawk.seq", "setghost.seq", "setgblow.seq", "bizztail.seq", "bizzpoof.seq", "queenegg.seq", "roacshot.seq", "backgrnd.seq", "screens.seq", "arrow.seq", "fonts.seq", "drips.seq", "firetrap.seq", "magic2.seq", "creepy.seq", "slider.seq", "ravolt.seq", "eyehit.seq", "font2.seq", "seebubbl.seq", "blood.seq", "drum.seq", "poof2.seq", "deadbrn.seq", "grenbubb.seq", "rochfire.seq", "rat.seq"};
        int i = 0;
        while (i < 78) {
            Seq.SeqOffsets[i] = sequences;
            if (!Seq.ReadSequence(SeqNames[i])) {
                Console.Println("Error loading " + SeqNames[i]);
            }
            ++i;
        }
        Globals.nShadowPic = Seq.GetFirstSeqPicnum(32);
        Globals.nShadowWidth = Engine.tilesizx[Globals.nShadowPic];
        Globals.nFlameHeight = Engine.tilesizy[Seq.GetFirstSeqPicnum(38)];
        Globals.nBackgroundPic = Seq.GetFirstSeqPicnum(58);
        Globals.nPilotLightBase = SeqBase[SeqOffsets[4] + 3];
        Globals.nPilotLightCount = SeqSize[SeqOffsets[4] + 3];
        Globals.nPilotLightFrame = 0;
        Globals.nFontFirstChar = Seq.GetFirstSeqPicnum(69);
        i = 0;
        while (i < SeqSize[SeqOffsets[69]]) {
            int n = i + Globals.nFontFirstChar;
            Engine.picanm[n] = Engine.picanm[n] & 0xFF0000FF;
            ++i;
        }
        View.InitStatus();
    }

    public static short GetSeqPicnum(int seq, int offset, int a3) {
        if (SeqBase[SeqOffsets[seq] + offset] + a3 == -1) {
            return 0;
        }
        return ChunkPict[FrameBase[SeqBase[SeqOffsets[seq] + offset] + a3]];
    }

    public static int GetSeqPicnum2(int seq, int a2) {
        if (SeqBase[seq] + a2 == -1) {
            return 0;
        }
        return ChunkPict[FrameBase[SeqBase[seq] + a2]];
    }

    public static int GetFirstSeqPicnum(int seq) {
        if (SeqBase[seq] == -1) {
            return 0;
        }
        return ChunkPict[FrameBase[SeqBase[SeqOffsets[seq]]]];
    }

    public static void DrawStatusSequence(int seq, int frameOffs, int yOffset) {
        int v3 = SeqBase[seq] + frameOffs;
        if (v3 == -1) {
            return;
        }
        int chunkNum = FrameBase[v3];
        int count = FrameSize[v3];
        while (--count >= 0) {
            int ang = 0;
            int stat = 10;
            short orientation = ChunkFlag[chunkNum];
            int x = ChunkXpos[chunkNum] + 160;
            int y = ChunkYpos[chunkNum] + 100 + yOffset;
            if ((orientation & 3) != 0) {
                if ((orientation & 1) != 0) {
                    ang = 1024;
                }
                if (orientation != 3) {
                    stat |= 4;
                }
            }
            Main.engine.rotatesprite(x << 16, y << 16, 65536, ang, ChunkPict[chunkNum++], 0, 0, stat, 0, 0, Engine.xdim, Engine.ydim);
        }
    }

    public static void DrawCustomSequence(int baseSeq, int frameOffs, int xoffs, int yoffs, int shade, int pal, int dastat) {
        if (baseSeq == -1) {
            return;
        }
        int v3 = SeqBase[baseSeq] + frameOffs;
        if (v3 == -1) {
            return;
        }
        int chunkNum = FrameBase[v3];
        int count = FrameSize[v3];
        while (--count >= 0) {
            int ang = 0;
            int stat = 0xA | dastat;
            short orientation = ChunkFlag[chunkNum];
            int x = ChunkXpos[chunkNum] + 160 + xoffs;
            int y = ChunkYpos[chunkNum] + 100 + yoffs;
            if ((orientation & 3) != 0) {
                if ((orientation & 1) != 0) {
                    ang = 1024;
                }
                if (orientation != 3) {
                    stat |= 4;
                }
            }
            Main.engine.rotatesprite(x << 16, y << 16, 65536, ang, ChunkPict[chunkNum++], shade, pal, stat, 0, 0, Engine.xdim, Engine.ydim);
        }
    }

    public static void DrawGunSequence(int baseSeq, int frameOffs, int xoffs, int yoffs, int shade, int pal, int extstat) {
        if (baseSeq == -1) {
            return;
        }
        int v3 = SeqBase[baseSeq] + frameOffs;
        if (v3 == -1) {
            return;
        }
        int chunkNum = FrameBase[v3];
        int count = FrameSize[v3];
        short flags = FrameFlag[v3];
        while (--count >= 0) {
            int ang = 0;
            int stat = 0xA | extstat;
            short orientation = ChunkFlag[chunkNum];
            int x = ChunkXpos[chunkNum] + 160 + xoffs;
            int y = ChunkYpos[chunkNum] + 100 + yoffs;
            if ((orientation & 3) != 0) {
                if ((orientation & 1) != 0) {
                    ang = 1024;
                }
                if (orientation != 3) {
                    stat |= 4;
                }
            }
            if ((flags & 4) != 0) {
                shade -= 100;
            }
            if (Globals.nPlayerInvisible[Globals.nLocalPlayer] != 0) {
                stat |= 0x21;
            }
            Main.engine.rotatesprite(x << 16, y << 16, 65536, ang, ChunkPict[chunkNum++], shade, pal, stat, 0, 0, Engine.xdim, Engine.ydim);
        }
    }

    public static void PlotArrowSequence(int nSprite, int baseSeq, short frameOffs) {
        int ang = (Engine.tsprite[nSprite].ang + 512 - Main.engine.GetMyAngle(Globals.nCamerax - Engine.tsprite[nSprite].x, Globals.nCameray - Engine.tsprite[nSprite].y) + 128 & 0x7FF) >> 8;
        int seq = SeqBase[baseSeq + ang] + frameOffs;
        if (seq == -1) {
            return;
        }
        short frm = FrameBase[seq];
        int cstat = Engine.tsprite[nSprite].cstat | 0x80;
        byte shade = Engine.tsprite[nSprite].shade;
        cstat = (ang & 3) != 0 ? (cstat |= 0x18) : (cstat &= 0xFFFFFFE7);
        if ((FrameFlag[seq] & 4) != 0) {
            shade = (byte)(shade - 100);
        }
        Engine.tsprite[nSprite].cstat = (short)cstat;
        Engine.tsprite[nSprite].shade = shade;
        Engine.tsprite[nSprite].statnum = FrameSize[seq];
        if ((ChunkFlag[frm] & 1) != 0) {
            Engine.tsprite[nSprite].xoffset = ChunkXpos[frm];
            Engine.tsprite[nSprite].cstat = (short)(Engine.tsprite[nSprite].cstat | 4);
        } else {
            Engine.tsprite[nSprite].xoffset = -ChunkXpos[frm];
        }
        Engine.tsprite[nSprite].yoffset = -ChunkYpos[frm];
        Engine.tsprite[nSprite].picnum = ChunkPict[frm];
    }

    public static void PlotSequence(int a1, int a2, int a3, int a4) {
        int fz;
        SPRITE pTSprite = Engine.tsprite[(short)(a1 & 0xFFFF)];
        short dang = Main.engine.GetMyAngle(Globals.nCamerax - pTSprite.x, Globals.nCameray - pTSprite.y);
        int nShade = pTSprite.shade;
        if (SeqBase[a2] + a3 == -1) {
            return;
        }
        if ((FrameFlag[SeqBase[a2] + a3] & 4) != 0) {
            nShade -= 100;
        }
        int v8 = (a4 & 1) == 0 ? (pTSprite.ang - dang + 128 & 0x7FF) >> 8 : 0;
        int seq = SeqBase[v8 + a2] + a3;
        int frm = FrameBase[seq];
        int frmSize = FrameSize[seq];
        int nStatnum = 100;
        if ((a4 & 0x100) != 0) {
            nStatnum = -3;
        }
        short nOwner = pTSprite.owner;
        int nTSprite = Engine.spritesortcnt;
        short nTile = ChunkPict[frm];
        int xoffs = 0;
        int yoffs = 0;
        int i = frmSize;
        while (i > 0) {
            if (Engine.tsprite[nTSprite] == null) {
                Engine.tsprite[nTSprite] = new SPRITE();
            }
            xoffs = Pragmas.mulscale(frmSize - i, Engine.sintable[dang + 512 & 0x7FF], 10);
            yoffs = Pragmas.mulscale(frmSize - i, Engine.sintable[dang & 0x7FF], 10);
            Engine.tsprite[nTSprite].x = pTSprite.x + xoffs;
            Engine.tsprite[nTSprite].y = pTSprite.y + yoffs;
            Engine.tsprite[nTSprite].z = pTSprite.z;
            Engine.tsprite[nTSprite].shade = (byte)nShade;
            Engine.tsprite[nTSprite].pal = pTSprite.pal;
            Engine.tsprite[nTSprite].xrepeat = pTSprite.xrepeat;
            Engine.tsprite[nTSprite].yrepeat = pTSprite.yrepeat;
            Engine.tsprite[nTSprite].ang = ChunkPict[frm] == 736 ? dang : pTSprite.ang;
            Engine.tsprite[nTSprite].owner = pTSprite.owner;
            Engine.tsprite[nTSprite].sectnum = pTSprite.sectnum;
            Engine.tsprite[nTSprite].cstat = (short)(pTSprite.cstat | 0x80);
            Engine.tsprite[nTSprite].statnum = (short)(i + nStatnum + 1);
            if ((ChunkFlag[frm] & 1) != 0) {
                Engine.tsprite[nTSprite].xoffset = ChunkXpos[frm];
                Engine.tsprite[nTSprite].cstat = (short)(Engine.tsprite[nTSprite].cstat | 4);
            } else {
                Engine.tsprite[nTSprite].xoffset = -ChunkXpos[frm];
            }
            Engine.tsprite[nTSprite].yoffset = -ChunkYpos[frm];
            Engine.tsprite[nTSprite].picnum = ChunkPict[frm];
            ++Engine.spritesortcnt;
            ++nTSprite;
            ++frm;
            --i;
        }
        if ((pTSprite.cstat & 0x101) != 0 && (Engine.sprite[nOwner].statnum != 100 || Globals.nNetPlayerCount == 0) && (fz = Engine.sector[pTSprite.sectnum].floorz) > Globals.initz + Globals.PlayerList[Globals.nLocalPlayer].eyelevel) {
            if (!Main.cfg.bNewShadows) {
                short siz = (short)Math.max(32 * Engine.tilesizx[nTile] / Globals.nShadowWidth - (fz - pTSprite.z >> 10), 1);
                pTSprite.picnum = (short)Globals.nShadowPic;
                pTSprite.cstat = (short)34;
                pTSprite.xrepeat = pTSprite.yrepeat = siz;
            } else {
                pTSprite.x -= Pragmas.mulscale(Engine.sintable[dang + 512 & 0x7FF], 100L, 16);
                pTSprite.y += Pragmas.mulscale(Engine.sintable[dang + 1024 & 0x7FF], 100L, 16);
                short siz = (short)Math.max(48 - (fz - pTSprite.z >> 10), 1);
                pTSprite.picnum = nTile;
                pTSprite.xrepeat = siz;
                pTSprite.yrepeat = (short)(pTSprite.yrepeat >> 3);
                if (pTSprite.yrepeat < 4) {
                    pTSprite.yrepeat = (short)4;
                }
                pTSprite.shade = (byte)127;
                pTSprite.cstat = (short)(pTSprite.cstat | 2);
            }
            pTSprite.z = fz + 1;
            pTSprite.statnum = (short)-3;
            pTSprite.pal = 0;
            return;
        }
        pTSprite.owner = (short)-1;
    }

    public static void StartDeathSeq(int player, int seq) {
        Ra.FreeRa(player);
        Globals.PlayerList[player].HealthAmount = 0;
        short nSprite = Globals.PlayerList[player].spriteId;
        short lotag = Engine.sector[Engine.sprite[nSprite].sectnum].lotag;
        if (lotag > 0) {
            RunList.SignalRun(lotag - 1, 0x70000 | player);
        }
        if (Globals.nPlayerGrenade[player] < 0) {
            if (Globals.nNetPlayerCount != 0 && Globals.PlayerList[player].currentWeapon > 0 && Globals.PlayerList[player].currentWeapon <= 6) {
                short sect = Engine.sprite[nSprite].sectnum;
                if (Globals.SectBelow[sect] > -1) {
                    sect = Globals.SectBelow[sect];
                }
                short spr = Weapons.GrabBodyGunSprite();
                Main.engine.changespritesect(spr, sect);
                Engine.sprite[spr].x = Engine.sprite[nSprite].x;
                Engine.sprite[spr].y = Engine.sprite[nSprite].y;
                Engine.sprite[spr].z = Engine.sector[sect].floorz - 512;
                Main.engine.changespritestat(spr, (short)(Player.nActionEyeLevel[Globals.PlayerList[player].currentWeapon + 20] + 900));
                Engine.sprite[spr].picnum = nGunPicnum[Globals.PlayerList[player].currentWeapon - 1];
                Map.BuildItemAnim(spr);
            }
        } else {
            Grenade.ThrowGrenade(player, 0, 0, 0, -10000);
        }
        Weapons.StopFiringWeapon(player);
        Globals.PlayerList[player].horiz = 92.0f;
        Globals.PlayerList[player].eyelevel = (short)-14080;
        Globals.nPlayerInvisible[player] = 0;
        Globals.dVertPan[player] = 15;
        Engine.sprite[nSprite].cstat = (short)(Engine.sprite[nSprite].cstat & 0xFFFF7EFE);
        Weapons.SetNewWeaponImmediate(player, -2);
        Globals.nDeathType[player] = Globals.SectDamage[Engine.sprite[nSprite].sectnum] <= 0 ? (int)seq : 2;
        Globals.PlayerList[player].anim_ = seq != 0 || (Globals.SectFlag[Engine.sprite[nSprite].sectnum] & 0x2000) == 0 ? (short)(2 * seq + 17) : (short)16;
        Globals.PlayerList[player].animCount = 0;
        if (Mmulti.numplayers == 1) {
            if (Globals.nPlayerLives[player] > 0) {
                StatusAnim.BuildStatusAnim(3 * (Globals.nPlayerLives[player] - 1) + 7, 0);
            }
            if (Globals.levelnum > 0 || Globals.mUserFlag == Main.UserFlag.UserMap) {
                int n = player;
                Globals.nPlayerLives[n] = (short)(Globals.nPlayerLives[n] - 1);
            }
            if (Globals.nPlayerLives[player] < 0) {
                Globals.nPlayerLives[player] = 0;
            }
        }
        Globals.totalvel[player] = 0;
    }

    public static void DrawPilotLightSeq(int x, int y) {
        if ((Globals.SectFlag[Globals.nPlayerViewSect[Globals.nLocalPlayer]] & 0x2000) == 0) {
            int v3 = Globals.nPilotLightBase + Globals.nPilotLightFrame;
            int seq = FrameBase[v3];
            int count = FrameSize[v3];
            while (--count >= 0) {
                Main.engine.rotatesprite(x + 160 + ChunkXpos[seq] << 16, y + 100 + ChunkYpos[seq] << 16, 65536, -8 * (int)Globals.sPlayerInput[Globals.nLocalPlayer].avel, ChunkPict[seq], -127, 1, 10, 0, 0, Engine.xdim, Engine.ydim);
                ++seq;
            }
        }
    }

    public static boolean ReadSequence(String name) {
        int sequence = 0;
        Resource bb = BuildGdx.cache.open(name, 1);
        if (bb == null) {
            System.err.println("Unable to open " + name);
            return false;
        }
        String sign = bb.readString(2);
        centerx = bb.readShort().shortValue();
        centery = bb.readShort().shortValue();
        int nSeqs = bb.readShort().shortValue();
        if (nSeqs <= 0 || nSeqs + sequences >= 4096) {
            System.err.println("Not enough sequences available!  Increase array");
            bb.close();
            return false;
        }
        int i = 0;
        while (i < nSeqs) {
            Seq.SeqBase[i + Seq.sequences] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < nSeqs) {
            Seq.SeqSize[i + Seq.sequences] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < nSeqs) {
            Seq.SeqFlag[i + Seq.sequences] = bb.readShort();
            ++i;
        }
        i = 0;
        while (i < nSeqs) {
            int n = i + sequences;
            SeqBase[n] = (short)(SeqBase[n] + frames);
            ++i;
        }
        int oldSeqFrameOffset = frames;
        int nFrames = bb.readShort().shortValue();
        if (nFrames <= 0 || frames + nFrames >= 18000) {
            System.err.println("Not enough frames available!  Increase FRAMEMAX");
            bb.close();
            return false;
        }
        int i2 = 0;
        while (i2 < nFrames) {
            Seq.FrameBase[i2 + Seq.frames] = bb.readShort();
            ++i2;
        }
        i2 = 0;
        while (i2 < nFrames) {
            Seq.FrameSize[i2 + Seq.frames] = bb.readShort();
            ++i2;
        }
        i2 = 0;
        while (i2 < nFrames) {
            Seq.FrameFlag[i2 + Seq.frames] = bb.readShort();
            ++i2;
        }
        i2 = 0;
        while (i2 < nFrames) {
            Seq.FrameSound[i2 + Seq.frames] = -1;
            ++i2;
        }
        i2 = 0;
        while (i2 < nFrames) {
            int n = i2 + frames;
            FrameBase[n] = (short)(FrameBase[n] + chunks);
            ++i2;
        }
        int nChunks = bb.readShort().shortValue();
        if (nChunks < 0 || chunks + nChunks >= 21000) {
            System.err.println("Not enough chunks available!  Increase CHUNKMAX");
            bb.close();
            return false;
        }
        int i3 = 0;
        while (i3 < nChunks) {
            Seq.ChunkXpos[i3 + Seq.chunks] = bb.readShort();
            ++i3;
        }
        i3 = 0;
        while (i3 < nChunks) {
            Seq.ChunkYpos[i3 + Seq.chunks] = bb.readShort();
            ++i3;
        }
        i3 = 0;
        while (i3 < nChunks) {
            Seq.ChunkPict[i3 + Seq.chunks] = bb.readShort();
            ++i3;
        }
        i3 = 0;
        while (i3 < nChunks) {
            if ((Engine.picanm[ChunkPict[i3 + chunks]] & 0xC0) != 0) {
                System.err.println("sequence " + sequence + " tile " + ChunkPict[i3 + chunks] + " has Ken animation attached!");
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < nChunks) {
            Seq.ChunkFlag[i3 + Seq.chunks] = bb.readShort();
            ++i3;
        }
        i3 = 0;
        while (i3 < nChunks) {
            int n = i3 + chunks;
            ChunkXpos[n] = (short)(ChunkXpos[n] - centerx);
            int n2 = i3 + chunks;
            ChunkYpos[n2] = (short)(ChunkYpos[n2] - centery);
            ++i3;
        }
        Seq.SeqBase[Seq.sequences += nSeqs] = (short)(frames += nFrames);
        Seq.FrameBase[Seq.frames] = (short)(chunks += nChunks);
        if (sign.equals("DS")) {
            int numSounds = bb.readShort().shortValue();
            String[] sounds = new String[20];
            byte[] data = new byte[8];
            int i4 = 0;
            while (i4 < numSounds) {
                bb.read(data);
                sounds[i4] = new String(data).trim();
                ++i4;
            }
            int v52 = bb.readShort().shortValue();
            int i5 = 0;
            while (i5 < v52) {
                short index = bb.readShort();
                short v46 = bb.readShort();
                Seq.FrameSound[index + oldSeqFrameOffset] = (short)(v46 & 0xFE00 | Sound.LoadSound(sounds[v46 & 0x1FF]));
                ++i5;
            }
        }
        bb.close();
        return true;
    }

    public static int GetFrameFlag(int a1, int a2) {
        return FrameFlag[a2 + SeqBase[a1]];
    }

    public static void MoveSequence(int nSprite, int a2, int a3) {
        int v4 = Sound.GetFrameSound(a2, a3);
        if (v4 != -1) {
            if (nSprite <= -1) {
                Sound.PlayLocalSound(v4, 0);
            } else {
                Sound.D3PlayFX(v4, nSprite);
            }
        }
    }
}

