/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Powerslave.Type;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pattern.Tools.Interpolation;
import ru.m210projects.Powerslave.Globals;
import ru.m210projects.Powerslave.Main;
import ru.m210projects.Powerslave.Type.PLocation;

public class PlayerStruct {
    public PLocation prevView = new PLocation();
    public int nPlayer;
    public short HealthAmount;
    public short animCount;
    public short anim_;
    public short spriteId;
    public short mummified;
    public short network;
    public short invisibility;
    public short AirAmount;
    public short seq;
    public short AirMaskAmount;
    public short KeysBitMask;
    public short MagicAmount;
    public byte[] ItemsAmount = new byte[8];
    public short[] AmmosAmount = new short[9];
    public short currentWeapon;
    public short seqOffset;
    public short weaponFire;
    public short newWeapon;
    public short weaponState;
    public short lastWeapon;
    public short RunFunc;
    public short turnAround;
    public short lastUsedWeapon;
    public float ang;
    public float horiz;
    public short eyelevel;
    public boolean crouch_toggle;
    private byte[] buf = new byte[79];
    private ByteBuffer bb = ByteBuffer.wrap(this.buf).order(ByteOrder.LITTLE_ENDIAN);

    public void UpdatePlayerLoc() {
        Interpolation.ILoc oldLoc = Main.game.pInt.getsprinterpolate(this.spriteId);
        if (oldLoc != null) {
            oldLoc.x = Engine.sprite[this.spriteId].x;
            oldLoc.y = Engine.sprite[this.spriteId].y;
            oldLoc.z = Engine.sprite[this.spriteId].z;
        } else {
            Main.game.pInt.setsprinterpolate(this.spriteId, Engine.sprite[this.spriteId]);
        }
        Main.game.pInt.setsprinterpolate(Globals.nDoppleSprite[this.nPlayer], Engine.sprite[Globals.nDoppleSprite[this.nPlayer]]);
        this.prevView.x = Engine.sprite[this.spriteId].x;
        this.prevView.y = Engine.sprite[this.spriteId].y;
        this.prevView.z = Engine.sprite[this.spriteId].z + this.eyelevel;
        this.prevView.ang = this.ang;
        this.prevView.horiz = this.horiz;
    }

    public static int size(boolean isGDX) {
        if (isGDX) {
            return 79;
        }
        return 64;
    }

    public byte[] getBytes(boolean isGDX) {
        this.bb.rewind();
        this.bb.putShort(this.HealthAmount);
        this.bb.putShort(this.animCount);
        this.bb.putShort(this.anim_);
        this.bb.putShort(this.spriteId);
        this.bb.putShort(this.mummified);
        this.bb.putShort(this.network);
        this.bb.putShort(this.invisibility);
        this.bb.putShort(this.AirAmount);
        this.bb.putShort(this.seq);
        this.bb.putShort(this.AirMaskAmount);
        this.bb.putShort(this.KeysBitMask);
        this.bb.putShort(this.MagicAmount);
        this.bb.put(this.ItemsAmount);
        int i = 0;
        while (i < 9) {
            this.bb.putShort(this.AmmosAmount[i]);
            ++i;
        }
        this.bb.putShort(this.currentWeapon);
        this.bb.putShort(this.seqOffset);
        this.bb.putShort(this.weaponFire);
        this.bb.putShort(this.newWeapon);
        this.bb.putShort(this.weaponState);
        this.bb.putShort(this.lastWeapon);
        this.bb.putShort(this.RunFunc);
        if (isGDX) {
            this.bb.putShort(this.turnAround);
            this.bb.putShort(this.lastUsedWeapon);
            this.bb.putFloat(this.ang);
            this.bb.putFloat(this.horiz);
            this.bb.putShort(this.eyelevel);
            this.bb.put(this.crouch_toggle ? (byte)1 : 0);
        }
        return this.buf;
    }

    public void setBytes(Resource bb, boolean isGDX) {
        this.HealthAmount = bb.readShort();
        this.animCount = bb.readShort();
        this.anim_ = bb.readShort();
        this.spriteId = bb.readShort();
        this.mummified = bb.readShort();
        this.network = bb.readShort();
        this.invisibility = bb.readShort();
        this.AirAmount = bb.readShort();
        this.seq = bb.readShort();
        this.AirMaskAmount = bb.readShort();
        this.KeysBitMask = bb.readShort();
        this.MagicAmount = bb.readShort();
        bb.read(this.ItemsAmount);
        int i = 0;
        while (i < 9) {
            this.AmmosAmount[i] = bb.readShort();
            ++i;
        }
        this.currentWeapon = bb.readShort();
        this.seqOffset = bb.readShort();
        this.weaponFire = bb.readShort();
        this.newWeapon = bb.readShort();
        this.weaponState = bb.readShort();
        this.lastWeapon = bb.readShort();
        this.RunFunc = bb.readShort();
        if (isGDX) {
            this.turnAround = bb.readShort();
            this.lastUsedWeapon = bb.readShort();
            this.ang = bb.readFloat().floatValue();
            this.horiz = bb.readFloat().floatValue();
            this.eyelevel = bb.readShort();
            this.crouch_toggle = bb.readBoolean();
        }
    }

    public void reset() {
        this.HealthAmount = 0;
        this.animCount = 0;
        this.anim_ = 0;
        this.spriteId = 0;
        this.mummified = 0;
        this.network = 0;
        this.invisibility = 0;
        this.AirAmount = 0;
        this.seq = 0;
        this.AirMaskAmount = 0;
        this.KeysBitMask = 0;
        this.MagicAmount = 0;
        Arrays.fill(this.ItemsAmount, (byte)0);
        Arrays.fill(this.AmmosAmount, (short)0);
        this.currentWeapon = 0;
        this.seqOffset = 0;
        this.weaponFire = 0;
        this.newWeapon = 0;
        this.weaponState = 0;
        this.lastWeapon = 0;
        this.RunFunc = 0;
        this.turnAround = 0;
        this.lastUsedWeapon = 0;
        this.ang = 0.0f;
        this.horiz = 92.0f;
        this.eyelevel = (short)-14080;
        this.crouch_toggle = false;
    }

    public void copy(PlayerStruct src) {
        this.HealthAmount = src.HealthAmount;
        this.animCount = src.animCount;
        this.anim_ = src.anim_;
        this.spriteId = src.spriteId;
        this.mummified = src.mummified;
        this.network = src.network;
        this.invisibility = src.invisibility;
        this.AirAmount = src.AirAmount;
        this.seq = src.seq;
        this.AirMaskAmount = src.AirMaskAmount;
        this.KeysBitMask = src.KeysBitMask;
        this.MagicAmount = src.MagicAmount;
        System.arraycopy(src.ItemsAmount, 0, this.ItemsAmount, 0, this.ItemsAmount.length);
        System.arraycopy(src.AmmosAmount, 0, this.AmmosAmount, 0, this.AmmosAmount.length);
        this.currentWeapon = src.currentWeapon;
        this.seqOffset = src.seqOffset;
        this.weaponFire = src.weaponFire;
        this.newWeapon = src.newWeapon;
        this.weaponState = src.weaponState;
        this.lastWeapon = src.lastWeapon;
        this.RunFunc = src.RunFunc;
        this.turnAround = src.turnAround;
        this.lastUsedWeapon = src.lastUsedWeapon;
        this.ang = src.ang;
        this.horiz = src.horiz;
        this.eyelevel = src.eyelevel;
        this.crouch_toggle = src.crouch_toggle;
    }
}

