/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck;

import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.utils.ByteArray;
import java.util.Arrays;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildMessage;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.DirectoryEntry;
import ru.m210projects.Build.FileHandle.FileEntry;
import ru.m210projects.Build.FileHandle.Group;
import ru.m210projects.Build.FileHandle.GroupResource;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Net.Mmulti;
import ru.m210projects.Build.OnSceenDisplay.Console;
import ru.m210projects.Build.OnSceenDisplay.OSDCOMMAND;
import ru.m210projects.Build.OnSceenDisplay.OSDCVARFUNC;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Build.Settings.BuildConfig;
import ru.m210projects.Build.Types.LittleEndian;
import ru.m210projects.Redneck.Animate;
import ru.m210projects.Redneck.Config;
import ru.m210projects.Redneck.Factory.RREngine;
import ru.m210projects.Redneck.Factory.RRFactory;
import ru.m210projects.Redneck.Factory.RRMenuHandler;
import ru.m210projects.Redneck.Factory.RRNetwork;
import ru.m210projects.Redneck.Fonts.GameFont;
import ru.m210projects.Redneck.Fonts.MenuFont;
import ru.m210projects.Redneck.Gamedef;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.LoadSave;
import ru.m210projects.Redneck.Menus.GameMenu;
import ru.m210projects.Redneck.Menus.MainMenu;
import ru.m210projects.Redneck.Menus.MenuCorruptGame;
import ru.m210projects.Redneck.Menus.TrackPlayerMenu;
import ru.m210projects.Redneck.Player;
import ru.m210projects.Redneck.Premap;
import ru.m210projects.Redneck.ResourceHandler;
import ru.m210projects.Redneck.Screens.AnmScreen;
import ru.m210projects.Redneck.Screens.DemoScreen;
import ru.m210projects.Redneck.Screens.DisconnectScreen;
import ru.m210projects.Redneck.Screens.EndScreen;
import ru.m210projects.Redneck.Screens.GameScreen;
import ru.m210projects.Redneck.Screens.LoadingScreen;
import ru.m210projects.Redneck.Screens.MVEScreen;
import ru.m210projects.Redneck.Screens.MenuScreen;
import ru.m210projects.Redneck.Screens.NetScreen;
import ru.m210projects.Redneck.Screens.PrecacheScreen;
import ru.m210projects.Redneck.Screens.StatisticScreen;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.Types.Animwalltype;
import ru.m210projects.Redneck.Types.PlayerOrig;
import ru.m210projects.Redneck.Types.PlayerStruct;
import ru.m210projects.Redneck.Types.RTS;
import ru.m210projects.Redneck.Types.Weaponhit;

public class Main
extends BuildGame {
    public static final String appdef = "rrgdx.def";
    public static AnmScreen gAnmScreen;
    public static MVEScreen gMveScreen;
    public static MenuScreen gMenuScreen;
    public static LoadingScreen gLoadingScreen;
    public static GameScreen gGameScreen;
    public static DemoScreen gDemoScreen;
    public static StatisticScreen gStatisticScreen;
    public static EndScreen gEndScreen;
    public static NetScreen gNetScreen;
    public static DisconnectScreen gDisconnectScreen;
    public static PrecacheScreen gPrecacheScreen;
    public static UserFlag mUserFlag;
    public static Main game;
    public static RREngine engine;
    public static Config cfg;
    public RRMenuHandler menu;
    public RRNetwork net;
    private Runnable rMenu = new Runnable(){

        @Override
        public void run() {
            Sounds.StopAllSounds();
            Globals.ud.level_number = 0;
            Globals.ud.multimode = 1;
            Globals.mFakeMultiplayer = false;
            if (!Main.this.menu.gShowMenu) {
                Main.this.menu.mOpen(Main.this.menu.mMenus[0], -1);
            }
            if (Mmulti.numplayers > 1 || Main.gDemoScreen.demofiles.size() == 0 || Main.cfg.gDemoSeq == 0 || !gDemoScreen.showDemo()) {
                Main.this.changeScreen(gMenuScreen);
            }
        }
    };

    static {
        mUserFlag = UserFlag.None;
    }

    public Main(BuildConfig dcfg, String appname, String sversion, boolean isDemo, boolean isRelease) {
        super(dcfg, appname, sversion, isRelease);
        game = this;
        cfg = (Config)dcfg;
    }

    public Main(BuildConfig dcfg, String appname, String sversion, boolean isDemo) {
        this(dcfg, appname, sversion, isDemo, true);
    }

    @Override
    public BuildFactory getFactory() {
        return new RRFactory(this);
    }

    @Override
    public boolean init() throws Exception {
        FileEntry filgdx;
        this.net = (RRNetwork)this.pNet;
        this.ConsoleInit();
        Premap.genspriteremaps();
        Gamedef.compilecons();
        engine.inittimer(120);
        ResourceHandler.InitSpecialTextures();
        this.InitUserDefs();
        RTS.RTS_Init(Globals.ud.rtsname);
        if (RTS.numlumps != 0) {
            Console.Println("Using .RTS file:" + Globals.ud.rtsname);
        }
        Sounds.SoundStartup();
        Sounds.MusicStartup();
        Sounds.searchCDtracks();
        Animate.initanimations();
        LoadSave.FindSaves();
        int i = 0;
        while (i < 16) {
            Globals.ps[i] = new PlayerStruct();
            Globals.po[i] = new PlayerOrig();
            ++i;
        }
        Player.InitPlayers();
        i = 0;
        while (i < 512) {
            Globals.animwall[i] = new Animwalltype();
            ++i;
        }
        i = 0;
        while (i < Engine.MAXSPRITES) {
            Globals.hittype[i] = new Weaponhit();
            ++i;
        }
        Console.Println("Initializing def-scripts...");
        Gameutils.loadGdxDef(this.baseDef, appdef, "rrgdx.dat");
        if (Main.cfg.autoloadFolder) {
            Console.Println("Initializing autoload folder");
            DirectoryEntry autoload = BuildGdx.compat.checkDirectory("autoload");
            if (autoload != null) {
                for (FileEntry file : autoload.getFiles().values()) {
                    if (file.getExtension().equals("zip")) {
                        GroupResource def;
                        Group group = BuildGdx.cache.add(file.getPath());
                        if (group == null || (def = group.open(appdef)) == null) continue;
                        byte[] buf = def.getBytes();
                        this.baseDef.loadScript(file.getName(), buf);
                        def.close();
                        continue;
                    }
                    if (!file.getExtension().equals("def")) continue;
                    this.baseDef.loadScript(file);
                }
            }
        }
        if ((filgdx = BuildGdx.compat.checkFile(appdef)) != null) {
            this.baseDef.loadScript(filgdx);
        }
        this.setDefs(this.baseDef);
        this.menu.mMenus[18] = new TrackPlayerMenu();
        this.menu.mMenus[0] = new MainMenu(this);
        this.menu.mMenus[1] = new GameMenu(this);
        this.menu.mMenus[17] = new MenuCorruptGame(this);
        gAnmScreen = new AnmScreen(this);
        gMveScreen = new MVEScreen(this);
        gMenuScreen = new MenuScreen(this);
        gLoadingScreen = new LoadingScreen(this);
        gGameScreen = new GameScreen(this);
        gDemoScreen = new DemoScreen(this);
        gStatisticScreen = new StatisticScreen(this);
        gEndScreen = new EndScreen();
        gNetScreen = new NetScreen(this);
        gDisconnectScreen = new DisconnectScreen(this);
        gPrecacheScreen = new PrecacheScreen(this);
        gDemoScreen.demoscan();
        return true;
    }

    public static boolean IsOriginalDemo() {
        ScreenAdapter screen = (ScreenAdapter)game.getScreen();
        if (screen instanceof DemoScreen) {
            return ((DemoScreen)screen).IsOriginalGame();
        }
        if (screen instanceof GameScreen) {
            return ((GameScreen)screen).IsOriginalGame();
        }
        return false;
    }

    @Override
    public boolean setDefs(DefScript script) {
        if (super.setDefs(script)) {
            ((GameFont)this.getFont(1)).update();
            ((MenuFont)this.getFont(2)).update();
            return true;
        }
        return false;
    }

    @Override
    public void show() {
        Globals.uGameFlags = 0;
        Globals.kGameCrash = false;
        if (ResourceHandler.usecustomarts) {
            ResourceHandler.resetEpisodeResources();
        }
        if (Globals.ud.recstat == 1 && Globals.ud.rec != null) {
            Globals.ud.rec.close();
        }
        if (Globals.currentGame.getCON().type == 2 && gMveScreen.init("redint.mve")) {
            gMveScreen.setCallback(this.rMenu);
            this.setScreen(gMveScreen.escSkipping(true));
        } else if (gAnmScreen.init("rr_intro.anm", 0)) {
            gAnmScreen.setCallback(new Runnable(){

                @Override
                public void run() {
                    if (gAnmScreen.init("redneck.anm", 1)) {
                        gAnmScreen.setCallback(new Runnable(){

                            @Override
                            public void run() {
                                if (gAnmScreen.init("xatlogo.anm", 2)) {
                                    Main.this.setScreen(gAnmScreen.setCallback(Main.this.rMenu).escSkipping(false));
                                }
                            }
                        });
                        Main.this.setScreen(gAnmScreen.escSkipping(false));
                    }
                }
            }).setSkipping(this.rMenu);
            this.setScreen(gAnmScreen.escSkipping(false));
        } else {
            this.setScreen(gLoadingScreen);
            BuildGdx.app.postRunnable(this.rMenu);
        }
    }

    public void InitUserDefs() {
        Globals.ud.setDefaults(cfg);
        Globals.ud.god = false;
        Globals.ud.cashman = 0;
        Globals.ud.player_skill = 2;
    }

    public void ConsoleInit() {
        Console.Println("Initializing on-screen display system");
        Console.setVersion(String.valueOf(this.appname) + " " + this.sversion, 10, Console.OSDTEXT_GOLD);
        Console.RegisterCvar(new OSDCOMMAND("restart", "restart", new OSDCVARFUNC(){

            @Override
            public void execute() {
                Premap.LeaveMap();
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("net_player", "net_player", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Console.osd_argc != 2) {
                    Console.Println("net_player: num");
                    return;
                }
                try {
                    String num = Console.osd_argv[1];
                    int pnum = Integer.parseInt(num);
                    int p = Main.game.net.PutPacketByte(Premap.packbuf, 0, 10);
                    p = Main.game.net.PutPacketByte(Premap.packbuf, p, pnum);
                    int trail = Main.game.net.gNetFifoTail;
                    if (Mmulti.myconnectindex == Mmulti.connecthead) {
                        ++trail;
                    }
                    LittleEndian.putInt(Premap.packbuf, p, trail);
                    Main.game.net.PlayerSyncRequest = pnum;
                    Main.game.net.sendtoall(Premap.packbuf, p += 4);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("quicksave", "quicksave: performs a quick save", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Globals.ud.multimode != 1 || Mmulti.numplayers > 1) {
                    Console.Println("quicksave: Single player only");
                    return;
                }
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    LoadSave.quicksave();
                } else {
                    Console.Println("quicksave: not in a game");
                }
            }
        }));
        Console.RegisterCvar(new OSDCOMMAND("quickload", "quickload: performs a quick load", new OSDCVARFUNC(){

            @Override
            public void execute() {
                if (Globals.ud.multimode != 1 || Mmulti.numplayers > 1) {
                    Console.Println("quickload: Single player only");
                    return;
                }
                if (Main.this.isCurrentScreen(gGameScreen)) {
                    LoadSave.quickload();
                } else {
                    Console.Println("quickload: not in a game");
                }
            }
        }));
    }

    public void dassert(String msg) {
        if (Globals.kGameCrash) {
            return;
        }
        this.ThrowError(msg);
        System.exit(0);
    }

    public boolean GameMessage(String text, boolean question) {
        if (!question) {
            BuildGdx.message.show("Warning: ", text, BuildMessage.MessageType.Info);
            Console.Println("Warning: " + text, Console.OSDTEXT_YELLOW);
            return true;
        }
        Console.Println("Warning: " + text, Console.OSDTEXT_YELLOW);
        return BuildGdx.message.show("Warning: ", text, BuildMessage.MessageType.Question);
    }

    public void GameCrash(String errorText) {
        BuildGdx.message.show("Error: ", errorText, BuildMessage.MessageType.Info);
        Console.Println("Game error: " + errorText, Console.OSDTEXT_RED);
        Globals.kGameCrash = true;
    }

    public void Disconnect() {
        if (Globals.ud.recstat == 1 && Globals.ud.rec != null) {
            Globals.ud.rec.close();
        }
        if (gDisconnectScreen != null) {
            this.changeScreen(gDisconnectScreen);
        }
    }

    @Override
    public void dispose() {
        if (Globals.ud.rec != null) {
            Globals.ud.rec.close();
        }
        super.dispose();
    }

    @Override
    protected byte[] reportData() {
        byte[] out = null;
        String text = "Mapname: " + Globals.boardfilename;
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + "UserFlag: " + (Object)((Object)mUserFlag);
        text = String.valueOf(text) + "\r\n";
        if (mUserFlag == UserFlag.Addon && Globals.currentGame != null) {
            try {
                FileEntry addon = Globals.currentGame.getFile();
                text = addon != null && Globals.currentGame.isPackage() ? String.valueOf(text) + "Episode filename: " + addon.getPath() + ":" + Globals.currentGame.ConName : String.valueOf(text) + "Episode filename: " + Globals.currentGame.getDirectory().checkFile(Globals.currentGame.ConName).getPath();
                text = String.valueOf(text) + "\r\n";
            }
            catch (Exception e) {
                text = String.valueOf(text) + "Episode filename get error \r\n";
            }
        }
        text = String.valueOf(text) + "volume " + (Globals.ud.volume_number + 1);
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + "level " + (Globals.ud.level_number + 1);
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + "nDifficulty: " + Globals.ud.player_skill;
        text = String.valueOf(text) + "\r\n";
        if (Globals.ps != null) {
            text = String.valueOf(text) + "PlayerX: " + Globals.ps[Mmulti.myconnectindex].posx;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerY: " + Globals.ps[Mmulti.myconnectindex].posy;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerZ: " + Globals.ps[Mmulti.myconnectindex].posz;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerAng: " + Globals.ps[Mmulti.myconnectindex].ang;
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + "PlayerSect: " + Globals.ps[Mmulti.myconnectindex].cursectnum;
            text = String.valueOf(text) + "\r\n";
        }
        if (mUserFlag == UserFlag.UserMap && Globals.boardfilename != null) {
            ByteArray array = new ByteArray();
            byte[] data = BuildGdx.cache.getBytes(Globals.boardfilename, 0);
            if (data != null) {
                text = String.valueOf(text) + "\r\n<------Start Map data------->\r\n";
                array.addAll(text.getBytes());
                array.addAll(data);
                array.addAll("\r\n<------End Map data------->\r\n".getBytes());
                out = Arrays.copyOf(array.items, array.size);
            }
        } else {
            out = text.getBytes();
        }
        return out;
    }

    public static enum UserFlag {
        None,
        UserMap,
        Addon;

    }
}

