/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Redneck.Screens;

import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.FileHandle.Resource;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildGame;
import ru.m210projects.Build.Pattern.ScreenAdapters.SkippableAdapter;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Render.GLRenderer;
import ru.m210projects.Redneck.Globals;
import ru.m210projects.Redneck.Sounds;
import ru.m210projects.Redneck.Types.MVEFile;

public class MVEScreen
extends SkippableAdapter {
    private Runnable callback;
    private int gCutsClock;
    private MVEFile anmfil;
    private long anmtime;
    private long LastMS;

    public MVEScreen(BuildGame game) {
        super(game);
    }

    @Override
    public void show() {
        if (this.game.pMenu.gShowMenu) {
            this.game.pMenu.mClose();
        }
        this.engine.sampletimer();
        this.LastMS = this.engine.getticks();
        Engine.totalclock = 0;
        this.gCutsClock = 0;
        Sounds.StopAllSounds();
        Sounds.sndStopMusic();
    }

    @Override
    public void hide() {
        this.engine.setbrightness(Globals.ud.brightness >> 2, Engine.palette, GLRenderer.GLInvalidateFlag.All);
    }

    @Override
    public void skip() {
        this.close();
        super.skip();
    }

    public MVEScreen setCallback(Runnable callback) {
        this.callback = callback;
        this.setSkipping(callback);
        return this;
    }

    public boolean init(String fn) {
        if (this.anmfil != null) {
            return false;
        }
        Resource dat = BuildGdx.cache.open(fn, 0);
        if (dat == null) {
            return false;
        }
        try {
            this.anmfil = new MVEFile(dat);
            Engine.tilesizx[Globals.TILE_ANIM] = (short)this.anmfil.getHeight();
            Engine.tilesizy[Globals.TILE_ANIM] = (short)this.anmfil.getWidth();
            this.anmtime = 0L;
            this.LastMS = -1L;
            Engine.waloff[Globals.TILE_ANIM] = null;
            byte[] pal = this.anmfil.getPalette();
            this.engine.changepalette(pal);
            int white = -1;
            int k = 0;
            int i = 0;
            while (i < 256) {
                int j = (pal[3 * i] & 0xFF) + (pal[3 * i + 1] & 0xFF) + (pal[3 * i + 2] & 0xFF);
                if (j > k) {
                    k = j;
                    white = i;
                }
                i += 3;
            }
            int palnum = 250;
            byte[] remapbuf = new byte[768];
            int i2 = 0;
            while (i2 < 768) {
                remapbuf[i2] = (byte)white;
                ++i2;
            }
            this.engine.makepalookup(palnum, remapbuf, 0, 1, 0, 1);
            i2 = 0;
            while (i2 < 256) {
                int tile = this.game.getFont(0).getTile(i2);
                if (tile >= 0) {
                    this.engine.invalidatetile(tile, palnum, -1);
                }
                ++i2;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean anmPlay() {
        if (this.anmfil != null) {
            if (this.LastMS == -1L) {
                this.LastMS = this.engine.getticks();
            }
            long ms = this.engine.getticks();
            long dt = ms - this.LastMS;
            this.anmtime += dt;
            boolean isDone = false;
            float tick = (float)this.anmfil.getRate() / 2000.0f;
            if ((float)this.anmtime >= tick) {
                isDone = this.anmfil.process();
                if (!isDone) {
                    Engine.waloff[Globals.TILE_ANIM] = this.anmfil.getFrame();
                    this.engine.invalidatetile(Globals.TILE_ANIM, 251, -1);
                }
                this.anmtime = (long)((float)this.anmtime - tick);
            }
            this.LastMS = ms;
            if (Engine.tilesizx[Globals.TILE_ANIM] <= 0) {
                return false;
            }
            if (Engine.waloff[Globals.TILE_ANIM] != null) {
                this.engine.rotatesprite(0xA00000, 0x640000, Pragmas.divscale(200L, Engine.tilesizx[Globals.TILE_ANIM], 16), 512, Globals.TILE_ANIM, 0, 251, 78, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            }
            return !isDone;
        }
        return false;
    }

    @Override
    public void draw(float delta) {
        if (!this.anmPlay() && this.skipCallback != null) {
            this.close();
            if (this.callback != null) {
                BuildGdx.app.postRunnable(this.callback);
                this.callback = null;
            }
        }
        if (this.game.pInput.ctrlKeyStatus(256)) {
            this.gCutsClock = Engine.totalclock;
        }
        int shade = 16 + Pragmas.mulscale(64L, Engine.sintable[20 * Engine.totalclock & 0x7FF], 16);
        if (Engine.totalclock - this.gCutsClock < 200 && this.escSkip) {
            this.game.getFont(0).drawText(160, 5, "Press ESC to skip", shade, 250, BuildFont.TextAlign.Center, 2, true);
        }
    }

    public boolean isInited() {
        return this.anmfil != null;
    }

    public void close() {
        this.anmfil.close();
        this.anmfil = null;
    }
}

