/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Tekwar.Screens;

import com.badlogic.gdx.ScreenAdapter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ru.m210projects.Build.Architecture.BuildFrame;
import ru.m210projects.Build.Architecture.BuildGdx;
import ru.m210projects.Build.Architecture.BuildGraphics;
import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Gameutils;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.BuildSmacker.SMKFile;
import ru.m210projects.Tekwar.Main;
import ru.m210projects.Tekwar.Teksnd;

public abstract class SmkMenu
extends ScreenAdapter {
    private final int kSMKTile = Engine.MAXTILES - 3;
    private SMKFile smkfil;
    protected int currmission;
    protected MessageType message = MessageType.NONE;
    private Runnable chooseCallback;
    private float delayclock;
    private float helpclock;
    private boolean rebuild;
    protected Main game;

    public SmkMenu(Main game) {
        this.game = game;
    }

    public abstract int skip();

    public abstract void keyUp();

    public abstract void keyDown();

    public abstract void keyLeft();

    public abstract void keyRight();

    public abstract int loadGame();

    public abstract String init();

    public abstract void rebuildFrame();

    public abstract boolean mouseHandler(int var1, int var2);

    public SmkMenu setCallback(Runnable chooseCallback) {
        this.chooseCallback = chooseCallback;
        return this;
    }

    @Override
    public synchronized void show() {
        this.rebuild = true;
        this.delayclock = 0.0f;
        this.helpclock = 0.0f;
        this.message = MessageType.NONE;
        BuildGdx.input.setCursorCatched(false);
        this.game.pInput.ctrlResetKeyStatus();
        this.init(this.init());
    }

    @Override
    public void hide() {
        if (this.smkfil == null) {
            return;
        }
        BuildGdx.input.setCursorCatched(true);
        Engine.waloff[this.kSMKTile] = null;
        this.smkfil = null;
    }

    @Override
    public synchronized void render(float delta) {
        if (this.smkfil == null) {
            return;
        }
        if (this.rebuild || this.mouseHandler(BuildGdx.input.getX(), BuildGdx.input.getY())) {
            this.rebuildFrame();
            Engine.waloff[this.kSMKTile] = this.smkfil.getVideoBuffer().array();
            this.game.pEngine.invalidatetile(this.kSMKTile, 0, -1);
            this.rebuild = false;
        }
        this.DrawMenu();
        this.keyhandler();
    }

    private int keyhandler() {
        int mission = this.skip();
        if (mission != -1) {
            return mission;
        }
        if (this.message == MessageType.EXIT) {
            if (this.game.pInput.ctrlKeyStatusOnce(53)) {
                this.game.changeScreen(Main.gCreditsScreen);
            }
            if (this.game.pInput.ctrlKeyStatusOnce(42) || this.game.pInput.ctrlKeyStatusOnce(131)) {
                this.resetStatus();
            }
            return -1;
        }
        if (this.delayclock > 0.0f) {
            this.delayclock = Gameutils.BClipLow(this.delayclock - BuildGdx.graphics.getDeltaTime(), 0);
            if (this.delayclock == 0.0f) {
                this.resetStatus();
            }
            return -1;
        }
        this.helpclock += BuildGdx.graphics.getDeltaTime();
        if (this.helpclock > 8.0f && this.message != MessageType.HELP) {
            this.HelpMessage();
        }
        if (this.game.pInput.ctrlKeyStatusOnce(256)) {
            if (this.game.pInput.ctrlKeyStatusOnce(36)) {
                this.HelpMessage();
            } else if (this.game.pInput.ctrlKeyStatusOnce(131)) {
                if (this.message == MessageType.HELP) {
                    this.resetStatus();
                } else {
                    this.ExitMessage();
                }
            } else if (this.game.pInput.ctrlKeyStatusOnce(21)) {
                this.message = MessageType.NONE;
                this.keyLeft();
                this.helpclock = 0.0f;
                this.rebuild = true;
            } else if (this.game.pInput.ctrlKeyStatusOnce(22)) {
                this.message = MessageType.NONE;
                this.keyRight();
                this.helpclock = 0.0f;
                this.rebuild = true;
            } else if (this.game.pInput.ctrlKeyStatusOnce(19)) {
                this.message = MessageType.NONE;
                this.keyUp();
                this.helpclock = 0.0f;
                this.rebuild = true;
            } else if (this.game.pInput.ctrlKeyStatusOnce(20)) {
                this.message = MessageType.NONE;
                this.keyDown();
                this.helpclock = 0.0f;
                this.rebuild = true;
            } else {
                if (this.game.pInput.ctrlKeyStatusOnce(40)) {
                    this.loadGame();
                    if (this.chooseCallback != null) {
                        this.chooseCallback.run();
                    }
                    return 8;
                }
                if (this.game.pInput.ctrlKeyStatusOnce(66) || this.game.pInput.ctrlKeyStatusOnce(62)) {
                    this.helpclock = 0.0f;
                    this.rebuild = true;
                    if (this.chooseCallback != null) {
                        this.chooseCallback.run();
                    }
                    return this.currmission;
                }
            }
        }
        return -1;
    }

    protected void DrawFrame(int fn) {
        if (this.smkfil != null && fn < this.smkfil.getFrames()) {
            this.smkfil.setFrame(fn - 1);
        }
    }

    protected void resetStatus() {
        this.helpclock = 0.0f;
        this.message = MessageType.NONE;
        this.rebuild = true;
    }

    protected void AccessWarning() {
        Teksnd.playsound(55, 0, 0, 0, 1);
        this.message = MessageType.ACCESS;
        this.delayclock = 1.0f;
        this.rebuild = true;
    }

    protected void HelpMessage() {
        this.message = MessageType.HELP;
        Teksnd.playsound(110, 0, 0, 0, 1);
        this.rebuild = true;
    }

    protected void ExitMessage() {
        this.message = MessageType.EXIT;
        Teksnd.playsound(110, 0, 0, 0, 1);
        this.rebuild = true;
    }

    private void init(String name) {
        byte[] smkbuf = BuildGdx.cache.getBytes(name, 0);
        if (smkbuf == null) {
            return;
        }
        ByteBuffer bb = ByteBuffer.wrap(smkbuf);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        try {
            this.smkfil = new SMKFile(bb);
        }
        catch (Exception e) {
            return;
        }
        this.smkfil.setEnable(SMKFile.Track.All, SMKFile.Track.Video.mask());
        Engine.tilesizx[this.kSMKTile] = (short)this.smkfil.getHeight();
        Engine.tilesizy[this.kSMKTile] = (short)this.smkfil.getWidth();
    }

    private void DrawMenu() {
        this.game.pEngine.clearview(0);
        if (this.smkfil == null) {
            return;
        }
        this.game.pEngine.setview(0, 0, Engine.xdim - 1, Engine.ydim - 1);
        int frames = Engine.xdim / Engine.tilesizx[406];
        int x = 160;
        int i = 0;
        while (i <= frames) {
            this.game.pEngine.rotatesprite(x << 16, 0x640000, 65536, 0, 406, 0, 0, 266, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
            x += Engine.tilesizx[406];
            ++i;
        }
        this.game.pEngine.rotatesprite(Engine.xdim << 15, Engine.ydim << 15, Pragmas.divscale(Engine.ydim, Engine.tilesizx[this.kSMKTile], 16), 512, this.kSMKTile, 0, 0, 12, 0, 0, Engine.xdim - 1, Engine.ydim - 1);
        this.game.menu.mDrawMouse(BuildGdx.input.getX(), BuildGdx.input.getY());
        this.game.pEngine.nextpage();
    }

    @Override
    public void pause() {
        if (BuildGdx.graphics.getFrameType() == BuildFrame.FrameType.GL) {
            BuildGdx.graphics.extra(BuildGraphics.Option.GLDefConfiguration, new Object[0]);
        }
    }

    @Override
    public void resume() {
        this.game.updateColorCorrection();
    }

    protected static enum MessageType {
        NONE(-1),
        USER(0),
        EXIT(1),
        ACCESS(2),
        HELP(3);

        private int num;

        private MessageType(int num) {
            this.num = num;
        }

        public int get() {
            return this.num;
        }

        public void set(int num) {
            this.num = num;
        }
    }
}

