/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Enemies;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Actor;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Enemies.Coolie;
import ru.m210projects.Wang.Enemies.Decision;
import ru.m210projects.Wang.Enemies.Personality;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Sprites;
import ru.m210projects.Wang.Track;
import ru.m210projects.Wang.Type.ATTRIBUTE;
import ru.m210projects.Wang.Type.Actor_Action_Set;
import ru.m210projects.Wang.Type.Animator;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Type.State;
import ru.m210projects.Wang.Type.USER;
import ru.m210projects.Wang.Weapon;

public class Goro {
    public static final int GORO_PAIN_R0 = 1489;
    public static final int GORO_PAIN_R1 = 1492;
    public static final int GORO_PAIN_R2 = 1495;
    public static final int GORO_PAIN_R3 = 1481;
    public static final int GORO_PAIN_R4 = 1485;
    private static final Decision[] GoroBattle = new Decision[]{new Decision(697, Ai.InitActorMoveCloser), new Decision(700, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] GoroOffense = new Decision[]{new Decision(797, Ai.InitActorMoveCloser), new Decision(800, Ai.InitActorAttackNoise), new Decision(1024, Ai.InitActorAttack)};
    private static final Decision[] GoroBroadcast = new Decision[]{new Decision(3, Ai.InitActorAmbientNoise), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] GoroSurprised = new Decision[]{new Decision(701, Ai.InitActorMoveCloser), new Decision(1024, Ai.InitActorDecide)};
    private static final Decision[] GoroEvasive = new Decision[]{new Decision(10, Ai.InitActorEvade), new Decision(1024, Ai.InitActorMoveCloser)};
    private static final Decision[] GoroLostTarget = new Decision[]{new Decision(900, Ai.InitActorFindPlayer), new Decision(1024, Ai.InitActorWanderAround)};
    private static final Decision[] GoroCloseRange = new Decision[]{new Decision(700, Ai.InitActorAttack), new Decision(1024, Ai.InitActorReposition)};
    private static final Personality GoroPersonality = new Personality(GoroBattle, GoroOffense, GoroBroadcast, GoroSurprised, GoroEvasive, GoroLostTarget, GoroCloseRange, GoroCloseRange);
    private static final ATTRIBUTE GoroAttrib;
    public static final int GORO_RUN_RATE = 18;
    private static final Animator DoGoroMove;
    private static final State[][] s_GoroRun;
    public static final int GORO_CHOP_RATE = 14;
    private static final Animator NullGoro;
    private static final Animator InitGoroChop;
    private static final State[][] s_GoroChop;
    public static final int GORO_SPELL_RATE = 6;
    public static final int GORO_SPELL_PAUSE = 30;
    private static final Animator InitEnemyFireball;
    private static final State[][] s_GoroSpell;
    public static final int GORO_STAND_RATE = 12;
    private static final State[][] s_GoroStand;
    public static final int GORO_PAIN_RATE = 12;
    private static final Animator DoGoroPain;
    private static final State[][] s_GoroPain;
    public static final int GORO_DIE_RATE = 16;
    private static final State[] s_GoroDie;
    private static final State[] s_GoroDead;
    private static final Actor_Action_Set GoroActionSet;

    static {
        short[] sArray = new short[4];
        sArray[0] = 3;
        sArray[2] = -2;
        sArray[3] = -3;
        int[] nArray = new int[10];
        nArray[0] = 101;
        nArray[1] = 102;
        nArray[3] = 103;
        nArray[4] = 104;
        nArray[5] = 106;
        nArray[6] = 105;
        GoroAttrib = new ATTRIBUTE(new short[]{160, 180, 200, 230}, sArray, 3, nArray);
        DoGoroMove = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Goro.DoGoroMove(SpriteNum) != 0;
            }
        };
        s_GoroRun = new State[][]{{new State(1469, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1470, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1471, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1472, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove)}, {new State(1473, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1474, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1475, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1476, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove)}, {new State(1477, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1478, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1479, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1480, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove)}, {new State(1481, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1482, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1483, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1484, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove)}, {new State(1485, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1486, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1487, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove), new State(1488, 0x12 | Gameutils.SF_TIC_ADJUST, DoGoroMove)}};
        NullGoro = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Goro.NullGoro(SpriteNum) != 0;
            }
        };
        InitGoroChop = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Weapon.InitGoroChop(SpriteNum) != 0;
            }
        };
        s_GoroChop = new State[][]{{new State(1489, 14, NullGoro), new State(1490, 14, NullGoro), new State(1491, 14, NullGoro), new State(1491, Gameutils.SF_QUICK_CALL, InitGoroChop), new State(1491, 14, NullGoro), new State(1491, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1491, 14, DoGoroMove).setNext()}, {new State(1492, 14, NullGoro), new State(1493, 14, NullGoro), new State(1494, 14, NullGoro), new State(1494, Gameutils.SF_QUICK_CALL, InitGoroChop), new State(1494, 14, NullGoro), new State(1494, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1494, 14, DoGoroMove).setNext()}, {new State(1495, 14, NullGoro), new State(1496, 14, NullGoro), new State(1497, 14, NullGoro), new State(1497, Gameutils.SF_QUICK_CALL, InitGoroChop), new State(1497, 14, NullGoro), new State(1497, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1497, 14, DoGoroMove).setNext()}, {new State(1481, 14, NullGoro), new State(1482, 14, NullGoro), new State(1483, 14, NullGoro), new State(1483, Gameutils.SF_QUICK_CALL, InitGoroChop), new State(1483, 14, NullGoro), new State(1483, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1483, 14, DoGoroMove).setNext()}, {new State(1485, 14, NullGoro), new State(1486, 14, NullGoro), new State(1487, 14, NullGoro), new State(1487, Gameutils.SF_QUICK_CALL, InitGoroChop), new State(1487, 14, NullGoro), new State(1487, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1487, 14, DoGoroMove).setNext()}};
        InitEnemyFireball = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Weapon.InitEnemyFireball(SpriteNum) != 0;
            }
        };
        s_GoroSpell = new State[][]{{new State(1513, 30, NullGoro), new State(1514, 30, NullGoro), new State(1514, 6, InitEnemyFireball), new State(1514, 6, NullGoro), new State(1514, 6, InitEnemyFireball), new State(1514, 6, NullGoro), new State(1514, 6, InitEnemyFireball), new State(1514, 30, NullGoro), new State(1514, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1514, 6, DoGoroMove).setNext()}, {new State(1515, 30, NullGoro), new State(1516, 30, NullGoro), new State(1516, 6, InitEnemyFireball), new State(1516, 6, NullGoro), new State(1516, 6, InitEnemyFireball), new State(1516, 6, NullGoro), new State(1516, 6, InitEnemyFireball), new State(1516, 30, NullGoro), new State(1516, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1516, 6, DoGoroMove).setNext()}, {new State(1517, 30, NullGoro), new State(1518, 30, NullGoro), new State(1518, 6, InitEnemyFireball), new State(1518, 6, NullGoro), new State(1518, 6, InitEnemyFireball), new State(1518, 6, NullGoro), new State(1518, 6, InitEnemyFireball), new State(1518, 30, NullGoro), new State(1518, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1518, 6, DoGoroMove).setNext()}, {new State(1481, 30, NullGoro), new State(1482, 30, NullGoro), new State(1482, 6, InitEnemyFireball), new State(1482, 6, NullGoro), new State(1482, 6, InitEnemyFireball), new State(1482, 6, NullGoro), new State(1482, 6, InitEnemyFireball), new State(1482, 30, NullGoro), new State(1482, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1482, 6, DoGoroMove).setNext()}, {new State(1485, 30, NullGoro), new State(1486, 30, NullGoro), new State(1486, 6, InitEnemyFireball), new State(1486, 6, NullGoro), new State(1486, 6, InitEnemyFireball), new State(1486, 6, NullGoro), new State(1486, 6, InitEnemyFireball), new State(1486, 30, NullGoro), new State(1486, Gameutils.SF_QUICK_CALL, Ai.InitActorDecide), new State(1486, 6, DoGoroMove).setNext()}};
        s_GoroStand = new State[][]{{new State(1489, 12, DoGoroMove).setNext()}, {new State(1492, 12, DoGoroMove).setNext()}, {new State(1495, 12, DoGoroMove).setNext()}, {new State(1481, 12, DoGoroMove).setNext()}, {new State(1485, 12, DoGoroMove).setNext()}};
        DoGoroPain = new Animator(){

            @Override
            public boolean invoke(int SpriteNum) {
                return Goro.DoGoroPain(SpriteNum) != 0;
            }
        };
        s_GoroPain = new State[][]{{new State(1489, 12, DoGoroPain).setNext()}, {new State(1492, 12, DoGoroPain).setNext()}, {new State(1495, 12, DoGoroPain).setNext()}, {new State(1481, 12, DoGoroPain).setNext()}, {new State(1485, 12, DoGoroPain).setNext()}};
        s_GoroDie = new State[]{new State(1504, 16, NullGoro), new State(1505, 16, NullGoro), new State(1506, 16, NullGoro), new State(1507, 16, NullGoro), new State(1508, 16, NullGoro), new State(1509, 16, NullGoro), new State(1510, 16, NullGoro), new State(1511, 16, NullGoro), new State(1512, 16, NullGoro), new State(1512, Gameutils.SF_QUICK_CALL, Player.QueueFloorBlood), new State(1512, 16, Actor.DoActorDebris).setNext()};
        s_GoroDead = new State[]{new State(1512, 16, Actor.DoActorDebris).setNext()};
        GoroActionSet = new Actor_Action_Set(GoroStateGroup.sg_GoroStand, GoroStateGroup.sg_GoroRun, null, null, null, null, null, null, null, null, null, GoroStateGroup.sg_GoroPain, GoroStateGroup.sg_GoroDie, null, GoroStateGroup.sg_GoroDead, null, null, new Sprites.StateGroup[]{GoroStateGroup.sg_GoroChop}, new short[]{1024}, new Sprites.StateGroup[]{GoroStateGroup.sg_GoroSpell}, new short[]{1024}, null, null, null);
    }

    public static void InitGoroStates() {
        GoroStateGroup[] goroStateGroupArray = GoroStateGroup.values();
        int n = goroStateGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            GoroStateGroup sg = goroStateGroupArray[n2];
            int rot = 0;
            while (rot < sg.group.length) {
                State.InitState(sg.group[rot]);
                ++rot;
            }
            ++n2;
        }
    }

    public static int SetupGoro(int SpriteNum) {
        USER u;
        SPRITE sp = Engine.sprite[SpriteNum];
        if (MyTypes.TEST(sp.cstat, Gameutils.CSTAT_SPRITE_RESTORE)) {
            u = Gameutils.pUser[SpriteNum];
        } else {
            Gameutils.pUser[SpriteNum] = u = Sprites.SpawnUser(SpriteNum, 1469, s_GoroRun[0][0]);
            u.Health = (short)200;
        }
        Sprites.ChangeState(SpriteNum, s_GoroRun[0][0]);
        u.Attrib = GoroAttrib;
        Ai.DoActorSetSpeed(SpriteNum, 1);
        u.StateEnd = s_GoroDie[0];
        u.Rot = GoroStateGroup.sg_GoroRun;
        Coolie.EnemyDefaults(SpriteNum, GoroActionSet, GoroPersonality);
        sp.clipdist = 128;
        u.Flags |= Gameutils.SPR_XFLIP_TOGGLE;
        return 0;
    }

    private static int NullGoro(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    private static int DoGoroPain(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        Goro.NullGoro(SpriteNum);
        u.WaitTics = (short)(u.WaitTics - 6);
        if (u.WaitTics <= 0) {
            Ai.InitActorDecide(SpriteNum);
        }
        return 0;
    }

    private static int DoGoroMove(int SpriteNum) {
        USER u = Gameutils.pUser[SpriteNum];
        if (MyTypes.TEST(u.Flags, Gameutils.SPR_SLIDING)) {
            Actor.DoActorSlide(SpriteNum);
        }
        if (u.track >= 0) {
            Track.ActorFollowTrack(SpriteNum, 6);
        } else {
            u.ActorActionFunc.invoke(SpriteNum);
        }
        Actor.KeepActorOnFloor(SpriteNum);
        Actor.DoActorSectorDamage(SpriteNum);
        return 0;
    }

    public static void GoroSaveable() {
        Saveable.SaveData(InitGoroChop);
        Saveable.SaveData(InitEnemyFireball);
        Saveable.SaveData(NullGoro);
        Saveable.SaveData(DoGoroPain);
        Saveable.SaveData(DoGoroMove);
        Saveable.SaveData(GoroPersonality);
        Saveable.SaveData(GoroAttrib);
        Saveable.SaveData(s_GoroRun);
        Saveable.SaveGroup(GoroStateGroup.sg_GoroRun);
        Saveable.SaveData(s_GoroChop);
        Saveable.SaveGroup(GoroStateGroup.sg_GoroChop);
        Saveable.SaveData(s_GoroSpell);
        Saveable.SaveGroup(GoroStateGroup.sg_GoroSpell);
        Saveable.SaveData(s_GoroStand);
        Saveable.SaveGroup(GoroStateGroup.sg_GoroStand);
        Saveable.SaveData(s_GoroPain);
        Saveable.SaveGroup(GoroStateGroup.sg_GoroPain);
        Saveable.SaveData(s_GoroDie);
        Saveable.SaveData(s_GoroDead);
        Saveable.SaveGroup(GoroStateGroup.sg_GoroDie);
        Saveable.SaveGroup(GoroStateGroup.sg_GoroDead);
        Saveable.SaveData(GoroActionSet);
    }

    static /* synthetic */ State[][] access$3() {
        return s_GoroStand;
    }

    static /* synthetic */ State[][] access$4() {
        return s_GoroRun;
    }

    static /* synthetic */ State[][] access$5() {
        return s_GoroPain;
    }

    static /* synthetic */ State[] access$6() {
        return s_GoroDie;
    }

    static /* synthetic */ State[] access$7() {
        return s_GoroDead;
    }

    static /* synthetic */ State[][] access$8() {
        return s_GoroChop;
    }

    static /* synthetic */ State[][] access$9() {
        return s_GoroSpell;
    }

    public static enum GoroStateGroup implements Sprites.StateGroup
    {
        sg_GoroStand(Goro.access$3()[0], Goro.access$3()[1], Goro.access$3()[2], Goro.access$3()[3], Goro.access$3()[4]),
        sg_GoroRun(Goro.access$4()[0], Goro.access$4()[1], Goro.access$4()[2], Goro.access$4()[3], Goro.access$4()[4]),
        sg_GoroPain(Goro.access$5()[0], Goro.access$5()[1], Goro.access$5()[2], Goro.access$5()[3], Goro.access$5()[4]),
        sg_GoroDie(new State[][]{Goro.access$6()}),
        sg_GoroDead(new State[][]{Goro.access$7()}),
        sg_GoroChop(Goro.access$8()[0], Goro.access$8()[1], Goro.access$8()[2], Goro.access$8()[3], Goro.access$8()[4]),
        sg_GoroSpell(Goro.access$9()[0], Goro.access$9()[1], Goro.access$9()[2], Goro.access$9()[3], Goro.access$9()[4]);

        private final State[][] group;
        private int index = -1;

        private GoroStateGroup(State[] ... states) {
            this.group = states;
        }

        @Override
        public State getState(int rotation, int offset) {
            return this.group[rotation][offset];
        }

        @Override
        public State getState(int rotation) {
            return this.group[rotation][0];
        }

        @Override
        public int getLength(int rotation) {
            return this.group[rotation].length;
        }

        @Override
        public int index() {
            return this.index;
        }

        @Override
        public void setIndex(int index) {
            this.index = index;
        }
    }
}

