/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Wang.Ai;
import ru.m210projects.Wang.Main;
import ru.m210projects.Wang.Player;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.USER;

public class Gameutils {
    public static final int SK_WEAPON_BIT0 = 0;
    public static final int SK_WEAPON_BIT1 = 1;
    public static final int SK_WEAPON_BIT2 = 2;
    public static final int SK_WEAPON_BIT3 = 3;
    public static final int SK_WEAPON_MASK = MyTypes.BIT(0) | MyTypes.BIT(1) | MyTypes.BIT(2) | MyTypes.BIT(3);
    public static final int SK_INV_HOTKEY_BIT0 = 4;
    public static final int SK_INV_HOTKEY_BIT1 = 5;
    public static final int SK_INV_HOTKEY_BIT2 = 6;
    public static final int SK_INV_HOTKEY_MASK = MyTypes.BIT(4) | MyTypes.BIT(5) | MyTypes.BIT(6);
    public static final int SK_AUTO_AIM = 7;
    public static final int SK_CENTER_VIEW = 8;
    public static final int SK_PAUSE = 9;
    public static final int SK_RUN_LOCK = 10;
    public static final int SK_MESSAGE = 11;
    public static final int SK_LOOK_UP = 12;
    public static final int SK_LOOK_DOWN = 13;
    public static final int SK_CRAWL_LOCK = 14;
    public static final int SK_FLY = 15;
    public static final int SK_RUN = 16;
    public static final int SK_SHOOT = 17;
    public static final int SK_OPERATE = 18;
    public static final int SK_JUMP = 19;
    public static final int SK_CRAWL = 20;
    public static final int SK_SNAP_UP = 21;
    public static final int SK_SNAP_DOWN = 22;
    public static final int SK_TILT_LEFT = 23;
    public static final int SK_TILT_RIGHT = 24;
    public static final int SK_TURN_180 = 25;
    public static final int SK_INV_LEFT = 26;
    public static final int SK_INV_RIGHT = 27;
    public static final int SK_QUIT_GAME = 28;
    public static final int SK_INV_USE = 29;
    public static final int SK_HIDE_WEAPON = 30;
    public static final int SK_SPACE_BAR = 31;
    public static final int WPN_FIST = 0;
    public static final int WPN_STAR = 1;
    public static final int WPN_SHOTGUN = 2;
    public static final int WPN_UZI = 3;
    public static final int WPN_MICRO = 4;
    public static final int WPN_GRENADE = 5;
    public static final int WPN_MINE = 6;
    public static final int WPN_RAIL = 7;
    public static final int WPN_HOTHEAD = 8;
    public static final int WPN_HEART = 9;
    public static final int WPN_NAPALM = 10;
    public static final int WPN_RING = 11;
    public static final int WPN_ROCKET = 12;
    public static final int WPN_SWORD = 13;
    public static final int DMG_NAPALM = 14;
    public static final int DMG_MIRV_METEOR = 15;
    public static final int DMG_SERP_METEOR = 16;
    public static final int DMG_ELECTRO_SHARD = 17;
    public static final int DMG_SECTOR_EXP = 18;
    public static final int DMG_BOLT_EXP = 19;
    public static final int DMG_TANK_SHELL_EXP = 20;
    public static final int DMG_FIREBALL_EXP = 21;
    public static final int DMG_NAPALM_EXP = 22;
    public static final int DMG_SKULL_EXP = 23;
    public static final int DMG_BASIC_EXP = 24;
    public static final int DMG_GRENADE_EXP = 25;
    public static final int DMG_MINE_EXP = 26;
    public static final int DMG_MINE_SHRAP = 27;
    public static final int DMG_MICRO_EXP = 28;
    public static final int DMG_NUCLEAR_EXP = 29;
    public static final int DMG_RADIATION_CLOUD = 30;
    public static final int DMG_FLASHBOMB = 31;
    public static final int DMG_FIREBALL_FLAMES = 32;
    public static final int DMG_RIPPER_SLASH = 33;
    public static final int DMG_SKEL_SLASH = 34;
    public static final int DMG_COOLG_BASH = 35;
    public static final int DMG_COOLG_FIRE = 36;
    public static final int DMG_GORO_CHOP = 37;
    public static final int DMG_GORO_FIREBALL = 38;
    public static final int DMG_SERP_SLASH = 39;
    public static final int DMG_LAVA_BOULDER = 40;
    public static final int DMG_LAVA_SHARD = 41;
    public static final int DMG_HORNET_STING = 42;
    public static final int DMG_EEL_ELECTRO = 43;
    public static final int DMG_SPEAR_TRAP = 44;
    public static final int DMG_VOMIT = 45;
    public static final int DMG_BLADE = 46;
    public static USER[] pUser = new USER[Engine.MAXSPRITES];
    public static final int CIRCLE_CAMERA_DIST_MIN = 12000;
    public static final int MAX_ACTIVE_RANGE = 42000;
    public static final int MIN_ACTIVE_RANGE = 20000;
    public static int dist_x;
    public static int dist_y;
    public static int dist_min;
    public static final int CEILING_DIST;
    public static final int FLOOR_DIST;
    public static final int MDA_BLANK = 0;
    public static final int MDA_NORMAL = 7;
    public static final int MDA_BLINK = 135;
    public static final int MDA_HIGH = 15;
    public static final int MDA_HIGHBLINK = 143;
    public static final int MDA_UNDER = 1;
    public static final int MDA_UNDERBLINK = 129;
    public static final int MDA_UNDERHIGH = 9;
    public static final int MDA_UNDERHIGHBLINK = 137;
    public static final int MDA_REVERSE = 112;
    public static final int MDA_REVERSEBLINK = 240;
    public static final int HIT_MASK = 57344;
    public static final int HIT_SPRITE = 49152;
    public static final int HIT_WALL = 32768;
    public static final int HIT_SECTOR = 16384;
    public static final int HIT_PLAX_WALL = 8192;
    public static final int OVER_SPRITE_MIDDLE;
    public static final int OVER_SPRITE_VIEW_CLIP;
    public static final int OVER_SPRITE_TRANSLUCENT;
    public static final int OVER_SPRITE_XFLIP;
    public static final int OVER_SPRITE_YFLIP;
    public static final int ROTATE_SPRITE_TRANSLUCENT;
    public static final int ROTATE_SPRITE_VIEW_CLIP;
    public static final int ROTATE_SPRITE_YFLIP;
    public static final int ROTATE_SPRITE_IGNORE_START_MOST;
    public static final int ROTATE_SPRITE_SCREEN_CLIP;
    public static final int ROTATE_SPRITE_CORNER;
    public static final int ROTATE_SPRITE_TRANS_FLIP;
    public static final int ROTATE_SPRITE_NON_MASK;
    public static final int ROTATE_SPRITE_ALL_PAGES;
    public static final int RS_SCALE;
    public static final int CEILING_STAT_PLAX;
    public static final int CEILING_STAT_SLOPE;
    public static final int CEILING_STAT_SWAPXY;
    public static final int CEILING_STAT_SMOOSH;
    public static final int CEILING_STAT_XFLIP;
    public static final int CEILING_STAT_YFLIP;
    public static final int CEILING_STAT_RELATIVE;
    public static final int CEILING_STAT_TYPE_MASK;
    public static final int CEILING_STAT_MASKED;
    public static final int CEILING_STAT_TRANS;
    public static final int CEILING_STAT_TRANS_FLIP;
    public static final int CEILING_STAT_FAF_BLOCK_HITSCAN;
    public static final int FLOOR_STAT_PLAX;
    public static final int FLOOR_STAT_SLOPE;
    public static final int FLOOR_STAT_SWAPXY;
    public static final int FLOOR_STAT_SMOOSH;
    public static final int FLOOR_STAT_XFLIP;
    public static final int FLOOR_STAT_YFLIP;
    public static final int FLOOR_STAT_RELATIVE;
    public static final int FLOOR_STAT_TYPE_MASK;
    public static final int FLOOR_STAT_MASKED;
    public static final int FLOOR_STAT_TRANS;
    public static final int FLOOR_STAT_TRANS_FLIP;
    public static final int FLOOR_STAT_FAF_BLOCK_HITSCAN;
    public static final int CSTAT_WALL_BLOCK;
    public static final int CSTAT_WALL_BOTTOM_SWAP;
    public static final int CSTAT_WALL_ALIGN_BOTTOM;
    public static final int CSTAT_WALL_XFLIP;
    public static final int CSTAT_WALL_MASKED;
    public static final int CSTAT_WALL_1WAY;
    public static final int CSTAT_WALL_BLOCK_HITSCAN;
    public static final int CSTAT_WALL_TRANSLUCENT;
    public static final int CSTAT_WALL_YFLIP;
    public static final int CSTAT_WALL_TRANS_FLIP;
    public static final int CSTAT_WALL_BLOCK_ACTOR;
    public static final int CSTAT_WALL_WARP_HITSCAN;
    public static final int CSTAT_SPRITE_BLOCK;
    public static final int CSTAT_SPRITE_TRANSLUCENT;
    public static final int CSTAT_SPRITE_XFLIP;
    public static final int CSTAT_SPRITE_YFLIP;
    public static final int CSTAT_SPRITE_WALL;
    public static final int CSTAT_SPRITE_FLOOR;
    public static final int CSTAT_SPRITE_SLAB;
    public static final int CSTAT_SPRITE_ONE_SIDE;
    public static final int CSTAT_SPRITE_YCENTER;
    public static final int CSTAT_SPRITE_BLOCK_HITSCAN;
    public static final int CSTAT_SPRITE_TRANS_FLIP;
    public static final int CSTAT_SPRITE_RESTORE;
    public static final int CSTAT_SPRITE_CLOSE_FLOOR;
    public static final int CSTAT_SPRITE_BLOCK_MISSILE;
    public static final int CSTAT_SPRITE_INVISIBLE;
    public static final int CSTAT_SPRITE_BREAKABLE;
    public static final int CLIPMASK_PLAYER;
    public static final int CLIPMASK_ACTOR;
    public static final int CLIPMASK_MISSILE;
    public static final int CLIPMASK_WARP_HITSCAN;
    public static final int TILE_ANIM_NUM;
    public static final int TILE_ANIM_TYPE;
    public static final int TILE_SPEED = 0xF00000;
    public static final int DEGREE_45 = 256;
    public static final int DEGREE_90 = 512;
    public static final int ORD_NORTH = 0;
    public static final int ORD_NE = 1;
    public static final int ORD_EAST = 2;
    public static final int ORD_SE = 3;
    public static final int ORD_SOUTH = 4;
    public static final int ORD_SW = 5;
    public static final int ORD_WEST = 6;
    public static final int ORD_NW = 7;
    public static final int NORTH = 0;
    public static final int NE = 256;
    public static final int EAST = 512;
    public static final int SE = 768;
    public static final int SOUTH = 1024;
    public static final int SW = 1280;
    public static final int WEST = 1536;
    public static final int NW = 1792;
    public static final int SEARCH_DOWN = 1;
    public static final int SEARCH_UP = -1;
    public static final int SEARCH_FLOOR = 1;
    public static final int SEARCH_CEILING = -1;
    public static final int UP_DIR = -1;
    public static final int DOWN_DIR = 1;
    public static final int OPEN = 0;
    public static final int CLOSE = 1;
    public static final int SF_TICS_MASK = 65535;
    public static final int SF_QUICK_CALL;
    public static final int SF_PLAYER_FUNC;
    public static final int SF_TIC_ADJUST;
    public static final int SF_WALL_STATE;
    public static final int MAXSHELLS = 32;
    public static final int MAX_PAIN = 5;
    public static final int MAX_TAUNTAI = 33;
    public static final int MAX_GETSOUNDS = 5;
    public static final int MAX_YELLSOUNDS = 3;
    public static final int MESSAGE_LINE = 142;
    public static final int MAXUSERQUOTES = 6;
    public static final int MAXCONQUOTES = 13;
    public static final int MAX_WEAPONS_KEYS = 10;
    public static final int MAX_WEAPONS_EXTRA = 4;
    public static final int MAX_WEAPONS = 14;
    public static final int WPN_NM_LAVA = -8;
    public static final int WPN_NM_SECTOR_SQUISH = -9;
    public static final int MAX_SW_PLAYERS = 8;
    public static final int MAX_LEVELS = 29;
    public static final int PACK = 1;
    public static final int MOVEFIFOSIZ = 256;
    public static final int MAXSYNCBYTES = 16;
    public static final int SYNCFIFOSIZ = 1024;
    public static final int NUM_KEYS = 8;
    public static final int PLAYER_DEATH_FLIP = 0;
    public static final int PLAYER_DEATH_CRUMBLE = 1;
    public static final int PLAYER_DEATH_EXPLODE = 2;
    public static final int PLAYER_DEATH_RIPPER = 3;
    public static final int PLAYER_DEATH_SQUISH = 4;
    public static final int PLAYER_DEATH_DROWN = 5;
    public static final int MAX_PLAYER_DEATHS = 7;
    public static final int PF_DEAD;
    public static final int PF_JUMPING;
    public static final int PF_FALLING;
    public static final int PF_LOCK_CRAWL;
    public static final int PF_LOCK_HORIZ;
    public static final int PF_LOOKING;
    public static final int PF_PLAYER_MOVED;
    public static final int PF_PLAYER_RIDING;
    public static final int PF_AUTO_AIM;
    public static final int PF_RECOIL;
    public static final int PF_FLYING;
    public static final int PF_WEAPON_RETRACT;
    public static final int PF_PICKED_UP_AN_UZI;
    public static final int PF_CRAWLING;
    public static final int PF_CLIMBING;
    public static final int PF_SWIMMING;
    public static final int PF_DIVING;
    public static final int PF_DIVING_IN_LAVA;
    public static final int PF_TWO_UZI;
    public static final int PF_LOCK_RUN;
    public static final int PF_TURN_180;
    public static final int PF_DEAD_HEAD;
    public static final int PF_HEAD_CONTROL;
    public static final int PF_CLIP_CHEAT;
    public static final int PF_SLIDING;
    public static final int PF_VIEW_FROM_OUTSIDE;
    public static final int PF_VIEW_OUTSIDE_WEAPON;
    public static final int PF_VIEW_FROM_CAMERA;
    public static final int PF_TANK;
    public static final int PF_WEAPON_DOWN;
    public static final int PF2_TELEPORTED;
    public static final int HEALTH_RIPPER = 70;
    public static final int HEALTH_RIPPER2 = 200;
    public static final int HEALTH_MOMMA_RIPPER = 500;
    public static final int HEALTH_NINJA = 40;
    public static final int HEALTH_RED_NINJA = 160;
    public static final int HEALTH_COOLIE = 120;
    public static final int HEALTH_COOLIE_GHOST = 65;
    public static final int HEALTH_SKEL_PRIEST = 90;
    public static final int HEALTH_GORO = 200;
    public static final int HEALTH_HORNET = 4;
    public static final int HEALTH_SKULL = 4;
    public static final int HEALTH_EEL = 100;
    public static final int HEALTH_SERP_GOD = 3800;
    public static final int MAX_ACTOR_CLOSE_ATTACK = 2;
    public static final int MAX_ACTOR_ATTACK = 6;
    public static final int SPRX_SKILL;
    public static final int SPRX_STAY_PUT_VATOR;
    public static final int SPRX_STAG;
    public static final int SPRX_QUEUE_SPRITE;
    public static final int SPRX_MULTI_ITEM;
    public static final int SPRX_PLAYER_OR_ENEMY;
    public static final int SPRX_FOUND;
    public static final int SPRX_BLADE;
    public static final int SPRX_BREAKABLE;
    public static final int SPRX_BURNABLE;
    public static final int SPRX_BLOCK;
    public static final int SPRX_BOOL11;
    public static final int SPRX_BOOL1;
    public static final int SPRX_BOOL2;
    public static final int SPRX_BOOL3;
    public static final int SPRX_BOOL4;
    public static final int SPRX_BOOL5;
    public static final int SPRX_BOOL6;
    public static final int SPRX_BOOL7;
    public static final int SPRX_BOOL8;
    public static final int SPRX_BOOL9;
    public static final int SPRX_BOOL10;
    public static final int SPR_MOVED;
    public static final int SPR_ATTACKED;
    public static final int SPR_TARGETED;
    public static final int SPR_ACTIVE;
    public static final int SPR_ELECTRO_TOLERANT;
    public static final int SPR_JUMPING;
    public static final int SPR_FALLING;
    public static final int SPR_CLIMBING;
    public static final int SPR_DEAD;
    public static final int SPR_ZDIFF_MODE;
    public static final int SPR_SPEED_UP;
    public static final int SPR_SLOW_DOWN;
    public static final int SPR_DONT_UPDATE_ANG;
    public static final int SPR_SO_ATTACHED;
    public static final int SPR_SUICIDE;
    public static final int SPR_RUN_AWAY;
    public static final int SPR_FIND_PLAYER;
    public static final int SPR_SWIMMING;
    public static final int SPR_WAIT_FOR_PLAYER;
    public static final int SPR_WAIT_FOR_TRIGGER;
    public static final int SPR_SLIDING;
    public static final int SPR_ON_SO_SECTOR;
    public static final int SPR_SHADE_DIR;
    public static final int SPR_XFLIP_TOGGLE;
    public static final int SPR_NO_SCAREDZ;
    public static final int SPR_SET_POS_DONT_KILL;
    public static final int SPR_SKIP2;
    public static final int SPR_SKIP4;
    public static final int SPR_BOUNCE;
    public static final int SPR_UNDERWATER;
    public static final int SPR_SHADOW;
    public static final int SPR2_BLUR_TAPER;
    public static final int SPR2_BLUR_TAPER_FAST = 8192;
    public static final int SPR2_BLUR_TAPER_SLOW = 16384;
    public static final int SPR2_SPRITE_FAKE_BLOCK;
    public static final int SPR2_NEVER_RESPAWN;
    public static final int SPR2_ATTACH_WALL;
    public static final int SPR2_ATTACH_FLOOR;
    public static final int SPR2_ATTACH_CEILING;
    public static final int SPR2_CHILDREN;
    public static final int SPR2_SO_MISSILE;
    public static final int SPR2_DYING;
    public static final int SPR2_VIS_SHADING;
    public static final int SPR2_DONT_TARGET_OWNER;
    public static final int SECTFX_SINK;
    public static final int SECTFX_OPERATIONAL;
    public static final int SECTFX_WARP_SECTOR;
    public static final int SECTFX_CURRENT;
    public static final int SECTFX_Z_ADJUST;
    public static final int SECTFX_NO_RIDE;
    public static final int SECTFX_DYNAMIC_AREA;
    public static final int SECTFX_DIVE_AREA;
    public static final int SECTFX_UNDERWATER;
    public static final int SECTFX_UNDERWATER2;
    public static final int SECTFX_LIQUID_MASK;
    public static final int SECTFX_LIQUID_NONE = 0;
    public static final int SECTFX_LIQUID_LAVA;
    public static final int SECTFX_LIQUID_WATER;
    public static final int SECTFX_SECTOR_OBJECT;
    public static final int SECTFX_VATOR;
    public static final int SECTFX_TRIGGER;
    public static final int SECTFU_SO_DONT_BOB;
    public static final int SECTFU_SO_SINK_DEST;
    public static final int SECTFU_SO_DONT_SINK;
    public static final int SECTFU_DONT_COPY_PALETTE;
    public static final int SECTFU_SO_SLOPE_FLOOR_TO_POINT;
    public static final int SECTFU_SO_SLOPE_CEILING_TO_POINT;
    public static final int SECTFU_DAMAGE_ABOVE_SECTOR;
    public static final int SECTFU_VATOR_BOTH;
    public static final int SECTFU_CANT_SURFACE;
    public static final int SECTFU_SLIDE_SECTOR;
    public static final int WALLFX_LOOP_DONT_SPIN;
    public static final int WALLFX_LOOP_REVERSE_SPIN;
    public static final int WALLFX_LOOP_SPIN_2X;
    public static final int WALLFX_LOOP_SPIN_4X;
    public static final int WALLFX_LOOP_OUTER;
    public static final int WALLFX_DONT_MOVE;
    public static final int WALLFX_SECTOR_OBJECT;
    public static final int WALLFX_DONT_STICK;
    public static final int WALLFX_DONT_SCALE;
    public static final int WALLFX_LOOP_OUTER_SECONDARY;
    public static final int MAX_TARGET_SORT = 16;
    public static final int MAX_DOOR_AUTO_CLOSE = 16;
    public static final int MAXANIM = 256;
    public static final int TF_TRACK_OCCUPIED;
    public static final int MAX_SO_SECTOR = 40;
    public static final int MAX_SO_POINTS = 600;
    public static final int MAX_SO_SPRITE = 60;
    public static final int MAX_CLIPBOX = 32;
    public static final int MAX_SECTOR_OBJECTS = 25;
    public static final int SOBJ_SPEED_UP;
    public static final int SOBJ_SLOW_DOWN;
    public static final int SOBJ_ZUP;
    public static final int SOBJ_ZDOWN;
    public static final int SOBJ_ZDIFF_MODE;
    public static final int SOBJ_MOVE_VERTICAL;
    public static final int SOBJ_ABSOLUTE_ANGLE;
    public static final int SOBJ_SPRITE_OBJ;
    public static final int SOBJ_DONT_ROTATE;
    public static final int SOBJ_WAIT_FOR_EVENT;
    public static final int SOBJ_HAS_WEAPON;
    public static final int SOBJ_SYNC1;
    public static final int SOBJ_SYNC2;
    public static final int SOBJ_DYNAMIC;
    public static final int SOBJ_ZMID_FLOOR;
    public static final int SOBJ_SLIDE;
    public static final int SOBJ_OPERATIONAL;
    public static final int SOBJ_KILLABLE;
    public static final int SOBJ_DIE_HARD;
    public static final int SOBJ_UPDATE_ONCE;
    public static final int SOBJ_UPDATE;
    public static final int SOBJ_NO_QUAKE;
    public static final int SOBJ_REMOTE_ONLY;
    public static final int SOBJ_RECT_CLIP;
    public static final int SOBJ_BROKEN;
    public static final int SO_OPERATE_TRACK_START = 90;
    public static final int SO_TURRET_MGUN = 96;
    public static final int SO_TURRET = 97;
    public static final int SO_TANK = 98;
    public static final int SO_SPEED_BOAT = 99;
    public static final int FAF_PLACE_MIRROR_PIC = 341;
    public static final short FAF_MIRROR_PIC = 2356;
    public static final int ACTOR_GRAVITY = 8;
    public static final int synctics = 3;
    public static final int ACTORMOVETICS = 6;
    public static final int TICSPERMOVEMENT = 3;
    public static final int GETZRANGE_CLIP_ADJ = 8;
    public static final int TEXT_TEST_LINE = 100;
    public static final int TEXT_TEST_TIME = 2;
    public static final int MASTER_SWITCHING = 1;
    public static final int STAT_DAMAGE_LIST_SIZE = 20;
    public static final int COLOR_PAIN = 128;
    public static final int MAXSO = Integer.MAX_VALUE;

    static {
        CEILING_DIST = Gameutils.Z(4);
        FLOOR_DIST = Gameutils.Z(4);
        OVER_SPRITE_MIDDLE = MyTypes.BIT(0);
        OVER_SPRITE_VIEW_CLIP = MyTypes.BIT(1);
        OVER_SPRITE_TRANSLUCENT = MyTypes.BIT(2);
        OVER_SPRITE_XFLIP = MyTypes.BIT(3);
        OVER_SPRITE_YFLIP = MyTypes.BIT(4);
        ROTATE_SPRITE_TRANSLUCENT = MyTypes.BIT(0);
        ROTATE_SPRITE_VIEW_CLIP = MyTypes.BIT(1);
        ROTATE_SPRITE_YFLIP = MyTypes.BIT(2);
        ROTATE_SPRITE_IGNORE_START_MOST = MyTypes.BIT(3);
        ROTATE_SPRITE_SCREEN_CLIP = MyTypes.BIT(1) | MyTypes.BIT(3);
        ROTATE_SPRITE_CORNER = MyTypes.BIT(4);
        ROTATE_SPRITE_TRANS_FLIP = MyTypes.BIT(5);
        ROTATE_SPRITE_NON_MASK = MyTypes.BIT(6);
        ROTATE_SPRITE_ALL_PAGES = MyTypes.BIT(7);
        RS_SCALE = MyTypes.BIT(16);
        CEILING_STAT_PLAX = MyTypes.BIT(0);
        CEILING_STAT_SLOPE = MyTypes.BIT(1);
        CEILING_STAT_SWAPXY = MyTypes.BIT(2);
        CEILING_STAT_SMOOSH = MyTypes.BIT(3);
        CEILING_STAT_XFLIP = MyTypes.BIT(4);
        CEILING_STAT_YFLIP = MyTypes.BIT(5);
        CEILING_STAT_RELATIVE = MyTypes.BIT(6);
        CEILING_STAT_TYPE_MASK = MyTypes.BIT(7) | MyTypes.BIT(8);
        CEILING_STAT_MASKED = MyTypes.BIT(7);
        CEILING_STAT_TRANS = MyTypes.BIT(8);
        CEILING_STAT_TRANS_FLIP = MyTypes.BIT(7) | MyTypes.BIT(8);
        CEILING_STAT_FAF_BLOCK_HITSCAN = MyTypes.BIT(15);
        FLOOR_STAT_PLAX = MyTypes.BIT(0);
        FLOOR_STAT_SLOPE = MyTypes.BIT(1);
        FLOOR_STAT_SWAPXY = MyTypes.BIT(2);
        FLOOR_STAT_SMOOSH = MyTypes.BIT(3);
        FLOOR_STAT_XFLIP = MyTypes.BIT(4);
        FLOOR_STAT_YFLIP = MyTypes.BIT(5);
        FLOOR_STAT_RELATIVE = MyTypes.BIT(6);
        FLOOR_STAT_TYPE_MASK = MyTypes.BIT(7) | MyTypes.BIT(8);
        FLOOR_STAT_MASKED = MyTypes.BIT(7);
        FLOOR_STAT_TRANS = MyTypes.BIT(8);
        FLOOR_STAT_TRANS_FLIP = MyTypes.BIT(7) | MyTypes.BIT(8);
        FLOOR_STAT_FAF_BLOCK_HITSCAN = MyTypes.BIT(15);
        CSTAT_WALL_BLOCK = MyTypes.BIT(0);
        CSTAT_WALL_BOTTOM_SWAP = MyTypes.BIT(1);
        CSTAT_WALL_ALIGN_BOTTOM = MyTypes.BIT(2);
        CSTAT_WALL_XFLIP = MyTypes.BIT(3);
        CSTAT_WALL_MASKED = MyTypes.BIT(4);
        CSTAT_WALL_1WAY = MyTypes.BIT(5);
        CSTAT_WALL_BLOCK_HITSCAN = MyTypes.BIT(6);
        CSTAT_WALL_TRANSLUCENT = MyTypes.BIT(7);
        CSTAT_WALL_YFLIP = MyTypes.BIT(8);
        CSTAT_WALL_TRANS_FLIP = MyTypes.BIT(9);
        CSTAT_WALL_BLOCK_ACTOR = MyTypes.BIT(14);
        CSTAT_WALL_WARP_HITSCAN = MyTypes.BIT(15);
        CSTAT_SPRITE_BLOCK = MyTypes.BIT(0);
        CSTAT_SPRITE_TRANSLUCENT = MyTypes.BIT(1);
        CSTAT_SPRITE_XFLIP = MyTypes.BIT(2);
        CSTAT_SPRITE_YFLIP = MyTypes.BIT(3);
        CSTAT_SPRITE_WALL = MyTypes.BIT(4);
        CSTAT_SPRITE_FLOOR = MyTypes.BIT(5);
        CSTAT_SPRITE_SLAB = MyTypes.BIT(4) | MyTypes.BIT(5);
        CSTAT_SPRITE_ONE_SIDE = MyTypes.BIT(6);
        CSTAT_SPRITE_YCENTER = MyTypes.BIT(7);
        CSTAT_SPRITE_BLOCK_HITSCAN = MyTypes.BIT(8);
        CSTAT_SPRITE_TRANS_FLIP = MyTypes.BIT(9);
        CSTAT_SPRITE_RESTORE = MyTypes.BIT(12);
        CSTAT_SPRITE_CLOSE_FLOOR = MyTypes.BIT(13);
        CSTAT_SPRITE_BLOCK_MISSILE = MyTypes.BIT(14);
        CSTAT_SPRITE_INVISIBLE = MyTypes.BIT(15);
        CSTAT_SPRITE_BREAKABLE = CSTAT_SPRITE_BLOCK_HITSCAN | CSTAT_SPRITE_BLOCK_MISSILE;
        CLIPMASK_PLAYER = Gameutils.CS(CSTAT_SPRITE_BLOCK) | CSTAT_WALL_BLOCK;
        CLIPMASK_ACTOR = Gameutils.CS(CSTAT_SPRITE_BLOCK) | CSTAT_WALL_BLOCK | CSTAT_WALL_BLOCK_ACTOR;
        CLIPMASK_MISSILE = Gameutils.CS(CSTAT_SPRITE_BLOCK_HITSCAN | CSTAT_SPRITE_BLOCK_MISSILE) | CSTAT_WALL_BLOCK_HITSCAN;
        CLIPMASK_WARP_HITSCAN = Gameutils.CS(CSTAT_SPRITE_BLOCK_HITSCAN) | CSTAT_WALL_BLOCK_HITSCAN | CSTAT_WALL_WARP_HITSCAN;
        TILE_ANIM_NUM = 0xF | MyTypes.BIT(4) | MyTypes.BIT(5);
        TILE_ANIM_TYPE = MyTypes.BIT(6) | MyTypes.BIT(7);
        SF_QUICK_CALL = MyTypes.BIT(16);
        SF_PLAYER_FUNC = MyTypes.BIT(17);
        SF_TIC_ADJUST = MyTypes.BIT(18);
        SF_WALL_STATE = MyTypes.BIT(19);
        PF_DEAD = MyTypes.BIT(1);
        PF_JUMPING = MyTypes.BIT(2);
        PF_FALLING = MyTypes.BIT(3);
        PF_LOCK_CRAWL = MyTypes.BIT(4);
        PF_LOCK_HORIZ = MyTypes.BIT(5);
        PF_LOOKING = MyTypes.BIT(6);
        PF_PLAYER_MOVED = MyTypes.BIT(7);
        PF_PLAYER_RIDING = MyTypes.BIT(8);
        PF_AUTO_AIM = MyTypes.BIT(9);
        PF_RECOIL = MyTypes.BIT(10);
        PF_FLYING = MyTypes.BIT(11);
        PF_WEAPON_RETRACT = MyTypes.BIT(12);
        PF_PICKED_UP_AN_UZI = MyTypes.BIT(13);
        PF_CRAWLING = MyTypes.BIT(14);
        PF_CLIMBING = MyTypes.BIT(15);
        PF_SWIMMING = MyTypes.BIT(16);
        PF_DIVING = MyTypes.BIT(17);
        PF_DIVING_IN_LAVA = MyTypes.BIT(18);
        PF_TWO_UZI = MyTypes.BIT(19);
        PF_LOCK_RUN = MyTypes.BIT(20);
        PF_TURN_180 = MyTypes.BIT(21);
        PF_DEAD_HEAD = MyTypes.BIT(22);
        PF_HEAD_CONTROL = MyTypes.BIT(23);
        PF_CLIP_CHEAT = MyTypes.BIT(24);
        PF_SLIDING = MyTypes.BIT(25);
        PF_VIEW_FROM_OUTSIDE = MyTypes.BIT(26);
        PF_VIEW_OUTSIDE_WEAPON = MyTypes.BIT(27);
        PF_VIEW_FROM_CAMERA = MyTypes.BIT(28);
        PF_TANK = MyTypes.BIT(29);
        PF_WEAPON_DOWN = MyTypes.BIT(31);
        PF2_TELEPORTED = MyTypes.BIT(0);
        SPRX_SKILL = MyTypes.BIT(0) | MyTypes.BIT(1) | MyTypes.BIT(2);
        SPRX_STAY_PUT_VATOR = MyTypes.BIT(5);
        SPRX_STAG = MyTypes.BIT(6);
        SPRX_QUEUE_SPRITE = MyTypes.BIT(7);
        SPRX_MULTI_ITEM = MyTypes.BIT(9);
        SPRX_PLAYER_OR_ENEMY = MyTypes.BIT(11);
        SPRX_FOUND = MyTypes.BIT(12);
        SPRX_BLADE = MyTypes.BIT(12);
        SPRX_BREAKABLE = MyTypes.BIT(13);
        SPRX_BURNABLE = MyTypes.BIT(14);
        SPRX_BLOCK = MyTypes.BIT(15);
        SPRX_BOOL11 = MyTypes.BIT(5);
        SPRX_BOOL1 = MyTypes.BIT(6);
        SPRX_BOOL2 = MyTypes.BIT(7);
        SPRX_BOOL3 = MyTypes.BIT(8);
        SPRX_BOOL4 = MyTypes.BIT(9);
        SPRX_BOOL5 = MyTypes.BIT(10);
        SPRX_BOOL6 = MyTypes.BIT(11);
        SPRX_BOOL7 = MyTypes.BIT(4);
        SPRX_BOOL8 = MyTypes.BIT(13);
        SPRX_BOOL9 = MyTypes.BIT(14);
        SPRX_BOOL10 = MyTypes.BIT(15);
        SPR_MOVED = MyTypes.BIT(0);
        SPR_ATTACKED = MyTypes.BIT(1);
        SPR_TARGETED = MyTypes.BIT(2);
        SPR_ACTIVE = MyTypes.BIT(3);
        SPR_ELECTRO_TOLERANT = MyTypes.BIT(4);
        SPR_JUMPING = MyTypes.BIT(5);
        SPR_FALLING = MyTypes.BIT(6);
        SPR_CLIMBING = MyTypes.BIT(7);
        SPR_DEAD = MyTypes.BIT(8);
        SPR_ZDIFF_MODE = MyTypes.BIT(10);
        SPR_SPEED_UP = MyTypes.BIT(11);
        SPR_SLOW_DOWN = MyTypes.BIT(12);
        SPR_DONT_UPDATE_ANG = MyTypes.BIT(13);
        SPR_SO_ATTACHED = MyTypes.BIT(14);
        SPR_SUICIDE = MyTypes.BIT(15);
        SPR_RUN_AWAY = MyTypes.BIT(16);
        SPR_FIND_PLAYER = MyTypes.BIT(17);
        SPR_SWIMMING = MyTypes.BIT(18);
        SPR_WAIT_FOR_PLAYER = MyTypes.BIT(19);
        SPR_WAIT_FOR_TRIGGER = MyTypes.BIT(20);
        SPR_SLIDING = MyTypes.BIT(21);
        SPR_ON_SO_SECTOR = MyTypes.BIT(22);
        SPR_SHADE_DIR = MyTypes.BIT(23);
        SPR_XFLIP_TOGGLE = MyTypes.BIT(24);
        SPR_NO_SCAREDZ = MyTypes.BIT(25);
        SPR_SET_POS_DONT_KILL = MyTypes.BIT(26);
        SPR_SKIP2 = MyTypes.BIT(27);
        SPR_SKIP4 = MyTypes.BIT(28);
        SPR_BOUNCE = MyTypes.BIT(29);
        SPR_UNDERWATER = MyTypes.BIT(30);
        SPR_SHADOW = MyTypes.BIT(31);
        SPR2_BLUR_TAPER = MyTypes.BIT(13) | MyTypes.BIT(14);
        SPR2_SPRITE_FAKE_BLOCK = MyTypes.BIT(15);
        SPR2_NEVER_RESPAWN = MyTypes.BIT(16);
        SPR2_ATTACH_WALL = MyTypes.BIT(17);
        SPR2_ATTACH_FLOOR = MyTypes.BIT(18);
        SPR2_ATTACH_CEILING = MyTypes.BIT(19);
        SPR2_CHILDREN = MyTypes.BIT(20);
        SPR2_SO_MISSILE = MyTypes.BIT(21);
        SPR2_DYING = MyTypes.BIT(22);
        SPR2_VIS_SHADING = MyTypes.BIT(23);
        SPR2_DONT_TARGET_OWNER = MyTypes.BIT(24);
        SECTFX_SINK = MyTypes.BIT(0);
        SECTFX_OPERATIONAL = MyTypes.BIT(1);
        SECTFX_WARP_SECTOR = MyTypes.BIT(2);
        SECTFX_CURRENT = MyTypes.BIT(3);
        SECTFX_Z_ADJUST = MyTypes.BIT(4);
        SECTFX_NO_RIDE = MyTypes.BIT(5);
        SECTFX_DYNAMIC_AREA = MyTypes.BIT(6);
        SECTFX_DIVE_AREA = MyTypes.BIT(7);
        SECTFX_UNDERWATER = MyTypes.BIT(8);
        SECTFX_UNDERWATER2 = MyTypes.BIT(9);
        SECTFX_LIQUID_MASK = MyTypes.BIT(10) | MyTypes.BIT(11);
        SECTFX_LIQUID_LAVA = MyTypes.BIT(10);
        SECTFX_LIQUID_WATER = MyTypes.BIT(11);
        SECTFX_SECTOR_OBJECT = MyTypes.BIT(12);
        SECTFX_VATOR = MyTypes.BIT(13);
        SECTFX_TRIGGER = MyTypes.BIT(14);
        SECTFU_SO_DONT_BOB = MyTypes.BIT(0);
        SECTFU_SO_SINK_DEST = MyTypes.BIT(1);
        SECTFU_SO_DONT_SINK = MyTypes.BIT(2);
        SECTFU_DONT_COPY_PALETTE = MyTypes.BIT(3);
        SECTFU_SO_SLOPE_FLOOR_TO_POINT = MyTypes.BIT(4);
        SECTFU_SO_SLOPE_CEILING_TO_POINT = MyTypes.BIT(5);
        SECTFU_DAMAGE_ABOVE_SECTOR = MyTypes.BIT(6);
        SECTFU_VATOR_BOTH = MyTypes.BIT(7);
        SECTFU_CANT_SURFACE = MyTypes.BIT(8);
        SECTFU_SLIDE_SECTOR = MyTypes.BIT(9);
        WALLFX_LOOP_DONT_SPIN = MyTypes.BIT(0);
        WALLFX_LOOP_REVERSE_SPIN = MyTypes.BIT(1);
        WALLFX_LOOP_SPIN_2X = MyTypes.BIT(2);
        WALLFX_LOOP_SPIN_4X = MyTypes.BIT(3);
        WALLFX_LOOP_OUTER = MyTypes.BIT(4);
        WALLFX_DONT_MOVE = MyTypes.BIT(5);
        WALLFX_SECTOR_OBJECT = MyTypes.BIT(6);
        WALLFX_DONT_STICK = MyTypes.BIT(7);
        WALLFX_DONT_SCALE = MyTypes.BIT(8);
        WALLFX_LOOP_OUTER_SECONDARY = MyTypes.BIT(9);
        TF_TRACK_OCCUPIED = MyTypes.BIT(0);
        SOBJ_SPEED_UP = MyTypes.BIT(0);
        SOBJ_SLOW_DOWN = MyTypes.BIT(1);
        SOBJ_ZUP = MyTypes.BIT(2);
        SOBJ_ZDOWN = MyTypes.BIT(3);
        SOBJ_ZDIFF_MODE = MyTypes.BIT(4);
        SOBJ_MOVE_VERTICAL = MyTypes.BIT(5);
        SOBJ_ABSOLUTE_ANGLE = MyTypes.BIT(7);
        SOBJ_SPRITE_OBJ = MyTypes.BIT(8);
        SOBJ_DONT_ROTATE = MyTypes.BIT(9);
        SOBJ_WAIT_FOR_EVENT = MyTypes.BIT(10);
        SOBJ_HAS_WEAPON = MyTypes.BIT(11);
        SOBJ_SYNC1 = MyTypes.BIT(12);
        SOBJ_SYNC2 = MyTypes.BIT(13);
        SOBJ_DYNAMIC = MyTypes.BIT(14);
        SOBJ_ZMID_FLOOR = MyTypes.BIT(15);
        SOBJ_SLIDE = MyTypes.BIT(16);
        SOBJ_OPERATIONAL = MyTypes.BIT(17);
        SOBJ_KILLABLE = MyTypes.BIT(18);
        SOBJ_DIE_HARD = MyTypes.BIT(19);
        SOBJ_UPDATE_ONCE = MyTypes.BIT(20);
        SOBJ_UPDATE = MyTypes.BIT(21);
        SOBJ_NO_QUAKE = MyTypes.BIT(22);
        SOBJ_REMOTE_ONLY = MyTypes.BIT(23);
        SOBJ_RECT_CLIP = MyTypes.BIT(24);
        SOBJ_BROKEN = MyTypes.BIT(25);
    }

    public static final int SP_TAG1(SPRITE sp) {
        return sp.hitag;
    }

    public static final int SP_TAG2(SPRITE sp) {
        return sp.lotag;
    }

    public static final int SP_TAG3(SPRITE sp) {
        return sp.clipdist;
    }

    public static final int SP_TAG4(SPRITE sp) {
        return sp.ang;
    }

    public static final int SP_TAG5(SPRITE sp) {
        return sp.xvel;
    }

    public static final int SP_TAG6(SPRITE sp) {
        return sp.yvel;
    }

    public static final int SP_TAG7(SPRITE sp) {
        return sp.zvel >> 8 & 0xFF;
    }

    public static final void SET_SP_TAG7(SPRITE sp, int var) {
        sp.zvel = (short)(Gameutils.SP_TAG8(sp) | (var & 0xFF) << 8);
    }

    public static final int SP_TAG8(SPRITE sp) {
        return sp.zvel & 0xFF;
    }

    public static final void SET_SP_TAG8(SPRITE sp, int var) {
        sp.zvel = (short)(var & 0xFF | Gameutils.SP_TAG7(sp) << 8);
    }

    public static final int SP_TAG9(SPRITE sp) {
        return sp.owner >> 8 & 0xFF;
    }

    public static final void SET_SP_TAG9(SPRITE sp, int var) {
        sp.owner = (short)(Gameutils.SP_TAG10(sp) | (var & 0xFF) << 8);
    }

    public static final int SP_TAG10(SPRITE sp) {
        return sp.owner & 0xFF;
    }

    public static final void SET_SP_TAG10(SPRITE sp, int var) {
        sp.owner = (short)(var & 0xFF | Gameutils.SP_TAG9(sp) << 8);
    }

    public static final int SP_TAG11(SPRITE sp) {
        return sp.shade;
    }

    public static final int SP_TAG12(SPRITE sp) {
        return sp.pal;
    }

    public static final int SP_TAG13(SPRITE sp) {
        return sp.xoffset & 0xFF | (sp.yoffset & 0xFF) << 8;
    }

    public static final void SET_SP_TAG13(SPRITE sp, int value) {
        sp.xoffset = (short)(value >>> 0 & 0xFF);
        sp.yoffset = (short)(value >>> 8 & 0xFF);
    }

    public static final int SP_TAG14(SPRITE sp) {
        return sp.xrepeat & 0xFF | (sp.yrepeat & 0xFF) << 8;
    }

    public static final void SET_SP_TAG14(SPRITE sp, int value) {
        sp.xrepeat = (short)(value >>> 0 & 0xFF);
        sp.yrepeat = (short)(value >>> 8 & 0xFF);
    }

    public static final int SP_TAG15(SPRITE sp) {
        return sp.z;
    }

    public static final int SPRITE_TAG1(int sp) {
        return Engine.sprite[sp].hitag;
    }

    public static final int SPRITE_TAG2(int sp) {
        return Engine.sprite[sp].lotag;
    }

    public static final int SPRITE_TAG3(int sp) {
        return Engine.sprite[sp].clipdist;
    }

    public static final int SPRITE_TAG4(int sp) {
        return Engine.sprite[sp].ang;
    }

    public static final int SPRITE_TAG5(int sp) {
        return Engine.sprite[sp].xvel;
    }

    public static final int SPRITE_TAG6(int sp) {
        return Engine.sprite[sp].yvel;
    }

    public static final int DRAG_WALL(int w) {
        return Engine.wall[Engine.wall[w].nextwall].point2;
    }

    public static final boolean SpriteInDiveArea(SPRITE sp) {
        return !ru.m210projects.Build.Gameutils.isValidSector(sp.sectnum) ? false : MyTypes.TEST(Engine.sector[sp.sectnum].extra, SECTFX_DIVE_AREA);
    }

    public static final boolean SpriteInUnderwaterArea(SPRITE sp) {
        return !ru.m210projects.Build.Gameutils.isValidSector(sp.sectnum) ? false : MyTypes.TEST(Engine.sector[sp.sectnum].extra, SECTFX_UNDERWATER | SECTFX_UNDERWATER2);
    }

    public static final boolean SectorIsDiveArea(int sect) {
        return !ru.m210projects.Build.Gameutils.isValidSector(sect) ? false : MyTypes.TEST(Engine.sector[sect].extra, SECTFX_DIVE_AREA);
    }

    public static final boolean SectorIsUnderwaterArea(int sect) {
        return !ru.m210projects.Build.Gameutils.isValidSector(sect) ? false : MyTypes.TEST(Engine.sector[sect].extra, SECTFX_UNDERWATER | SECTFX_UNDERWATER2);
    }

    public static final boolean FLAG_KEY_PRESSED(PlayerStr pp, int sync_key) {
        return MyTypes.TEST(pp.KeyPressFlags, 1 << sync_key);
    }

    public static final boolean FLAG_KEY_RELEASE(PlayerStr pp, int sync_key) {
        return (pp.KeyPressFlags &= ~(1 << sync_key)) != 0;
    }

    public static final int FLAG_KEY_RESET(PlayerStr pp, int sync_key) {
        return pp.KeyPressFlags |= 1 << sync_key;
    }

    public static final boolean TEST_SYNC_KEY(PlayerStr player, int sync_num) {
        return MyTypes.TEST(player.input.bits, 1 << sync_num);
    }

    public static final int RESET_SYNC_KEY(PlayerStr player, int sync_num) {
        return player.input.bits &= ~(1 << sync_num);
    }

    public static final short NORM_ANGLE(int ang) {
        return (short)(ang & 0x7FF);
    }

    public static final int ANGLE_2_PLAYER(PlayerStr pp, int x, int y) {
        return Gameutils.NORM_ANGLE(Main.engine.getangle(pp.posx - x, pp.posy - y));
    }

    public static final int STD_RANDOM_P2(int pwr_of_2) {
        return MyTypes.MOD_P2(Main.engine.rand(), pwr_of_2);
    }

    public static final int STD_RANDOM_RANGE(int range) {
        return Ai.StdRandomRange(range);
    }

    public static final int STD_RANDOM() {
        return Main.engine.rand();
    }

    public static final int MOVEx(int vel, int ang) {
        return vel * Engine.sintable[Gameutils.NORM_ANGLE(ang + 512)] >> 14;
    }

    public static final int MOVEy(int vel, int ang) {
        return vel * Engine.sintable[Gameutils.NORM_ANGLE(ang)] >> 14;
    }

    public static final int DIST(int x1, int y1, int x2, int y2) {
        return Main.engine.ksqrt(Gameutils.SQ(x1 - x2) + Gameutils.SQ(y1 - y2));
    }

    public static final int PIC_SIZX(int sn) {
        return Engine.tilesizx[Engine.sprite[sn].picnum];
    }

    public static final int PIC_SIZY(int sn) {
        return Engine.tilesizy[Engine.sprite[sn].picnum];
    }

    public static final int DISTANCE(int x1, int y1, int x2, int y2) {
        dist_x = Pragmas.klabs(x2 - x1);
        dist_y = Pragmas.klabs(y2 - y1);
        dist_min = Math.min(dist_x, dist_y);
        return dist_x + dist_y - MyTypes.DIV2(dist_min);
    }

    public static final int SPRITE_SIZE_X(int sp_num) {
        return Engine.sprite[sp_num].xrepeat == 64 ? Engine.tilesizx[Engine.sprite[sp_num].picnum] : Engine.sprite[sp_num].xrepeat * Engine.tilesizx[Engine.sprite[sp_num].picnum] >> 6;
    }

    public static final int SPRITE_SIZE_Y(int sp_num) {
        return Engine.sprite[sp_num].yrepeat == 64 ? Engine.tilesizy[Engine.sprite[sp_num].picnum] : Engine.sprite[sp_num].yrepeat * Engine.tilesizy[Engine.sprite[sp_num].picnum] >> 6;
    }

    public static final int SPRITE_SIZE_Z(int sp_num) {
        return Engine.sprite[sp_num].yrepeat == 64 ? Gameutils.Z(Engine.tilesizy[Engine.sprite[sp_num].picnum]) : Engine.sprite[sp_num].yrepeat * Engine.tilesizy[Engine.sprite[sp_num].picnum] << 2;
    }

    public static final int SPRITEp_SIZE_X(SPRITE sp) {
        return sp.xrepeat == 64 ? Engine.tilesizx[sp.picnum] : sp.xrepeat * Engine.tilesizx[sp.picnum] >> 6;
    }

    public static final int SPRITEp_SIZE_Y(SPRITE sp) {
        return sp.yrepeat == 64 ? Engine.tilesizy[sp.picnum] : sp.yrepeat * Engine.tilesizy[sp.picnum] >> 6;
    }

    public static final int SPRITEp_SIZE_Z(SPRITE sp) {
        return sp.yrepeat == 64 ? Gameutils.Z(Engine.tilesizy[sp.picnum]) : sp.yrepeat * Engine.tilesizy[sp.picnum] << 2;
    }

    public static final int SPRITEp_SIZE_X_2_XREPEAT(SPRITE sp, int x) {
        return x * 64 / Engine.tilesizx[sp.picnum];
    }

    public static final int SPRITEp_SIZE_Z_2_YREPEAT(SPRITE sp, int zh) {
        return zh / (4 * Engine.tilesizy[sp.picnum]);
    }

    public static final int SPRITEp_SIZE_Y_2_YREPEAT(SPRITE sp, int y) {
        return y * 64 / Engine.tilesizy[sp.picnum];
    }

    public static final int TILE_XOFF(int picnum) {
        return (byte)MyTypes.DTEST(Engine.picanm[picnum] >> 8, 255);
    }

    public static final int TILE_YOFF(int picnum) {
        return (byte)MyTypes.DTEST(Engine.picanm[picnum] >> 16, 255);
    }

    public static final int SPRITEp_XOFF(SPRITE sp) {
        return (byte)MyTypes.DTEST(Engine.picanm[sp.picnum] >> 8, 255);
    }

    public static final int SPRITEp_YOFF(SPRITE sp) {
        return (byte)MyTypes.DTEST(Engine.picanm[sp.picnum] >> 16, 255);
    }

    public static final int SPRITEp_SIZE_TOS(SPRITE sp) {
        return MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)) + Gameutils.Z(Gameutils.SPRITEp_YOFF(sp));
    }

    public static final int SPRITEp_SIZE_BOS(SPRITE sp) {
        return MyTypes.DIV2(Gameutils.SPRITEp_SIZE_Z(sp)) - Gameutils.Z(Gameutils.SPRITEp_YOFF(sp));
    }

    public static final int SPRITEp_TOS(SPRITE sp) {
        return MyTypes.TEST(sp.cstat, CSTAT_SPRITE_YCENTER) ? sp.z - Gameutils.SPRITEp_SIZE_TOS(sp) : sp.z - Gameutils.SPRITEp_SIZE_Z(sp);
    }

    public static final int SPRITEp_BOS(SPRITE sp) {
        return MyTypes.TEST(sp.cstat, CSTAT_SPRITE_YCENTER) ? sp.z + Gameutils.SPRITEp_SIZE_BOS(sp) : sp.z;
    }

    public static final int SPRITEp_MID(SPRITE sp) {
        return MyTypes.DIV2(Gameutils.SPRITEp_TOS(sp) + Gameutils.SPRITEp_BOS(sp));
    }

    public static final int SPRITEp_UPPER(SPRITE sp) {
        return Gameutils.SPRITEp_TOS(sp) + MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(sp));
    }

    public static final int SPRITEp_LOWER(SPRITE sp) {
        return Gameutils.SPRITEp_BOS(sp) - MyTypes.DIV4(Gameutils.SPRITEp_SIZE_Z(sp));
    }

    public static final int Z(int value) {
        return value << 8;
    }

    public static final int PIXZ(int value) {
        return value >> 8;
    }

    public static final int SQ(int val) {
        return val * val;
    }

    public static final boolean KENFACING_PLAYER(PlayerStr pp, SPRITE sp) {
        return Engine.sintable[Gameutils.NORM_ANGLE(sp.ang + 512)] * (pp.posy - sp.y) >= Engine.sintable[Gameutils.NORM_ANGLE(sp.ang)] * (pp.posx - sp.x);
    }

    public static final boolean FACING_PLAYER(PlayerStr pp, SPRITE sp) {
        return Pragmas.klabs(Player.GetDeltaAngle(sp.ang, Gameutils.NORM_ANGLE(Main.engine.getangle(pp.posx - sp.x, pp.posy - sp.y)))) < 512;
    }

    public static final boolean PLAYER_FACING(PlayerStr pp, SPRITE sp) {
        return Pragmas.klabs(Player.GetDeltaAngle(pp.getAnglei(), Gameutils.NORM_ANGLE(Main.engine.getangle(sp.x - pp.posx, sp.y - pp.posy)))) < 320;
    }

    public static final boolean FACING(SPRITE sp1, SPRITE sp2) {
        return Pragmas.klabs(Player.GetDeltaAngle(sp2.ang, Gameutils.NORM_ANGLE(Main.engine.getangle(sp1.x - sp2.x, sp1.y - sp2.y)))) < 512;
    }

    public static final boolean FACING_PLAYER_RANGE(PlayerStr pp, SPRITE sp, int range) {
        return Pragmas.klabs(Player.GetDeltaAngle(sp.ang, Gameutils.NORM_ANGLE(Main.engine.getangle(pp.posx - sp.x, pp.posy - sp.y)))) < range;
    }

    public static final boolean PLAYER_FACING_RANGE(PlayerStr pp, SPRITE sp, int range) {
        return Pragmas.klabs(Player.GetDeltaAngle(pp.getAnglei(), Gameutils.NORM_ANGLE(Main.engine.getangle(sp.x - pp.posx, sp.y - pp.posy)))) < range;
    }

    public static final boolean FACING_RANGE(SPRITE sp1, SPRITE sp2, int range) {
        return Pragmas.klabs(Player.GetDeltaAngle(sp2.ang, Gameutils.NORM_ANGLE(Main.engine.getangle(sp1.x - sp2.x, sp1.y - sp2.y)))) < range;
    }

    public static final int DOT_PRODUCT_2D(int x1, int y1, int x2, int y2) {
        return Pragmas.mulscale(x1, x2, 16) + Pragmas.mulscale(y1, y2, 16);
    }

    public static final int DOT_PRODUCT_3D(int x1, int y1, int z1, int x2, int y2, int z2) {
        return Pragmas.mulscale(x1, x2, 16) + Pragmas.mulscale(y1, y2, 16) + Pragmas.mulscale(z1, z2, 16);
    }

    public static final int PLAYER_MOVING(PlayerStr pp) {
        return pp.xvect | pp.yvect;
    }

    public static final boolean TEST_GOTSECTOR(int sect_num) {
        return MyTypes.TEST(Engine.gotsector[sect_num >> 3], 1 << (sect_num & 7));
    }

    public static final int RESET_GOTSECTOR(int sect_num) {
        int n = sect_num >> 3;
        byte by = (byte)(Engine.gotsector[n] & ~(1 << (sect_num & 7)));
        Engine.gotsector[n] = by;
        return by;
    }

    public static final int SET_GOTSECTOR(int sect_num) {
        int n = sect_num >> 3;
        byte by = (byte)(Engine.gotsector[n] | 1 << (sect_num & 7));
        Engine.gotsector[n] = by;
        return by;
    }

    public static final boolean TEST_GOTPIC(int tile_num) {
        return tile_num == -1 ? false : MyTypes.TEST(Engine.gotpic[tile_num >> 3], 1 << (tile_num & 7));
    }

    public static final int RESET_GOTPIC(int tile_num) {
        int n = tile_num >> 3;
        byte by = (byte)(Engine.gotpic[n] & ~(1 << (tile_num & 7)));
        Engine.gotpic[n] = by;
        return by;
    }

    public static final int SET_GOTPIC(int tile_num) {
        int n = tile_num >> 3;
        byte by = (byte)(Engine.gotpic[n] | 1 << (tile_num & 7));
        Engine.gotpic[n] = by;
        return by;
    }

    public static final int LOW_TAG(int sectnum) {
        return ru.m210projects.Build.Gameutils.isValidSector(sectnum) ? (int)Engine.sector[sectnum].lotag : 0;
    }

    public static final int HIGH_TAG(int sectnum) {
        return ru.m210projects.Build.Gameutils.isValidSector(sectnum) ? (int)Engine.sector[sectnum].hitag : 0;
    }

    public static final int LOW_TAG_SPRITE(int spnum) {
        return ru.m210projects.Build.Gameutils.isValidSprite(spnum) ? (int)Engine.sprite[spnum].lotag : 0;
    }

    public static final int HIGH_TAG_SPRITE(int spnum) {
        return ru.m210projects.Build.Gameutils.isValidSprite(spnum) ? (int)Engine.sprite[spnum].hitag : 0;
    }

    public static final int LOW_TAG_WALL(int wallnum) {
        return ru.m210projects.Build.Gameutils.isValidWall(wallnum) ? (int)Engine.wall[wallnum].lotag : 0;
    }

    public static final int HIGH_TAG_WALL(int wallnum) {
        return ru.m210projects.Build.Gameutils.isValidWall(wallnum) ? (int)Engine.wall[wallnum].hitag : 0;
    }

    public static final int SEC(int value) {
        return value * 120;
    }

    public static final short NORM_SPRITE(int val) {
        return (short)(val & Engine.MAXSPRITES - 1);
    }

    public static final short NORM_WALL(int val) {
        return (short)(val & Engine.MAXWALLS - 1);
    }

    public static final short NORM_SECTOR(int val) {
        return (short)(val & Engine.MAXSECTORS - 1);
    }

    public static final int CS(int sprite_bit) {
        return sprite_bit << 16;
    }

    public static final int SET_BOOL1(SPRITE sp) {
        sp.extra = (short)(sp.extra | SPRX_BOOL1);
        return sp.extra;
    }

    public static final int SET_BOOL2(SPRITE sp) {
        sp.extra = (short)(sp.extra | SPRX_BOOL2);
        return sp.extra;
    }

    public static final int SET_BOOL3(SPRITE sp) {
        sp.extra = (short)(sp.extra | SPRX_BOOL3);
        return sp.extra;
    }

    public static final int SET_BOOL4(SPRITE sp) {
        sp.extra = (short)(sp.extra | SPRX_BOOL4);
        return sp.extra;
    }

    public static final int SET_BOOL5(SPRITE sp) {
        sp.extra = (short)(sp.extra | SPRX_BOOL5);
        return sp.extra;
    }

    public static final int SET_BOOL6(SPRITE sp) {
        sp.extra = (short)(sp.extra | SPRX_BOOL6);
        return sp.extra;
    }

    public static final int SET_BOOL7(SPRITE sp) {
        sp.extra = (short)(sp.extra | SPRX_BOOL7);
        return sp.extra;
    }

    public static final int SET_BOOL8(SPRITE sp) {
        sp.extra = (short)(sp.extra | SPRX_BOOL8);
        return sp.extra;
    }

    public static final int SET_BOOL9(SPRITE sp) {
        sp.extra = (short)(sp.extra | SPRX_BOOL9);
        return sp.extra;
    }

    public static final int SET_BOOL10(SPRITE sp) {
        sp.extra = (short)(sp.extra | SPRX_BOOL10);
        return sp.extra;
    }

    public static final int SET_BOOL11(SPRITE sp) {
        sp.extra = (short)(sp.extra | SPRX_BOOL11);
        return sp.extra;
    }

    public static final int RESET_BOOL1(SPRITE sp) {
        sp.extra = (short)(sp.extra & ~SPRX_BOOL1);
        return sp.extra;
    }

    public static final int RESET_BOOL2(SPRITE sp) {
        sp.extra = (short)(sp.extra & ~SPRX_BOOL2);
        return sp.extra;
    }

    public static final int RESET_BOOL3(SPRITE sp) {
        sp.extra = (short)(sp.extra & ~SPRX_BOOL3);
        return sp.extra;
    }

    public static final int RESET_BOOL4(SPRITE sp) {
        sp.extra = (short)(sp.extra & ~SPRX_BOOL4);
        return sp.extra;
    }

    public static final int RESET_BOOL5(SPRITE sp) {
        sp.extra = (short)(sp.extra & ~SPRX_BOOL5);
        return sp.extra;
    }

    public static final int RESET_BOOL6(SPRITE sp) {
        sp.extra = (short)(sp.extra & ~SPRX_BOOL6);
        return sp.extra;
    }

    public static final int RESET_BOOL7(SPRITE sp) {
        sp.extra = (short)(sp.extra & ~SPRX_BOOL7);
        return sp.extra;
    }

    public static final int RESET_BOOL8(SPRITE sp) {
        sp.extra = (short)(sp.extra & ~SPRX_BOOL8);
        return sp.extra;
    }

    public static final int RESET_BOOL9(SPRITE sp) {
        sp.extra = (short)(sp.extra & ~SPRX_BOOL9);
        return sp.extra;
    }

    public static final int RESET_BOOL10(SPRITE sp) {
        sp.extra = (short)(sp.extra & ~SPRX_BOOL10);
        return sp.extra;
    }

    public static final int RESET_BOOL11(SPRITE sp) {
        sp.extra = (short)(sp.extra & ~SPRX_BOOL11);
        return sp.extra;
    }

    public static final boolean TEST_BOOL1(SPRITE sp) {
        return MyTypes.TEST(sp.extra, SPRX_BOOL1);
    }

    public static final boolean TEST_BOOL2(SPRITE sp) {
        return MyTypes.TEST(sp.extra, SPRX_BOOL2);
    }

    public static final boolean TEST_BOOL3(SPRITE sp) {
        return MyTypes.TEST(sp.extra, SPRX_BOOL3);
    }

    public static final boolean TEST_BOOL4(SPRITE sp) {
        return MyTypes.TEST(sp.extra, SPRX_BOOL4);
    }

    public static final boolean TEST_BOOL5(SPRITE sp) {
        return MyTypes.TEST(sp.extra, SPRX_BOOL5);
    }

    public static final boolean TEST_BOOL6(SPRITE sp) {
        return MyTypes.TEST(sp.extra, SPRX_BOOL6);
    }

    public static final boolean TEST_BOOL7(SPRITE sp) {
        return MyTypes.TEST(sp.extra, SPRX_BOOL7);
    }

    public static final boolean TEST_BOOL8(SPRITE sp) {
        return MyTypes.TEST(sp.extra, SPRX_BOOL8);
    }

    public static final boolean TEST_BOOL9(SPRITE sp) {
        return MyTypes.TEST(sp.extra, SPRX_BOOL9);
    }

    public static final boolean TEST_BOOL10(SPRITE sp) {
        return MyTypes.TEST(sp.extra, SPRX_BOOL10);
    }

    public static final boolean TEST_BOOL11(SPRITE sp) {
        return MyTypes.TEST(sp.extra, SPRX_BOOL11);
    }

    public static final boolean FAF_ConnectCeiling(int sectnum) {
        return ru.m210projects.Build.Gameutils.isValidSector(sectnum) ? Engine.sector[sectnum].ceilingpicnum == 2356 : false;
    }

    public static final boolean FAF_ConnectFloor(int sectnum) {
        return ru.m210projects.Build.Gameutils.isValidSector(sectnum) ? Engine.sector[sectnum].floorpicnum == 2356 : false;
    }

    public static final boolean FAF_ConnectArea(int sectnum) {
        return Gameutils.FAF_ConnectCeiling(sectnum) || Gameutils.FAF_ConnectFloor(sectnum);
    }

    public static final int TEXT_XCENTER(int width) {
        return (320 - width) / 2;
    }

    public static final int TEXT_YCENTER(int height) {
        return (200 - height) / 2;
    }

    public static final int TEXT_TEST_COL(int width) {
        return Gameutils.TEXT_XCENTER(width);
    }

    public static final int RANDOM_P2(int pwr_of_2) {
        return MyTypes.MOD_P2(Main.engine.krand(), pwr_of_2);
    }

    public static final int RANDOM_RANGE(int range) {
        return Ai.RandomRange(range);
    }

    public static final int RANDOM() {
        return Main.engine.krand();
    }

    public static int FindDistance2D(int dx, int dy) {
        dx = Pragmas.klabs(dx);
        dy = Pragmas.klabs(dy);
        if (dx == 0) {
            return dy;
        }
        if (dy == 0) {
            return dx;
        }
        if (dy < dx) {
            int i = dx;
            dx = dy;
            dy = i;
        }
        dx += dx >> 1;
        return (dx >> 6) + (dx >> 2) + dy - (dy >> 5) - (dy >> 7);
    }

    public static int FindDistance3D(int dx, int dy, int dz) {
        int i;
        dx = Pragmas.klabs(dx);
        dy = Pragmas.klabs(dy);
        dz = Pragmas.klabs(dz);
        if (dx < dy) {
            i = dx;
            dx = dy;
            dy = i;
        }
        if (dx < dz) {
            i = dx;
            dx = dz;
            dz = i;
        }
        int t = dy + dz;
        return dx - (dx >> 4) + (t >> 2) + (t >> 3);
    }

    static enum FootType {
        WATER_FOOT,
        BLOOD_FOOT;

    }
}

