/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Type;

import java.nio.ByteBuffer;
import ru.m210projects.Build.Audio.SoundData;
import ru.m210projects.Build.Types.LittleEndian;

public class VOC
extends SoundData {
    private int datalen;

    public VOC(byte[] data) {
        if (data == null) {
            return;
        }
        this.getInfo(data);
        boolean eightbit = this.bits == 8;
        byte[] buf = this.convertData(data, this.datalen, eightbit);
        int samplelength = buf.length;
        if (!eightbit && samplelength % 2 == 1) {
            ++samplelength;
        }
        this.data = ByteBuffer.allocateDirect(samplelength);
        this.data.put(buf);
        this.data.rewind();
    }

    private void getInfo(byte[] data) {
        byte blocktype = 0;
        int blocklen = 0;
        String signature = new String(data, 0, 19);
        if (!signature.equalsIgnoreCase("Creative Voice File") && data[19] != 26) {
            return;
        }
        int tptr = 22;
        short version = LittleEndian.getShort(data, tptr);
        short checksum = LittleEndian.getShort(data, tptr += 2);
        tptr += 2;
        if (~version + 4660 != checksum) {
            return;
        }
        this.datalen = 0;
        block6: while (true) {
            if (tptr >= data.length - 4) {
                return;
            }
            blocktype = data[tptr];
            if (blocktype == 0) break;
            blocklen = LittleEndian.getInt(data, tptr + 1) & 0xFFFFFF;
            int ptr = tptr += 4;
            switch (blocktype) {
                case 1: {
                    this.rate = 1000000 / (256 - (data[tptr++] & 0xFF));
                    if (data[tptr++] != 0) {
                        return;
                    }
                    if (ptr + blocklen >= data.length) {
                        blocklen = data.length - ptr - 1;
                    }
                    this.channels = 1;
                    this.bits = 8;
                    this.datalen += blocklen - 2;
                    tptr = ptr + blocklen;
                    continue block6;
                }
                case 2: {
                    if (ptr + blocklen >= data.length) {
                        blocklen = data.length - ptr - 1;
                    }
                    this.datalen += blocklen;
                    tptr = ptr + blocklen;
                    continue block6;
                }
                case 8: {
                    short samplerate = LittleEndian.getShort(data, tptr);
                    this.rate = 256000000 / (65536 - (samplerate & 0xFFFF));
                    this.bits = 8;
                    if (data[(tptr += 2) + 1] == 1) {
                        this.rate >>= 1;
                        this.channels = 2;
                    } else {
                        this.channels = 1;
                    }
                    if (data[tptr] != 0) {
                        return;
                    }
                    tptr += 2;
                    continue block6;
                }
                case 9: {
                    this.rate = LittleEndian.getInt(data, tptr);
                    this.bits = data[tptr += 4] & 0xFF;
                    if (this.bits == 0) {
                        this.bits = 8;
                    }
                    this.channels = data[tptr + 1] & 0xFF;
                    if ((data[tptr + 2] & 0xFF | (data[tptr + 3] & 0xFF) << 8) != 0 && (data[tptr + 2] & 0xFF | (data[tptr + 3] & 0xFF) << 8) != 4) {
                        return;
                    }
                    tptr += 4;
                    if (ptr + blocklen >= data.length) {
                        blocklen = data.length - ptr - 1;
                    }
                    this.datalen += blocklen - 12;
                    tptr = ptr + blocklen;
                    continue block6;
                }
            }
            if (ptr + blocklen >= data.length) {
                blocklen = data.length - ptr - 1;
            }
            tptr = ptr + blocklen;
        }
    }

    private byte[] convertData(byte[] data, int bufferlen, boolean eightbit) {
        byte blocktype = 0;
        int blocklen = 0;
        byte[] buf = new byte[bufferlen];
        int pos = 26;
        int bufptr = 0;
        block5: while (bufferlen > 0) {
            int br;
            if ((blocktype = data[pos++]) == 0) break;
            blocklen = data[pos++] & 0xFF;
            blocklen |= (data[pos++] & 0xFF) << 8;
            blocklen |= (data[pos++] & 0xFF) << 16;
            switch (blocktype) {
                case 1: {
                    pos += 2;
                    br = Math.min(blocklen - 2, bufferlen);
                    break;
                }
                case 2: {
                    br = Math.min(blocklen, bufferlen);
                    break;
                }
                case 9: {
                    pos += 12;
                    br = Math.min(blocklen - 12, bufferlen);
                    break;
                }
                default: {
                    pos += blocklen;
                    continue block5;
                }
            }
            System.arraycopy(data, pos, buf, bufptr, br);
            bufferlen -= br;
            bufptr += br;
            pos += br;
        }
        return buf;
    }
}

