/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Weapons;

import ru.m210projects.Build.Engine;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.Panel_Sprite_Func;
import ru.m210projects.Wang.Type.Panel_State;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Vis;
import ru.m210projects.Wang.Weapon;
import ru.m210projects.Wang.Weapons.Uzi;

public class HotHead {
    private static final int HOTHEAD_REST = 2048;
    private static final int HOTHEAD_ATTACK = 2049;
    private static final int ID_HotheadPresent0 = 2048;
    private static final int ID_HotheadRest0 = 2048;
    private static final int ID_HotheadAttack0 = 2049;
    private static final int HOTHEAD_BOB_X_AMT = 10;
    private static final int HOTHEAD_XOFF = 216;
    private static final int HOTHEAD_YOFF = 200;
    private static final int HOTHEAD_FINGER_XOFF = 0;
    private static final int HOTHEAD_FINGER_YOFF = 0;
    private static final int Hothead_BEAT_RATE = 24;
    private static final int Hothead_ACTION_RATE_PRE = 2;
    private static final Panel_Sprite_Func pHotheadPresent = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            if (MyTypes.TEST(psp.PlayerP().Flags, Gameutils.PF_WEAPON_RETRACT)) {
                return;
            }
            psp.y -= 9;
            if (psp.y < 200) {
                psp.yorig = psp.y = 200;
                Panel.pSetState(psp, psp.RestState);
            }
        }
    };
    private static final Panel_Sprite_Func pHotheadHide = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            short picnum = psp.picndx;
            psp.x += 9;
            if (psp.x >= 216 + Engine.tilesizx[picnum] || psp.y >= 200 + Engine.tilesizy[picnum]) {
                psp.x = 216;
                psp.y = 200 + Engine.tilesizy[picnum];
                Panel.pWeaponUnHideKeys(psp, psp.PresentState);
            }
        }
    };
    private static final Panel_Sprite_Func pHotheadRetract = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            short picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 200 + Engine.tilesizy[picnum]) {
                psp.PlayerP().Flags &= ~Gameutils.PF_WEAPON_RETRACT;
                psp.PlayerP().Wpn[8] = null;
                Panel.pKillSprite(psp);
            }
        }
    };
    private static final Panel_Sprite_Func pHotheadRest = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            boolean force;
            boolean bl = force = MyTypes.TEST(psp.flags, Panel.PANF_UNHIDE_SHOOT);
            if (Panel.pWeaponHideKeys(psp, ps_HotheadHide[0])) {
                return;
            }
            if (HotheadRestStates[psp.PlayerP().WpnFlameType][0] != psp.RestState) {
                psp.RestState = HotheadRestStates[psp.PlayerP().WpnFlameType][0];
                Panel.pSetState(psp, HotheadRestStates[psp.PlayerP().WpnFlameType][0]);
            }
            HotHead.pHotheadBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
            if (Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) || force) {
                if (Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17) || force) {
                    psp.flags &= ~Panel.PANF_UNHIDE_SHOOT;
                    if (!Panel.WeaponOK(psp.PlayerP())) {
                        return;
                    }
                    if (psp.PlayerP().WpnAmmo[8] < 10) {
                        psp.PlayerP().WpnFlameType = 0;
                        Panel.WeaponOK(psp.PlayerP());
                    }
                    Panel.DoPlayerChooseYell(psp.PlayerP());
                    Panel.pSetState(psp, HotheadAttackStates[psp.PlayerP().WpnFlameType][0]);
                    psp.over[0].xoff = (short)-1;
                    psp.over[0].yoff = (short)-10;
                }
            } else {
                Panel.WeaponOK(psp.PlayerP());
            }
        }
    };
    private static final Panel_State[] ps_PresentHothead = new Panel_State[]{new Panel_State(2048, 24, pHotheadPresent).setNext()};
    private static final Panel_State[] ps_HotheadHide = new Panel_State[]{new Panel_State(2048, 24, pHotheadHide).setNext()};
    private static final Panel_State[] ps_RetractHothead = new Panel_State[]{new Panel_State(2048, 24, pHotheadRetract).setNext()};
    private static final Panel_State[] ps_HotheadRest = new Panel_State[]{new Panel_State(2048, 24, pHotheadRest).setNext()};
    private static final Panel_State[] ps_HotheadRestRing = new Panel_State[]{new Panel_State(2048, 24, pHotheadRest).setNext(ps_HotheadRest[0])};
    private static final Panel_State[] ps_HotheadRestNapalm = new Panel_State[]{new Panel_State(2048, 24, pHotheadRest).setNext(ps_HotheadRest[0])};
    private static final Panel_Sprite_Func pHotheadAction = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            boolean shooting;
            boolean bl = shooting = Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) && Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17);
            if (shooting) {
                Uzi.pUziBobSetup(psp);
                Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0 || shooting);
            }
        }
    };
    private static final Panel_Sprite_Func pHotheadAttack = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            switch (psp.PlayerP().WpnFlameType) {
                case 0: {
                    Vis.SpawnVis(psp.PlayerP().PlayerSprite, -1, -1, -1, -1, 32);
                    Weapon.InitFireball(psp.PlayerP());
                    break;
                }
                case 1: {
                    Vis.SpawnVis(psp.PlayerP().PlayerSprite, -1, -1, -1, -1, 20);
                    Weapon.InitSpellRing(psp.PlayerP());
                    break;
                }
                case 2: {
                    Vis.SpawnVis(psp.PlayerP().PlayerSprite, -1, -1, -1, -1, 16);
                    Weapon.InitSpellNapalm(psp.PlayerP());
                }
            }
        }
    };
    private static final Panel_Sprite_Func pHotheadRestTest = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            if (Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) && Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17)) {
                if (!Panel.WeaponOK(psp.PlayerP())) {
                    return;
                }
                if (psp.PlayerP().WpnAmmo[8] < 10) {
                    psp.PlayerP().WpnFlameType = 0;
                    Panel.WeaponOK(psp.PlayerP());
                }
                Panel.DoPlayerChooseYell(psp.PlayerP());
                Panel.pStatePlusOne(psp);
                return;
            }
            Panel.pSetState(psp, HotheadRestStates[psp.PlayerP().WpnFlameType][0]);
            psp.over[0].xoff = 0;
            psp.over[0].yoff = 0;
        }
    };
    private static final Panel_State ps_HotheadAttack_0 = new Panel_State(2049, 2, pHotheadAction);
    private static final Panel_State ps_HotheadAttack_1 = new Panel_State(2049, 3, pHotheadAction);
    private static final Panel_State ps_HotheadAttack_2 = new Panel_State(2049, 0, pHotheadAttack);
    private static final Panel_State ps_HotheadAttack_3 = new Panel_State(2049, 3, pHotheadAction);
    private static final Panel_State ps_HotheadAttack_4 = new Panel_State(2049, 0, pHotheadRestTest);
    private static final Panel_State ps_HotheadAttack_5 = new Panel_State(2049, 0, pHotheadAction);
    private static final Panel_State[] ps_HotheadAttack = new Panel_State[]{ps_HotheadAttack_0.setNext(ps_HotheadAttack_1).setFlags(Panel.psf_ShadeHalf), ps_HotheadAttack_1.setNext(ps_HotheadAttack_2).setFlags(Panel.psf_ShadeHalf), ps_HotheadAttack_2.setNext(ps_HotheadAttack_3).setFlags(Panel.psf_QuickCall), ps_HotheadAttack_3.setNext(ps_HotheadAttack_4).setFlags(Panel.psf_ShadeHalf), ps_HotheadAttack_4.setNext().setPlusOne(ps_HotheadAttack_5).setFlags(Panel.psf_QuickCall), ps_HotheadAttack_5.setNext(ps_HotheadAttack_0).setFlags(Panel.psf_ShadeHalf)};
    private static final Panel_State ps_HotheadRing_0 = new Panel_State(2049, 2, pHotheadAction);
    private static final Panel_State ps_HotheadRing_1 = new Panel_State(2049, 10, pHotheadAction);
    private static final Panel_State ps_HotheadRing_2 = new Panel_State(2049, 0, pHotheadAttack);
    private static final Panel_State ps_HotheadRing_3 = new Panel_State(2049, 40, pHotheadAction);
    private static final Panel_State ps_HotheadRing_4 = new Panel_State(2049, 0, pHotheadRestTest);
    private static final Panel_State ps_HotheadRing_5 = new Panel_State(2049, 3, pHotheadAction);
    private static final Panel_State[] ps_HotheadRing = new Panel_State[]{ps_HotheadRing_0.setNext(ps_HotheadRing_1).setFlags(Panel.psf_ShadeHalf), ps_HotheadRing_1.setNext(ps_HotheadRing_2).setFlags(Panel.psf_ShadeHalf), ps_HotheadRing_2.setNext(ps_HotheadRing_3).setFlags(Panel.psf_QuickCall), ps_HotheadRing_3.setNext(ps_HotheadRing_4).setFlags(Panel.psf_ShadeHalf), ps_HotheadRing_4.setNext().setPlusOne(ps_HotheadRing_5).setFlags(Panel.psf_QuickCall), ps_HotheadRing_5.setNext(ps_HotheadRing_0).setFlags(Panel.psf_ShadeHalf)};
    private static final Panel_State ps_HotheadNapalm_0 = new Panel_State(2049, 2, pHotheadAction);
    private static final Panel_State ps_HotheadNapalm_1 = new Panel_State(2049, 3, pHotheadAction);
    private static final Panel_State ps_HotheadNapalm_2 = new Panel_State(2049, 0, pHotheadAttack);
    private static final Panel_State ps_HotheadNapalm_3 = new Panel_State(2049, 50, pHotheadAction);
    private static final Panel_State ps_HotheadNapalm_4 = new Panel_State(2049, 0, pHotheadRestTest);
    private static final Panel_State ps_HotheadNapalm_5 = new Panel_State(2049, 3, pHotheadAction);
    private static final Panel_State[] ps_HotheadNapalm = new Panel_State[]{ps_HotheadNapalm_0.setNext(ps_HotheadNapalm_1).setFlags(Panel.psf_ShadeHalf), ps_HotheadNapalm_1.setNext(ps_HotheadNapalm_2).setFlags(Panel.psf_ShadeHalf), ps_HotheadNapalm_2.setNext(ps_HotheadNapalm_3).setFlags(Panel.psf_QuickCall), ps_HotheadNapalm_3.setNext(ps_HotheadNapalm_4).setFlags(Panel.psf_ShadeHalf), ps_HotheadNapalm_4.setNext().setPlusOne(ps_HotheadNapalm_5).setFlags(Panel.psf_QuickCall), ps_HotheadNapalm_5.setNext(ps_HotheadNapalm_0).setFlags(Panel.psf_ShadeHalf)};
    private static final Panel_State[][] HotheadRestStates = new Panel_State[][]{ps_HotheadRest, ps_HotheadRestRing, ps_HotheadRestNapalm};
    private static final Panel_State[][] HotheadAttackStates = new Panel_State[][]{ps_HotheadAttack, ps_HotheadRing, ps_HotheadNapalm};

    public static void pHotHeadOverlays(Panel_Sprite psp, short mode) {
        switch (mode) {
            case 0: {
                psp.over[0].pic = (short)2055;
                break;
            }
            case 1: {
                psp.over[0].pic = (short)2056;
                break;
            }
            case 2: {
                psp.over[0].pic = (short)2057;
            }
        }
    }

    public static void InitWeaponHothead(PlayerStr pp) {
        Panel_Sprite psp = null;
        if (WangNetwork.Prediction) {
            return;
        }
        if (!MyTypes.TEST(pp.WpnFlags, MyTypes.BIT(8)) || MyTypes.TEST(pp.Flags, Gameutils.PF_WEAPON_RETRACT)) {
            return;
        }
        if (pp.Wpn[8] == null) {
            psp = pp.Wpn[8] = Panel.pSpawnSprite(pp, ps_PresentHothead[0], 128, 216, 200);
            psp.y += Engine.tilesizy[psp.picndx];
        }
        if (pp.CurWpn == pp.Wpn[8]) {
            return;
        }
        psp.WeaponType = (short)8;
        Panel.PlayerUpdateWeapon(pp, 8);
        pp.WpnUziType = (byte)2;
        Panel.RetractCurWpn(pp);
        psp = pp.CurWpn = pp.Wpn[8];
        psp.flags |= Panel.PANF_WEAPON_SPRITE;
        psp.ActionState = ps_HotheadAttack[0];
        psp.PresentState = ps_PresentHothead[0];
        psp.RestState = HotheadRestStates[psp.PlayerP().WpnFlameType][0];
        psp.RetractState = ps_RetractHothead[0];
        Panel.pSetState(psp, psp.PresentState);
        psp.ang = (short)768;
        psp.vel = (short)512;
        Gameutils.FLAG_KEY_RELEASE(psp.PlayerP(), 17);
        Gameutils.FLAG_KEY_RESET(psp.PlayerP(), 17);
        HotHead.pHotHeadOverlays(psp, pp.WpnFlameType);
        psp.over[0].xoff = 0;
        psp.over[0].yoff = 0;
        Sound.PlaySound(102, pp, 9);
    }

    private static void pHotheadBobSetup(Panel_Sprite psp) {
        if (MyTypes.TEST(psp.flags, Panel.PANF_BOB)) {
            return;
        }
        psp.xorig = psp.x;
        psp.yorig = psp.y;
        psp.sin_amt = (short)10;
        psp.sin_ndx = 0;
        psp.bob_height_shift = (short)2;
    }

    public static void HotHeadSaveable() {
        Saveable.SaveData(ps_PresentHothead);
        Saveable.SaveData(ps_HotheadHide);
        Saveable.SaveData(ps_RetractHothead);
        Saveable.SaveData(ps_HotheadRest);
        Saveable.SaveData(ps_HotheadRestRing);
        Saveable.SaveData(ps_HotheadRestNapalm);
        Saveable.SaveData(ps_HotheadAttack);
        Saveable.SaveData(ps_HotheadRing);
        Saveable.SaveData(ps_HotheadNapalm);
        Saveable.SaveData(pHotheadPresent);
        Saveable.SaveData(pHotheadHide);
        Saveable.SaveData(pHotheadRetract);
        Saveable.SaveData(pHotheadRest);
        Saveable.SaveData(pHotheadAction);
        Saveable.SaveData(pHotheadAttack);
        Saveable.SaveData(pHotheadRestTest);
    }
}

