/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Wang.Weapons;

import ru.m210projects.Build.Engine;
import ru.m210projects.Wang.Factory.WangNetwork;
import ru.m210projects.Wang.Gameutils;
import ru.m210projects.Wang.Panel;
import ru.m210projects.Wang.Sound;
import ru.m210projects.Wang.Text;
import ru.m210projects.Wang.Type.MyTypes;
import ru.m210projects.Wang.Type.Panel_Sprite;
import ru.m210projects.Wang.Type.Panel_Sprite_Func;
import ru.m210projects.Wang.Type.Panel_State;
import ru.m210projects.Wang.Type.PlayerStr;
import ru.m210projects.Wang.Type.Saveable;
import ru.m210projects.Wang.Weapon;

public class Mine {
    private static final int MINE_YOFF = 200;
    private static final int MINE_XOFF = 210;
    private static final int Mine_REST_RATE = 24;
    private static final int Mine_ACTION_RATE = 6;
    private static final int MINE_REST = 2220;
    private static final int MINE_THROW = 2222;
    private static final int ID_MinePresent0 = 2220;
    private static final int ID_MinePresent1 = 2221;
    private static final int ID_MineThrow0 = 2222;
    private static final Panel_Sprite_Func pMinePresent = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            if (MyTypes.TEST(psp.PlayerP().Flags, Gameutils.PF_WEAPON_RETRACT)) {
                return;
            }
            psp.y -= 9;
            if (psp.y < 200) {
                psp.y = 200;
                psp.rotate_ang = 0;
                psp.yorig = psp.y;
                Panel.pSetState(psp, psp.RestState);
            }
        }
    };
    private static final Panel_State[] ps_PresentMine = new Panel_State[]{new Panel_State(2220, 24, pMinePresent).setNext()};
    private static final Panel_Sprite_Func pMineRetract = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            short picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 200 + Engine.tilesizy[picnum]) {
                psp.PlayerP().Flags &= ~Gameutils.PF_WEAPON_RETRACT;
                psp.PlayerP().Wpn[6] = null;
                Panel.pKillSprite(psp);
            }
        }
    };
    private static final Panel_State[] ps_RetractMine = new Panel_State[]{new Panel_State(2220, 24, pMineRetract).setNext()};
    private static final Panel_Sprite_Func pMineHide = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            short picnum = psp.picndx;
            psp.y += 9;
            if (psp.y >= 200 + Engine.tilesizy[picnum]) {
                psp.y = 200 + Engine.tilesizy[picnum];
                psp.x = 210;
                Panel.pWeaponUnHideKeys(psp, psp.PresentState);
            }
        }
    };
    private static final Panel_State[] ps_MineHide = new Panel_State[]{new Panel_State(2220, 24, pMineHide).setNext()};
    private static final Panel_Sprite_Func pMineRest = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            boolean force;
            boolean bl = force = MyTypes.TEST(psp.flags, Panel.PANF_UNHIDE_SHOOT);
            if (Panel.pWeaponHideKeys(psp, ps_MineHide[0])) {
                return;
            }
            Mine.pMineBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
            if (Gameutils.TEST_SYNC_KEY(psp.PlayerP(), 17) || force) {
                if (Gameutils.FLAG_KEY_PRESSED(psp.PlayerP(), 17) || force) {
                    psp.flags &= ~Panel.PANF_UNHIDE_SHOOT;
                    Panel.DoPlayerChooseYell(psp.PlayerP());
                    Panel.pSetState(psp, psp.ActionState);
                }
            } else {
                Panel.WeaponOK(psp.PlayerP());
            }
        }
    };
    private static final Panel_Sprite_Func pMineUpSound = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            PlayerStr pp = psp.PlayerP();
            Sound.PlaySound(244, pp, 1);
        }
    };
    private static final Panel_State ps_MineRest_0 = new Panel_State(2220, 36, pMineRest);
    private static final Panel_State ps_MineRest_1 = new Panel_State(2220, 0, pMineUpSound);
    private static final Panel_State ps_MineRest_2 = new Panel_State(2221, 24, pMineRest);
    private static final Panel_State[] ps_MineRest = new Panel_State[]{ps_MineRest_0.setNext(ps_MineRest_1), ps_MineRest_1.setNext(ps_MineRest_2).setFlags(Panel.psf_QuickCall), ps_MineRest_2.setNext()};
    private static final Panel_Sprite_Func pMineThrow = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            Weapon.InitMine(psp.PlayerP());
        }
    };
    private static final Panel_Sprite_Func pMineLower = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            psp.y += 12;
            if (psp.y > 200 + Engine.tilesizy[psp.picndx]) {
                if (!Panel.WeaponOK(psp.PlayerP())) {
                    return;
                }
                psp.y = 200 + Engine.tilesizy[psp.picndx];
                Panel.pStatePlusOne(psp);
            }
        }
    };
    private static final Panel_Sprite_Func pMineRaise = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            psp.y -= 12;
            if (psp.y < 200) {
                psp.y = 200;
                Panel.pStatePlusOne(psp);
            }
        }
    };
    private static final Panel_Sprite_Func pMineAction = new Panel_Sprite_Func(){

        @Override
        public void invoke(Panel_Sprite psp) {
            Mine.pMineBobSetup(psp);
            Panel.pWeaponBob(psp, Gameutils.PLAYER_MOVING(psp.PlayerP()) != 0);
        }
    };
    private static final Panel_State ps_MineThrow_0 = new Panel_State(2222, 3, null);
    private static final Panel_State ps_MineThrow_1 = new Panel_State(2222, 6, pMineThrow);
    private static final Panel_State ps_MineThrow_2 = new Panel_State(2222, 6, pMineLower);
    private static final Panel_State ps_MineThrow_3 = new Panel_State(2222, 30, null);
    private static final Panel_State ps_MineThrow_4 = new Panel_State(2220, 6, pMineRaise);
    private static final Panel_State ps_MineThrow_5 = new Panel_State(2220, 6, null);
    private static final Panel_State ps_MineThrow_6 = new Panel_State(2220, 3, pMineAction);
    private static final Panel_State[] ps_MineThrow = new Panel_State[]{ps_MineThrow_0.setNext(ps_MineThrow_1), ps_MineThrow_1.setNext(ps_MineThrow_2).setFlags(Panel.psf_QuickCall), ps_MineThrow_2.setNext().setPlusOne(ps_MineThrow_3), ps_MineThrow_3.setNext(ps_MineThrow_4), ps_MineThrow_4.setNext().setPlusOne(ps_MineThrow_5), ps_MineThrow_5.setNext(ps_MineThrow_6), ps_MineThrow_6.setNext(ps_MineRest[0])};

    public static void InitWeaponMine(PlayerStr pp) {
        Panel_Sprite psp;
        if (WangNetwork.Prediction) {
            return;
        }
        if (pp.WpnAmmo[6] <= 0) {
            Text.PutStringInfo(pp, "Out of Sticky Bombs!");
        }
        if (!MyTypes.TEST(pp.WpnFlags, MyTypes.BIT(6)) || pp.WpnAmmo[6] <= 0 || MyTypes.TEST(pp.Flags, Gameutils.PF_WEAPON_RETRACT)) {
            return;
        }
        if (pp.Wpn[6] == null) {
            psp = pp.Wpn[6] = Panel.pSpawnSprite(pp, ps_PresentMine[0], 128, 210, 200);
            psp.y += Engine.tilesizy[psp.picndx];
        }
        if (pp.CurWpn == pp.Wpn[6]) {
            return;
        }
        Panel.PlayerUpdateWeapon(pp, 6);
        pp.WpnUziType = (byte)2;
        Panel.RetractCurWpn(pp);
        psp = pp.CurWpn = pp.Wpn[6];
        psp.flags |= Panel.PANF_WEAPON_SPRITE;
        psp.ActionState = ps_MineThrow[0];
        psp.RetractState = ps_RetractMine[0];
        psp.PresentState = ps_PresentMine[0];
        psp.RestState = ps_MineRest[0];
        Panel.pSetState(psp, psp.PresentState);
        Sound.PlaySound(279, pp, 9);
        Gameutils.FLAG_KEY_RELEASE(psp.PlayerP(), 17);
        Gameutils.FLAG_KEY_RESET(psp.PlayerP(), 17);
    }

    private static void pMineBobSetup(Panel_Sprite psp) {
        if (MyTypes.TEST(psp.flags, Panel.PANF_BOB)) {
            return;
        }
        psp.xorig = psp.x;
        psp.yorig = psp.y;
        psp.sin_amt = (short)12;
        psp.sin_ndx = 0;
        psp.bob_height_shift = (short)3;
    }

    public static void MineSaveable() {
        Saveable.SaveData(ps_PresentMine);
        Saveable.SaveData(ps_MineRest);
        Saveable.SaveData(ps_MineHide);
        Saveable.SaveData(ps_MineThrow);
        Saveable.SaveData(ps_RetractMine);
        Saveable.SaveData(pMinePresent);
        Saveable.SaveData(pMineRetract);
        Saveable.SaveData(pMineHide);
        Saveable.SaveData(pMineRest);
        Saveable.SaveData(pMineUpSound);
        Saveable.SaveData(pMineThrow);
        Saveable.SaveData(pMineLower);
        Saveable.SaveData(pMineRaise);
        Saveable.SaveData(pMineAction);
    }
}

