/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.AI;

import ru.m210projects.Build.Engine;
import ru.m210projects.Build.Pragmas;
import ru.m210projects.Build.Types.SPRITE;
import ru.m210projects.Witchaven.AI.AIState;
import ru.m210projects.Witchaven.AI.Ai;
import ru.m210projects.Witchaven.AI.Enemy;
import ru.m210projects.Witchaven.AI.EnemyInfo;
import ru.m210projects.Witchaven.Globals;
import ru.m210projects.Witchaven.Main;
import ru.m210projects.Witchaven.Names;
import ru.m210projects.Witchaven.Types.PLAYER;
import ru.m210projects.Witchaven.WHFX;
import ru.m210projects.Witchaven.WHOBJ;
import ru.m210projects.Witchaven.WHPLR;
import ru.m210projects.Witchaven.WHSND;

public class AIGoblin {
    public static final AIState goblinChill = new AIState(){

        @Override
        public void process(PLAYER plr, short i) {
            SPRITE spr = Engine.sprite[i];
            spr.lotag = (short)(spr.lotag - 3);
            if (spr.lotag < 0) {
                spr.picnum = (short)(spr.picnum + 1);
                spr.lotag = (short)18;
                if (spr.picnum == 951) {
                    spr.picnum = (short)922;
                    WHOBJ.newstatus(i, 109);
                }
            }
        }
    };
    public static final AIState goblinWar = new AIState(){

        @Override
        public void process(PLAYER plr, short i) {
            SPRITE spr = Engine.sprite[i];
            if (spr.lotag > 256) {
                spr.lotag = (short)100;
                spr.extra = 0;
            }
            switch (spr.extra) {
                case 0: {
                    long olddist = 16384L;
                    boolean found = false;
                    int k = 0;
                    while (k < Engine.MAXSPRITES) {
                        long dist;
                        if (Engine.sprite[k].picnum == 922 && spr.pal != Engine.sprite[k].pal && spr.hitag == Engine.sprite[k].hitag && (dist = (long)(Pragmas.klabs(spr.x - Engine.sprite[k].x) + Pragmas.klabs(spr.y - Engine.sprite[k].y))) < olddist) {
                            found = true;
                            olddist = dist;
                            spr.owner = (short)k;
                            spr.ang = Main.engine.getangle(Engine.sprite[k].x - spr.x, Engine.sprite[k].y - spr.y);
                            spr.extra = 1;
                        }
                        k = (short)(k + 1);
                    }
                    if (found) break;
                    spr.hitag = spr.pal == 5 ? WHOBJ.adjusthp(35) : (spr.pal == 4 ? WHOBJ.adjusthp(25) : WHOBJ.adjusthp(15));
                    if (plr.shadowtime > 0) {
                        spr.ang = (short)((Main.engine.krand() & 0x100) + spr.ang + 1024 & 0x7FF);
                        WHOBJ.newstatus(i, 122);
                        break;
                    }
                    WHOBJ.newstatus(i, 109);
                    break;
                }
                case 1: {
                    short k = spr.owner;
                    int movehit = Ai.aimove(i);
                    if (movehit == 0) {
                        spr.ang = Main.engine.getangle(Engine.sprite[k].x - spr.x, Engine.sprite[k].y - spr.y);
                    } else if ((movehit & 0xE000) == 32768) {
                        spr.extra = (short)3;
                        spr.ang = (short)(spr.ang + (Main.engine.krand() & 0x80) & 0x7FF);
                        spr.lotag = (short)60;
                    } else if ((movehit & 0xE000) == 49152) {
                        int sprnum = movehit & 0x1FFF;
                        if (sprnum != k) {
                            spr.extra = (short)3;
                            spr.ang = (short)(spr.ang + (Main.engine.krand() & 0x80) & 0x7FF);
                            spr.lotag = (short)60;
                        } else {
                            spr.ang = Main.engine.getangle(Engine.sprite[k].x - spr.x, Engine.sprite[k].y - spr.y);
                        }
                    }
                    Ai.processfluid(i, Engine.zr_florhit, false);
                    Main.engine.setsprite(i, spr.x, spr.y, spr.z);
                    if (Ai.checkdist(i, Engine.sprite[k].x, Engine.sprite[k].y, Engine.sprite[k].z)) {
                        spr.extra = (short)2;
                    } else {
                        spr.picnum = (short)922;
                    }
                    if (!Ai.checksector6(i)) break;
                    return;
                }
                case 2: {
                    short k = spr.owner;
                    if (Ai.checkdist(i, Engine.sprite[k].x, Engine.sprite[k].y, Engine.sprite[k].z)) {
                        if ((Main.engine.krand() & 1) != 0) {
                            if (Main.engine.krand() % 10 > 6) {
                                WHSND.playsound_loc(WHSND.S_GENSWING, spr.x, spr.y);
                            }
                            if (Main.engine.krand() % 10 > 6) {
                                WHSND.playsound_loc(WHSND.S_SWORD1 + Main.engine.krand() % 6, spr.x, spr.y);
                            }
                            if (Ai.checkdist(plr, i)) {
                                WHPLR.addhealth(plr, -(Main.engine.krand() & 5));
                            }
                            if (Main.engine.krand() % 100 > 90) {
                                spr.extra = 0;
                                spr.picnum = (short)922;
                                Engine.sprite[k].extra = (short)4;
                                Engine.sprite[k].picnum = (short)968;
                                Engine.sprite[k].lotag = (short)20;
                                Engine.sprite[k].hitag = 0;
                                WHOBJ.newstatus(k, 107);
                            } else {
                                spr.extra = 0;
                                Engine.sprite[k].extra = (short)3;
                                Engine.sprite[k].ang = (short)(spr.ang + (Main.engine.krand() & 0x80) & 0x7FF);
                                Engine.sprite[k].lotag = (short)60;
                            }
                        }
                    } else {
                        spr.extra = 1;
                    }
                    Ai.processfluid(i, Engine.zr_florhit, false);
                    Main.engine.setsprite(i, spr.x, spr.y, spr.z);
                    if (!Ai.checksector6(i)) break;
                    return;
                }
                case 3: {
                    spr.lotag = (short)(spr.lotag - 3);
                    if (Ai.aimove(i) != 0) {
                        spr.ang = (short)(Main.engine.krand() & 0x7FF);
                    }
                    Ai.processfluid(i, Engine.zr_florhit, false);
                    Main.engine.setsprite(i, spr.x, spr.y, spr.z);
                    if (spr.lotag < 0) {
                        spr.lotag = 0;
                        spr.extra = 0;
                    }
                    if (!Ai.checksector6(i)) break;
                    return;
                }
                case 4: {
                    spr.picnum = (short)968;
                    break;
                }
            }
            AIGoblin.checkexpl(plr, i);
        }
    };

    public static void create() {
        Ai.enemy[7] = new Enemy();
        Ai.enemy[7].info = new EnemyInfo(36, 36, 1024, 120, 0, 64, false, 15, 0){

            @Override
            public short getHealth(SPRITE spr) {
                if (spr.pal == 5) {
                    return WHOBJ.adjusthp(35);
                }
                if (spr.pal == 4) {
                    return WHOBJ.adjusthp(25);
                }
                return WHOBJ.adjusthp(this.health);
            }
        };
        Ai.enemy[7].chase = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                if (spr.lotag < 0) {
                    spr.lotag = (short)250;
                }
                short osectnum = spr.sectnum;
                if (Main.engine.cansee(plr.x, plr.y, plr.z, plr.sector, spr.x, spr.y, spr.z - (Engine.tilesizy[spr.picnum] << 7), spr.sectnum) && plr.invisibletime < 0) {
                    if (Ai.checkdist(plr, i)) {
                        if (plr.shadowtime > 0) {
                            spr.ang = (short)((Main.engine.krand() & 0x100) + spr.ang + 1024 & 0x7FF);
                            WHOBJ.newstatus(i, 122);
                        } else {
                            WHOBJ.newstatus(i, 6);
                        }
                    } else if (Main.engine.krand() % 63 > 60) {
                        spr.ang = (short)((Main.engine.krand() & 0xFFFFFF80) + spr.ang + 1024 & 0x7FF);
                        WHOBJ.newstatus(i, 122);
                    } else {
                        int movestat = Ai.aimove(i);
                        if ((movestat & 0xE000) == 16384) {
                            spr.ang = (short)(spr.ang + 1024 & 0x7FF);
                            WHOBJ.newstatus(i, 122);
                            return;
                        }
                        if ((movestat & 0xE000) == 49152) {
                            if ((movestat & 0x1FFF) != plr.spritenum) {
                                short daang;
                                spr.ang = daang = (short)(spr.ang - 256 & 0x7FF);
                                if (plr.shadowtime > 0) {
                                    spr.ang = (short)((Main.engine.krand() & 0x100) + spr.ang + 1024 & 0x7FF);
                                    WHOBJ.newstatus(i, 122);
                                } else {
                                    WHOBJ.newstatus(i, 128);
                                }
                            } else {
                                spr.ang = (short)((Main.engine.krand() & 0x100) + spr.ang + 1024 & 0x7FF);
                                WHOBJ.newstatus(i, 128);
                            }
                        }
                    }
                } else {
                    spr.ang = (short)((Main.engine.krand() & 0x100) + spr.ang + 1024 & 0x7FF);
                    WHOBJ.newstatus(i, 122);
                }
                Main.engine.getzrange(spr.x, spr.y, spr.z - 1, spr.sectnum, spr.clipdist << 2, 65537);
                if (spr.sectnum != osectnum && Engine.sector[spr.sectnum].lotag == 10) {
                    WHFX.warpsprite(i);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, false);
                if (Engine.sector[osectnum].lotag == 4444) {
                    spr.hitag = (short)(spr.hitag - 1);
                    if (spr.hitag < 0) {
                        WHOBJ.newstatus(i, 107);
                    }
                }
                Main.engine.setsprite(i, spr.x, spr.y, spr.z);
                if ((Engine.zr_florhit & 0xE000) == 16384 && (Engine.sector[spr.sectnum].floorpicnum == 79 || Engine.sector[spr.sectnum].floorpicnum == 62 || Engine.sector[spr.sectnum].floorpicnum == 61)) {
                    spr.hitag = (short)(spr.hitag - 1);
                    if (spr.hitag < 0) {
                        WHOBJ.newstatus(i, 107);
                    }
                }
                AIGoblin.checkexpl(plr, i);
            }
        };
        Ai.enemy[7].die = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                if (spr.lotag <= 0) {
                    spr.picnum = (short)(spr.picnum + 1);
                    spr.lotag = (short)20;
                    if (spr.picnum == 977) {
                        if (Globals.difficulty == 4) {
                            WHOBJ.newstatus(i, 116);
                        } else {
                            ++Globals.kills;
                            WHOBJ.newstatus(i, 108);
                        }
                    }
                }
            }
        };
        Ai.enemy[7].pain = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                if (spr.lotag < 0) {
                    spr.picnum = (short)922;
                    spr.ang = (short)plr.ang;
                    WHOBJ.newstatus(i, 122);
                }
                Ai.aimove(i);
                Ai.processfluid(i, Engine.zr_florhit, false);
                Main.engine.setsprite(i, spr.x, spr.y, spr.z);
                AIGoblin.checkexpl(plr, i);
            }
        };
        Ai.enemy[7].face = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                boolean cansee = Main.engine.cansee(plr.x, plr.y, plr.z, plr.sector, spr.x, spr.y, spr.z - (Engine.tilesizy[spr.picnum] << 7), spr.sectnum);
                if (cansee && plr.invisibletime < 0) {
                    spr.ang = Main.engine.getangle(plr.x - spr.x, plr.y - spr.y);
                    spr.picnum = (short)922;
                    if (plr.shadowtime > 0) {
                        spr.ang = (short)((Main.engine.krand() & 0x100) + spr.ang + 1024 & 0x7FF);
                        WHOBJ.newstatus(i, 122);
                    } else {
                        spr.owner = plr.spritenum;
                        WHOBJ.newstatus(i, 2);
                    }
                } else if (spr.owner == plr.spritenum) {
                    spr.ang = (short)((Main.engine.krand() & 0x100) + spr.ang & 0x7FF);
                    WHOBJ.newstatus(i, 142);
                } else if (cansee) {
                    WHOBJ.newstatus(i, 122);
                }
                if (Ai.checkdist(plr, i)) {
                    WHOBJ.newstatus(i, 6);
                }
                AIGoblin.checkexpl(plr, i);
            }
        };
        Ai.enemy[7].flee = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                short osectnum = spr.sectnum;
                int movestat = Ai.aimove(i);
                if ((movestat & 0xE000) != 16384 && movestat != 0) {
                    if ((movestat & 0xE000) == 32768) {
                        int nWall = movestat & 0x1FFF;
                        int nx = -(Engine.wall[Engine.wall[nWall].point2].y - Engine.wall[nWall].y) >> 4;
                        int ny = Engine.wall[Engine.wall[nWall].point2].x - Engine.wall[nWall].x >> 4;
                        spr.ang = Main.engine.getangle(nx, ny);
                    } else {
                        spr.ang = Main.engine.getangle(plr.x - spr.x, plr.y - spr.y);
                        WHOBJ.newstatus(i, 109);
                    }
                }
                if (spr.lotag < 0) {
                    WHOBJ.newstatus(i, 109);
                }
                if (spr.sectnum != osectnum && Engine.sector[spr.sectnum].lotag == 10) {
                    WHFX.warpsprite(i);
                }
                if (Ai.checksector6(i)) {
                    return;
                }
                Ai.processfluid(i, Engine.zr_florhit, false);
                Main.engine.setsprite(i, spr.x, spr.y, spr.z);
                AIGoblin.checkexpl(plr, i);
            }
        };
        Ai.enemy[7].stand = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.ang = Main.engine.getangle(plr.x - spr.x, plr.y - spr.y);
                if (Engine.sintable[spr.ang + 2560 & 0x7FF] * (plr.x - spr.x) + Engine.sintable[spr.ang + 2048 & 0x7FF] * (plr.y - spr.y) >= 0 && Main.engine.cansee(plr.x, plr.y, plr.z, plr.sector, spr.x, spr.y, spr.z - (Engine.tilesizy[spr.picnum] << 7), spr.sectnum) && plr.invisibletime < 0) {
                    switch (spr.picnum) {
                        case 942: {
                            spr.picnum = (short)946;
                            WHSND.playsound_loc(WHSND.S_GOBPAIN1 + Main.engine.krand() % 2, spr.x, spr.y);
                            WHOBJ.newstatus(i, 127);
                            break;
                        }
                        default: {
                            spr.picnum = (short)922;
                            if (plr.shadowtime > 0) {
                                spr.ang = (short)((Main.engine.krand() & 0x100) + spr.ang + 1024 & 0x7FF);
                                WHOBJ.newstatus(i, 122);
                                break;
                            }
                            WHOBJ.newstatus(i, 2);
                        }
                    }
                }
                Ai.checksector6(i);
            }
        };
        Ai.enemy[7].attack = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                Main.engine.getzrange(spr.x, spr.y, spr.z - 1, spr.sectnum, spr.clipdist << 2, 65537);
                spr.z = Engine.zr_florz;
                switch (Ai.checkfluid(i, Engine.zr_florhit)) {
                    case 2: {
                        Engine.sprite[i].hitag = (short)(Engine.sprite[i].hitag - 1);
                        if (Engine.sprite[i].hitag < 0) {
                            WHOBJ.newstatus(i, 107);
                        }
                    }
                    case 1: {
                        spr.z += Engine.tilesizy[spr.picnum] << 5;
                    }
                }
                Main.engine.setsprite(i, spr.x, spr.y, spr.z);
                if (spr.lotag == 31) {
                    if (Ai.checksight(plr, i) && Ai.checkdist(plr, i)) {
                        spr.ang = (short)Ai.checksight_ang;
                        Ai.attack(plr, i);
                    }
                } else if (spr.lotag < 0) {
                    spr.picnum = (short)922;
                    if (plr.shadowtime > 0) {
                        spr.ang = (short)((Main.engine.krand() & 0x100) + spr.ang + 1024 & 0x7FF);
                        WHOBJ.newstatus(i, 122);
                    } else {
                        WHOBJ.newstatus(i, 2);
                    }
                }
                spr.lotag = (short)(spr.lotag - 3);
                Ai.checksector6(i);
            }
        };
        Ai.enemy[7].resurect = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                if (spr.lotag < 0) {
                    WHOBJ.newstatus(i, 109);
                    spr.picnum = (short)922;
                    spr.hitag = WHOBJ.adjusthp(35);
                    spr.lotag = (short)100;
                    spr.cstat = (short)(spr.cstat | 1);
                }
            }
        };
        Ai.enemy[7].search = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                Ai.aisearch(plr, i, false);
                if (!Ai.checksector6(i)) {
                    AIGoblin.checkexpl(plr, i);
                }
            }
        };
        Ai.enemy[7].frozen = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                if (spr.lotag < 0) {
                    spr.pal = 0;
                    spr.picnum = (short)922;
                    WHOBJ.newstatus(i, 109);
                }
            }
        };
        Ai.enemy[7].nuked = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                if (spr.lotag < 0) {
                    spr.picnum = (short)(spr.picnum + 1);
                    spr.lotag = (short)24;
                    if (spr.picnum == 2457) {
                        WHOBJ.trailingsmoke(i, false);
                        Main.engine.deletesprite(i);
                    }
                }
            }
        };
        Ai.enemy[7].skirmish = new AIState(){

            @Override
            public void process(PLAYER plr, short i) {
                SPRITE spr = Engine.sprite[i];
                spr.lotag = (short)(spr.lotag - 3);
                if (spr.lotag < 0) {
                    WHOBJ.newstatus(i, 109);
                }
                short osectnum = spr.sectnum;
                int movestat = Ai.aimove(i);
                if ((movestat & 0xE000) != 16384 && movestat != 0) {
                    spr.ang = Main.engine.getangle(plr.x - spr.x, plr.y - spr.y);
                    WHOBJ.newstatus(i, 109);
                }
                if (spr.sectnum != osectnum && Engine.sector[spr.sectnum].lotag == 10) {
                    WHFX.warpsprite(i);
                }
                Ai.processfluid(i, Engine.zr_florhit, false);
                Main.engine.setsprite(i, spr.x, spr.y, spr.z);
                if (Ai.checksector6(i)) {
                    return;
                }
                AIGoblin.checkexpl(plr, i);
            }
        };
    }

    public static void goblinWarProcess(PLAYER plr) {
        short i = Engine.headspritestat[132];
        while (i >= 0) {
            short nextsprite = Engine.nextspritestat[i];
            SPRITE spr = Engine.sprite[i];
            switch (spr.detail) {
                case 7: {
                    goblinWar.process(plr, i);
                }
            }
            i = nextsprite;
        }
    }

    public static void checkexpl(PLAYER plr, short i) {
        SPRITE spr = Engine.sprite[i];
        short j = Engine.headspritesect[spr.sectnum];
        while (j != -1) {
            short nextj = Engine.nextspritesect[j];
            long dx = Pragmas.klabs(spr.x - Engine.sprite[j].x);
            long dy = Pragmas.klabs(spr.y - Engine.sprite[j].y);
            long dz = Pragmas.klabs((spr.z >> 8) - (Engine.sprite[j].z >> 8));
            long dh = Engine.tilesizy[Engine.sprite[j].picnum] >> 1;
            if (dx + dy < 512L && dz - dh <= (long)WHOBJ.getPickHeight() && (Engine.sprite[j].picnum == Names.EXPLO2 || Engine.sprite[j].picnum == Names.SMOKEFX || Engine.sprite[j].picnum == 660)) {
                spr.hitag = (short)(spr.hitag - 12);
                if (spr.hitag < 0) {
                    WHOBJ.newstatus(i, 107);
                }
            }
            j = nextj;
        }
    }

    public static void premap(short i) {
        SPRITE spr = Engine.sprite[i];
        spr.detail = (short)7;
        if (spr.hitag >= 90 && spr.hitag <= 99) {
            short ohitag = spr.hitag;
            Ai.enemy[7].info.set(spr);
            if (spr.pal != 0) {
                spr.xrepeat = (short)30;
            }
            spr.extra = 0;
            spr.owner = 0;
            spr.hitag = ohitag;
            return;
        }
        Ai.enemy[7].info.set(spr);
        if (spr.picnum == 942) {
            Main.engine.changespritestat(i, 8);
            spr.lotag = (short)30;
            if (Main.engine.krand() % 100 > 50) {
                spr.extra = 1;
            }
            return;
        }
        Main.engine.changespritestat(i, 109);
        if (Main.engine.krand() % 100 > 50) {
            spr.extra = 1;
        }
    }
}

