/*
 * Decompiled with CFR 0.152.
 */
package ru.m210projects.Witchaven.Factory;

import ru.m210projects.Build.Input.BuildControllers;
import ru.m210projects.Build.OnSceenDisplay.OSDFunc;
import ru.m210projects.Build.Pattern.BuildControls;
import ru.m210projects.Build.Pattern.BuildEngine;
import ru.m210projects.Build.Pattern.BuildFactory;
import ru.m210projects.Build.Pattern.BuildFont;
import ru.m210projects.Build.Pattern.BuildNet;
import ru.m210projects.Build.Pattern.FontHandler;
import ru.m210projects.Build.Pattern.MenuItems.MenuHandler;
import ru.m210projects.Build.Pattern.MenuItems.SliderDrawable;
import ru.m210projects.Build.Render.Renderer;
import ru.m210projects.Build.Script.DefScript;
import ru.m210projects.Witchaven.Factory.WH2MenuHandler;
import ru.m210projects.Witchaven.Factory.WHControl;
import ru.m210projects.Witchaven.Factory.WHEngine;
import ru.m210projects.Witchaven.Factory.WHMenuHandler;
import ru.m210projects.Witchaven.Factory.WHNetwork;
import ru.m210projects.Witchaven.Factory.WHOSDFunc;
import ru.m210projects.Witchaven.Factory.WHPolymost;
import ru.m210projects.Witchaven.Factory.WHSliderDrawable;
import ru.m210projects.Witchaven.Factory.WHSoftware;
import ru.m210projects.Witchaven.Fonts.HealthFont;
import ru.m210projects.Witchaven.Fonts.MenuFont;
import ru.m210projects.Witchaven.Fonts.PotionFont;
import ru.m210projects.Witchaven.Fonts.ScoreFont;
import ru.m210projects.Witchaven.Fonts.StandartFont;
import ru.m210projects.Witchaven.Fonts.TheFont;
import ru.m210projects.Witchaven.Fonts.WH2Fonts;
import ru.m210projects.Witchaven.Main;

public class WHFactory
extends BuildFactory {
    private Main app;

    public WHFactory(Main app) {
        super("stuff.dat");
        this.app = app;
    }

    @Override
    public int getInitTile() {
        return 500;
    }

    @Override
    public BuildEngine engine() throws Exception {
        Main.engine = new WHEngine(this.app);
        return Main.engine;
    }

    @Override
    public Renderer renderer(Renderer.RenderType type) {
        if (type == Renderer.RenderType.Software) {
            return new WHSoftware(this.app.pEngine);
        }
        return new WHPolymost(this.app.pEngine);
    }

    @Override
    public DefScript getBaseDef(BuildEngine engine) {
        return new DefScript(engine, false);
    }

    @Override
    public BuildControls input(BuildControllers gpmanager) {
        return new WHControl(this.app.pCfg, gpmanager);
    }

    @Override
    public OSDFunc console() {
        return new WHOSDFunc(this.app);
    }

    @Override
    public MenuHandler menus() {
        this.app.menu = Main.game.WH2 ? new WH2MenuHandler(this.app) : new WHMenuHandler(this.app);
        return this.app.menu;
    }

    @Override
    public FontHandler fonts() {
        return new FontHandler(6){

            @Override
            protected BuildFont init(int i) {
                if (i == 0) {
                    if (Main.game.WH2) {
                        return new WH2Fonts(((WHFactory)WHFactory.this).app.pEngine);
                    }
                    return new MenuFont(((WHFactory)WHFactory.this).app.pEngine);
                }
                if (i == 1) {
                    return new TheFont(((WHFactory)WHFactory.this).app.pEngine);
                }
                if (i == 2) {
                    return new HealthFont(((WHFactory)WHFactory.this).app.pEngine);
                }
                if (i == 3) {
                    return new PotionFont(((WHFactory)WHFactory.this).app.pEngine);
                }
                if (i == 4) {
                    return new ScoreFont(((WHFactory)WHFactory.this).app.pEngine);
                }
                return new StandartFont(((WHFactory)WHFactory.this).app.pEngine);
            }
        };
    }

    @Override
    public BuildNet net() {
        return new WHNetwork(this.app);
    }

    @Override
    public SliderDrawable slider() {
        return new WHSliderDrawable();
    }
}

